/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.archive;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.log4j.Logger;
import org.eso.util.archive.ArchiveException;
import org.eso.util.archive.NgasFileResponseHandler;
import org.eso.util.archive.NgasHost;
import org.eso.util.archive.NgasRedirectResponseException;
import org.eso.util.archive.Pair;
import org.eso.util.archive.RetrieveTask;
import org.eso.util.misc.SystemCommand;

public class RetrieveFileTask
extends RetrieveTask
implements Callable<Pair<String, File>> {
    static final Logger logger = Logger.getLogger(RetrieveFileTask.class);
    private final String FILENAME_KEYWORD = "\\$FILENAME";
    private String downloadDir;
    private boolean overwrite;
    private boolean uncompress;
    private Map<String, String> uncompressCommands;

    public RetrieveFileTask(HttpClient httpClient, NgasHost host, String fileId, boolean hotfly, boolean irafKeywords) {
        super(httpClient, host, fileId, hotfly, irafKeywords);
    }

    @Override
    public Pair<String, File> call() throws Exception {
        logger.info("Downloading file " + this.fileId);
        HttpGet get = this.prepareHttpCall();
        NgasFileResponseHandler rh = new NgasFileResponseHandler(this.downloadDir, this.overwrite);
        try {
            File archiveFile;
            try {
                archiveFile = this.httpClient.execute((HttpUriRequest)get, rh);
            }
            catch (HttpResponseException e2) {
                String newLocation = ((NgasRedirectResponseException)e2).getRedirectLocation();
                get = new HttpGet(newLocation);
                archiveFile = this.httpClient.execute((HttpUriRequest)get, rh);
            }
            if (this.uncompress) {
                archiveFile = this.uncompress(archiveFile);
            }
            return new Pair<String, File>(this.fileId, archiveFile);
        }
        catch (ClientProtocolException e3) {
            throw new ArchiveException(e3);
        }
        catch (IOException e4) {
            throw new ArchiveException(e4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File uncompress(File archiveFile) throws Exception {
        String methodLogName = "RetrieveFileTask::uncompress";
        String filename = archiveFile.getAbsolutePath();
        String[] tokens = filename.split("\\.");
        String extension = tokens[tokens.length - 1];
        String uncompressCmd = this.getUncompressCommand(extension);
        if (uncompressCmd != null) {
            String uncompressedFilename = filename.substring(0, filename.indexOf(extension) - 1);
            boolean destFileExists = false;
            File destFile = new File(uncompressedFilename);
            if (destFile.exists()) {
                if (this.overwrite) {
                    logger.info("RetrieveFileTask::uncompress - file " + uncompressedFilename + " already exists: going to delete it");
                    if (!destFile.delete()) {
                        logger.error(" - unable to delete " + uncompressedFilename);
                        destFileExists = true;
                    }
                } else {
                    throw new Exception("RetrieveFileTask::uncompress - file " + uncompressedFilename + " already exists");
                }
            }
            if (!destFileExists) {
                SystemCommand command = new SystemCommand(uncompressCmd.replaceAll("\\$FILENAME", filename));
                logger.info("RetrieveFileTask::uncompress - Executing command [" + command.getCommandLine() + "]");
                int exitStatus = -1;
                try {
                    command.setTimeout(1800L);
                    exitStatus = command.execute();
                    String stdout = command.getStandardOutputString();
                    String stderr = command.getStandardErrorString();
                    if (stdout.length() > 0) {
                        logger.info("RetrieveFileTask::uncompress -  - [STDOUT] " + stdout);
                    }
                    if (stderr.length() > 0) {
                        logger.info("RetrieveFileTask::uncompress -  - [STDERR] " + stderr);
                    }
                }
                catch (Exception e2) {
                    logger.error("RetrieveFileTask::uncompress - " + e2.getMessage());
                }
                finally {
                    if (exitStatus != 0) {
                        throw new Exception(command.getStandardErrorString());
                    }
                    logger.info("RetrieveFileTask::uncompress - " + command.getStandardOutputString());
                }
            }
            return new File(uncompressedFilename);
        }
        logger.info("No uncompress command defined for file [" + filename + "]");
        return new File(filename);
    }

    public String getUncompressCommand(String extension) {
        if (this.uncompressCommands != null) {
            return this.uncompressCommands.get(extension);
        }
        return null;
    }

    public Map<String, String> getUncompressCommands() {
        return this.uncompressCommands;
    }

    public void setUncompressCommands(Map<String, String> uncompressCommands) {
        this.uncompressCommands = uncompressCommands;
    }

    public String getDownloadDir() {
        return this.downloadDir;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isUncompress() {
        return this.uncompress;
    }

    public void setDownloadDir(String downloadDir) {
        this.downloadDir = downloadDir;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setUncompress(boolean uncompress) {
        this.uncompress = uncompress;
    }
}

