/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eso.util.dal.ConnectionServiceException;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.NgasFile;
import org.eso.util.dal.NgasFileDAO;
import org.eso.util.dal.SybaseConnectionService;

public class NgasFileDAOSyb
implements NgasFileDAO {
    private static final Logger logger = Logger.getLogger(NgasFileDAOSyb.class);
    private final String dbUrl;
    private final String dbUsername;
    private final String dbPassword;
    private final String dbTable;
    private final Connection dbConnection;

    public NgasFileDAOSyb(String dbUrl, String dbUsername, String dbPassword, String dbTable) {
        this.dbUrl = dbUrl;
        this.dbUsername = dbUsername;
        this.dbPassword = dbPassword;
        this.dbTable = dbTable;
        this.dbConnection = null;
    }

    public NgasFileDAOSyb(Connection dbConnection, String dbTable) {
        this.dbUrl = "";
        this.dbUsername = "";
        this.dbPassword = "";
        this.dbConnection = dbConnection;
        this.dbTable = dbTable;
    }

    @Override
    public int delete(NgasFile ngasFile) throws DAOException {
        throw new DAOException("Not yet implemented.");
    }

    @Override
    public int deleteByDiskId(String diskId) throws DAOException {
        String sqlStatement = "delete from " + this.dbTable + " where disk_id='" + diskId + "'";
        try {
            return this.executeUpdateStatement(sqlStatement);
        }
        catch (Exception e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    @Override
    public int deleteByDiskIdAndFileId(String diskId, String fileId) throws DAOException {
        String sqlStatement = "delete from " + this.dbTable + " where disk_id='" + diskId + "' and file_id='" + fileId + "'";
        try {
            return this.executeUpdateStatement(sqlStatement);
        }
        catch (Exception e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    @Override
    public List<NgasFile> findByFileId(String fileId) throws DAOException {
        return this.find(fileId, null, null);
    }

    @Override
    public NgasFile findMostRecentByFileId(String fileId) throws DAOException {
        try {
            return this.findByFileId(fileId).get(0);
        }
        catch (IndexOutOfBoundsException e2) {
            throw new DAOException("No entries found in NGAS for the given file_id: " + fileId);
        }
    }

    @Override
    public List<NgasFile> find(String fileId, String diskId, Integer version) throws DAOException {
        String logHead = "NgasFileDAOSyb::find() - ";
        String sqlStatement = this.getFindSQLStatement(fileId, diskId, version);
        List<NgasFile> ngasFileList = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            ResultSet rs = SybaseConnectionService.executeStatement(connection, sqlStatement);
            ngasFileList = NgasFileDAOSyb.toNgasFileList(rs);
        }
        catch (Exception e2) {
            throw new DAOException(e2.getMessage());
        }
        finally {
            try {
                SybaseConnectionService.closeConnection(connection);
            }
            catch (ConnectionServiceException e3) {
                logger.error("NgasFileDAOSyb::find() - Cannot close connection.");
            }
        }
        return ngasFileList;
    }

    @Override
    public List<NgasFile> findAll() throws DAOException {
        throw new DAOException("Not yet implemented.");
    }

    @Override
    public void save(NgasFile ngasFile) throws DAOException {
        String sqlStatement = this.getSaveSQLStatement(ngasFile);
        try {
            this.executeStatement(sqlStatement);
        }
        catch (Exception e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    @Override
    public int update(NgasFile ngasFile) throws DAOException {
        throw new DAOException("Not yet implemented.");
    }

    @Override
    public boolean saveIfNotFound(NgasFile ngasFile) throws DAOException {
        String logHead = "NgasFileDAOSyb::saveIfNotFound() - ";
        boolean alreadyThere = false;
        Connection connection = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(false);
            ResultSet rs = SybaseConnectionService.executeStatement(connection, this.getFindSQLStatement(ngasFile.getFileId(), ngasFile.getDiskId(), ngasFile.getFileVersion()));
            int rowCount = 0;
            while (rs.next()) {
                ++rowCount;
            }
            boolean bl = alreadyThere = rowCount > 0;
            if (!alreadyThere) {
                SybaseConnectionService.executeStatement(connection, this.getSaveSQLStatement(ngasFile));
            }
        }
        catch (IllegalArgumentException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (ConnectionServiceException e3) {
            throw new DAOException(e3.getMessage());
        }
        catch (SQLException e4) {
            throw new DAOException(e4.getMessage());
        }
        try {
            connection.commit();
        }
        catch (SQLException e5) {
            throw new DAOException("It was not possible to complete the transaction. Reason: " + e5.getMessage());
        }
        finally {
            try {
                connection.setAutoCommit(true);
                connection.close();
            }
            catch (SQLException e6) {
                logger.error("NgasFileDAOSyb::saveIfNotFound() - Cannot close connection.");
            }
        }
        return alreadyThere;
    }

    public static List<NgasFile> toNgasFileList(ResultSet rs) throws DAOException {
        ArrayList<NgasFile> ngasFileList = new ArrayList<NgasFile>();
        try {
            while (rs.next()) {
                NgasFile ngasFile = new NgasFile();
                ngasFile.setDiskId(rs.getString("disk_id"));
                ngasFile.setFileName(rs.getString("file_name"));
                ngasFile.setFileId(rs.getString("file_id"));
                ngasFile.setFormat(rs.getString("format"));
                ngasFile.setFileSize(rs.getLong("file_size"));
                ngasFile.setUncompressedFileSize(rs.getLong("uncompressed_file_size"));
                ngasFile.setCompression(rs.getString("compression"));
                ngasFile.setIngestionDate(rs.getDate("ingestion_date"));
                ngasFile.setIgnore(rs.getInt("ignore"));
                ngasFile.setChecksum(rs.getString("checksum"));
                ngasFile.setChecksumPlugin(rs.getString("checksum_plugin"));
                ngasFile.setFileVersion(rs.getInt("file_version"));
                ngasFile.setFileStatus(rs.getString("file_status"));
                ngasFile.setCreationDate(rs.getDate("creation_date"));
                ngasFileList.add(ngasFile);
            }
        }
        catch (SQLException e2) {
            throw new DAOException("Error while parsing result set. Reason: " + e2.getMessage());
        }
        return ngasFileList;
    }

    private String fieldNamesToString(NgasFile ngasFile) {
        return "disk_id,file_name,file_id,format,file_size,uncompressed_file_size" + (ngasFile.getCompression() == null ? "" : ",compression") + ",ingestion_date" + (ngasFile.getIgnore() == null ? "" : ",ignore") + (ngasFile.getChecksum() == null ? "" : ",checksum") + (ngasFile.getChecksumPlugin() == null ? "" : ",checksum_plugin") + (ngasFile.getFileVersion() == null ? "" : ",file_version") + (ngasFile.getFileStatus() == null ? "" : ",file_status") + (ngasFile.getCreationDate() == null ? "" : ",creation_date");
    }

    private String valuesToString(NgasFile ngasFile) {
        return "'" + ngasFile.getDiskId() + "'," + "'" + ngasFile.getFileName() + "'," + "'" + ngasFile.getFileId() + "'," + "'" + ngasFile.getFormat() + "'," + ngasFile.getFileSize() + "," + ngasFile.getUncompressedFileSize() + (ngasFile.getCompression() == null ? "" : ",'" + ngasFile.getCompression() + "'") + ",'" + SybaseConnectionService.dateFormat.format(ngasFile.getIngestionDate()) + "'" + (ngasFile.getIgnore() == null ? "" : "," + ngasFile.getIgnore()) + (ngasFile.getChecksum() == null ? "" : ",'" + ngasFile.getChecksum() + "'") + (ngasFile.getChecksumPlugin() == null ? "" : ",'" + ngasFile.getChecksumPlugin() + "'") + (ngasFile.getFileVersion() == null ? "" : "," + ngasFile.getFileVersion()) + (ngasFile.getFileStatus() == null ? "" : ",'" + ngasFile.getFileStatus() + "'") + (ngasFile.getCreationDate() == null ? "" : ",'" + SybaseConnectionService.dateFormat.format(ngasFile.getCreationDate()) + "'");
    }

    private String getSaveSQLStatement(NgasFile ngasFile) {
        return "insert into " + this.dbTable + "(" + this.fieldNamesToString(ngasFile) + ") values (" + this.valuesToString(ngasFile) + ")";
    }

    private String getFindSQLStatement(String fileId, String diskId, Integer version) throws DAOException {
        if (fileId == null) {
            throw new DAOException("File ID cannot be null.");
        }
        return "SELECT * FROM " + this.dbTable + " nf " + " WHERE file_status = '00000000' AND nf.ignore = 0 AND " + "file_id='" + fileId + "'" + (diskId != null ? " AND disk_id='" + diskId + "'" : "") + (version != null ? " AND file_version=" + version + " ORDER BY file_version DESC" : "");
    }

    private Connection getConnection() throws IllegalArgumentException, ConnectionServiceException {
        if (this.dbConnection == null) {
            return SybaseConnectionService.getConnection(this.dbUrl, this.dbUsername, this.dbPassword);
        }
        return this.dbConnection;
    }

    private void executeStatement(String sqlStatement) throws IllegalArgumentException, ConnectionServiceException {
        if (this.dbConnection == null) {
            Connection connection = SybaseConnectionService.getConnection(this.dbUrl, this.dbUsername, this.dbPassword);
            SybaseConnectionService.executeStatement(connection, sqlStatement);
            SybaseConnectionService.closeConnection(connection);
        } else {
            SybaseConnectionService.executeStatement(this.dbConnection, sqlStatement);
        }
    }

    private int executeUpdateStatement(String sqlStatement) throws IllegalArgumentException, ConnectionServiceException {
        int affectedRows = 0;
        if (this.dbConnection == null) {
            Connection connection = SybaseConnectionService.getConnection(this.dbUrl, this.dbUsername, this.dbPassword);
            affectedRows = SybaseConnectionService.executeUpdateStatement(connection, sqlStatement);
            SybaseConnectionService.closeConnection(connection);
        } else {
            affectedRows = SybaseConnectionService.executeUpdateStatement(this.dbConnection, sqlStatement);
        }
        return affectedRows;
    }

    @Override
    public Long getSize(List<String> fileIds) throws DAOException {
        Long res = 0L;
        int numberOfIterations = (fileIds.size() + 99) / 100;
        for (int i = 0; i < numberOfIterations; ++i) {
            int start = i * 100;
            int stop = Math.min((i + 1) * 100, fileIds.size());
            res = res + this.getSize(fileIds, start, stop);
        }
        return res;
    }

    private Long getSize(List<String> fileIds, int startIdx, int stopIdx) throws DAOException {
        String logHead = "NgasFileDAOSyb::getSize() - ";
        Long result = 0L;
        Connection connection = null;
        try {
            connection = this.getConnection();
            String query = "select distinct file_id,file_size from " + this.dbTable + " where file_id in (";
            for (int i = startIdx; i < stopIdx; ++i) {
                query = query + "'" + fileIds.get(i) + "',";
            }
            query = query.substring(0, query.length() - 1);
            query = query + ")";
            ResultSet rs = SybaseConnectionService.executeStatement(connection, query);
            while (rs.next()) {
                result = result + rs.getLong("file_size");
            }
        }
        catch (IllegalArgumentException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (ConnectionServiceException e3) {
            throw new DAOException(e3.getMessage());
        }
        catch (SQLException e4) {
            throw new DAOException(e4.getMessage());
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e5) {
                logger.error("NgasFileDAOSyb::getSize() - Cannot close connection.");
            }
        }
        return result;
    }
}

