/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.filesystem;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eso.util.filesystem.Directory;

public class FileSystemOperations {
    static final Logger logger = Logger.getLogger(FileSystemOperations.class);
    private static final String classLogName = "FileSystemOperations";

    public static boolean checkForDirectories(Directory[] directories) throws NullPointerException {
        String methodLogName = "FileSystemOperations::checkForDirectories()";
        logger.trace("FileSystemOperations::checkForDirectories()");
        if (directories == null) {
            String message = "FileSystemOperations::checkForDirectories() - directories must not be null.";
            logger.fatal("FileSystemOperations::checkForDirectories() - directories must not be null.");
            throw new NullPointerException("FileSystemOperations::checkForDirectories() - directories must not be null.");
        }
        boolean allDirsInPlace = true;
        String commonLogText = null;
        for (int i = 0; i < directories.length; ++i) {
            if (!directories[i].isRequired) continue;
            commonLogText = "FileSystemOperations::checkForDirectories()" + (directories[i].logText == null ? " -" : " - " + directories[i].logText) + " directory [" + directories[i].path + "]";
            if (FileSystemOperations.requireDirectory(directories[i].path, directories[i].createDir)) {
                logger.debug(commonLogText + " in place.");
                continue;
            }
            logger.error(commonLogText + " not available.");
            allDirsInPlace = false;
        }
        return allDirsInPlace;
    }

    public static boolean requireDirectory(File path, boolean createDir) throws NullPointerException {
        String methodLogName = "FileSystemOperations::requireDirectory()";
        logger.trace("FileSystemOperations::requireDirectory()");
        if (path == null) {
            String message = "FileSystemOperations::requireDirectory() - path must not be null.";
            logger.fatal("FileSystemOperations::requireDirectory() - path must not be null.");
            throw new NullPointerException("FileSystemOperations::requireDirectory() - path must not be null.");
        }
        try {
            if (path.exists()) {
                if (path.isDirectory()) {
                    logger.debug("FileSystemOperations::requireDirectory() - existing directory [" + path + "] found.");
                    return true;
                }
                logger.error("FileSystemOperations::requireDirectory() - a non-directory is already present at path [" + path + "].");
                return false;
            }
            if (createDir) {
                if (path.mkdir()) {
                    logger.info("FileSystemOperations::requireDirectory() - directory [" + path + "] created.");
                    return true;
                }
                logger.error("FileSystemOperations::requireDirectory() - directory [" + path + "] could not be created.");
                return false;
            }
            logger.error("FileSystemOperations::requireDirectory() - directory [" + path + "] is not present.");
            return false;
        }
        catch (Exception e2) {
            logger.error("FileSystemOperations::requireDirectory() - error [" + e2.getMessage() + "] whilst attempting to require" + " directory [" + path + "].");
            return false;
        }
    }

    public static boolean moveAllToDir(List<File> sourcePaths, File destDir) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "FileSystemOperations::moveAllToDir()";
        logger.trace("FileSystemOperations::moveAllToDir()");
        if (sourcePaths == null || destDir == null) {
            String message = "FileSystemOperations::moveAllToDir() - sourcePaths" + (sourcePaths == null ? " [null]" : "") + " and destDir [" + destDir + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        boolean allFilesMoved = true;
        ListIterator<File> fileIterator = sourcePaths.listIterator();
        File currentFile = null;
        while (fileIterator.hasNext()) {
            currentFile = fileIterator.next();
            if (FileSystemOperations.moveToDir(currentFile, destDir)) {
                fileIterator.remove();
                continue;
            }
            allFilesMoved = false;
        }
        return allFilesMoved;
    }

    public static boolean moveToDir(File sourcePath, File destDir) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "FileSystemOperations::moveToDir()";
        logger.trace("FileSystemOperations::moveToDir()");
        if (sourcePath == null || destDir == null) {
            String message = "FileSystemOperations::moveToDir() - sourcePath [" + sourcePath + "] and destDir [" + destDir + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        try {
            if (!destDir.isDirectory()) {
                String message = "FileSystemOperations::moveToDir() - destDir [" + destDir + "] is not a directory.";
                logger.fatal(message);
                throw new IllegalArgumentException(message);
            }
        }
        catch (Exception e2) {
            String message = "FileSystemOperations::moveToDir() - error [" + e2.getMessage() + "] whilst attempting to access destination directory [" + destDir + "].";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        File destPath = new File(destDir, sourcePath.getName());
        return FileSystemOperations.move(sourcePath, destPath);
    }

    public static boolean move(File sourcePath, File destPath) throws NullPointerException {
        String methodLogName = "FileSystemOperations::move()";
        logger.trace("FileSystemOperations::move()");
        if (sourcePath == null || destPath == null) {
            String message = "FileSystemOperations::move() - sourcePath [" + sourcePath + "] and destPath [" + destPath + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        try {
            if (sourcePath.renameTo(destPath)) {
                logger.debug("FileSystemOperations::move() - moved [" + sourcePath + "] to [" + destPath + "].");
                return true;
            }
            logger.error("FileSystemOperations::move() - unable to move [" + sourcePath + "] to [" + destPath + "].");
            return false;
        }
        catch (Exception e2) {
            logger.error("FileSystemOperations::move() - error [" + e2.getMessage() + "] whilst attempting to move [" + sourcePath + "] to [" + destPath + "].");
            return false;
        }
    }

    public static boolean writeStringToFile(String string, boolean append, File outputFile) throws NullPointerException {
        String methodLogName = "FileSystemOperations::writeStringToFile()";
        logger.trace("FileSystemOperations::writeStringToFile()");
        if (string == null || outputFile == null) {
            String message = "FileSystemOperations::writeStringToFile() - string [" + string + "] and outputFile [" + outputFile + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile, append));
            writer.write(string);
            writer.close();
            logger.debug("FileSystemOperations::writeStringToFile() - string successfully written to file [" + outputFile + "].");
            return true;
        }
        catch (Exception e2) {
            logger.error("FileSystemOperations::writeStringToFile() - error [" + e2.getMessage() + "] whilst attempting to write to file [" + outputFile + "].");
            return false;
        }
    }

    public static boolean exists(File path) throws NullPointerException {
        String methodLogName = "FileSystemOperations::exists()";
        logger.trace("FileSystemOperations::exists()");
        if (path == null) {
            String message = "FileSystemOperations::exists() - path must not be null.";
            logger.fatal("FileSystemOperations::exists() - path must not be null.");
            throw new NullPointerException("FileSystemOperations::exists() - path must not be null.");
        }
        try {
            if (path.exists()) {
                logger.debug("FileSystemOperations::exists() - [" + path + "] exists.");
                return true;
            }
            logger.debug("FileSystemOperations::exists() - [" + path + "] does not exist.");
            return false;
        }
        catch (Exception e2) {
            logger.error("FileSystemOperations::exists() - error [" + e2.getMessage() + "] whilst attempting to check whether [" + path + "] exists.");
            return false;
        }
    }

    public static boolean isFile(File path) throws NullPointerException {
        String methodLogName = "FileSystemOperations::isFile()";
        logger.trace("FileSystemOperations::isFile()");
        if (path == null) {
            String message = "FileSystemOperations::isFile() - path must not be null.";
            logger.fatal("FileSystemOperations::isFile() - path must not be null.");
            throw new NullPointerException("FileSystemOperations::isFile() - path must not be null.");
        }
        try {
            if (path.isFile()) {
                logger.debug("FileSystemOperations::isFile() - [" + path + "] is a normal file and exists on the disk.");
                return true;
            }
            logger.debug("FileSystemOperations::isFile() - [" + path + "] is not a normal file, or does not exist.");
            return false;
        }
        catch (Exception e2) {
            logger.error("FileSystemOperations::isFile() - error [" + e2.getMessage() + "] whilst attempting to check whether [" + path + "] is a normal file and exists on the disk.");
            return false;
        }
    }

    public static boolean isDirectory(File path) throws NullPointerException {
        String methodLogName = "FileSystemOperations::isDirectory()";
        logger.trace("FileSystemOperations::isDirectory()");
        if (path == null) {
            String message = "FileSystemOperations::isDirectory() - path must not be null.";
            logger.fatal("FileSystemOperations::isDirectory() - path must not be null.");
            throw new NullPointerException("FileSystemOperations::isDirectory() - path must not be null.");
        }
        try {
            if (path.isDirectory()) {
                logger.debug("FileSystemOperations::isDirectory() - [" + path + "] is a directory and exists on the disk.");
                return true;
            }
            logger.debug("FileSystemOperations::isDirectory() - [" + path + "] is not a directory, or does not exist.");
            return false;
        }
        catch (Exception e2) {
            logger.error("FileSystemOperations::isDirectory() - error [" + e2.getMessage() + "] whilst attempting to check whether [" + path + "] is a directory and exists on the disk.");
            return false;
        }
    }

    public static boolean listFilenamesInDirectory(File path, FilenameFilter filter, Set<String> set) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "FileSystemOperations::listFilenamesInDirectory()";
        logger.trace("FileSystemOperations::listFilenamesInDirectory()");
        if (path == null || set == null) {
            String message = "FileSystemOperations::listFilenamesInDirectory() - path [" + path + "] and set [" + set + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        try {
            if (!path.isDirectory()) {
                String message = "FileSystemOperations::listFilenamesInDirectory() - path [" + path + "] is not a directory.";
                logger.fatal(message);
                throw new IllegalArgumentException(message);
            }
        }
        catch (Exception e2) {
            String message = "FileSystemOperations::listFilenamesInDirectory() - error [" + e2.getMessage() + "] whilst attempting to access directory [" + path + "].";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        String[] filenames = null;
        try {
            filenames = filter == null ? path.list() : path.list(filter);
        }
        catch (Exception e3) {
            logger.error("FileSystemOperations::listFilenamesInDirectory() - error [" + e3.getMessage() + "] whilst attempting to list contents of directory [" + path + "].");
            return false;
        }
        if (filenames == null) {
            logger.error("FileSystemOperations::listFilenamesInDirectory() - unable to list contents of directory [" + path + "].");
            return false;
        }
        logger.debug("FileSystemOperations::listFilenamesInDirectory() - " + filenames.length + (filenames.length == 1 ? " file found in directory [" : " files found in directory [") + path + "].");
        for (int i = 0; i < filenames.length; ++i) {
            set.add(filenames[i]);
        }
        return true;
    }

    public static boolean delete(File path) throws NullPointerException {
        String methodLogName = "FileSystemOperations::delete()";
        logger.trace("FileSystemOperations::delete()");
        if (path == null) {
            String message = "FileSystemOperations::delete() - path must not be null.";
            logger.fatal("FileSystemOperations::delete() - path must not be null.");
            throw new NullPointerException("FileSystemOperations::delete() - path must not be null.");
        }
        try {
            if (path.delete()) {
                logger.debug("FileSystemOperations::delete() - deleted [" + path + "].");
                return true;
            }
            logger.error("FileSystemOperations::delete() - could not delete [" + path + "].");
            return false;
        }
        catch (Exception e2) {
            logger.error("FileSystemOperations::delete() - error [" + e2.getMessage() + "] whilst attempting to delete [" + path + "].");
            return false;
        }
    }
}

