/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.filesystem;

import java.io.File;
import java.util.Vector;
import org.eso.util.filesystem.FileSelectionModel;

public class RecursiveFileSelectionModel
extends FileSelectionModel {
    String rootDir = null;
    Vector fileList = new Vector();

    public RecursiveFileSelectionModel(String dir) {
        if (dir == null) {
            throw new IllegalArgumentException("null dir");
        }
        this.rootDir = dir;
    }

    @Override
    public Vector getFileList() {
        this.fileList = new Vector();
        this.getFileList(new File(this.rootDir));
        return this.fileList;
    }

    private void getFileList(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            if (children == null) {
                return;
            }
            for (int i = 0; i < children.length; ++i) {
                this.getFileList(new File(dir, children[i]));
            }
        } else {
            this.fileList.add(dir.getAbsolutePath());
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            args = new String[]{"z:/giraffe/raw_hdr"};
        }
        for (String dir : args) {
            System.out.println("Recursive list of files in test directory: " + dir);
            if (dir == null) {
                System.out.println("....skipping null directory.");
                continue;
            }
            RecursiveFileSelectionModel fileSelection = new RecursiveFileSelectionModel(dir);
            Vector fullList = fileSelection.getFileList();
            for (int i = 0; i < fullList.size(); ++i) {
                System.out.println(fullList.elementAt(i));
            }
        }
    }
}

