/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import javax.sql.DataSource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactory;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedDatabaseFactoryBean
extends EmbeddedDatabaseFactory
implements FactoryBean<DataSource>,
InitializingBean,
DisposableBean {
    private DatabasePopulator databaseCleaner;

    public void setDatabaseCleaner(DatabasePopulator databaseCleaner) {
        this.databaseCleaner = databaseCleaner;
    }

    @Override
    public void afterPropertiesSet() {
        this.initDatabase();
    }

    @Override
    public void destroy() {
        if (this.databaseCleaner != null) {
            DatabasePopulatorUtils.execute(this.databaseCleaner, this.getDataSource());
        }
        this.shutdownDatabase();
    }

    @Override
    public DataSource getObject() {
        return this.getDataSource();
    }

    @Override
    public Class<? extends DataSource> getObjectType() {
        return DataSource.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

