/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the EnrollCertificateRestRequest type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &EnrollCertificateRestRequest{}

// EnrollCertificateRestRequest struct for EnrollCertificateRestRequest
type EnrollCertificateRestRequest struct {
	// Certificate request
	CertificateRequest *string `json:"certificate_request,omitempty"`
	// Certificate profile name
	CertificateProfileName *string `json:"certificate_profile_name,omitempty"`
	// End Entity profile name
	EndEntityProfileName *string `json:"end_entity_profile_name,omitempty"`
	// Certificate Authority (CA) name
	CertificateAuthorityName *string `json:"certificate_authority_name,omitempty"`
	// Username
	Username *string `json:"username,omitempty"`
	// Password
	Password *string `json:"password,omitempty"`
	// Account Binding ID
	AccountBindingId *string `json:"account_binding_id,omitempty"`
	IncludeChain     *bool   `json:"include_chain,omitempty"`
	// Email
	Email                *string `json:"email,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _EnrollCertificateRestRequest EnrollCertificateRestRequest

// NewEnrollCertificateRestRequest instantiates a new EnrollCertificateRestRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEnrollCertificateRestRequest() *EnrollCertificateRestRequest {
	this := EnrollCertificateRestRequest{}
	return &this
}

// NewEnrollCertificateRestRequestWithDefaults instantiates a new EnrollCertificateRestRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEnrollCertificateRestRequestWithDefaults() *EnrollCertificateRestRequest {
	this := EnrollCertificateRestRequest{}
	return &this
}

// GetCertificateRequest returns the CertificateRequest field value if set, zero value otherwise.
func (o *EnrollCertificateRestRequest) GetCertificateRequest() string {
	if o == nil || isNil(o.CertificateRequest) {
		var ret string
		return ret
	}
	return *o.CertificateRequest
}

// GetCertificateRequestOk returns a tuple with the CertificateRequest field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EnrollCertificateRestRequest) GetCertificateRequestOk() (*string, bool) {
	if o == nil || isNil(o.CertificateRequest) {
		return nil, false
	}
	return o.CertificateRequest, true
}

// HasCertificateRequest returns a boolean if a field has been set.
func (o *EnrollCertificateRestRequest) HasCertificateRequest() bool {
	if o != nil && !isNil(o.CertificateRequest) {
		return true
	}

	return false
}

// SetCertificateRequest gets a reference to the given string and assigns it to the CertificateRequest field.
func (o *EnrollCertificateRestRequest) SetCertificateRequest(v string) {
	o.CertificateRequest = &v
}

// GetCertificateProfileName returns the CertificateProfileName field value if set, zero value otherwise.
func (o *EnrollCertificateRestRequest) GetCertificateProfileName() string {
	if o == nil || isNil(o.CertificateProfileName) {
		var ret string
		return ret
	}
	return *o.CertificateProfileName
}

// GetCertificateProfileNameOk returns a tuple with the CertificateProfileName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EnrollCertificateRestRequest) GetCertificateProfileNameOk() (*string, bool) {
	if o == nil || isNil(o.CertificateProfileName) {
		return nil, false
	}
	return o.CertificateProfileName, true
}

// HasCertificateProfileName returns a boolean if a field has been set.
func (o *EnrollCertificateRestRequest) HasCertificateProfileName() bool {
	if o != nil && !isNil(o.CertificateProfileName) {
		return true
	}

	return false
}

// SetCertificateProfileName gets a reference to the given string and assigns it to the CertificateProfileName field.
func (o *EnrollCertificateRestRequest) SetCertificateProfileName(v string) {
	o.CertificateProfileName = &v
}

// GetEndEntityProfileName returns the EndEntityProfileName field value if set, zero value otherwise.
func (o *EnrollCertificateRestRequest) GetEndEntityProfileName() string {
	if o == nil || isNil(o.EndEntityProfileName) {
		var ret string
		return ret
	}
	return *o.EndEntityProfileName
}

// GetEndEntityProfileNameOk returns a tuple with the EndEntityProfileName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EnrollCertificateRestRequest) GetEndEntityProfileNameOk() (*string, bool) {
	if o == nil || isNil(o.EndEntityProfileName) {
		return nil, false
	}
	return o.EndEntityProfileName, true
}

// HasEndEntityProfileName returns a boolean if a field has been set.
func (o *EnrollCertificateRestRequest) HasEndEntityProfileName() bool {
	if o != nil && !isNil(o.EndEntityProfileName) {
		return true
	}

	return false
}

// SetEndEntityProfileName gets a reference to the given string and assigns it to the EndEntityProfileName field.
func (o *EnrollCertificateRestRequest) SetEndEntityProfileName(v string) {
	o.EndEntityProfileName = &v
}

// GetCertificateAuthorityName returns the CertificateAuthorityName field value if set, zero value otherwise.
func (o *EnrollCertificateRestRequest) GetCertificateAuthorityName() string {
	if o == nil || isNil(o.CertificateAuthorityName) {
		var ret string
		return ret
	}
	return *o.CertificateAuthorityName
}

// GetCertificateAuthorityNameOk returns a tuple with the CertificateAuthorityName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EnrollCertificateRestRequest) GetCertificateAuthorityNameOk() (*string, bool) {
	if o == nil || isNil(o.CertificateAuthorityName) {
		return nil, false
	}
	return o.CertificateAuthorityName, true
}

// HasCertificateAuthorityName returns a boolean if a field has been set.
func (o *EnrollCertificateRestRequest) HasCertificateAuthorityName() bool {
	if o != nil && !isNil(o.CertificateAuthorityName) {
		return true
	}

	return false
}

// SetCertificateAuthorityName gets a reference to the given string and assigns it to the CertificateAuthorityName field.
func (o *EnrollCertificateRestRequest) SetCertificateAuthorityName(v string) {
	o.CertificateAuthorityName = &v
}

// GetUsername returns the Username field value if set, zero value otherwise.
func (o *EnrollCertificateRestRequest) GetUsername() string {
	if o == nil || isNil(o.Username) {
		var ret string
		return ret
	}
	return *o.Username
}

// GetUsernameOk returns a tuple with the Username field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EnrollCertificateRestRequest) GetUsernameOk() (*string, bool) {
	if o == nil || isNil(o.Username) {
		return nil, false
	}
	return o.Username, true
}

// HasUsername returns a boolean if a field has been set.
func (o *EnrollCertificateRestRequest) HasUsername() bool {
	if o != nil && !isNil(o.Username) {
		return true
	}

	return false
}

// SetUsername gets a reference to the given string and assigns it to the Username field.
func (o *EnrollCertificateRestRequest) SetUsername(v string) {
	o.Username = &v
}

// GetPassword returns the Password field value if set, zero value otherwise.
func (o *EnrollCertificateRestRequest) GetPassword() string {
	if o == nil || isNil(o.Password) {
		var ret string
		return ret
	}
	return *o.Password
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EnrollCertificateRestRequest) GetPasswordOk() (*string, bool) {
	if o == nil || isNil(o.Password) {
		return nil, false
	}
	return o.Password, true
}

// HasPassword returns a boolean if a field has been set.
func (o *EnrollCertificateRestRequest) HasPassword() bool {
	if o != nil && !isNil(o.Password) {
		return true
	}

	return false
}

// SetPassword gets a reference to the given string and assigns it to the Password field.
func (o *EnrollCertificateRestRequest) SetPassword(v string) {
	o.Password = &v
}

// GetAccountBindingId returns the AccountBindingId field value if set, zero value otherwise.
func (o *EnrollCertificateRestRequest) GetAccountBindingId() string {
	if o == nil || isNil(o.AccountBindingId) {
		var ret string
		return ret
	}
	return *o.AccountBindingId
}

// GetAccountBindingIdOk returns a tuple with the AccountBindingId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EnrollCertificateRestRequest) GetAccountBindingIdOk() (*string, bool) {
	if o == nil || isNil(o.AccountBindingId) {
		return nil, false
	}
	return o.AccountBindingId, true
}

// HasAccountBindingId returns a boolean if a field has been set.
func (o *EnrollCertificateRestRequest) HasAccountBindingId() bool {
	if o != nil && !isNil(o.AccountBindingId) {
		return true
	}

	return false
}

// SetAccountBindingId gets a reference to the given string and assigns it to the AccountBindingId field.
func (o *EnrollCertificateRestRequest) SetAccountBindingId(v string) {
	o.AccountBindingId = &v
}

// GetIncludeChain returns the IncludeChain field value if set, zero value otherwise.
func (o *EnrollCertificateRestRequest) GetIncludeChain() bool {
	if o == nil || isNil(o.IncludeChain) {
		var ret bool
		return ret
	}
	return *o.IncludeChain
}

// GetIncludeChainOk returns a tuple with the IncludeChain field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EnrollCertificateRestRequest) GetIncludeChainOk() (*bool, bool) {
	if o == nil || isNil(o.IncludeChain) {
		return nil, false
	}
	return o.IncludeChain, true
}

// HasIncludeChain returns a boolean if a field has been set.
func (o *EnrollCertificateRestRequest) HasIncludeChain() bool {
	if o != nil && !isNil(o.IncludeChain) {
		return true
	}

	return false
}

// SetIncludeChain gets a reference to the given bool and assigns it to the IncludeChain field.
func (o *EnrollCertificateRestRequest) SetIncludeChain(v bool) {
	o.IncludeChain = &v
}

// GetEmail returns the Email field value if set, zero value otherwise.
func (o *EnrollCertificateRestRequest) GetEmail() string {
	if o == nil || isNil(o.Email) {
		var ret string
		return ret
	}
	return *o.Email
}

// GetEmailOk returns a tuple with the Email field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EnrollCertificateRestRequest) GetEmailOk() (*string, bool) {
	if o == nil || isNil(o.Email) {
		return nil, false
	}
	return o.Email, true
}

// HasEmail returns a boolean if a field has been set.
func (o *EnrollCertificateRestRequest) HasEmail() bool {
	if o != nil && !isNil(o.Email) {
		return true
	}

	return false
}

// SetEmail gets a reference to the given string and assigns it to the Email field.
func (o *EnrollCertificateRestRequest) SetEmail(v string) {
	o.Email = &v
}

func (o EnrollCertificateRestRequest) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o EnrollCertificateRestRequest) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.CertificateRequest) {
		toSerialize["certificate_request"] = o.CertificateRequest
	}
	if !isNil(o.CertificateProfileName) {
		toSerialize["certificate_profile_name"] = o.CertificateProfileName
	}
	if !isNil(o.EndEntityProfileName) {
		toSerialize["end_entity_profile_name"] = o.EndEntityProfileName
	}
	if !isNil(o.CertificateAuthorityName) {
		toSerialize["certificate_authority_name"] = o.CertificateAuthorityName
	}
	if !isNil(o.Username) {
		toSerialize["username"] = o.Username
	}
	if !isNil(o.Password) {
		toSerialize["password"] = o.Password
	}
	if !isNil(o.AccountBindingId) {
		toSerialize["account_binding_id"] = o.AccountBindingId
	}
	if !isNil(o.IncludeChain) {
		toSerialize["include_chain"] = o.IncludeChain
	}
	if !isNil(o.Email) {
		toSerialize["email"] = o.Email
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *EnrollCertificateRestRequest) UnmarshalJSON(bytes []byte) (err error) {
	varEnrollCertificateRestRequest := _EnrollCertificateRestRequest{}

	if err = json.Unmarshal(bytes, &varEnrollCertificateRestRequest); err == nil {
		*o = EnrollCertificateRestRequest(varEnrollCertificateRestRequest)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "certificate_request")
		delete(additionalProperties, "certificate_profile_name")
		delete(additionalProperties, "end_entity_profile_name")
		delete(additionalProperties, "certificate_authority_name")
		delete(additionalProperties, "username")
		delete(additionalProperties, "password")
		delete(additionalProperties, "account_binding_id")
		delete(additionalProperties, "include_chain")
		delete(additionalProperties, "email")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableEnrollCertificateRestRequest struct {
	value *EnrollCertificateRestRequest
	isSet bool
}

func (v NullableEnrollCertificateRestRequest) Get() *EnrollCertificateRestRequest {
	return v.value
}

func (v *NullableEnrollCertificateRestRequest) Set(val *EnrollCertificateRestRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableEnrollCertificateRestRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableEnrollCertificateRestRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEnrollCertificateRestRequest(val *EnrollCertificateRestRequest) *NullableEnrollCertificateRestRequest {
	return &NullableEnrollCertificateRestRequest{value: val, isSet: true}
}

func (v NullableEnrollCertificateRestRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEnrollCertificateRestRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
