/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the PaginationSummary type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PaginationSummary{}

// PaginationSummary struct for PaginationSummary
type PaginationSummary struct {
	PageSize             *int32 `json:"page_size,omitempty"`
	CurrentPage          *int32 `json:"current_page,omitempty"`
	TotalCerts           *int64 `json:"total_certs,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PaginationSummary PaginationSummary

// NewPaginationSummary instantiates a new PaginationSummary object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPaginationSummary() *PaginationSummary {
	this := PaginationSummary{}
	return &this
}

// NewPaginationSummaryWithDefaults instantiates a new PaginationSummary object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPaginationSummaryWithDefaults() *PaginationSummary {
	this := PaginationSummary{}
	return &this
}

// GetPageSize returns the PageSize field value if set, zero value otherwise.
func (o *PaginationSummary) GetPageSize() int32 {
	if o == nil || isNil(o.PageSize) {
		var ret int32
		return ret
	}
	return *o.PageSize
}

// GetPageSizeOk returns a tuple with the PageSize field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PaginationSummary) GetPageSizeOk() (*int32, bool) {
	if o == nil || isNil(o.PageSize) {
		return nil, false
	}
	return o.PageSize, true
}

// HasPageSize returns a boolean if a field has been set.
func (o *PaginationSummary) HasPageSize() bool {
	if o != nil && !isNil(o.PageSize) {
		return true
	}

	return false
}

// SetPageSize gets a reference to the given int32 and assigns it to the PageSize field.
func (o *PaginationSummary) SetPageSize(v int32) {
	o.PageSize = &v
}

// GetCurrentPage returns the CurrentPage field value if set, zero value otherwise.
func (o *PaginationSummary) GetCurrentPage() int32 {
	if o == nil || isNil(o.CurrentPage) {
		var ret int32
		return ret
	}
	return *o.CurrentPage
}

// GetCurrentPageOk returns a tuple with the CurrentPage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PaginationSummary) GetCurrentPageOk() (*int32, bool) {
	if o == nil || isNil(o.CurrentPage) {
		return nil, false
	}
	return o.CurrentPage, true
}

// HasCurrentPage returns a boolean if a field has been set.
func (o *PaginationSummary) HasCurrentPage() bool {
	if o != nil && !isNil(o.CurrentPage) {
		return true
	}

	return false
}

// SetCurrentPage gets a reference to the given int32 and assigns it to the CurrentPage field.
func (o *PaginationSummary) SetCurrentPage(v int32) {
	o.CurrentPage = &v
}

// GetTotalCerts returns the TotalCerts field value if set, zero value otherwise.
func (o *PaginationSummary) GetTotalCerts() int64 {
	if o == nil || isNil(o.TotalCerts) {
		var ret int64
		return ret
	}
	return *o.TotalCerts
}

// GetTotalCertsOk returns a tuple with the TotalCerts field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PaginationSummary) GetTotalCertsOk() (*int64, bool) {
	if o == nil || isNil(o.TotalCerts) {
		return nil, false
	}
	return o.TotalCerts, true
}

// HasTotalCerts returns a boolean if a field has been set.
func (o *PaginationSummary) HasTotalCerts() bool {
	if o != nil && !isNil(o.TotalCerts) {
		return true
	}

	return false
}

// SetTotalCerts gets a reference to the given int64 and assigns it to the TotalCerts field.
func (o *PaginationSummary) SetTotalCerts(v int64) {
	o.TotalCerts = &v
}

func (o PaginationSummary) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PaginationSummary) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.PageSize) {
		toSerialize["page_size"] = o.PageSize
	}
	if !isNil(o.CurrentPage) {
		toSerialize["current_page"] = o.CurrentPage
	}
	if !isNil(o.TotalCerts) {
		toSerialize["total_certs"] = o.TotalCerts
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PaginationSummary) UnmarshalJSON(bytes []byte) (err error) {
	varPaginationSummary := _PaginationSummary{}

	if err = json.Unmarshal(bytes, &varPaginationSummary); err == nil {
		*o = PaginationSummary(varPaginationSummary)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "page_size")
		delete(additionalProperties, "current_page")
		delete(additionalProperties, "total_certs")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePaginationSummary struct {
	value *PaginationSummary
	isSet bool
}

func (v NullablePaginationSummary) Get() *PaginationSummary {
	return v.value
}

func (v *NullablePaginationSummary) Set(val *PaginationSummary) {
	v.value = val
	v.isSet = true
}

func (v NullablePaginationSummary) IsSet() bool {
	return v.isSet
}

func (v *NullablePaginationSummary) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePaginationSummary(val *PaginationSummary) *NullablePaginationSummary {
	return &NullablePaginationSummary{value: val, isSet: true}
}

func (v NullablePaginationSummary) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePaginationSummary) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
