/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the RestResourceStatusRestResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RestResourceStatusRestResponse{}

// RestResourceStatusRestResponse struct for RestResourceStatusRestResponse
type RestResourceStatusRestResponse struct {
	// Status
	Status *string `json:"status,omitempty"`
	// Resource version
	Version *string `json:"version,omitempty"`
	// Application revision
	Revision             *string `json:"revision,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _RestResourceStatusRestResponse RestResourceStatusRestResponse

// NewRestResourceStatusRestResponse instantiates a new RestResourceStatusRestResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRestResourceStatusRestResponse() *RestResourceStatusRestResponse {
	this := RestResourceStatusRestResponse{}
	return &this
}

// NewRestResourceStatusRestResponseWithDefaults instantiates a new RestResourceStatusRestResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRestResourceStatusRestResponseWithDefaults() *RestResourceStatusRestResponse {
	this := RestResourceStatusRestResponse{}
	return &this
}

// GetStatus returns the Status field value if set, zero value otherwise.
func (o *RestResourceStatusRestResponse) GetStatus() string {
	if o == nil || isNil(o.Status) {
		var ret string
		return ret
	}
	return *o.Status
}

// GetStatusOk returns a tuple with the Status field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RestResourceStatusRestResponse) GetStatusOk() (*string, bool) {
	if o == nil || isNil(o.Status) {
		return nil, false
	}
	return o.Status, true
}

// HasStatus returns a boolean if a field has been set.
func (o *RestResourceStatusRestResponse) HasStatus() bool {
	if o != nil && !isNil(o.Status) {
		return true
	}

	return false
}

// SetStatus gets a reference to the given string and assigns it to the Status field.
func (o *RestResourceStatusRestResponse) SetStatus(v string) {
	o.Status = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *RestResourceStatusRestResponse) GetVersion() string {
	if o == nil || isNil(o.Version) {
		var ret string
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RestResourceStatusRestResponse) GetVersionOk() (*string, bool) {
	if o == nil || isNil(o.Version) {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *RestResourceStatusRestResponse) HasVersion() bool {
	if o != nil && !isNil(o.Version) {
		return true
	}

	return false
}

// SetVersion gets a reference to the given string and assigns it to the Version field.
func (o *RestResourceStatusRestResponse) SetVersion(v string) {
	o.Version = &v
}

// GetRevision returns the Revision field value if set, zero value otherwise.
func (o *RestResourceStatusRestResponse) GetRevision() string {
	if o == nil || isNil(o.Revision) {
		var ret string
		return ret
	}
	return *o.Revision
}

// GetRevisionOk returns a tuple with the Revision field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RestResourceStatusRestResponse) GetRevisionOk() (*string, bool) {
	if o == nil || isNil(o.Revision) {
		return nil, false
	}
	return o.Revision, true
}

// HasRevision returns a boolean if a field has been set.
func (o *RestResourceStatusRestResponse) HasRevision() bool {
	if o != nil && !isNil(o.Revision) {
		return true
	}

	return false
}

// SetRevision gets a reference to the given string and assigns it to the Revision field.
func (o *RestResourceStatusRestResponse) SetRevision(v string) {
	o.Revision = &v
}

func (o RestResourceStatusRestResponse) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RestResourceStatusRestResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.Status) {
		toSerialize["status"] = o.Status
	}
	if !isNil(o.Version) {
		toSerialize["version"] = o.Version
	}
	if !isNil(o.Revision) {
		toSerialize["revision"] = o.Revision
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RestResourceStatusRestResponse) UnmarshalJSON(bytes []byte) (err error) {
	varRestResourceStatusRestResponse := _RestResourceStatusRestResponse{}

	if err = json.Unmarshal(bytes, &varRestResourceStatusRestResponse); err == nil {
		*o = RestResourceStatusRestResponse(varRestResourceStatusRestResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "status")
		delete(additionalProperties, "version")
		delete(additionalProperties, "revision")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRestResourceStatusRestResponse struct {
	value *RestResourceStatusRestResponse
	isSet bool
}

func (v NullableRestResourceStatusRestResponse) Get() *RestResourceStatusRestResponse {
	return v.value
}

func (v *NullableRestResourceStatusRestResponse) Set(val *RestResourceStatusRestResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableRestResourceStatusRestResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableRestResourceStatusRestResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRestResourceStatusRestResponse(val *RestResourceStatusRestResponse) *NullableRestResourceStatusRestResponse {
	return &NullableRestResourceStatusRestResponse{value: val, isSet: true}
}

func (v NullableRestResourceStatusRestResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRestResourceStatusRestResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
