/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the SearchEndEntitiesRestRequestV2 type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &SearchEndEntitiesRestRequestV2{}

// SearchEndEntitiesRestRequestV2 struct for SearchEndEntitiesRestRequestV2
type SearchEndEntitiesRestRequestV2 struct {
	// Maximum number of results
	MaxNumberOfResults *int32 `json:"max_number_of_results,omitempty"`
	// Current page number
	CurrentPage *int32 `json:"current_page,omitempty"`
	// A List of search criteria.
	Criteria             []SearchEndEntityCriteriaRestRequest `json:"criteria,omitempty"`
	SortOperation        *SearchEndEntitiesSortRestRequest    `json:"sort_operation,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _SearchEndEntitiesRestRequestV2 SearchEndEntitiesRestRequestV2

// NewSearchEndEntitiesRestRequestV2 instantiates a new SearchEndEntitiesRestRequestV2 object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSearchEndEntitiesRestRequestV2() *SearchEndEntitiesRestRequestV2 {
	this := SearchEndEntitiesRestRequestV2{}
	return &this
}

// NewSearchEndEntitiesRestRequestV2WithDefaults instantiates a new SearchEndEntitiesRestRequestV2 object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSearchEndEntitiesRestRequestV2WithDefaults() *SearchEndEntitiesRestRequestV2 {
	this := SearchEndEntitiesRestRequestV2{}
	return &this
}

// GetMaxNumberOfResults returns the MaxNumberOfResults field value if set, zero value otherwise.
func (o *SearchEndEntitiesRestRequestV2) GetMaxNumberOfResults() int32 {
	if o == nil || isNil(o.MaxNumberOfResults) {
		var ret int32
		return ret
	}
	return *o.MaxNumberOfResults
}

// GetMaxNumberOfResultsOk returns a tuple with the MaxNumberOfResults field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SearchEndEntitiesRestRequestV2) GetMaxNumberOfResultsOk() (*int32, bool) {
	if o == nil || isNil(o.MaxNumberOfResults) {
		return nil, false
	}
	return o.MaxNumberOfResults, true
}

// HasMaxNumberOfResults returns a boolean if a field has been set.
func (o *SearchEndEntitiesRestRequestV2) HasMaxNumberOfResults() bool {
	if o != nil && !isNil(o.MaxNumberOfResults) {
		return true
	}

	return false
}

// SetMaxNumberOfResults gets a reference to the given int32 and assigns it to the MaxNumberOfResults field.
func (o *SearchEndEntitiesRestRequestV2) SetMaxNumberOfResults(v int32) {
	o.MaxNumberOfResults = &v
}

// GetCurrentPage returns the CurrentPage field value if set, zero value otherwise.
func (o *SearchEndEntitiesRestRequestV2) GetCurrentPage() int32 {
	if o == nil || isNil(o.CurrentPage) {
		var ret int32
		return ret
	}
	return *o.CurrentPage
}

// GetCurrentPageOk returns a tuple with the CurrentPage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SearchEndEntitiesRestRequestV2) GetCurrentPageOk() (*int32, bool) {
	if o == nil || isNil(o.CurrentPage) {
		return nil, false
	}
	return o.CurrentPage, true
}

// HasCurrentPage returns a boolean if a field has been set.
func (o *SearchEndEntitiesRestRequestV2) HasCurrentPage() bool {
	if o != nil && !isNil(o.CurrentPage) {
		return true
	}

	return false
}

// SetCurrentPage gets a reference to the given int32 and assigns it to the CurrentPage field.
func (o *SearchEndEntitiesRestRequestV2) SetCurrentPage(v int32) {
	o.CurrentPage = &v
}

// GetCriteria returns the Criteria field value if set, zero value otherwise.
func (o *SearchEndEntitiesRestRequestV2) GetCriteria() []SearchEndEntityCriteriaRestRequest {
	if o == nil || isNil(o.Criteria) {
		var ret []SearchEndEntityCriteriaRestRequest
		return ret
	}
	return o.Criteria
}

// GetCriteriaOk returns a tuple with the Criteria field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SearchEndEntitiesRestRequestV2) GetCriteriaOk() ([]SearchEndEntityCriteriaRestRequest, bool) {
	if o == nil || isNil(o.Criteria) {
		return nil, false
	}
	return o.Criteria, true
}

// HasCriteria returns a boolean if a field has been set.
func (o *SearchEndEntitiesRestRequestV2) HasCriteria() bool {
	if o != nil && !isNil(o.Criteria) {
		return true
	}

	return false
}

// SetCriteria gets a reference to the given []SearchEndEntityCriteriaRestRequest and assigns it to the Criteria field.
func (o *SearchEndEntitiesRestRequestV2) SetCriteria(v []SearchEndEntityCriteriaRestRequest) {
	o.Criteria = v
}

// GetSortOperation returns the SortOperation field value if set, zero value otherwise.
func (o *SearchEndEntitiesRestRequestV2) GetSortOperation() SearchEndEntitiesSortRestRequest {
	if o == nil || isNil(o.SortOperation) {
		var ret SearchEndEntitiesSortRestRequest
		return ret
	}
	return *o.SortOperation
}

// GetSortOperationOk returns a tuple with the SortOperation field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SearchEndEntitiesRestRequestV2) GetSortOperationOk() (*SearchEndEntitiesSortRestRequest, bool) {
	if o == nil || isNil(o.SortOperation) {
		return nil, false
	}
	return o.SortOperation, true
}

// HasSortOperation returns a boolean if a field has been set.
func (o *SearchEndEntitiesRestRequestV2) HasSortOperation() bool {
	if o != nil && !isNil(o.SortOperation) {
		return true
	}

	return false
}

// SetSortOperation gets a reference to the given SearchEndEntitiesSortRestRequest and assigns it to the SortOperation field.
func (o *SearchEndEntitiesRestRequestV2) SetSortOperation(v SearchEndEntitiesSortRestRequest) {
	o.SortOperation = &v
}

func (o SearchEndEntitiesRestRequestV2) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o SearchEndEntitiesRestRequestV2) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.MaxNumberOfResults) {
		toSerialize["max_number_of_results"] = o.MaxNumberOfResults
	}
	if !isNil(o.CurrentPage) {
		toSerialize["current_page"] = o.CurrentPage
	}
	if !isNil(o.Criteria) {
		toSerialize["criteria"] = o.Criteria
	}
	if !isNil(o.SortOperation) {
		toSerialize["sort_operation"] = o.SortOperation
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *SearchEndEntitiesRestRequestV2) UnmarshalJSON(bytes []byte) (err error) {
	varSearchEndEntitiesRestRequestV2 := _SearchEndEntitiesRestRequestV2{}

	if err = json.Unmarshal(bytes, &varSearchEndEntitiesRestRequestV2); err == nil {
		*o = SearchEndEntitiesRestRequestV2(varSearchEndEntitiesRestRequestV2)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "max_number_of_results")
		delete(additionalProperties, "current_page")
		delete(additionalProperties, "criteria")
		delete(additionalProperties, "sort_operation")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableSearchEndEntitiesRestRequestV2 struct {
	value *SearchEndEntitiesRestRequestV2
	isSet bool
}

func (v NullableSearchEndEntitiesRestRequestV2) Get() *SearchEndEntitiesRestRequestV2 {
	return v.value
}

func (v *NullableSearchEndEntitiesRestRequestV2) Set(val *SearchEndEntitiesRestRequestV2) {
	v.value = val
	v.isSet = true
}

func (v NullableSearchEndEntitiesRestRequestV2) IsSet() bool {
	return v.isSet
}

func (v *NullableSearchEndEntitiesRestRequestV2) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSearchEndEntitiesRestRequestV2(val *SearchEndEntitiesRestRequestV2) *NullableSearchEndEntitiesRestRequestV2 {
	return &NullableSearchEndEntitiesRestRequestV2{value: val, isSet: true}
}

func (v NullableSearchEndEntitiesRestRequestV2) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSearchEndEntitiesRestRequestV2) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
