/*============================================================================*
 *============================================================================*
 * Component:           plextor-tool-applet
 * Filename:            gplextor-tool.h
 *                                                                             
 * Authors:             Georg Huettenegger
 *                                                                             
 * Date of Creation:    Fri Jul 30 16:03:48 1999
 *                                                                             
 * Last Modification:   Fri Jul 30 16:03:48 1999
 *                                                                             
 * Copyright:           Georg Huettenegger                                     
 *                                                                             
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                             
 *============================================================================*
 *============================================================================*
 */
#ifndef ___GPLEXTOR_TOOL_H
#define ___GPLEXTOR_TOOL_H

#include <gnome.h>
#include "plextor-tool.h"

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Common defines for the GNOME applet.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
#define APPLNAME "plextor-tool-applet"
#define PACKAGE "plextor-tool-applet"
#define WIDTH 56
#define HEIGHT 48

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Two structures used with the GNOME applet to provide all functions with
 * all necessary information (about the controlled devices and about
 * all GUI related data).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
typedef struct
{
  PlextorToolData ptd;                          /* common structure */
  GList * avail_speeds;                         /* the available speeds */
  GList * avail_spindowns;                      /* the available spin-down
                                                 * times */
  gboolean act_lock_volume;                     /* whether left/right volume
						 * is locked */
} GPlextorToolData;

typedef struct
{
  GList * device_data;                          /* contains GPlextorToolDatas*/
  GtkWidget * applet;                           /* the applet widget itself */
  GList * device_names;                         /* contains the device names */

#if (defined CALL_TRACE) || (defined VERBOSE_OUTPUT)
  /* debug output */
  FILE * out_file_ptr;
#endif

  /* data to detect changes in combos */
  char * old_device_selection;
  char * old_speed_selection;
  char * old_spindown_selection;

  /* used for the interface in the panel itself */
  GtkWidget * device_selection_combo;
  GtkWidget * speed_selection_combo;
  gint dev_sel_signal_id;
  gint speed_sel_signal_id;

  /* the properties box */
  gboolean prop_active;                         /* is property window vis.? */
  GnomePropertyBox * prop_win;                  /* the properties window */
  GtkWidget * prop_dev_selection_combo;
  GtkWidget * prop_speed_selection_combo;
  GtkWidget * prop_avail_spindowns_combo;
  GtkWidget * nsd_toggle;
  GtkWidget * avoid_vib_toggle;
  GtkWidget * waiting_toggle;
  GtkAdjustment * left_volume;
  GtkAdjustment * right_volume;
  GtkWidget * lock_volume;
  gint prop_dev_sel_signal_id;
  gint prop_speed_sel_signal_id;
  gint prop_avail_spindwn_signal_id;
  gint prop_nsd_toggle_signal_id;
  gint prop_avoid_vib_toggle_signal_id;
  gint prop_waiting_toggle_signal_id;
  gint prop_left_volume_signal_id;
  gint prop_right_volume_signal_id;
  gint prop_lock_volume_signal_id;
} GPlextorToolAppletData;

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Function invoked when applet is activated. Just calls
 * make_new_plextor_tool_applet.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
GtkWidget * applet_start_new_applet (const gchar * goad_id,
                                     const char * params[], int nparams);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Actually shows the applet (creates the GPlextorToolAppletData structure,
 * searches for devices, loads information from the GNOME session management,
 * and builds the gui for the user).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
GtkWidget * make_new_plextor_tool_applet (const char * goad_id);

#endif


/*============================================================================*
 *============================================================================*
 * EOF gplextor-tool.h
 *============================================================================*
 *============================================================================*
 */
