/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.dialog.util;

import com.projectlibre1.datatype.Hyperlink;
import com.projectlibre1.dialog.FieldDialog;
import com.projectlibre1.dialog.util.ExtDateField;
import com.projectlibre1.dialog.util.FieldChangeListener;
import com.projectlibre1.dialog.util.FieldVerifier;
import com.projectlibre1.dialog.util.FixedSizeFilter;
import com.projectlibre1.dialog.util.LinkLabel;
import com.projectlibre1.dialog.util.LookupField;
import com.projectlibre1.field.Field;
import com.projectlibre1.field.FieldContext;
import com.projectlibre1.field.FieldParseException;
import com.projectlibre1.field.ObjectRef;
import com.projectlibre1.field.Range;
import com.projectlibre1.field.StaticSelect;
import com.projectlibre1.options.CalendarOption;
import com.projectlibre1.options.EditOption;
import com.projectlibre1.pm.graphic.spreadsheet.editor.SpinEditor;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.Alert;
import com.projectlibre1.util.ClassUtils;
import com.projectlibre1.util.DateTime;
import com.projectlibre1.util.MathUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;

public class ComponentFactory {
    public static final int READ_ONLY = 1;
    public static final int SOMETIMES_READ_ONLY = 2;
    private static double MAX_VALUE = 6.0E7;
    private static FieldContext context = null;

    private static JComponent getFieldComponent(JComponent jComponent) {
        if (jComponent instanceof JScrollPane) {
            jComponent = (JComponent)((JScrollPane)jComponent).getViewport().getComponent(0);
        }
        return jComponent;
    }

    static JTextField getSpinnerTextField(JSpinner jSpinner) {
        return ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField();
    }

    public static Object getValueFromComponent(JComponent jComponent, Field field) {
        if ((jComponent = ComponentFactory.getFieldComponent(jComponent)) instanceof JTextField) {
            return ((JTextField)jComponent).getText();
        }
        if (jComponent instanceof JTextArea) {
            return ((JTextArea)jComponent).getText();
        }
        if (jComponent instanceof JCheckBox) {
            return new Boolean(((JCheckBox)jComponent).isSelected());
        }
        if (jComponent instanceof ExtDateField) {
            return ((ExtDateField)jComponent).getDateValue();
        }
        if (jComponent instanceof JComboBox) {
            return ((JComboBox)jComponent).getSelectedItem();
        }
        if (jComponent instanceof JSpinner) {
            return SpinEditor.getValue((JSpinner)jComponent, field);
        }
        return null;
    }

    static void markComponentAsUnmodified(JComponent jComponent) {
        jComponent.setForeground(Color.BLACK);
        ComponentFactory.verifiedComponent(jComponent).setForeground(Color.BLACK);
    }

    public static void setValueOfComponent(JComponent jComponent, Object object, boolean bl) {
        boolean bl2 = ClassUtils.isMultipleValue(object);
        if ((jComponent = ComponentFactory.getFieldComponent(jComponent)) instanceof JTextField) {
            ((JTextField)jComponent).setText(object == null ? "" : (bl2 ? "" : object.toString()));
        } else if (jComponent instanceof JTextArea) {
            ((JTextArea)jComponent).setText(object == null ? "" : (bl2 ? "" : object.toString()));
        } else if (jComponent instanceof JCheckBox) {
            ((JCheckBox)jComponent).setSelected(object == null ? false : (Boolean)object);
        } else if (jComponent instanceof ExtDateField) {
            if (DateTime.getZeroDate().equals(object)) {
                object = null;
            }
            ((ExtDateField)jComponent).setValue(object == null ? null : object);
        } else if (jComponent instanceof JComboBox) {
            ((JComboBox)jComponent).setSelectedItem(object);
        } else if (jComponent instanceof JSpinner && object != null) {
            ((JSpinner)jComponent).setValue(object);
            if (bl2) {
                ComponentFactory.getSpinnerTextField((JSpinner)jComponent).setText("");
            }
        } else if (jComponent instanceof LinkLabel) {
            ((LinkLabel)jComponent).setHyperlink((Hyperlink)object);
        } else if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setText(object == null ? "" : object.toString());
        } else if (jComponent instanceof LookupField) {
            ((LookupField)jComponent).setText(object == null ? "" : object.toString());
        }
        jComponent.setEnabled(!bl);
        ComponentFactory.markComponentAsUnmodified(jComponent);
    }

    private static JComponent componentFor(final Field field, Object object, boolean bl) {
        Component component = null;
        Range range = field.getRange();
        Component component2 = null;
        if (object instanceof Boolean) {
            component = new JCheckBox(field.getName(), (boolean)((Boolean)object));
        } else if (bl) {
            component = field.isHyperlink() ? new LinkLabel((Hyperlink)object) : new JLabel();
        } else if (field.isDate()) {
            ExtDateField extDateField = ComponentFactory.createDateField(field);
            Component[] componentArray = extDateField.getComponents();
            extDateField.getFormattedTextField().addActionListener(new FieldVerifier.VerifierListener());
            component = extDateField;
            component2 = (JTextComponent)ComponentFactory.verifiedComponent(component);
        } else if (field.getLookupTypes() != null) {
            component = new LookupField(field, null);
        } else if (field.hasOptions()) {
            final JComboBox<Object> jComboBox = new JComboBox<Object>(field.getOptions(null));
            jComboBox.addActionListener(new FieldVerifier.VerifierListener());
            component = jComboBox;
            if (field.isDynamicOptions()) {
                jComboBox.getComponent(0).addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        jComboBox.setModel(new DefaultComboBoxModel<Object>(field.getOptions(null)));
                        jComboBox.showPopup();
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                    }
                });
            }
        } else if (range != null) {
            component = SpinEditor.getJSpinnerInstance(field, ((Number)object).doubleValue(), false);
            JSpinner jSpinner = (JSpinner)component;
            Component component3 = component2 = ComponentFactory.getSpinnerTextField(jSpinner);
            ((JSpinner)component).addChangeListener(new ChangeListener((JTextComponent)component3, jSpinner){
                final /* synthetic */ JTextComponent val$t;
                final /* synthetic */ JSpinner val$spinner;
                {
                    this.val$t = jTextComponent;
                    this.val$spinner = jSpinner;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    FieldVerifier fieldVerifier = (FieldVerifier)this.val$t.getInputVerifier();
                    boolean bl = true;
                    if (fieldVerifier != null) {
                        Number number = (Number)this.val$spinner.getValue();
                        if (number == null) {
                            return;
                        }
                        double d = MathUtils.roundToDecentPrecision(number.doubleValue());
                        bl = fieldVerifier == null || fieldVerifier.getValue() == null ? false : d == ((Number)fieldVerifier.getValue()).doubleValue();
                    }
                    this.val$t.setForeground(bl ? Color.BLACK : Color.BLUE);
                }
            });
        } else if (field.isMemo()) {
            component2 = new JTextArea();
            component = new JScrollPane(component2);
        } else {
            component2 = new JTextField();
            int n = field.getTextWidth(null, null);
            if (n != Integer.MAX_VALUE) {
                ((AbstractDocument)((JTextComponent)component2).getDocument()).setDocumentFilter(new FixedSizeFilter(n));
            }
            component = component2;
        }
        if (component2 != null) {
            component2.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    JTextComponent jTextComponent = (JTextComponent)keyEvent.getComponent();
                    jTextComponent.setForeground(Color.BLUE);
                    FieldDialog fieldDialog = ComponentFactory.getParentFieldDialog(jTextComponent);
                    if (fieldDialog != null) {
                        fieldDialog.setDirtyComponent(jTextComponent);
                    }
                }
            });
        }
        if (!(component instanceof JCheckBox)) {
            ComponentFactory.setValueOfComponent(component, object, bl);
        }
        return component;
    }

    public static FieldDialog getParentFieldDialog(Component component) {
        while (component != null && !(component instanceof FieldDialog)) {
            component = component.getParent();
        }
        return (FieldDialog)component;
    }

    public static Object getFieldValue(Field field, ObjectRef objectRef) {
        if (field.hasOptions()) {
            return field.getText(objectRef, context);
        }
        Object object = field.getValue(objectRef, context);
        if (object != null && field.isDate()) {
            object = new Date(DateTime.dayFloor(((Date)object).getTime()));
        }
        return object;
    }

    public static void updateValueOfComponent(JComponent jComponent, Field field, ObjectRef objectRef) {
        Object object;
        boolean bl;
        boolean bl2 = bl = jComponent instanceof JLabel || field.isReadOnly(objectRef, context);
        if (jComponent instanceof LinkLabel) {
            object = field.getValue(objectRef, context);
        } else if (jComponent instanceof LookupField) {
            object = field.getValue(objectRef, context);
        } else if (jComponent instanceof JLabel) {
            object = field.getText(objectRef, context);
        } else if (field.hasOptions() && field.getSelect() instanceof StaticSelect) {
            object = field.getText(objectRef, context);
            if (object instanceof String && ((String)object).length() == 0) {
                object = null;
            }
        } else {
            object = field.isDuration() || field.isRate() ? field.getText(objectRef, context) : field.getValue(objectRef, context);
        }
        if (!bl && field.isDate() && object != null && !(object instanceof Date)) {
            System.out.println("bad date");
            object = field.getValue(objectRef, context);
            return;
        }
        JComponent jComponent2 = ComponentFactory.verifiedComponent(jComponent);
        FieldVerifier fieldVerifier = (FieldVerifier)jComponent2.getInputVerifier();
        if (fieldVerifier != null) {
            fieldVerifier.setUpdating(true);
        }
        ComponentFactory.setValueOfComponent(jComponent, object, bl);
        if (fieldVerifier != null) {
            fieldVerifier.setValue(object);
            fieldVerifier.setUpdating(false);
        }
        ComponentFactory.markComponentAsUnmodified(jComponent);
    }

    static JComponent verifiedComponent(JComponent jComponent) {
        if (jComponent instanceof ExtDateField) {
            return ((ExtDateField)jComponent).getFormattedTextField();
        }
        if (jComponent instanceof JSpinner) {
            return ComponentFactory.getSpinnerTextField((JSpinner)jComponent);
        }
        if (jComponent instanceof LookupField) {
            return ((LookupField)jComponent).getDisplay();
        }
        return jComponent;
    }

    private static void setVerifier(JComponent jComponent, FieldVerifier fieldVerifier) {
        jComponent = ComponentFactory.getFieldComponent(jComponent);
        JComponent jComponent2 = ComponentFactory.verifiedComponent(jComponent);
        jComponent2.setInputVerifier(fieldVerifier);
    }

    public static JComponent componentFor(Field field, ObjectRef objectRef, int n) {
        JComponent jComponent;
        Object object = ComponentFactory.getFieldValue(field, objectRef);
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = field.isReadOnly(objectRef, context);
        bl |= bl3;
        if (bl2) {
            bl = false;
        }
        if ((jComponent = ComponentFactory.componentFor(field, object, bl)) instanceof LookupField) {
            ((LookupField)jComponent).addChangeListener(new FieldChangeListener(field, objectRef));
        } else if (!bl) {
            if (jComponent instanceof JCheckBox) {
                ((JCheckBox)jComponent).addItemListener(new FieldChangeListener(field, objectRef));
            } else if ("Field.accessControlPolicy".equals(field.getId())) {
                jComponent.setInputVerifier(new FieldVerifier(field, objectRef, ComponentFactory.getValueFromComponent(jComponent, field)){

                    @Override
                    public boolean verify(JComponent jComponent) {
                        JComboBox jComboBox = (JComboBox)jComponent;
                        Object object = ComponentFactory.getValueFromComponent(jComponent, this.field);
                        Object e = jComboBox.getItemAt(0);
                        if (object != this.value) {
                            Integer n = (Integer)this.field.getValue(this.objectRef, this.context);
                            try {
                                if (n == 1 && e.equals(object)) {
                                    if (Alert.okCancel(Messages.getString("Text.resetRoles"))) {
                                        Project project = (Project)this.objectRef.getObject();
                                        project.resetRoles(true);
                                        this.field.setValue(this.objectRef, this.source, object, this.context);
                                        return true;
                                    }
                                    jComboBox.setSelectedIndex(n);
                                    return false;
                                }
                                this.field.setValue(this.objectRef, this.source, object, this.context);
                            }
                            catch (FieldParseException fieldParseException) {
                                // empty catch block
                            }
                        }
                        return true;
                    }

                    @Override
                    public boolean shouldYieldFocus(JComponent jComponent) {
                        return true;
                    }
                });
            } else {
                ComponentFactory.setVerifier(jComponent, new FieldVerifier(field, objectRef, ComponentFactory.getValueFromComponent(jComponent, field)));
            }
        } else if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setText(field.getText(objectRef, context));
        }
        if (bl2 && bl3) {
            jComponent.setEnabled(false);
        }
        return jComponent;
    }

    public static ExtDateField createDateField() {
        return ComponentFactory.createDateField(null);
    }

    public static ExtDateField createDateField(Field field) {
        DateFormat dateFormat;
        long l = DateTime.midnightToday();
        if (field != null) {
            dateFormat = field.isDateOnly() ? EditOption.getInstance().getShortDateFormat() : EditOption.getInstance().getDateFormat();
            if (field.isStartValue()) {
                l = CalendarOption.getInstance().makeValidStart(l, true);
            } else if (field.isEndValue()) {
                l = CalendarOption.getInstance().makeValidEnd(l, true);
            }
        } else {
            dateFormat = EditOption.getInstance().getShortDateFormat();
        }
        ExtDateField extDateField = new ExtDateField(dateFormat);
        extDateField.getFormattedTextField().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JFormattedTextField jFormattedTextField = (JFormattedTextField)propertyChangeEvent.getSource();
                if (propertyChangeEvent.getPropertyName().equals("value") && propertyChangeEvent.getNewValue() != propertyChangeEvent.getOldValue() && jFormattedTextField.getInputVerifier() != null) {
                    jFormattedTextField.getInputVerifier().verify(jFormattedTextField);
                }
            }
        });
        return extDateField;
    }
}

