RabbitMQ `3.11.21` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).
This release series [goes out of community support on Dec 31, 2023](https://rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25 and supports Erlang versions up to `25.3.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Bug Fixes

 * Certain diagnostics operations during rolling upgrades from 3.10 to 3.11 could fail
   if the `listener_records_in_ets` feature flag was enabled in the middle of the upgrade.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#8984](https://github.com/rabbitmq/rabbitmq-server/pull/8984)

 * On Windows, PowerShell will no longer be used as a fallback for `handle.exe`
   for computing how many file and socket handles a node uses.

   If a user does not have `handle.exe`` installed in the `PATH`` of their Windows system,
   a message will be logged once, and then the total handles being used will be set to 0.

   PowerShell ended up being a CPU-intensive alternative that's not worth the gains
   for many installations.

   GitHub issue: [#8700](https://github.com/rabbitmq/rabbitmq-server/issues/8700)

 * Node maintenance state was not replicated to all nodes, even though it was accessible
   from any node (and for any node).

   GitHub issue: [#9011](https://github.com/rabbitmq/rabbitmq-server/pull/9011)


### CLI Tools

#### Enhacements

 * Some warnings were emitted even when `--formatter` was set to `json`.

   GitHub issue: [#8912](https://github.com/rabbitmq/rabbitmq-server/issues/8912)


### HTTP AuthN/AuthZ Backend Plugin

#### Bug Fixes

 * AMQP 1.0 client connections were refused with this plugin.

   GitHub issue: [#9043](https://github.com/rabbitmq/rabbitmq-server/issues/9043)


### LDAP AuthN/AuthZ Backend Plugin

#### Bug Fixes

 * AMQP 1.0 client connections were refused with this plugin.

   GitHub issue: [#9043](https://github.com/rabbitmq/rabbitmq-server/issues/9043)


## Dependency Upgrades

 * `osiris` was upgraded to [`1.6.2`](https://github.com/rabbitmq/osiris/tags)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.21.tar.xz`
instead of the source tarball produced by GitHub.
