// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LogProfileStep Log Profile Step
//
// Defines what to log for a given step.
//
// swagger:model log_profile_step
type LogProfileStep struct {
	// If enabled, no log shall be emitted for the given step.
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Drop string `json:"drop,omitempty"`

	// Override "log-format" or "error-log-format" strings depending on the step.
	Format string `json:"format,omitempty"`

	// Override the "log-format-sd" string.
	Sd string `json:"sd,omitempty"`

	// Logging step name.
	// Required: true
	// Enum: ["accept","any","close","connect","error","request","response","http-req","http-res","http-after-res","quic-init","tcp-req-conn","tcp-req-cont","tcp-req-sess"]
	// +kubebuilder:validation:Enum=accept;any;close;connect;error;request;response;http-req;http-res;http-after-res;quic-init;tcp-req-conn;tcp-req-cont;tcp-req-sess;
	Step string `json:"step"`
}

// Validate validates this log profile step
func (m *LogProfileStep) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDrop(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStep(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var logProfileStepTypeDropPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		logProfileStepTypeDropPropEnum = append(logProfileStepTypeDropPropEnum, v)
	}
}

const (

	// LogProfileStepDropEnabled captures enum value "enabled"
	LogProfileStepDropEnabled string = "enabled"

	// LogProfileStepDropDisabled captures enum value "disabled"
	LogProfileStepDropDisabled string = "disabled"
)

// prop value enum
func (m *LogProfileStep) validateDropEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, logProfileStepTypeDropPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LogProfileStep) validateDrop(formats strfmt.Registry) error {
	if swag.IsZero(m.Drop) { // not required
		return nil
	}

	// value enum
	if err := m.validateDropEnum("drop", "body", m.Drop); err != nil {
		return err
	}

	return nil
}

var logProfileStepTypeStepPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["accept","any","close","connect","error","request","response","http-req","http-res","http-after-res","quic-init","tcp-req-conn","tcp-req-cont","tcp-req-sess"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		logProfileStepTypeStepPropEnum = append(logProfileStepTypeStepPropEnum, v)
	}
}

const (

	// LogProfileStepStepAccept captures enum value "accept"
	LogProfileStepStepAccept string = "accept"

	// LogProfileStepStepAny captures enum value "any"
	LogProfileStepStepAny string = "any"

	// LogProfileStepStepClose captures enum value "close"
	LogProfileStepStepClose string = "close"

	// LogProfileStepStepConnect captures enum value "connect"
	LogProfileStepStepConnect string = "connect"

	// LogProfileStepStepError captures enum value "error"
	LogProfileStepStepError string = "error"

	// LogProfileStepStepRequest captures enum value "request"
	LogProfileStepStepRequest string = "request"

	// LogProfileStepStepResponse captures enum value "response"
	LogProfileStepStepResponse string = "response"

	// LogProfileStepStepHTTPDashReq captures enum value "http-req"
	LogProfileStepStepHTTPDashReq string = "http-req"

	// LogProfileStepStepHTTPDashRes captures enum value "http-res"
	LogProfileStepStepHTTPDashRes string = "http-res"

	// LogProfileStepStepHTTPDashAfterDashRes captures enum value "http-after-res"
	LogProfileStepStepHTTPDashAfterDashRes string = "http-after-res"

	// LogProfileStepStepQuicDashInit captures enum value "quic-init"
	LogProfileStepStepQuicDashInit string = "quic-init"

	// LogProfileStepStepTCPDashReqDashConn captures enum value "tcp-req-conn"
	LogProfileStepStepTCPDashReqDashConn string = "tcp-req-conn"

	// LogProfileStepStepTCPDashReqDashCont captures enum value "tcp-req-cont"
	LogProfileStepStepTCPDashReqDashCont string = "tcp-req-cont"

	// LogProfileStepStepTCPDashReqDashSess captures enum value "tcp-req-sess"
	LogProfileStepStepTCPDashReqDashSess string = "tcp-req-sess"
)

// prop value enum
func (m *LogProfileStep) validateStepEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, logProfileStepTypeStepPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *LogProfileStep) validateStep(formats strfmt.Registry) error {

	if err := validate.RequiredString("step", "body", m.Step); err != nil {
		return err
	}

	// value enum
	if err := m.validateStepEnum("step", "body", m.Step); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this log profile step based on context it is used
func (m *LogProfileStep) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LogProfileStep) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogProfileStep) UnmarshalBinary(b []byte) error {
	var res LogProfileStep
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
