package labservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// SchedulesClient is the client for the Schedules methods of the Labservices service.
type SchedulesClient struct {
	BaseClient
}

// NewSchedulesClient creates an instance of the SchedulesClient client.
func NewSchedulesClient(subscriptionID string) SchedulesClient {
	return NewSchedulesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewSchedulesClientWithBaseURI creates an instance of the SchedulesClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewSchedulesClientWithBaseURI(baseURI string, subscriptionID string) SchedulesClient {
	return SchedulesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate operation to create or update a lab schedule.
// Parameters:
// body - the request body.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labName - the name of the lab that uniquely identifies it within containing lab account. Used in resource
// URIs.
// scheduleName - the name of the schedule that uniquely identifies it within containing lab. Used in resource
// URIs.
func (client SchedulesClient) CreateOrUpdate(ctx context.Context, body Schedule, resourceGroupName string, labName string, scheduleName string) (result Schedule, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SchedulesClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body.ScheduleProperties", Name: validation.Null, Rule: true, Chain: nil}}},
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labName,
			Constraints: []validation.Constraint{{Target: "labName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: scheduleName,
			Constraints: []validation.Constraint{{Target: "scheduleName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "scheduleName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "scheduleName", Name: validation.Pattern, Rule: `^[-\w\\._\\(\\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.SchedulesClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, body, resourceGroupName, labName, scheduleName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client SchedulesClient) CreateOrUpdatePreparer(ctx context.Context, body Schedule, resourceGroupName string, labName string, scheduleName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labName":           autorest.Encode("path", labName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"scheduleName":      autorest.Encode("path", scheduleName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	body.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/schedules/{scheduleName}", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client SchedulesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client SchedulesClient) CreateOrUpdateResponder(resp *http.Response) (result Schedule, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete operation to delete a schedule resource.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labName - the name of the lab that uniquely identifies it within containing lab account. Used in resource
// URIs.
// scheduleName - the name of the schedule that uniquely identifies it within containing lab. Used in resource
// URIs.
func (client SchedulesClient) Delete(ctx context.Context, resourceGroupName string, labName string, scheduleName string) (result SchedulesDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SchedulesClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labName,
			Constraints: []validation.Constraint{{Target: "labName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: scheduleName,
			Constraints: []validation.Constraint{{Target: "scheduleName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "scheduleName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "scheduleName", Name: validation.Pattern, Rule: `^[-\w\\._\\(\\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.SchedulesClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, labName, scheduleName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client SchedulesClient) DeletePreparer(ctx context.Context, resourceGroupName string, labName string, scheduleName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labName":           autorest.Encode("path", labName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"scheduleName":      autorest.Encode("path", scheduleName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/schedules/{scheduleName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client SchedulesClient) DeleteSender(req *http.Request) (future SchedulesDeleteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client SchedulesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get returns the properties of a lab Schedule.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labName - the name of the lab that uniquely identifies it within containing lab account. Used in resource
// URIs.
// scheduleName - the name of the schedule that uniquely identifies it within containing lab. Used in resource
// URIs.
func (client SchedulesClient) Get(ctx context.Context, resourceGroupName string, labName string, scheduleName string) (result Schedule, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SchedulesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labName,
			Constraints: []validation.Constraint{{Target: "labName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: scheduleName,
			Constraints: []validation.Constraint{{Target: "scheduleName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "scheduleName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "scheduleName", Name: validation.Pattern, Rule: `^[-\w\\._\\(\\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.SchedulesClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, labName, scheduleName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client SchedulesClient) GetPreparer(ctx context.Context, resourceGroupName string, labName string, scheduleName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labName":           autorest.Encode("path", labName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"scheduleName":      autorest.Encode("path", scheduleName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/schedules/{scheduleName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client SchedulesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client SchedulesClient) GetResponder(resp *http.Response) (result Schedule, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByLab returns a list of all schedules for a lab.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labName - the name of the lab that uniquely identifies it within containing lab account. Used in resource
// URIs.
// filter - the filter to apply to the operation.
func (client SchedulesClient) ListByLab(ctx context.Context, resourceGroupName string, labName string, filter string) (result PagedSchedulesPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SchedulesClient.ListByLab")
		defer func() {
			sc := -1
			if result.ps.Response.Response != nil {
				sc = result.ps.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labName,
			Constraints: []validation.Constraint{{Target: "labName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.SchedulesClient", "ListByLab", err.Error())
	}

	result.fn = client.listByLabNextResults
	req, err := client.ListByLabPreparer(ctx, resourceGroupName, labName, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "ListByLab", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByLabSender(req)
	if err != nil {
		result.ps.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "ListByLab", resp, "Failure sending request")
		return
	}

	result.ps, err = client.ListByLabResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "ListByLab", resp, "Failure responding to request")
		return
	}
	if result.ps.hasNextLink() && result.ps.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByLabPreparer prepares the ListByLab request.
func (client SchedulesClient) ListByLabPreparer(ctx context.Context, resourceGroupName string, labName string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labName":           autorest.Encode("path", labName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/schedules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByLabSender sends the ListByLab request. The method will close the
// http.Response Body if it receives an error.
func (client SchedulesClient) ListByLabSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByLabResponder handles the response to the ListByLab request. The method always
// closes the http.Response Body.
func (client SchedulesClient) ListByLabResponder(resp *http.Response) (result PagedSchedules, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByLabNextResults retrieves the next set of results, if any.
func (client SchedulesClient) listByLabNextResults(ctx context.Context, lastResults PagedSchedules) (result PagedSchedules, err error) {
	req, err := lastResults.pagedSchedulesPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "labservices.SchedulesClient", "listByLabNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByLabSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "labservices.SchedulesClient", "listByLabNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByLabResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "listByLabNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByLabComplete enumerates all values, automatically crossing page boundaries as required.
func (client SchedulesClient) ListByLabComplete(ctx context.Context, resourceGroupName string, labName string, filter string) (result PagedSchedulesIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SchedulesClient.ListByLab")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByLab(ctx, resourceGroupName, labName, filter)
	return
}

// Update operation to update a lab schedule.
// Parameters:
// body - the request body.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// labName - the name of the lab that uniquely identifies it within containing lab account. Used in resource
// URIs.
// scheduleName - the name of the schedule that uniquely identifies it within containing lab. Used in resource
// URIs.
func (client SchedulesClient) Update(ctx context.Context, body ScheduleUpdate, resourceGroupName string, labName string, scheduleName string) (result Schedule, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SchedulesClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: labName,
			Constraints: []validation.Constraint{{Target: "labName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "labName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: scheduleName,
			Constraints: []validation.Constraint{{Target: "scheduleName", Name: validation.MaxLength, Rule: 100, Chain: nil},
				{Target: "scheduleName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "scheduleName", Name: validation.Pattern, Rule: `^[-\w\\._\\(\\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.SchedulesClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, body, resourceGroupName, labName, scheduleName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.SchedulesClient", "Update", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client SchedulesClient) UpdatePreparer(ctx context.Context, body ScheduleUpdate, resourceGroupName string, labName string, scheduleName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"labName":           autorest.Encode("path", labName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"scheduleName":      autorest.Encode("path", scheduleName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/schedules/{scheduleName}", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client SchedulesClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client SchedulesClient) UpdateResponder(resp *http.Response) (result Schedule, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
