proc makeJalStringFunction { name string } {
   set r ""
   if { [ string length $string ] > 255 } {
      error ">> string for $name too long"
   }
   set n 0
   while { $n < [ string length $string ] } {
      set c [ string index $string $n ]
      set r "$r\n   if x == $n then return \"$c\" end if"
      incr n
   }
   set r "$r\n   return 0"
   set r "function $name ( byte in x ) return byte is $r\nend function"
   return $r
}

proc toAscii { char } {
   scan $char %c value
   return $value
}


proc toChar { value } {
   return [format %c $value]
}

proc makeAsciiChecksum text {
   set sum 0
   foreach line $text {
      foreach c [ split $line {} ] { 
         set n [ toAscii $c ]      
         set sum [ expr $sum + $n]
         if { $sum >= 256 } {
            set sum [ expr $sum - 256 ]
         }
# puts "$c $n $sum"
      }
   }
   return $sum
}

proc makeJalTextFunction { name text } {
   set r1 ""
   set r2 ""
   set n 0
   foreach line $text {
      set x [ makeJalStringFunction $name$n $line ]
      set r1 "$r1\n$x"
      set r2 "$r2\n   if x == $n then return $name$n ( y ) end if"
      incr n
   }
   set r2 "$r2\n   return -1"
   set r2 "function $name ( byte in x, byte in y ) return byte is\n$r2\nend function"
   set sum [ makeAsciiChecksum $text ]
   set r3 "const byte $name-checksum = $sum"
   return "$r1\n$r2\n\n$r3"
}

proc mariner { } {
   return [ makeJalTextFunction mariner {
      {IT IS an ancient Mariner}
      {And he stoppeth one of three.}
      {'By thy long grey beard and glittering eye}
      {Now wherefor stopp'st thou me?}
      {}
      {The Bridegroom's doors are open wide,}
      {And I am next of kin;}
      {The guest are met, the feast is set:}
      {May'st hear the merry din.'}
      {}
      {He holds him with his skinny hand,}
      {'There was a ship,' qoth he.}
      {'Hold off! unhand me, grey-beard loon!'}
      {Eftsoons his hand dropt he.}
      {}
      {He holds him with his glittering eye--}
      {The Wedding-Guest stood still,}
      {And listens like a three years' child:}
      {The Mariner hath his will.}
      {}
      {The Wedding-Guest sat on a stone;}
      {He cannot choose but hear;}
      {And thus spake on that ancient man,}
      {The bright-eyed Mariner.}
   } ]
}

proc toFile { file text } {
   set f [ open $file "w" ]
   puts $f $text
   close $f
}

toFile mtext.jal [ mariner ]