/* error location handling
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __ERRORLH_H__
#define __ERRORLH_H__

/* data which describes a source location */
typedef struct {
    char *file_name;
    char *line;
    int line_nr;
    int token_start;
    int token_size;
} loc_r;

typedef loc_r *loc_t;

extern char e_string[];
extern loc_t nowhere;

/* return allocated string which describes location loc */
char *location_string(loc_t loc);

/* short version of the above */
char *loc_string(loc_t loc);

/********** logging and error handling **********/

/* log with build-in sprintf */
void flog(char *file, int line, char *m);

extern string _log_string;
#define log(x) { \
   char *m=_log_string; sprintf x; flog( __FILE__, __LINE__, m ); }
#define trace  { \
   flog( __FILE__, __LINE__, "trace" ); }

/* report a fatal error (with context) and exit */
void ffatal(loc_t loc, char *m);

/* idem with build-in sprintf */
#define fatal( loc, x ) { string m; \
   sprintf x; \
   ffatal( loc, m ); \
}

/* fatal using the current context */
#define cfatal( x ) fatal( scanner_context->loc, x )

/* check an internal assumption */
void assert_fail_f(loc_t loc, char *file, int line);

#define jal_assert( loc, x ) { \
   if( check_asserts) { \
      if( ! ( x ) ){ assert_fail_f( loc, __FILE__, __LINE__ ); } \
   } \
}

/* idem with implicit location */
#define cassert( x ) jal_assert( scanner_context->loc, x )

/* report an internal inconsistency */
#define snark( loc ) jal_assert( loc, false );

/* report a node which was not expected in this context */
#define snark_node( loc, p ){ \
   if( verbose_stack ) stack_dump(); \
   log((m, "node nr=%04d kind=%s", \
      p->nr, node_name[ p->kind ] )); \
   assert_fail_f( loc, __FILE__, __LINE__ ); \
}

#define pre_check 12345678
#define post_check 56789012

/* check whether a pointer points to an allocated block */
void assert_pointer_p(loc_t loc, char *s, int n, void *p);

void assert_arena_2(char *s, int n);

void assert_pointer_2(loc_t loc, char *s, int n, void *p);

#define assert_chain { \
   assert_arena_2( __FILE__, __LINE__, p ); \
}
#define assert_pointer( loc, p ){ \
   if( check_asserts ){ \
      assert_pointer_2( loc, __FILE__, __LINE__, p ); \
   } \
}

/* checked malloc */
extern int total_memory;
#define allocation_chunk ( 64 * 1024 )
extern char *allocation_buffer;
extern int allocation_buffer_size;
void free_all(void);

void *_allocate(int size, int line);

#endif
