/* tree tools
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __TREETOOLS_H__
#define __TREETOOLS_H__

tree follow(tree p);

boolean is_type_compatible(tree p, tree q);

void check_type_compatible(loc_t loc, tree p, tree q);

tree new_assign(loc_t loc, tree d, tree s);

tree new_assign_actual(loc_t loc, tree d, tree s);

/* return the maximum depth of the expression */
int expression_depth(tree p);

/* return call depth (== stack use) */
void call_depth_2(tree p, int *n);


int call_depth(tree p);

/* a list of strings */
typedef struct string_list_struct *string_list;
typedef struct string_list_struct {
    char *s;
    string_list next;
} string_list_element;
void string_list_add(string_list * p, char *s);

/* prepare and print call tree */
extern string_list call_tree_root;
void call_tree_2(tree p, int *n);

int make_call_tree(tree p);

void print_call_tree(FILE * f);

tree clone2(tree p, boolean dup);

tree clone(tree p);

/* count the number of assembler locations */
int code_size(tree p);


/* determine whether the code sequence can be skipped
 * using a skip instruction
 */
int can_be_skipped(tree p);

/* set register bank bits */
tree code_register_bank(tree p, tree x);

/* set code page bits */
tree code_code_page(tree p, tree x);

/********** scoping **********/

/* A declaration with a name which starts with a space
 * is used to delimit the build-in declarations which
 * can not be re-declared.
 *
 * A declaration with first_decl == true marks the beggining
 * of a scope.
 */

extern tree last_chain;
extern tree last_decl;
extern boolean first_decl;

/* macro to open a new list of statements */
#define open_list( q ) \
   tree save_last_chain    = last_chain; \
   tree save_last_decl     = last_decl; \
   boolean save_first_decl = first_decl; \
   tree q                  = new_chain2( NULL, NULL ); \
   last_chain              = q; \
   first_decl              = true; \

/* close the current list of statements and revert to the previous one */
#define close_list \
   last_chain = save_last_chain; \
   last_decl  = save_last_decl; \
   first_decl = save_first_decl; \

/* add a node to the current list of statements */
void add(tree p);

tree arg(tree p, int n, boolean must_find);

boolean operator_match(op_t op, tree left, tree right, tree p);

/* try to find a name in the indicated scope */
tree find_general(string ss, op_t op, tree left, tree right, boolean local, boolean use);


tree find_local(string s);

tree find(string s);

tree find_local_operator(op_t op, tree left, tree right);

tree find_operator(op_t op, tree left, tree right);

/* check and add name to the current scope */
void check_and_add(tree p);

/********** basic jal types **********/

tree type_tree(char *s, int bits, int large);

void init_types(void);

/* return whether p is a basic integer type */
boolean is_buildin_type(tree p);

/* chop a value node according to its type */
void chop(tree p);

#endif
