// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudtrail

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTags for more information on using the AddTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/AddTags
func (c *CloudTrail) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	output = &AddTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTags API operation for AWS CloudTrail.
//
// Adds one or more tags to a trail, up to a limit of 50. Overwrites an existing
// tag's value when a new value is specified for an existing tag key. Tag key
// names must be unique for a trail; you cannot have two keys with the same
// name but different values. If you specify a key without a value, the tag
// will be created with the specified key and a value of null. You can tag a
// trail that applies to all Amazon Web Services Regions only from the Region
// in which the trail was created (also known as its home region).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation AddTags for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the specified resource is not found.
//
//   * ARNInvalidException
//   This exception is thrown when an operation is called with a trail ARN that
//   is not valid. The following is the format of a trail ARN.
//
//   arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
//
//   * ResourceTypeNotSupportedException
//   This exception is thrown when the specified resource type is not supported
//   by CloudTrail.
//
//   * TagsLimitExceededException
//   The number of tags per trail has exceeded the permitted amount. Currently,
//   the limit is 50.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * InvalidTagParameterException
//   This exception is thrown when the specified tag key or values are not valid.
//   It can also occur if there are duplicate tags or too many tags on the resource.
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
//   * NotOrganizationMasterAccountException
//   This exception is thrown when the Amazon Web Services account making the
//   request to create or update an organization trail is not the management account
//   for an organization in Organizations. For more information, see Prepare For
//   Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/AddTags
func (c *CloudTrail) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	return out, req.Send()
}

// AddTagsWithContext is the same as AddTags with the addition of
// the ability to pass a context and additional request options.
//
// See AddTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) AddTagsWithContext(ctx aws.Context, input *AddTagsInput, opts ...request.Option) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrail = "CreateTrail"

// CreateTrailRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrail for more information on using the CreateTrail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrailRequest method.
//    req, resp := client.CreateTrailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateTrail
func (c *CloudTrail) CreateTrailRequest(input *CreateTrailInput) (req *request.Request, output *CreateTrailOutput) {
	op := &request.Operation{
		Name:       opCreateTrail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrailInput{}
	}

	output = &CreateTrailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrail API operation for AWS CloudTrail.
//
// Creates a trail that specifies the settings for delivery of log data to an
// Amazon S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation CreateTrail for usage and error information.
//
// Returned Error Types:
//   * MaximumNumberOfTrailsExceededException
//   This exception is thrown when the maximum number of trails is reached.
//
//   * TrailAlreadyExistsException
//   This exception is thrown when the specified trail already exists.
//
//   * S3BucketDoesNotExistException
//   This exception is thrown when the specified S3 bucket does not exist.
//
//   * InsufficientS3BucketPolicyException
//   This exception is thrown when the policy on the S3 bucket is not sufficient.
//
//   * InsufficientSnsTopicPolicyException
//   This exception is thrown when the policy on the Amazon SNS topic is not sufficient.
//
//   * InsufficientEncryptionPolicyException
//   This exception is thrown when the policy on the S3 bucket or KMS key is not
//   sufficient.
//
//   * InvalidS3BucketNameException
//   This exception is thrown when the provided S3 bucket name is not valid.
//
//   * InvalidS3PrefixException
//   This exception is thrown when the provided S3 prefix is not valid.
//
//   * InvalidSnsTopicNameException
//   This exception is thrown when the provided SNS topic name is not valid.
//
//   * InvalidKmsKeyIdException
//   This exception is thrown when the KMS key ARN is not valid.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * TrailNotProvidedException
//   This exception is no longer in use.
//
//   * InvalidParameterCombinationException
//   This exception is thrown when the combination of parameters provided is not
//   valid.
//
//   * KmsKeyNotFoundException
//   This exception is thrown when the KMS key does not exist, when the S3 bucket
//   and the KMS key are not in the same region, or when the KMS key associated
//   with the Amazon SNS topic either does not exist or is not in the same region.
//
//   * KmsKeyDisabledException
//   This exception is no longer in use.
//
//   * KmsException
//   This exception is thrown when there is an issue with the specified KMS key
//   and the trail can’t be updated.
//
//   * InvalidCloudWatchLogsLogGroupArnException
//   This exception is thrown when the provided CloudWatch Logs log group is not
//   valid.
//
//   * InvalidCloudWatchLogsRoleArnException
//   This exception is thrown when the provided role is not valid.
//
//   * CloudWatchLogsDeliveryUnavailableException
//   Cannot set a CloudWatch Logs delivery for this region.
//
//   * InvalidTagParameterException
//   This exception is thrown when the specified tag key or values are not valid.
//   It can also occur if there are duplicate tags or too many tags on the resource.
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
//   * AccessNotEnabledException
//   This exception is thrown when trusted access has not been enabled between
//   CloudTrail and Organizations. For more information, see Enabling Trusted
//   Access with Other Amazon Web Services Services (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html)
//   and Prepare For Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
//   * InsufficientDependencyServiceAccessPermissionException
//   This exception is thrown when the IAM user or role that is used to create
//   the organization trail is lacking one or more required permissions for creating
//   an organization trail in a required service. For more information, see Prepare
//   For Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
//   * NotOrganizationMasterAccountException
//   This exception is thrown when the Amazon Web Services account making the
//   request to create or update an organization trail is not the management account
//   for an organization in Organizations. For more information, see Prepare For
//   Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
//   * OrganizationsNotInUseException
//   This exception is thrown when the request is made from an Amazon Web Services
//   account that is not a member of an organization. To make this request, sign
//   in using the credentials of an account that belongs to an organization.
//
//   * OrganizationNotInAllFeaturesModeException
//   This exception is thrown when Organizations is not configured to support
//   all features. All features must be enabled in Organizations to support creating
//   an organization trail. For more information, see Prepare For Creating a Trail
//   For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
//   * CloudTrailInvalidClientTokenIdException
//   This exception is thrown when a call results in the InvalidClientTokenId
//   error code. This can occur when you are creating or updating a trail to send
//   notifications to an Amazon SNS topic that is in a suspended Amazon Web Services
//   account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateTrail
func (c *CloudTrail) CreateTrail(input *CreateTrailInput) (*CreateTrailOutput, error) {
	req, out := c.CreateTrailRequest(input)
	return out, req.Send()
}

// CreateTrailWithContext is the same as CreateTrail with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) CreateTrailWithContext(ctx aws.Context, input *CreateTrailInput, opts ...request.Option) (*CreateTrailOutput, error) {
	req, out := c.CreateTrailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrail = "DeleteTrail"

// DeleteTrailRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrail for more information on using the DeleteTrail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrailRequest method.
//    req, resp := client.DeleteTrailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrail
func (c *CloudTrail) DeleteTrailRequest(input *DeleteTrailInput) (req *request.Request, output *DeleteTrailOutput) {
	op := &request.Operation{
		Name:       opDeleteTrail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrailInput{}
	}

	output = &DeleteTrailOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTrail API operation for AWS CloudTrail.
//
// Deletes a trail. This operation must be called from the region in which the
// trail was created. DeleteTrail cannot be called on the shadow trails (replicated
// trails in other regions) of a trail that is enabled in all regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation DeleteTrail for usage and error information.
//
// Returned Error Types:
//   * TrailNotFoundException
//   This exception is thrown when the trail with the given name is not found.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * InvalidHomeRegionException
//   This exception is thrown when an operation is called on a trail from a region
//   other than the region in which the trail was created.
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
//   * NotOrganizationMasterAccountException
//   This exception is thrown when the Amazon Web Services account making the
//   request to create or update an organization trail is not the management account
//   for an organization in Organizations. For more information, see Prepare For
//   Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
//   * InsufficientDependencyServiceAccessPermissionException
//   This exception is thrown when the IAM user or role that is used to create
//   the organization trail is lacking one or more required permissions for creating
//   an organization trail in a required service. For more information, see Prepare
//   For Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
//   * ConflictException
//   This exception is thrown when the specified resource is not ready for an
//   operation. This can occur when you try to run an operation on a trail before
//   CloudTrail has time to fully load the trail. If this exception occurs, wait
//   a few minutes, and then try the operation again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrail
func (c *CloudTrail) DeleteTrail(input *DeleteTrailInput) (*DeleteTrailOutput, error) {
	req, out := c.DeleteTrailRequest(input)
	return out, req.Send()
}

// DeleteTrailWithContext is the same as DeleteTrail with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) DeleteTrailWithContext(ctx aws.Context, input *DeleteTrailInput, opts ...request.Option) (*DeleteTrailOutput, error) {
	req, out := c.DeleteTrailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrails = "DescribeTrails"

// DescribeTrailsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrails for more information on using the DescribeTrails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrailsRequest method.
//    req, resp := client.DescribeTrailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrails
func (c *CloudTrail) DescribeTrailsRequest(input *DescribeTrailsInput) (req *request.Request, output *DescribeTrailsOutput) {
	op := &request.Operation{
		Name:       opDescribeTrails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrailsInput{}
	}

	output = &DescribeTrailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrails API operation for AWS CloudTrail.
//
// Retrieves settings for one or more trails associated with the current region
// for your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation DescribeTrails for usage and error information.
//
// Returned Error Types:
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrails
func (c *CloudTrail) DescribeTrails(input *DescribeTrailsInput) (*DescribeTrailsOutput, error) {
	req, out := c.DescribeTrailsRequest(input)
	return out, req.Send()
}

// DescribeTrailsWithContext is the same as DescribeTrails with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) DescribeTrailsWithContext(ctx aws.Context, input *DescribeTrailsInput, opts ...request.Option) (*DescribeTrailsOutput, error) {
	req, out := c.DescribeTrailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventSelectors = "GetEventSelectors"

// GetEventSelectorsRequest generates a "aws/request.Request" representing the
// client's request for the GetEventSelectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventSelectors for more information on using the GetEventSelectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEventSelectorsRequest method.
//    req, resp := client.GetEventSelectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventSelectors
func (c *CloudTrail) GetEventSelectorsRequest(input *GetEventSelectorsInput) (req *request.Request, output *GetEventSelectorsOutput) {
	op := &request.Operation{
		Name:       opGetEventSelectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEventSelectorsInput{}
	}

	output = &GetEventSelectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventSelectors API operation for AWS CloudTrail.
//
// Describes the settings for the event selectors that you configured for your
// trail. The information returned for your event selectors includes the following:
//
//    * If your event selector includes read-only events, write-only events,
//    or all events. This applies to both management events and data events.
//
//    * If your event selector includes management events.
//
//    * If your event selector includes data events, the resources on which
//    you are logging data events.
//
// For more information, see Logging Data and Management Events for Trails (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html)
// in the CloudTrail User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation GetEventSelectors for usage and error information.
//
// Returned Error Types:
//   * TrailNotFoundException
//   This exception is thrown when the trail with the given name is not found.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventSelectors
func (c *CloudTrail) GetEventSelectors(input *GetEventSelectorsInput) (*GetEventSelectorsOutput, error) {
	req, out := c.GetEventSelectorsRequest(input)
	return out, req.Send()
}

// GetEventSelectorsWithContext is the same as GetEventSelectors with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventSelectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) GetEventSelectorsWithContext(ctx aws.Context, input *GetEventSelectorsInput, opts ...request.Option) (*GetEventSelectorsOutput, error) {
	req, out := c.GetEventSelectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInsightSelectors = "GetInsightSelectors"

// GetInsightSelectorsRequest generates a "aws/request.Request" representing the
// client's request for the GetInsightSelectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInsightSelectors for more information on using the GetInsightSelectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInsightSelectorsRequest method.
//    req, resp := client.GetInsightSelectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetInsightSelectors
func (c *CloudTrail) GetInsightSelectorsRequest(input *GetInsightSelectorsInput) (req *request.Request, output *GetInsightSelectorsOutput) {
	op := &request.Operation{
		Name:       opGetInsightSelectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInsightSelectorsInput{}
	}

	output = &GetInsightSelectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInsightSelectors API operation for AWS CloudTrail.
//
// Describes the settings for the Insights event selectors that you configured
// for your trail. GetInsightSelectors shows if CloudTrail Insights event logging
// is enabled on the trail, and if it is, which insight types are enabled. If
// you run GetInsightSelectors on a trail that does not have Insights events
// enabled, the operation throws the exception InsightNotEnabledException
//
// For more information, see Logging CloudTrail Insights Events for Trails (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html)
// in the CloudTrail User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation GetInsightSelectors for usage and error information.
//
// Returned Error Types:
//   * TrailNotFoundException
//   This exception is thrown when the trail with the given name is not found.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
//   * InsightNotEnabledException
//   If you run GetInsightSelectors on a trail that does not have Insights events
//   enabled, the operation throws the exception InsightNotEnabledException.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetInsightSelectors
func (c *CloudTrail) GetInsightSelectors(input *GetInsightSelectorsInput) (*GetInsightSelectorsOutput, error) {
	req, out := c.GetInsightSelectorsRequest(input)
	return out, req.Send()
}

// GetInsightSelectorsWithContext is the same as GetInsightSelectors with the addition of
// the ability to pass a context and additional request options.
//
// See GetInsightSelectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) GetInsightSelectorsWithContext(ctx aws.Context, input *GetInsightSelectorsInput, opts ...request.Option) (*GetInsightSelectorsOutput, error) {
	req, out := c.GetInsightSelectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTrail = "GetTrail"

// GetTrailRequest generates a "aws/request.Request" representing the
// client's request for the GetTrail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrail for more information on using the GetTrail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTrailRequest method.
//    req, resp := client.GetTrailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrail
func (c *CloudTrail) GetTrailRequest(input *GetTrailInput) (req *request.Request, output *GetTrailOutput) {
	op := &request.Operation{
		Name:       opGetTrail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTrailInput{}
	}

	output = &GetTrailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrail API operation for AWS CloudTrail.
//
// Returns settings information for a specified trail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation GetTrail for usage and error information.
//
// Returned Error Types:
//   * TrailNotFoundException
//   This exception is thrown when the trail with the given name is not found.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrail
func (c *CloudTrail) GetTrail(input *GetTrailInput) (*GetTrailOutput, error) {
	req, out := c.GetTrailRequest(input)
	return out, req.Send()
}

// GetTrailWithContext is the same as GetTrail with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) GetTrailWithContext(ctx aws.Context, input *GetTrailInput, opts ...request.Option) (*GetTrailOutput, error) {
	req, out := c.GetTrailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTrailStatus = "GetTrailStatus"

// GetTrailStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetTrailStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrailStatus for more information on using the GetTrailStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTrailStatusRequest method.
//    req, resp := client.GetTrailStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrailStatus
func (c *CloudTrail) GetTrailStatusRequest(input *GetTrailStatusInput) (req *request.Request, output *GetTrailStatusOutput) {
	op := &request.Operation{
		Name:       opGetTrailStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTrailStatusInput{}
	}

	output = &GetTrailStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrailStatus API operation for AWS CloudTrail.
//
// Returns a JSON-formatted list of information about the specified trail. Fields
// include information on delivery errors, Amazon SNS and Amazon S3 errors,
// and start and stop logging times for each trail. This operation returns trail
// status from a single region. To return trail status from all regions, you
// must call the operation on each region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation GetTrailStatus for usage and error information.
//
// Returned Error Types:
//   * TrailNotFoundException
//   This exception is thrown when the trail with the given name is not found.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrailStatus
func (c *CloudTrail) GetTrailStatus(input *GetTrailStatusInput) (*GetTrailStatusOutput, error) {
	req, out := c.GetTrailStatusRequest(input)
	return out, req.Send()
}

// GetTrailStatusWithContext is the same as GetTrailStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrailStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) GetTrailStatusWithContext(ctx aws.Context, input *GetTrailStatusInput, opts ...request.Option) (*GetTrailStatusOutput, error) {
	req, out := c.GetTrailStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPublicKeys = "ListPublicKeys"

// ListPublicKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListPublicKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPublicKeys for more information on using the ListPublicKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPublicKeysRequest method.
//    req, resp := client.ListPublicKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys
func (c *CloudTrail) ListPublicKeysRequest(input *ListPublicKeysInput) (req *request.Request, output *ListPublicKeysOutput) {
	op := &request.Operation{
		Name:       opListPublicKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPublicKeysInput{}
	}

	output = &ListPublicKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPublicKeys API operation for AWS CloudTrail.
//
// Returns all public keys whose private keys were used to sign the digest files
// within the specified time range. The public key is needed to validate digest
// files that were signed with its corresponding private key.
//
// CloudTrail uses different private and public key pairs per region. Each digest
// file is signed with a private key unique to its region. When you validate
// a digest file from a specific region, you must look in the same region for
// its corresponding public key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation ListPublicKeys for usage and error information.
//
// Returned Error Types:
//   * InvalidTimeRangeException
//   Occurs if the timestamp values are not valid. Either the start time occurs
//   after the end time, or the time range is outside the range of possible values.
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
//   * InvalidTokenException
//   Reserved for future use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys
func (c *CloudTrail) ListPublicKeys(input *ListPublicKeysInput) (*ListPublicKeysOutput, error) {
	req, out := c.ListPublicKeysRequest(input)
	return out, req.Send()
}

// ListPublicKeysWithContext is the same as ListPublicKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ListPublicKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) ListPublicKeysWithContext(ctx aws.Context, input *ListPublicKeysInput, opts ...request.Option) (*ListPublicKeysOutput, error) {
	req, out := c.ListPublicKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPublicKeysPages iterates over the pages of a ListPublicKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPublicKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPublicKeys operation.
//    pageNum := 0
//    err := client.ListPublicKeysPages(params,
//        func(page *cloudtrail.ListPublicKeysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudTrail) ListPublicKeysPages(input *ListPublicKeysInput, fn func(*ListPublicKeysOutput, bool) bool) error {
	return c.ListPublicKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPublicKeysPagesWithContext same as ListPublicKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) ListPublicKeysPagesWithContext(ctx aws.Context, input *ListPublicKeysInput, fn func(*ListPublicKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPublicKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPublicKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPublicKeysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTags
func (c *CloudTrail) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for AWS CloudTrail.
//
// Lists the tags for the trail in the current region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation ListTags for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the specified resource is not found.
//
//   * ARNInvalidException
//   This exception is thrown when an operation is called with a trail ARN that
//   is not valid. The following is the format of a trail ARN.
//
//   arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
//
//   * ResourceTypeNotSupportedException
//   This exception is thrown when the specified resource type is not supported
//   by CloudTrail.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
//   * InvalidTokenException
//   Reserved for future use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTags
func (c *CloudTrail) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsPages iterates over the pages of a ListTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTags operation.
//    pageNum := 0
//    err := client.ListTagsPages(params,
//        func(page *cloudtrail.ListTagsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudTrail) ListTagsPages(input *ListTagsInput, fn func(*ListTagsOutput, bool) bool) error {
	return c.ListTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsPagesWithContext same as ListTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) ListTagsPagesWithContext(ctx aws.Context, input *ListTagsInput, fn func(*ListTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrails = "ListTrails"

// ListTrailsRequest generates a "aws/request.Request" representing the
// client's request for the ListTrails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrails for more information on using the ListTrails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrailsRequest method.
//    req, resp := client.ListTrailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTrails
func (c *CloudTrail) ListTrailsRequest(input *ListTrailsInput) (req *request.Request, output *ListTrailsOutput) {
	op := &request.Operation{
		Name:       opListTrails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrailsInput{}
	}

	output = &ListTrailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrails API operation for AWS CloudTrail.
//
// Lists trails that are in the current account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation ListTrails for usage and error information.
//
// Returned Error Types:
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTrails
func (c *CloudTrail) ListTrails(input *ListTrailsInput) (*ListTrailsOutput, error) {
	req, out := c.ListTrailsRequest(input)
	return out, req.Send()
}

// ListTrailsWithContext is the same as ListTrails with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) ListTrailsWithContext(ctx aws.Context, input *ListTrailsInput, opts ...request.Option) (*ListTrailsOutput, error) {
	req, out := c.ListTrailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrailsPages iterates over the pages of a ListTrails operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrails method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTrails operation.
//    pageNum := 0
//    err := client.ListTrailsPages(params,
//        func(page *cloudtrail.ListTrailsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudTrail) ListTrailsPages(input *ListTrailsInput, fn func(*ListTrailsOutput, bool) bool) error {
	return c.ListTrailsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrailsPagesWithContext same as ListTrailsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) ListTrailsPagesWithContext(ctx aws.Context, input *ListTrailsInput, fn func(*ListTrailsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrailsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrailsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrailsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opLookupEvents = "LookupEvents"

// LookupEventsRequest generates a "aws/request.Request" representing the
// client's request for the LookupEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See LookupEvents for more information on using the LookupEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the LookupEventsRequest method.
//    req, resp := client.LookupEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents
func (c *CloudTrail) LookupEventsRequest(input *LookupEventsInput) (req *request.Request, output *LookupEventsOutput) {
	op := &request.Operation{
		Name:       opLookupEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &LookupEventsInput{}
	}

	output = &LookupEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// LookupEvents API operation for AWS CloudTrail.
//
// Looks up management events (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events)
// or CloudTrail Insights events (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events)
// that are captured by CloudTrail. You can look up events that occurred in
// a region within the last 90 days. Lookup supports the following attributes
// for management events:
//
//    * Amazon Web Services access key
//
//    * Event ID
//
//    * Event name
//
//    * Event source
//
//    * Read only
//
//    * Resource name
//
//    * Resource type
//
//    * User name
//
// Lookup supports the following attributes for Insights events:
//
//    * Event ID
//
//    * Event name
//
//    * Event source
//
// All attributes are optional. The default number of results returned is 50,
// with a maximum of 50 possible. The response includes a token that you can
// use to get the next page of results.
//
// The rate of lookup requests is limited to two per second, per account, per
// region. If this limit is exceeded, a throttling error occurs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation LookupEvents for usage and error information.
//
// Returned Error Types:
//   * InvalidLookupAttributesException
//   Occurs when a lookup attribute is specified that is not valid.
//
//   * InvalidTimeRangeException
//   Occurs if the timestamp values are not valid. Either the start time occurs
//   after the end time, or the time range is outside the range of possible values.
//
//   * InvalidMaxResultsException
//   This exception is thrown if the limit specified is not valid.
//
//   * InvalidNextTokenException
//   A token that is not valid, or a token that was previously used in a request
//   with different parameters. This exception is thrown if the token is not valid.
//
//   * InvalidEventCategoryException
//   Occurs if an event category that is not valid is specified as a value of
//   EventCategory.
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents
func (c *CloudTrail) LookupEvents(input *LookupEventsInput) (*LookupEventsOutput, error) {
	req, out := c.LookupEventsRequest(input)
	return out, req.Send()
}

// LookupEventsWithContext is the same as LookupEvents with the addition of
// the ability to pass a context and additional request options.
//
// See LookupEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) LookupEventsWithContext(ctx aws.Context, input *LookupEventsInput, opts ...request.Option) (*LookupEventsOutput, error) {
	req, out := c.LookupEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// LookupEventsPages iterates over the pages of a LookupEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See LookupEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a LookupEvents operation.
//    pageNum := 0
//    err := client.LookupEventsPages(params,
//        func(page *cloudtrail.LookupEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudTrail) LookupEventsPages(input *LookupEventsInput, fn func(*LookupEventsOutput, bool) bool) error {
	return c.LookupEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// LookupEventsPagesWithContext same as LookupEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) LookupEventsPagesWithContext(ctx aws.Context, input *LookupEventsInput, fn func(*LookupEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *LookupEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.LookupEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*LookupEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutEventSelectors = "PutEventSelectors"

// PutEventSelectorsRequest generates a "aws/request.Request" representing the
// client's request for the PutEventSelectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEventSelectors for more information on using the PutEventSelectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEventSelectorsRequest method.
//    req, resp := client.PutEventSelectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectors
func (c *CloudTrail) PutEventSelectorsRequest(input *PutEventSelectorsInput) (req *request.Request, output *PutEventSelectorsOutput) {
	op := &request.Operation{
		Name:       opPutEventSelectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEventSelectorsInput{}
	}

	output = &PutEventSelectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEventSelectors API operation for AWS CloudTrail.
//
// Configures an event selector or advanced event selectors for your trail.
// Use event selectors or advanced event selectors to specify management and
// data event settings for your trail. By default, trails created without specific
// event selectors are configured to log all read and write management events,
// and no data events.
//
// When an event occurs in your account, CloudTrail evaluates the event selectors
// or advanced event selectors in all trails. For each trail, if the event matches
// any event selector, the trail processes and logs the event. If the event
// doesn't match any event selector, the trail doesn't log the event.
//
// Example
//
// You create an event selector for a trail and specify that you want write-only
// events.
//
// The EC2 GetConsoleOutput and RunInstances API operations occur in your account.
//
// CloudTrail evaluates whether the events match your event selectors.
//
// The RunInstances is a write-only event and it matches your event selector.
// The trail logs the event.
//
// The GetConsoleOutput is a read-only event that doesn't match your event selector.
// The trail doesn't log the event.
//
// The PutEventSelectors operation must be called from the region in which the
// trail was created; otherwise, an InvalidHomeRegionException exception is
// thrown.
//
// You can configure up to five event selectors for each trail. For more information,
// see Logging data and management events for trails (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html)
// and Quotas in CloudTrail (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html)
// in the CloudTrail User Guide.
//
// You can add advanced event selectors, and conditions for your advanced event
// selectors, up to a maximum of 500 values for all conditions and selectors
// on a trail. You can use either AdvancedEventSelectors or EventSelectors,
// but not both. If you apply AdvancedEventSelectors to a trail, any existing
// EventSelectors are overwritten. For more information about advanced event
// selectors, see Logging data events for trails (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html)
// in the CloudTrail User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation PutEventSelectors for usage and error information.
//
// Returned Error Types:
//   * TrailNotFoundException
//   This exception is thrown when the trail with the given name is not found.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * InvalidHomeRegionException
//   This exception is thrown when an operation is called on a trail from a region
//   other than the region in which the trail was created.
//
//   * InvalidEventSelectorsException
//   This exception is thrown when the PutEventSelectors operation is called with
//   a number of event selectors, advanced event selectors, or data resources
//   that is not valid. The combination of event selectors or advanced event selectors
//   and data resources is not valid. A trail can have up to 5 event selectors.
//   If a trail uses advanced event selectors, a maximum of 500 total values for
//   all conditions in all advanced event selectors is allowed. A trail is limited
//   to 250 data resources. These data resources can be distributed across event
//   selectors, but the overall total cannot exceed 250.
//
//   You can:
//
//      * Specify a valid number of event selectors (1 to 5) for a trail.
//
//      * Specify a valid number of data resources (1 to 250) for an event selector.
//      The limit of number of resources on an individual event selector is configurable
//      up to 250. However, this upper limit is allowed only if the total number
//      of data resources does not exceed 250 across all event selectors for a
//      trail.
//
//      * Specify up to 500 values for all conditions in all advanced event selectors
//      for a trail.
//
//      * Specify a valid value for a parameter. For example, specifying the ReadWriteType
//      parameter with a value of read-only is not valid.
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
//   * NotOrganizationMasterAccountException
//   This exception is thrown when the Amazon Web Services account making the
//   request to create or update an organization trail is not the management account
//   for an organization in Organizations. For more information, see Prepare For
//   Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
//   * InsufficientDependencyServiceAccessPermissionException
//   This exception is thrown when the IAM user or role that is used to create
//   the organization trail is lacking one or more required permissions for creating
//   an organization trail in a required service. For more information, see Prepare
//   For Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectors
func (c *CloudTrail) PutEventSelectors(input *PutEventSelectorsInput) (*PutEventSelectorsOutput, error) {
	req, out := c.PutEventSelectorsRequest(input)
	return out, req.Send()
}

// PutEventSelectorsWithContext is the same as PutEventSelectors with the addition of
// the ability to pass a context and additional request options.
//
// See PutEventSelectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) PutEventSelectorsWithContext(ctx aws.Context, input *PutEventSelectorsInput, opts ...request.Option) (*PutEventSelectorsOutput, error) {
	req, out := c.PutEventSelectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutInsightSelectors = "PutInsightSelectors"

// PutInsightSelectorsRequest generates a "aws/request.Request" representing the
// client's request for the PutInsightSelectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutInsightSelectors for more information on using the PutInsightSelectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutInsightSelectorsRequest method.
//    req, resp := client.PutInsightSelectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutInsightSelectors
func (c *CloudTrail) PutInsightSelectorsRequest(input *PutInsightSelectorsInput) (req *request.Request, output *PutInsightSelectorsOutput) {
	op := &request.Operation{
		Name:       opPutInsightSelectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutInsightSelectorsInput{}
	}

	output = &PutInsightSelectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutInsightSelectors API operation for AWS CloudTrail.
//
// Lets you enable Insights event logging by specifying the Insights selectors
// that you want to enable on an existing trail. You also use PutInsightSelectors
// to turn off Insights event logging, by passing an empty list of insight types.
// The valid Insights event type in this release is ApiCallRateInsight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation PutInsightSelectors for usage and error information.
//
// Returned Error Types:
//   * TrailNotFoundException
//   This exception is thrown when the trail with the given name is not found.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * InvalidHomeRegionException
//   This exception is thrown when an operation is called on a trail from a region
//   other than the region in which the trail was created.
//
//   * InvalidInsightSelectorsException
//   The formatting or syntax of the InsightSelectors JSON statement in your PutInsightSelectors
//   or GetInsightSelectors request is not valid, or the specified insight type
//   in the InsightSelectors statement is not a valid insight type.
//
//   * InsufficientS3BucketPolicyException
//   This exception is thrown when the policy on the S3 bucket is not sufficient.
//
//   * InsufficientEncryptionPolicyException
//   This exception is thrown when the policy on the S3 bucket or KMS key is not
//   sufficient.
//
//   * S3BucketDoesNotExistException
//   This exception is thrown when the specified S3 bucket does not exist.
//
//   * KmsException
//   This exception is thrown when there is an issue with the specified KMS key
//   and the trail can’t be updated.
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
//   * NotOrganizationMasterAccountException
//   This exception is thrown when the Amazon Web Services account making the
//   request to create or update an organization trail is not the management account
//   for an organization in Organizations. For more information, see Prepare For
//   Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutInsightSelectors
func (c *CloudTrail) PutInsightSelectors(input *PutInsightSelectorsInput) (*PutInsightSelectorsOutput, error) {
	req, out := c.PutInsightSelectorsRequest(input)
	return out, req.Send()
}

// PutInsightSelectorsWithContext is the same as PutInsightSelectors with the addition of
// the ability to pass a context and additional request options.
//
// See PutInsightSelectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) PutInsightSelectorsWithContext(ctx aws.Context, input *PutInsightSelectorsInput, opts ...request.Option) (*PutInsightSelectorsOutput, error) {
	req, out := c.PutInsightSelectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTags for more information on using the RemoveTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsRequest method.
//    req, resp := client.RemoveTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RemoveTags
func (c *CloudTrail) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	output = &RemoveTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTags API operation for AWS CloudTrail.
//
// Removes the specified tags from a trail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation RemoveTags for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   This exception is thrown when the specified resource is not found.
//
//   * ARNInvalidException
//   This exception is thrown when an operation is called with a trail ARN that
//   is not valid. The following is the format of a trail ARN.
//
//   arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
//
//   * ResourceTypeNotSupportedException
//   This exception is thrown when the specified resource type is not supported
//   by CloudTrail.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * InvalidTagParameterException
//   This exception is thrown when the specified tag key or values are not valid.
//   It can also occur if there are duplicate tags or too many tags on the resource.
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
//   * NotOrganizationMasterAccountException
//   This exception is thrown when the Amazon Web Services account making the
//   request to create or update an organization trail is not the management account
//   for an organization in Organizations. For more information, see Prepare For
//   Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RemoveTags
func (c *CloudTrail) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	return out, req.Send()
}

// RemoveTagsWithContext is the same as RemoveTags with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) RemoveTagsWithContext(ctx aws.Context, input *RemoveTagsInput, opts ...request.Option) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartLogging = "StartLogging"

// StartLoggingRequest generates a "aws/request.Request" representing the
// client's request for the StartLogging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartLogging for more information on using the StartLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartLoggingRequest method.
//    req, resp := client.StartLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartLogging
func (c *CloudTrail) StartLoggingRequest(input *StartLoggingInput) (req *request.Request, output *StartLoggingOutput) {
	op := &request.Operation{
		Name:       opStartLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartLoggingInput{}
	}

	output = &StartLoggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartLogging API operation for AWS CloudTrail.
//
// Starts the recording of Amazon Web Services API calls and log file delivery
// for a trail. For a trail that is enabled in all regions, this operation must
// be called from the region in which the trail was created. This operation
// cannot be called on the shadow trails (replicated trails in other regions)
// of a trail that is enabled in all regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation StartLogging for usage and error information.
//
// Returned Error Types:
//   * TrailNotFoundException
//   This exception is thrown when the trail with the given name is not found.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * InvalidHomeRegionException
//   This exception is thrown when an operation is called on a trail from a region
//   other than the region in which the trail was created.
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
//   * NotOrganizationMasterAccountException
//   This exception is thrown when the Amazon Web Services account making the
//   request to create or update an organization trail is not the management account
//   for an organization in Organizations. For more information, see Prepare For
//   Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
//   * InsufficientDependencyServiceAccessPermissionException
//   This exception is thrown when the IAM user or role that is used to create
//   the organization trail is lacking one or more required permissions for creating
//   an organization trail in a required service. For more information, see Prepare
//   For Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartLogging
func (c *CloudTrail) StartLogging(input *StartLoggingInput) (*StartLoggingOutput, error) {
	req, out := c.StartLoggingRequest(input)
	return out, req.Send()
}

// StartLoggingWithContext is the same as StartLogging with the addition of
// the ability to pass a context and additional request options.
//
// See StartLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) StartLoggingWithContext(ctx aws.Context, input *StartLoggingInput, opts ...request.Option) (*StartLoggingOutput, error) {
	req, out := c.StartLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopLogging = "StopLogging"

// StopLoggingRequest generates a "aws/request.Request" representing the
// client's request for the StopLogging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopLogging for more information on using the StopLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopLoggingRequest method.
//    req, resp := client.StopLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopLogging
func (c *CloudTrail) StopLoggingRequest(input *StopLoggingInput) (req *request.Request, output *StopLoggingOutput) {
	op := &request.Operation{
		Name:       opStopLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopLoggingInput{}
	}

	output = &StopLoggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopLogging API operation for AWS CloudTrail.
//
// Suspends the recording of Amazon Web Services API calls and log file delivery
// for the specified trail. Under most circumstances, there is no need to use
// this action. You can update a trail without stopping it first. This action
// is the only way to stop recording. For a trail enabled in all regions, this
// operation must be called from the region in which the trail was created,
// or an InvalidHomeRegionException will occur. This operation cannot be called
// on the shadow trails (replicated trails in other regions) of a trail enabled
// in all regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation StopLogging for usage and error information.
//
// Returned Error Types:
//   * TrailNotFoundException
//   This exception is thrown when the trail with the given name is not found.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * InvalidHomeRegionException
//   This exception is thrown when an operation is called on a trail from a region
//   other than the region in which the trail was created.
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
//   * NotOrganizationMasterAccountException
//   This exception is thrown when the Amazon Web Services account making the
//   request to create or update an organization trail is not the management account
//   for an organization in Organizations. For more information, see Prepare For
//   Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
//   * InsufficientDependencyServiceAccessPermissionException
//   This exception is thrown when the IAM user or role that is used to create
//   the organization trail is lacking one or more required permissions for creating
//   an organization trail in a required service. For more information, see Prepare
//   For Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopLogging
func (c *CloudTrail) StopLogging(input *StopLoggingInput) (*StopLoggingOutput, error) {
	req, out := c.StopLoggingRequest(input)
	return out, req.Send()
}

// StopLoggingWithContext is the same as StopLogging with the addition of
// the ability to pass a context and additional request options.
//
// See StopLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) StopLoggingWithContext(ctx aws.Context, input *StopLoggingInput, opts ...request.Option) (*StopLoggingOutput, error) {
	req, out := c.StopLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrail = "UpdateTrail"

// UpdateTrailRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrail for more information on using the UpdateTrail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTrailRequest method.
//    req, resp := client.UpdateTrailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateTrail
func (c *CloudTrail) UpdateTrailRequest(input *UpdateTrailInput) (req *request.Request, output *UpdateTrailOutput) {
	op := &request.Operation{
		Name:       opUpdateTrail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTrailInput{}
	}

	output = &UpdateTrailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrail API operation for AWS CloudTrail.
//
// Updates trail settings that control what events you are logging, and how
// to handle log files. Changes to a trail do not require stopping the CloudTrail
// service. Use this action to designate an existing bucket for log delivery.
// If the existing bucket has previously been a target for CloudTrail log files,
// an IAM policy exists for the bucket. UpdateTrail must be called from the
// region in which the trail was created; otherwise, an InvalidHomeRegionException
// is thrown.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation UpdateTrail for usage and error information.
//
// Returned Error Types:
//   * S3BucketDoesNotExistException
//   This exception is thrown when the specified S3 bucket does not exist.
//
//   * InsufficientS3BucketPolicyException
//   This exception is thrown when the policy on the S3 bucket is not sufficient.
//
//   * InsufficientSnsTopicPolicyException
//   This exception is thrown when the policy on the Amazon SNS topic is not sufficient.
//
//   * InsufficientEncryptionPolicyException
//   This exception is thrown when the policy on the S3 bucket or KMS key is not
//   sufficient.
//
//   * TrailNotFoundException
//   This exception is thrown when the trail with the given name is not found.
//
//   * InvalidS3BucketNameException
//   This exception is thrown when the provided S3 bucket name is not valid.
//
//   * InvalidS3PrefixException
//   This exception is thrown when the provided S3 prefix is not valid.
//
//   * InvalidSnsTopicNameException
//   This exception is thrown when the provided SNS topic name is not valid.
//
//   * InvalidKmsKeyIdException
//   This exception is thrown when the KMS key ARN is not valid.
//
//   * InvalidTrailNameException
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are not valid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * TrailNotProvidedException
//   This exception is no longer in use.
//
//   * InvalidEventSelectorsException
//   This exception is thrown when the PutEventSelectors operation is called with
//   a number of event selectors, advanced event selectors, or data resources
//   that is not valid. The combination of event selectors or advanced event selectors
//   and data resources is not valid. A trail can have up to 5 event selectors.
//   If a trail uses advanced event selectors, a maximum of 500 total values for
//   all conditions in all advanced event selectors is allowed. A trail is limited
//   to 250 data resources. These data resources can be distributed across event
//   selectors, but the overall total cannot exceed 250.
//
//   You can:
//
//      * Specify a valid number of event selectors (1 to 5) for a trail.
//
//      * Specify a valid number of data resources (1 to 250) for an event selector.
//      The limit of number of resources on an individual event selector is configurable
//      up to 250. However, this upper limit is allowed only if the total number
//      of data resources does not exceed 250 across all event selectors for a
//      trail.
//
//      * Specify up to 500 values for all conditions in all advanced event selectors
//      for a trail.
//
//      * Specify a valid value for a parameter. For example, specifying the ReadWriteType
//      parameter with a value of read-only is not valid.
//
//   * InvalidParameterCombinationException
//   This exception is thrown when the combination of parameters provided is not
//   valid.
//
//   * InvalidHomeRegionException
//   This exception is thrown when an operation is called on a trail from a region
//   other than the region in which the trail was created.
//
//   * KmsKeyNotFoundException
//   This exception is thrown when the KMS key does not exist, when the S3 bucket
//   and the KMS key are not in the same region, or when the KMS key associated
//   with the Amazon SNS topic either does not exist or is not in the same region.
//
//   * KmsKeyDisabledException
//   This exception is no longer in use.
//
//   * KmsException
//   This exception is thrown when there is an issue with the specified KMS key
//   and the trail can’t be updated.
//
//   * InvalidCloudWatchLogsLogGroupArnException
//   This exception is thrown when the provided CloudWatch Logs log group is not
//   valid.
//
//   * InvalidCloudWatchLogsRoleArnException
//   This exception is thrown when the provided role is not valid.
//
//   * CloudWatchLogsDeliveryUnavailableException
//   Cannot set a CloudWatch Logs delivery for this region.
//
//   * UnsupportedOperationException
//   This exception is thrown when the requested operation is not supported.
//
//   * OperationNotPermittedException
//   This exception is thrown when the requested operation is not permitted.
//
//   * AccessNotEnabledException
//   This exception is thrown when trusted access has not been enabled between
//   CloudTrail and Organizations. For more information, see Enabling Trusted
//   Access with Other Amazon Web Services Services (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html)
//   and Prepare For Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
//   * InsufficientDependencyServiceAccessPermissionException
//   This exception is thrown when the IAM user or role that is used to create
//   the organization trail is lacking one or more required permissions for creating
//   an organization trail in a required service. For more information, see Prepare
//   For Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
//   * OrganizationsNotInUseException
//   This exception is thrown when the request is made from an Amazon Web Services
//   account that is not a member of an organization. To make this request, sign
//   in using the credentials of an account that belongs to an organization.
//
//   * NotOrganizationMasterAccountException
//   This exception is thrown when the Amazon Web Services account making the
//   request to create or update an organization trail is not the management account
//   for an organization in Organizations. For more information, see Prepare For
//   Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
//   * OrganizationNotInAllFeaturesModeException
//   This exception is thrown when Organizations is not configured to support
//   all features. All features must be enabled in Organizations to support creating
//   an organization trail. For more information, see Prepare For Creating a Trail
//   For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
//
//   * CloudTrailInvalidClientTokenIdException
//   This exception is thrown when a call results in the InvalidClientTokenId
//   error code. This can occur when you are creating or updating a trail to send
//   notifications to an Amazon SNS topic that is in a suspended Amazon Web Services
//   account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateTrail
func (c *CloudTrail) UpdateTrail(input *UpdateTrailInput) (*UpdateTrailOutput, error) {
	req, out := c.UpdateTrailRequest(input)
	return out, req.Send()
}

// UpdateTrailWithContext is the same as UpdateTrail with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) UpdateTrailWithContext(ctx aws.Context, input *UpdateTrailInput, opts ...request.Option) (*UpdateTrailOutput, error) {
	req, out := c.UpdateTrailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// This exception is thrown when an operation is called with a trail ARN that
// is not valid. The following is the format of a trail ARN.
//
// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
type ARNInvalidException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ARNInvalidException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ARNInvalidException) GoString() string {
	return s.String()
}

func newErrorARNInvalidException(v protocol.ResponseMetadata) error {
	return &ARNInvalidException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ARNInvalidException) Code() string {
	return "CloudTrailARNInvalidException"
}

// Message returns the exception's message.
func (s *ARNInvalidException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ARNInvalidException) OrigErr() error {
	return nil
}

func (s *ARNInvalidException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ARNInvalidException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ARNInvalidException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when trusted access has not been enabled between
// CloudTrail and Organizations. For more information, see Enabling Trusted
// Access with Other Amazon Web Services Services (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html)
// and Prepare For Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
type AccessNotEnabledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessNotEnabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessNotEnabledException) GoString() string {
	return s.String()
}

func newErrorAccessNotEnabledException(v protocol.ResponseMetadata) error {
	return &AccessNotEnabledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessNotEnabledException) Code() string {
	return "CloudTrailAccessNotEnabledException"
}

// Message returns the exception's message.
func (s *AccessNotEnabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessNotEnabledException) OrigErr() error {
	return nil
}

func (s *AccessNotEnabledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessNotEnabledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessNotEnabledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the tags to add to a trail.
type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the trail to which one or more tags will be added. The
	// format of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Contains a list of tags, up to a limit of 50
	TagsList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.TagsList != nil {
		for i, v := range s.TagsList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagsList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *AddTagsInput) SetResourceId(v string) *AddTagsInput {
	s.ResourceId = &v
	return s
}

// SetTagsList sets the TagsList field's value.
func (s *AddTagsInput) SetTagsList(v []*Tag) *AddTagsInput {
	s.TagsList = v
	return s
}

// Returns the objects or data if successful. Otherwise, returns an error.
type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// Advanced event selectors let you create fine-grained selectors for the following
// CloudTrail event record ﬁelds. They help you control costs by logging only
// those events that are important to you. For more information about advanced
// event selectors, see Logging data events for trails (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html)
// in the CloudTrail User Guide.
//
//    * readOnly
//
//    * eventSource
//
//    * eventName
//
//    * eventCategory
//
//    * resources.type
//
//    * resources.ARN
//
// You cannot apply both event selectors and advanced event selectors to a trail.
type AdvancedEventSelector struct {
	_ struct{} `type:"structure"`

	// Contains all selector statements in an advanced event selector.
	//
	// FieldSelectors is a required field
	FieldSelectors []*AdvancedFieldSelector `min:"1" type:"list" required:"true"`

	// An optional, descriptive name for an advanced event selector, such as "Log
	// data events for only two S3 buckets".
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedEventSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedEventSelector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdvancedEventSelector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdvancedEventSelector"}
	if s.FieldSelectors == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldSelectors"))
	}
	if s.FieldSelectors != nil && len(s.FieldSelectors) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FieldSelectors", 1))
	}
	if s.FieldSelectors != nil {
		for i, v := range s.FieldSelectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FieldSelectors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldSelectors sets the FieldSelectors field's value.
func (s *AdvancedEventSelector) SetFieldSelectors(v []*AdvancedFieldSelector) *AdvancedEventSelector {
	s.FieldSelectors = v
	return s
}

// SetName sets the Name field's value.
func (s *AdvancedEventSelector) SetName(v string) *AdvancedEventSelector {
	s.Name = &v
	return s
}

// A single selector statement in an advanced event selector.
type AdvancedFieldSelector struct {
	_ struct{} `type:"structure"`

	// An operator that includes events that match the last few characters of the
	// event record field specified as the value of Field.
	EndsWith []*string `min:"1" type:"list"`

	// An operator that includes events that match the exact value of the event
	// record field specified as the value of Field. This is the only valid operator
	// that you can use with the readOnly, eventCategory, and resources.type fields.
	Equals []*string `min:"1" type:"list"`

	// A field in an event record on which to filter events to be logged. Supported
	// fields include readOnly, eventCategory, eventSource (for management events),
	// eventName, resources.type, and resources.ARN.
	//
	//    * readOnly - Optional. Can be set to Equals a value of true or false.
	//    A value of false logs both read and write events.
	//
	//    * eventSource - For filtering management events only. This can be set
	//    only to NotEquals kms.amazonaws.com.
	//
	//    * eventName - Can use any operator. You can use it to ﬁlter in or ﬁlter
	//    out any data event logged to CloudTrail, such as PutBucket or GetSnapshotBlock.
	//    You can have multiple values for this ﬁeld, separated by commas.
	//
	//    * eventCategory - This is required. It must be set to Equals, and the
	//    value must be Management or Data.
	//
	//    * resources.type - This ﬁeld is required. resources.type can only use
	//    the Equals operator, and the value can be one of the following: AWS::S3::Object
	//    AWS::Lambda::Function AWS::DynamoDB::Table AWS::S3Outposts::Object AWS::ManagedBlockchain::Node
	//    AWS::S3ObjectLambda::AccessPoint AWS::EC2::Snapshot AWS::S3::AccessPoint
	//    AWS::DynamoDB::Stream You can have only one resources.type ﬁeld per
	//    selector. To log data events on more than one resource type, add another
	//    selector.
	//
	//    * resources.ARN - You can use any operator with resources.ARN, but if
	//    you use Equals or NotEquals, the value must exactly match the ARN of a
	//    valid resource of the type you've speciﬁed in the template as the value
	//    of resources.type. For example, if resources.type equals AWS::S3::Object,
	//    the ARN must be in one of the following formats. To log all data events
	//    for all objects in a specific S3 bucket, use the StartsWith operator,
	//    and include only the bucket ARN as the matching value. The trailing slash
	//    is intentional; do not exclude it. Replace the text between less than
	//    and greater than symbols (<>) with resource-specific information. arn:<partition>:s3:::<bucket_name>/
	//    arn:<partition>:s3:::<bucket_name>/<object_path>/ When resources.type
	//    equals AWS::S3::AccessPoint, and the operator is set to Equals or NotEquals,
	//    the ARN must be in one of the following formats. To log events on all
	//    objects in an S3 access point, we recommend that you use only the access
	//    point ARN, don’t include the object path, and use the StartsWith or
	//    NotStartsWith operators. arn:<partition>:s3:<region>:<account_ID>:accesspoint/<access_point_name>
	//    arn:<partition>:s3:<region>:<account_ID>:accesspoint/<access_point_name>/object/<object_path>
	//    When resources.type equals AWS::Lambda::Function, and the operator is
	//    set to Equals or NotEquals, the ARN must be in the following format: arn:<partition>:lambda:<region>:<account_ID>:function:<function_name>
	//    When resources.type equals AWS::DynamoDB::Table, and the operator is set
	//    to Equals or NotEquals, the ARN must be in the following format: arn:<partition>:dynamodb:<region>:<account_ID>:table/<table_name>
	//    When resources.type equals AWS::S3Outposts::Object, and the operator is
	//    set to Equals or NotEquals, the ARN must be in the following format: arn:<partition>:s3-outposts:<region>:<account_ID>:<object_path>
	//    When resources.type equals AWS::ManagedBlockchain::Node, and the operator
	//    is set to Equals or NotEquals, the ARN must be in the following format:
	//    arn:<partition>:managedblockchain:<region>:<account_ID>:nodes/<node_ID>
	//    When resources.type equals AWS::S3ObjectLambda::AccessPoint, and the operator
	//    is set to Equals or NotEquals, the ARN must be in the following format:
	//    arn:<partition>:s3-object-lambda:<region>:<account_ID>:accesspoint/<access_point_name>
	//    When resources.type equals AWS::EC2::Snapshot, and the operator is set
	//    to Equals or NotEquals, the ARN must be in the following format: arn:<partition>:ec2:<region>::snapshot/<snapshot_ID>
	//    When resources.type equals AWS::DynamoDB::Stream, and the operator is
	//    set to Equals or NotEquals, the ARN must be in the following format: arn:<partition>:dynamodb:<region>:<account_ID>:table/<table_name>/stream/<date_time>
	//
	// Field is a required field
	Field *string `min:"1" type:"string" required:"true"`

	// An operator that excludes events that match the last few characters of the
	// event record field specified as the value of Field.
	NotEndsWith []*string `min:"1" type:"list"`

	// An operator that excludes events that match the exact value of the event
	// record field specified as the value of Field.
	NotEquals []*string `min:"1" type:"list"`

	// An operator that excludes events that match the first few characters of the
	// event record field specified as the value of Field.
	NotStartsWith []*string `min:"1" type:"list"`

	// An operator that includes events that match the first few characters of the
	// event record field specified as the value of Field.
	StartsWith []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedFieldSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedFieldSelector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdvancedFieldSelector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdvancedFieldSelector"}
	if s.EndsWith != nil && len(s.EndsWith) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndsWith", 1))
	}
	if s.Equals != nil && len(s.Equals) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Equals", 1))
	}
	if s.Field == nil {
		invalidParams.Add(request.NewErrParamRequired("Field"))
	}
	if s.Field != nil && len(*s.Field) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Field", 1))
	}
	if s.NotEndsWith != nil && len(s.NotEndsWith) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NotEndsWith", 1))
	}
	if s.NotEquals != nil && len(s.NotEquals) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NotEquals", 1))
	}
	if s.NotStartsWith != nil && len(s.NotStartsWith) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NotStartsWith", 1))
	}
	if s.StartsWith != nil && len(s.StartsWith) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartsWith", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndsWith sets the EndsWith field's value.
func (s *AdvancedFieldSelector) SetEndsWith(v []*string) *AdvancedFieldSelector {
	s.EndsWith = v
	return s
}

// SetEquals sets the Equals field's value.
func (s *AdvancedFieldSelector) SetEquals(v []*string) *AdvancedFieldSelector {
	s.Equals = v
	return s
}

// SetField sets the Field field's value.
func (s *AdvancedFieldSelector) SetField(v string) *AdvancedFieldSelector {
	s.Field = &v
	return s
}

// SetNotEndsWith sets the NotEndsWith field's value.
func (s *AdvancedFieldSelector) SetNotEndsWith(v []*string) *AdvancedFieldSelector {
	s.NotEndsWith = v
	return s
}

// SetNotEquals sets the NotEquals field's value.
func (s *AdvancedFieldSelector) SetNotEquals(v []*string) *AdvancedFieldSelector {
	s.NotEquals = v
	return s
}

// SetNotStartsWith sets the NotStartsWith field's value.
func (s *AdvancedFieldSelector) SetNotStartsWith(v []*string) *AdvancedFieldSelector {
	s.NotStartsWith = v
	return s
}

// SetStartsWith sets the StartsWith field's value.
func (s *AdvancedFieldSelector) SetStartsWith(v []*string) *AdvancedFieldSelector {
	s.StartsWith = v
	return s
}

// This exception is thrown when a call results in the InvalidClientTokenId
// error code. This can occur when you are creating or updating a trail to send
// notifications to an Amazon SNS topic that is in a suspended Amazon Web Services
// account.
type CloudTrailInvalidClientTokenIdException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudTrailInvalidClientTokenIdException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudTrailInvalidClientTokenIdException) GoString() string {
	return s.String()
}

func newErrorCloudTrailInvalidClientTokenIdException(v protocol.ResponseMetadata) error {
	return &CloudTrailInvalidClientTokenIdException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CloudTrailInvalidClientTokenIdException) Code() string {
	return "CloudTrailInvalidClientTokenIdException"
}

// Message returns the exception's message.
func (s *CloudTrailInvalidClientTokenIdException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CloudTrailInvalidClientTokenIdException) OrigErr() error {
	return nil
}

func (s *CloudTrailInvalidClientTokenIdException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CloudTrailInvalidClientTokenIdException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CloudTrailInvalidClientTokenIdException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Cannot set a CloudWatch Logs delivery for this region.
type CloudWatchLogsDeliveryUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsDeliveryUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsDeliveryUnavailableException) GoString() string {
	return s.String()
}

func newErrorCloudWatchLogsDeliveryUnavailableException(v protocol.ResponseMetadata) error {
	return &CloudWatchLogsDeliveryUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CloudWatchLogsDeliveryUnavailableException) Code() string {
	return "CloudWatchLogsDeliveryUnavailableException"
}

// Message returns the exception's message.
func (s *CloudWatchLogsDeliveryUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CloudWatchLogsDeliveryUnavailableException) OrigErr() error {
	return nil
}

func (s *CloudWatchLogsDeliveryUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CloudWatchLogsDeliveryUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CloudWatchLogsDeliveryUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the specified resource is not ready for an
// operation. This can occur when you try to run an operation on a trail before
// CloudTrail has time to fully load the trail. If this exception occurs, wait
// a few minutes, and then try the operation again.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies the settings for each trail.
type CreateTrailInput struct {
	_ struct{} `type:"structure"`

	// Specifies a log group name using an Amazon Resource Name (ARN), a unique
	// identifier that represents the log group to which CloudTrail logs will be
	// delivered. Not required unless you specify CloudWatchLogsRoleArn.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies whether log file integrity validation is enabled. The default is
	// false.
	//
	// When you disable log file integrity validation, the chain of digest files
	// is broken after one hour. CloudTrail does not create digest files for log
	// files that were delivered during a period in which log file integrity validation
	// was disabled. For example, if you enable log file integrity validation at
	// noon on January 1, disable it at noon on January 2, and re-enable it at noon
	// on January 10, digest files will not be created for the log files delivered
	// from noon on January 2 to noon on January 10. The same applies whenever you
	// stop CloudTrail logging or delete a trail.
	EnableLogFileValidation *bool `type:"boolean"`

	// Specifies whether the trail is publishing events from global services such
	// as IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail is created in the current region or in all regions.
	// The default is false, which creates a trail only in the region where you
	// are signed in. As a best practice, consider creating trails that log events
	// in all regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies whether the trail is created for all accounts in an organization
	// in Organizations, or only for the current Amazon Web Services account. The
	// default is false, and cannot be true unless the call is made on behalf of
	// an Amazon Web Services account that is the management account for an organization
	// in Organizations.
	IsOrganizationTrail *bool `type:"boolean"`

	// Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail.
	// The value can be an alias name prefixed by "alias/", a fully specified ARN
	// to an alias, a fully specified ARN to a key, or a globally unique identifier.
	//
	// CloudTrail also supports KMS multi-Region keys. For more information about
	// multi-Region keys, see Using multi-Region keys (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
	// in the Key Management Service Developer Guide.
	//
	// Examples:
	//
	//    * alias/MyAliasName
	//
	//    * arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
	//
	//    * arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//    * 12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies the name of the trail. The name must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-)
	//
	//    * Start with a letter or number, and end with a letter or number
	//
	//    * Be between 3 and 128 characters
	//
	//    * Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//    and my--namespace are not valid.
	//
	//    * Not be in IP address format (for example, 192.168.5.4)
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Specifies the name of the Amazon S3 bucket designated for publishing log
	// files. See Amazon S3 Bucket Naming Requirements (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html).
	//
	// S3BucketName is a required field
	S3BucketName *string `type:"string" required:"true"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
	// The maximum length is 200 characters.
	S3KeyPrefix *string `type:"string"`

	// Specifies the name of the Amazon SNS topic defined for notification of log
	// file delivery. The maximum length is 256 characters.
	SnsTopicName *string `type:"string"`

	// A list of tags.
	TagsList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrailInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.S3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketName"))
	}
	if s.TagsList != nil {
		for i, v := range s.TagsList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagsList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *CreateTrailInput) SetCloudWatchLogsLogGroupArn(v string) *CreateTrailInput {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *CreateTrailInput) SetCloudWatchLogsRoleArn(v string) *CreateTrailInput {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetEnableLogFileValidation sets the EnableLogFileValidation field's value.
func (s *CreateTrailInput) SetEnableLogFileValidation(v bool) *CreateTrailInput {
	s.EnableLogFileValidation = &v
	return s
}

// SetIncludeGlobalServiceEvents sets the IncludeGlobalServiceEvents field's value.
func (s *CreateTrailInput) SetIncludeGlobalServiceEvents(v bool) *CreateTrailInput {
	s.IncludeGlobalServiceEvents = &v
	return s
}

// SetIsMultiRegionTrail sets the IsMultiRegionTrail field's value.
func (s *CreateTrailInput) SetIsMultiRegionTrail(v bool) *CreateTrailInput {
	s.IsMultiRegionTrail = &v
	return s
}

// SetIsOrganizationTrail sets the IsOrganizationTrail field's value.
func (s *CreateTrailInput) SetIsOrganizationTrail(v bool) *CreateTrailInput {
	s.IsOrganizationTrail = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateTrailInput) SetKmsKeyId(v string) *CreateTrailInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTrailInput) SetName(v string) *CreateTrailInput {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CreateTrailInput) SetS3BucketName(v string) *CreateTrailInput {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *CreateTrailInput) SetS3KeyPrefix(v string) *CreateTrailInput {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicName sets the SnsTopicName field's value.
func (s *CreateTrailInput) SetSnsTopicName(v string) *CreateTrailInput {
	s.SnsTopicName = &v
	return s
}

// SetTagsList sets the TagsList field's value.
func (s *CreateTrailInput) SetTagsList(v []*Tag) *CreateTrailInput {
	s.TagsList = v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type CreateTrailOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail
	// logs will be delivered.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies whether the trail is publishing events from global services such
	// as IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail exists in one region or in all regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies whether the trail is an organization trail.
	IsOrganizationTrail *bool `type:"boolean"`

	// Specifies the KMS key ID that encrypts the logs delivered by CloudTrail.
	// The value is a fully specified ARN to a KMS key in the following format.
	//
	// arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies whether log file integrity validation is enabled.
	LogFileValidationEnabled *bool `type:"boolean"`

	// Specifies the name of the trail.
	Name *string `type:"string"`

	// Specifies the name of the Amazon S3 bucket designated for publishing log
	// files.
	S3BucketName *string `type:"string"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
	S3KeyPrefix *string `type:"string"`

	// Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications
	// when log files are delivered. The format of a topic ARN is:
	//
	// arn:aws:sns:us-east-2:123456789012:MyTopic
	SnsTopicARN *string `type:"string"`

	// This field is no longer in use. Use SnsTopicARN.
	//
	// Deprecated: SnsTopicName has been deprecated
	SnsTopicName *string `deprecated:"true" type:"string"`

	// Specifies the ARN of the trail that was created. The format of a trail ARN
	// is:
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	TrailARN *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrailOutput) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *CreateTrailOutput) SetCloudWatchLogsLogGroupArn(v string) *CreateTrailOutput {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *CreateTrailOutput) SetCloudWatchLogsRoleArn(v string) *CreateTrailOutput {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetIncludeGlobalServiceEvents sets the IncludeGlobalServiceEvents field's value.
func (s *CreateTrailOutput) SetIncludeGlobalServiceEvents(v bool) *CreateTrailOutput {
	s.IncludeGlobalServiceEvents = &v
	return s
}

// SetIsMultiRegionTrail sets the IsMultiRegionTrail field's value.
func (s *CreateTrailOutput) SetIsMultiRegionTrail(v bool) *CreateTrailOutput {
	s.IsMultiRegionTrail = &v
	return s
}

// SetIsOrganizationTrail sets the IsOrganizationTrail field's value.
func (s *CreateTrailOutput) SetIsOrganizationTrail(v bool) *CreateTrailOutput {
	s.IsOrganizationTrail = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateTrailOutput) SetKmsKeyId(v string) *CreateTrailOutput {
	s.KmsKeyId = &v
	return s
}

// SetLogFileValidationEnabled sets the LogFileValidationEnabled field's value.
func (s *CreateTrailOutput) SetLogFileValidationEnabled(v bool) *CreateTrailOutput {
	s.LogFileValidationEnabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTrailOutput) SetName(v string) *CreateTrailOutput {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CreateTrailOutput) SetS3BucketName(v string) *CreateTrailOutput {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *CreateTrailOutput) SetS3KeyPrefix(v string) *CreateTrailOutput {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicARN sets the SnsTopicARN field's value.
func (s *CreateTrailOutput) SetSnsTopicARN(v string) *CreateTrailOutput {
	s.SnsTopicARN = &v
	return s
}

// SetSnsTopicName sets the SnsTopicName field's value.
func (s *CreateTrailOutput) SetSnsTopicName(v string) *CreateTrailOutput {
	s.SnsTopicName = &v
	return s
}

// SetTrailARN sets the TrailARN field's value.
func (s *CreateTrailOutput) SetTrailARN(v string) *CreateTrailOutput {
	s.TrailARN = &v
	return s
}

// The Amazon S3 buckets, Lambda functions, or Amazon DynamoDB tables that you
// specify in your event selectors for your trail to log data events. Data events
// provide information about the resource operations performed on or within
// a resource itself. These are also known as data plane operations. You can
// specify up to 250 data resources for a trail.
//
// The total number of allowed data resources is 250. This number can be distributed
// between 1 and 5 event selectors, but the total cannot exceed 250 across all
// selectors.
//
// If you are using advanced event selectors, the maximum total number of values
// for all conditions, across all advanced event selectors for the trail, is
// 500.
//
// The following example demonstrates how logging works when you configure logging
// of all data events for an S3 bucket named bucket-1. In this example, the
// CloudTrail user specified an empty prefix, and the option to log both Read
// and Write data events.
//
// A user uploads an image file to bucket-1.
//
// The PutObject API operation is an Amazon S3 object-level API. It is recorded
// as a data event in CloudTrail. Because the CloudTrail user specified an S3
// bucket with an empty prefix, events that occur on any object in that bucket
// are logged. The trail processes and logs the event.
//
// A user uploads an object to an Amazon S3 bucket named arn:aws:s3:::bucket-2.
//
// The PutObject API operation occurred for an object in an S3 bucket that the
// CloudTrail user didn't specify for the trail. The trail doesn’t log the
// event.
//
// The following example demonstrates how logging works when you configure logging
// of Lambda data events for a Lambda function named MyLambdaFunction, but not
// for all Lambda functions.
//
// A user runs a script that includes a call to the MyLambdaFunction function
// and the MyOtherLambdaFunction function.
//
// The Invoke API operation on MyLambdaFunction is an Lambda API. It is recorded
// as a data event in CloudTrail. Because the CloudTrail user specified logging
// data events for MyLambdaFunction, any invocations of that function are logged.
// The trail processes and logs the event.
//
// The Invoke API operation on MyOtherLambdaFunction is an Lambda API. Because
// the CloudTrail user did not specify logging data events for all Lambda functions,
// the Invoke operation for MyOtherLambdaFunction does not match the function
// specified for the trail. The trail doesn’t log the event.
type DataResource struct {
	_ struct{} `type:"structure"`

	// The resource type in which you want to log data events. You can specify the
	// following basic event selector resource types:
	//
	//    * AWS::S3::Object
	//
	//    * AWS::Lambda::Function
	//
	//    * AWS::DynamoDB::Table
	//
	// The following resource types are also availble through advanced event selectors.
	// Basic event selector resource types are valid in advanced event selectors,
	// but advanced event selector resource types are not valid in basic event selectors.
	// For more information, see AdvancedFieldSelector$Field.
	//
	//    * AWS::S3Outposts::Object
	//
	//    * AWS::ManagedBlockchain::Node
	//
	//    * AWS::S3ObjectLambda::AccessPoint
	//
	//    * AWS::EC2::Snapshot
	//
	//    * AWS::S3::AccessPoint
	//
	//    * AWS::DynamoDB::Stream
	Type *string `type:"string"`

	// An array of Amazon Resource Name (ARN) strings or partial ARN strings for
	// the specified objects.
	//
	//    * To log data events for all objects in all S3 buckets in your Amazon
	//    Web Services account, specify the prefix as arn:aws:s3:::. This also enables
	//    logging of data event activity performed by any user or role in your Amazon
	//    Web Services account, even if that activity is performed on a bucket that
	//    belongs to another Amazon Web Services account.
	//
	//    * To log data events for all objects in an S3 bucket, specify the bucket
	//    and an empty object prefix such as arn:aws:s3:::bucket-1/. The trail logs
	//    data events for all objects in this S3 bucket.
	//
	//    * To log data events for specific objects, specify the S3 bucket and object
	//    prefix such as arn:aws:s3:::bucket-1/example-images. The trail logs data
	//    events for objects in this S3 bucket that match the prefix.
	//
	//    * To log data events for all Lambda functions in your Amazon Web Services
	//    account, specify the prefix as arn:aws:lambda. This also enables logging
	//    of Invoke activity performed by any user or role in your Amazon Web Services
	//    account, even if that activity is performed on a function that belongs
	//    to another Amazon Web Services account.
	//
	//    * To log data events for a specific Lambda function, specify the function
	//    ARN. Lambda function ARNs are exact. For example, if you specify a function
	//    ARN arn:aws:lambda:us-west-2:111111111111:function:helloworld, data events
	//    will only be logged for arn:aws:lambda:us-west-2:111111111111:function:helloworld.
	//    They will not be logged for arn:aws:lambda:us-west-2:111111111111:function:helloworld2.
	//
	//    * To log data events for all DynamoDB tables in your Amazon Web Services
	//    account, specify the prefix as arn:aws:dynamodb.
	Values []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataResource) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *DataResource) SetType(v string) *DataResource {
	s.Type = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DataResource) SetValues(v []*string) *DataResource {
	s.Values = v
	return s
}

// The request that specifies the name of a trail to delete.
type DeleteTrailInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name or the CloudTrail ARN of the trail to be deleted. The
	// following is the format of a trail ARN. arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrailInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteTrailInput) SetName(v string) *DeleteTrailInput {
	s.Name = &v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type DeleteTrailOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrailOutput) GoString() string {
	return s.String()
}

// Returns information about the trail.
type DescribeTrailsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to include shadow trails in the response. A shadow trail
	// is the replication in a region of a trail that was created in a different
	// region, or in the case of an organization trail, the replication of an organization
	// trail in member accounts. If you do not include shadow trails, organization
	// trails in a member account and region replication trails will not be returned.
	// The default is true.
	IncludeShadowTrails *bool `locationName:"includeShadowTrails" type:"boolean"`

	// Specifies a list of trail names, trail ARNs, or both, of the trails to describe.
	// The format of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// If an empty list is specified, information for the trail in the current region
	// is returned.
	//
	//    * If an empty list is specified and IncludeShadowTrails is false, then
	//    information for all trails in the current region is returned.
	//
	//    * If an empty list is specified and IncludeShadowTrails is null or true,
	//    then information for all trails in the current region and any associated
	//    shadow trails in other regions is returned.
	//
	// If one or more trail names are specified, information is returned only if
	// the names match the names of trails belonging only to the current region.
	// To return information about a trail in another region, you must specify its
	// trail ARN.
	TrailNameList []*string `locationName:"trailNameList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTrailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTrailsInput) GoString() string {
	return s.String()
}

// SetIncludeShadowTrails sets the IncludeShadowTrails field's value.
func (s *DescribeTrailsInput) SetIncludeShadowTrails(v bool) *DescribeTrailsInput {
	s.IncludeShadowTrails = &v
	return s
}

// SetTrailNameList sets the TrailNameList field's value.
func (s *DescribeTrailsInput) SetTrailNameList(v []*string) *DescribeTrailsInput {
	s.TrailNameList = v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type DescribeTrailsOutput struct {
	_ struct{} `type:"structure"`

	// The list of trail objects. Trail objects with string values are only returned
	// if values for the objects exist in a trail's configuration. For example,
	// SNSTopicName and SNSTopicARN are only returned in results if a trail is configured
	// to send SNS notifications. Similarly, KMSKeyId only appears in results if
	// a trail's log files are encrypted with KMS customer managed keys.
	TrailList []*Trail `locationName:"trailList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTrailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTrailsOutput) GoString() string {
	return s.String()
}

// SetTrailList sets the TrailList field's value.
func (s *DescribeTrailsOutput) SetTrailList(v []*Trail) *DescribeTrailsOutput {
	s.TrailList = v
	return s
}

// Contains information about an event that was returned by a lookup request.
// The result includes a representation of a CloudTrail event.
type Event struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services access key ID that was used to sign the request.
	// If the request was made with temporary security credentials, this is the
	// access key ID of the temporary credentials.
	AccessKeyId *string `type:"string"`

	// A JSON string that contains a representation of the event returned.
	CloudTrailEvent *string `type:"string"`

	// The CloudTrail ID of the event returned.
	EventId *string `type:"string"`

	// The name of the event returned.
	EventName *string `type:"string"`

	// The Amazon Web Services service to which the request was made.
	EventSource *string `type:"string"`

	// The date and time of the event returned.
	EventTime *time.Time `type:"timestamp"`

	// Information about whether the event is a write event or a read event.
	ReadOnly *string `type:"string"`

	// A list of resources referenced by the event returned.
	Resources []*Resource `type:"list"`

	// A user name or role name of the requester that called the API in the event
	// returned.
	Username *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *Event) SetAccessKeyId(v string) *Event {
	s.AccessKeyId = &v
	return s
}

// SetCloudTrailEvent sets the CloudTrailEvent field's value.
func (s *Event) SetCloudTrailEvent(v string) *Event {
	s.CloudTrailEvent = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *Event) SetEventId(v string) *Event {
	s.EventId = &v
	return s
}

// SetEventName sets the EventName field's value.
func (s *Event) SetEventName(v string) *Event {
	s.EventName = &v
	return s
}

// SetEventSource sets the EventSource field's value.
func (s *Event) SetEventSource(v string) *Event {
	s.EventSource = &v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *Event) SetEventTime(v time.Time) *Event {
	s.EventTime = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *Event) SetReadOnly(v string) *Event {
	s.ReadOnly = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *Event) SetResources(v []*Resource) *Event {
	s.Resources = v
	return s
}

// SetUsername sets the Username field's value.
func (s *Event) SetUsername(v string) *Event {
	s.Username = &v
	return s
}

// Use event selectors to further specify the management and data event settings
// for your trail. By default, trails created without specific event selectors
// will be configured to log all read and write management events, and no data
// events. When an event occurs in your account, CloudTrail evaluates the event
// selector for all trails. For each trail, if the event matches any event selector,
// the trail processes and logs the event. If the event doesn't match any event
// selector, the trail doesn't log the event.
//
// You can configure up to five event selectors for a trail.
//
// You cannot apply both event selectors and advanced event selectors to a trail.
type EventSelector struct {
	_ struct{} `type:"structure"`

	// CloudTrail supports data event logging for Amazon S3 objects, Lambda functions,
	// and Amazon DynamoDB tables with basic event selectors. You can specify up
	// to 250 resources for an individual event selector, but the total number of
	// data resources cannot exceed 250 across all event selectors in a trail. This
	// limit does not apply if you configure resource logging for all data events.
	//
	// For more information, see Data Events (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-data-events)
	// and Limits in CloudTrail (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html)
	// in the CloudTrail User Guide.
	DataResources []*DataResource `type:"list"`

	// An optional list of service event sources from which you do not want management
	// events to be logged on your trail. In this release, the list can be empty
	// (disables the filter), or it can filter out Key Management Service or Amazon
	// RDS Data API events by containing kms.amazonaws.com or rdsdata.amazonaws.com.
	// By default, ExcludeManagementEventSources is empty, and KMS and Amazon RDS
	// Data API events are logged to your trail.
	ExcludeManagementEventSources []*string `type:"list"`

	// Specify if you want your event selector to include management events for
	// your trail.
	//
	// For more information, see Management Events (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-management-events)
	// in the CloudTrail User Guide.
	//
	// By default, the value is true.
	//
	// The first copy of management events is free. You are charged for additional
	// copies of management events that you are logging on any subsequent trail
	// in the same region. For more information about CloudTrail pricing, see CloudTrail
	// Pricing (http://aws.amazon.com/cloudtrail/pricing/).
	IncludeManagementEvents *bool `type:"boolean"`

	// Specify if you want your trail to log read-only events, write-only events,
	// or all. For example, the EC2 GetConsoleOutput is a read-only API operation
	// and RunInstances is a write-only API operation.
	//
	// By default, the value is All.
	ReadWriteType *string `type:"string" enum:"ReadWriteType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSelector) GoString() string {
	return s.String()
}

// SetDataResources sets the DataResources field's value.
func (s *EventSelector) SetDataResources(v []*DataResource) *EventSelector {
	s.DataResources = v
	return s
}

// SetExcludeManagementEventSources sets the ExcludeManagementEventSources field's value.
func (s *EventSelector) SetExcludeManagementEventSources(v []*string) *EventSelector {
	s.ExcludeManagementEventSources = v
	return s
}

// SetIncludeManagementEvents sets the IncludeManagementEvents field's value.
func (s *EventSelector) SetIncludeManagementEvents(v bool) *EventSelector {
	s.IncludeManagementEvents = &v
	return s
}

// SetReadWriteType sets the ReadWriteType field's value.
func (s *EventSelector) SetReadWriteType(v string) *EventSelector {
	s.ReadWriteType = &v
	return s
}

type GetEventSelectorsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the trail or trail ARN. If you specify a trail name,
	// the string must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-)
	//
	//    * Start with a letter or number, and end with a letter or number
	//
	//    * Be between 3 and 128 characters
	//
	//    * Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//    and my--namespace are not valid.
	//
	//    * Not be in IP address format (for example, 192.168.5.4)
	//
	// If you specify a trail ARN, it must be in the format:
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// TrailName is a required field
	TrailName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventSelectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventSelectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventSelectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventSelectorsInput"}
	if s.TrailName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrailName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrailName sets the TrailName field's value.
func (s *GetEventSelectorsInput) SetTrailName(v string) *GetEventSelectorsInput {
	s.TrailName = &v
	return s
}

type GetEventSelectorsOutput struct {
	_ struct{} `type:"structure"`

	// The advanced event selectors that are configured for the trail.
	AdvancedEventSelectors []*AdvancedEventSelector `type:"list"`

	// The event selectors that are configured for the trail.
	EventSelectors []*EventSelector `type:"list"`

	// The specified trail ARN that has the event selectors.
	TrailARN *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventSelectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventSelectorsOutput) GoString() string {
	return s.String()
}

// SetAdvancedEventSelectors sets the AdvancedEventSelectors field's value.
func (s *GetEventSelectorsOutput) SetAdvancedEventSelectors(v []*AdvancedEventSelector) *GetEventSelectorsOutput {
	s.AdvancedEventSelectors = v
	return s
}

// SetEventSelectors sets the EventSelectors field's value.
func (s *GetEventSelectorsOutput) SetEventSelectors(v []*EventSelector) *GetEventSelectorsOutput {
	s.EventSelectors = v
	return s
}

// SetTrailARN sets the TrailARN field's value.
func (s *GetEventSelectorsOutput) SetTrailARN(v string) *GetEventSelectorsOutput {
	s.TrailARN = &v
	return s
}

type GetInsightSelectorsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the trail or trail ARN. If you specify a trail name,
	// the string must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-)
	//
	//    * Start with a letter or number, and end with a letter or number
	//
	//    * Be between 3 and 128 characters
	//
	//    * Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//    and my--namespace are not valid.
	//
	//    * Not be in IP address format (for example, 192.168.5.4)
	//
	// If you specify a trail ARN, it must be in the format:
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// TrailName is a required field
	TrailName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInsightSelectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInsightSelectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInsightSelectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInsightSelectorsInput"}
	if s.TrailName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrailName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrailName sets the TrailName field's value.
func (s *GetInsightSelectorsInput) SetTrailName(v string) *GetInsightSelectorsInput {
	s.TrailName = &v
	return s
}

type GetInsightSelectorsOutput struct {
	_ struct{} `type:"structure"`

	// A JSON string that contains the insight types you want to log on a trail.
	// In this release, only ApiCallRateInsight is supported as an insight type.
	InsightSelectors []*InsightSelector `type:"list"`

	// The Amazon Resource Name (ARN) of a trail for which you want to get Insights
	// selectors.
	TrailARN *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInsightSelectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInsightSelectorsOutput) GoString() string {
	return s.String()
}

// SetInsightSelectors sets the InsightSelectors field's value.
func (s *GetInsightSelectorsOutput) SetInsightSelectors(v []*InsightSelector) *GetInsightSelectorsOutput {
	s.InsightSelectors = v
	return s
}

// SetTrailARN sets the TrailARN field's value.
func (s *GetInsightSelectorsOutput) SetTrailARN(v string) *GetInsightSelectorsOutput {
	s.TrailARN = &v
	return s
}

type GetTrailInput struct {
	_ struct{} `type:"structure"`

	// The name or the Amazon Resource Name (ARN) of the trail for which you want
	// to retrieve settings information.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTrailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTrailInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetTrailInput) SetName(v string) *GetTrailInput {
	s.Name = &v
	return s
}

type GetTrailOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a trail.
	Trail *Trail `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrailOutput) GoString() string {
	return s.String()
}

// SetTrail sets the Trail field's value.
func (s *GetTrailOutput) SetTrail(v *Trail) *GetTrailOutput {
	s.Trail = v
	return s
}

// The name of a trail about which you want the current status.
type GetTrailStatusInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name or the CloudTrail ARN of the trail for which you are requesting
	// status. To get the status of a shadow trail (a replication of the trail in
	// another region), you must specify its ARN. The following is the format of
	// a trail ARN.
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrailStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrailStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTrailStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTrailStatusInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetTrailStatusInput) SetName(v string) *GetTrailStatusInput {
	s.Name = &v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type GetTrailStatusOutput struct {
	_ struct{} `type:"structure"`

	// Whether the CloudTrail trail is currently logging Amazon Web Services API
	// calls.
	IsLogging *bool `type:"boolean"`

	// Displays any CloudWatch Logs error that CloudTrail encountered when attempting
	// to deliver logs to CloudWatch Logs.
	LatestCloudWatchLogsDeliveryError *string `type:"string"`

	// Displays the most recent date and time when CloudTrail delivered logs to
	// CloudWatch Logs.
	LatestCloudWatchLogsDeliveryTime *time.Time `type:"timestamp"`

	// This field is no longer in use.
	LatestDeliveryAttemptSucceeded *string `type:"string"`

	// This field is no longer in use.
	LatestDeliveryAttemptTime *string `type:"string"`

	// Displays any Amazon S3 error that CloudTrail encountered when attempting
	// to deliver log files to the designated bucket. For more information, see
	// Error Responses (https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html)
	// in the Amazon S3 API Reference.
	//
	// This error occurs only when there is a problem with the destination S3 bucket,
	// and does not occur for requests that time out. To resolve the issue, create
	// a new bucket, and then call UpdateTrail to specify the new bucket; or fix
	// the existing objects so that CloudTrail can again write to the bucket.
	LatestDeliveryError *string `type:"string"`

	// Specifies the date and time that CloudTrail last delivered log files to an
	// account's Amazon S3 bucket.
	LatestDeliveryTime *time.Time `type:"timestamp"`

	// Displays any Amazon S3 error that CloudTrail encountered when attempting
	// to deliver a digest file to the designated bucket. For more information,
	// see Error Responses (https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html)
	// in the Amazon S3 API Reference.
	//
	// This error occurs only when there is a problem with the destination S3 bucket,
	// and does not occur for requests that time out. To resolve the issue, create
	// a new bucket, and then call UpdateTrail to specify the new bucket; or fix
	// the existing objects so that CloudTrail can again write to the bucket.
	LatestDigestDeliveryError *string `type:"string"`

	// Specifies the date and time that CloudTrail last delivered a digest file
	// to an account's Amazon S3 bucket.
	LatestDigestDeliveryTime *time.Time `type:"timestamp"`

	// This field is no longer in use.
	LatestNotificationAttemptSucceeded *string `type:"string"`

	// This field is no longer in use.
	LatestNotificationAttemptTime *string `type:"string"`

	// Displays any Amazon SNS error that CloudTrail encountered when attempting
	// to send a notification. For more information about Amazon SNS errors, see
	// the Amazon SNS Developer Guide (https://docs.aws.amazon.com/sns/latest/dg/welcome.html).
	LatestNotificationError *string `type:"string"`

	// Specifies the date and time of the most recent Amazon SNS notification that
	// CloudTrail has written a new log file to an account's Amazon S3 bucket.
	LatestNotificationTime *time.Time `type:"timestamp"`

	// Specifies the most recent date and time when CloudTrail started recording
	// API calls for an Amazon Web Services account.
	StartLoggingTime *time.Time `type:"timestamp"`

	// Specifies the most recent date and time when CloudTrail stopped recording
	// API calls for an Amazon Web Services account.
	StopLoggingTime *time.Time `type:"timestamp"`

	// This field is no longer in use.
	TimeLoggingStarted *string `type:"string"`

	// This field is no longer in use.
	TimeLoggingStopped *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrailStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrailStatusOutput) GoString() string {
	return s.String()
}

// SetIsLogging sets the IsLogging field's value.
func (s *GetTrailStatusOutput) SetIsLogging(v bool) *GetTrailStatusOutput {
	s.IsLogging = &v
	return s
}

// SetLatestCloudWatchLogsDeliveryError sets the LatestCloudWatchLogsDeliveryError field's value.
func (s *GetTrailStatusOutput) SetLatestCloudWatchLogsDeliveryError(v string) *GetTrailStatusOutput {
	s.LatestCloudWatchLogsDeliveryError = &v
	return s
}

// SetLatestCloudWatchLogsDeliveryTime sets the LatestCloudWatchLogsDeliveryTime field's value.
func (s *GetTrailStatusOutput) SetLatestCloudWatchLogsDeliveryTime(v time.Time) *GetTrailStatusOutput {
	s.LatestCloudWatchLogsDeliveryTime = &v
	return s
}

// SetLatestDeliveryAttemptSucceeded sets the LatestDeliveryAttemptSucceeded field's value.
func (s *GetTrailStatusOutput) SetLatestDeliveryAttemptSucceeded(v string) *GetTrailStatusOutput {
	s.LatestDeliveryAttemptSucceeded = &v
	return s
}

// SetLatestDeliveryAttemptTime sets the LatestDeliveryAttemptTime field's value.
func (s *GetTrailStatusOutput) SetLatestDeliveryAttemptTime(v string) *GetTrailStatusOutput {
	s.LatestDeliveryAttemptTime = &v
	return s
}

// SetLatestDeliveryError sets the LatestDeliveryError field's value.
func (s *GetTrailStatusOutput) SetLatestDeliveryError(v string) *GetTrailStatusOutput {
	s.LatestDeliveryError = &v
	return s
}

// SetLatestDeliveryTime sets the LatestDeliveryTime field's value.
func (s *GetTrailStatusOutput) SetLatestDeliveryTime(v time.Time) *GetTrailStatusOutput {
	s.LatestDeliveryTime = &v
	return s
}

// SetLatestDigestDeliveryError sets the LatestDigestDeliveryError field's value.
func (s *GetTrailStatusOutput) SetLatestDigestDeliveryError(v string) *GetTrailStatusOutput {
	s.LatestDigestDeliveryError = &v
	return s
}

// SetLatestDigestDeliveryTime sets the LatestDigestDeliveryTime field's value.
func (s *GetTrailStatusOutput) SetLatestDigestDeliveryTime(v time.Time) *GetTrailStatusOutput {
	s.LatestDigestDeliveryTime = &v
	return s
}

// SetLatestNotificationAttemptSucceeded sets the LatestNotificationAttemptSucceeded field's value.
func (s *GetTrailStatusOutput) SetLatestNotificationAttemptSucceeded(v string) *GetTrailStatusOutput {
	s.LatestNotificationAttemptSucceeded = &v
	return s
}

// SetLatestNotificationAttemptTime sets the LatestNotificationAttemptTime field's value.
func (s *GetTrailStatusOutput) SetLatestNotificationAttemptTime(v string) *GetTrailStatusOutput {
	s.LatestNotificationAttemptTime = &v
	return s
}

// SetLatestNotificationError sets the LatestNotificationError field's value.
func (s *GetTrailStatusOutput) SetLatestNotificationError(v string) *GetTrailStatusOutput {
	s.LatestNotificationError = &v
	return s
}

// SetLatestNotificationTime sets the LatestNotificationTime field's value.
func (s *GetTrailStatusOutput) SetLatestNotificationTime(v time.Time) *GetTrailStatusOutput {
	s.LatestNotificationTime = &v
	return s
}

// SetStartLoggingTime sets the StartLoggingTime field's value.
func (s *GetTrailStatusOutput) SetStartLoggingTime(v time.Time) *GetTrailStatusOutput {
	s.StartLoggingTime = &v
	return s
}

// SetStopLoggingTime sets the StopLoggingTime field's value.
func (s *GetTrailStatusOutput) SetStopLoggingTime(v time.Time) *GetTrailStatusOutput {
	s.StopLoggingTime = &v
	return s
}

// SetTimeLoggingStarted sets the TimeLoggingStarted field's value.
func (s *GetTrailStatusOutput) SetTimeLoggingStarted(v string) *GetTrailStatusOutput {
	s.TimeLoggingStarted = &v
	return s
}

// SetTimeLoggingStopped sets the TimeLoggingStopped field's value.
func (s *GetTrailStatusOutput) SetTimeLoggingStopped(v string) *GetTrailStatusOutput {
	s.TimeLoggingStopped = &v
	return s
}

// If you run GetInsightSelectors on a trail that does not have Insights events
// enabled, the operation throws the exception InsightNotEnabledException.
type InsightNotEnabledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightNotEnabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightNotEnabledException) GoString() string {
	return s.String()
}

func newErrorInsightNotEnabledException(v protocol.ResponseMetadata) error {
	return &InsightNotEnabledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsightNotEnabledException) Code() string {
	return "InsightNotEnabledException"
}

// Message returns the exception's message.
func (s *InsightNotEnabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsightNotEnabledException) OrigErr() error {
	return nil
}

func (s *InsightNotEnabledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsightNotEnabledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsightNotEnabledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A JSON string that contains a list of insight types that are logged on a
// trail.
type InsightSelector struct {
	_ struct{} `type:"structure"`

	// The type of Insights events to log on a trail. The valid Insights type in
	// this release is ApiCallRateInsight.
	InsightType *string `type:"string" enum:"InsightType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightSelector) GoString() string {
	return s.String()
}

// SetInsightType sets the InsightType field's value.
func (s *InsightSelector) SetInsightType(v string) *InsightSelector {
	s.InsightType = &v
	return s
}

// This exception is thrown when the IAM user or role that is used to create
// the organization trail is lacking one or more required permissions for creating
// an organization trail in a required service. For more information, see Prepare
// For Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
type InsufficientDependencyServiceAccessPermissionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientDependencyServiceAccessPermissionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientDependencyServiceAccessPermissionException) GoString() string {
	return s.String()
}

func newErrorInsufficientDependencyServiceAccessPermissionException(v protocol.ResponseMetadata) error {
	return &InsufficientDependencyServiceAccessPermissionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientDependencyServiceAccessPermissionException) Code() string {
	return "InsufficientDependencyServiceAccessPermissionException"
}

// Message returns the exception's message.
func (s *InsufficientDependencyServiceAccessPermissionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientDependencyServiceAccessPermissionException) OrigErr() error {
	return nil
}

func (s *InsufficientDependencyServiceAccessPermissionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientDependencyServiceAccessPermissionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientDependencyServiceAccessPermissionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the policy on the S3 bucket or KMS key is not
// sufficient.
type InsufficientEncryptionPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientEncryptionPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientEncryptionPolicyException) GoString() string {
	return s.String()
}

func newErrorInsufficientEncryptionPolicyException(v protocol.ResponseMetadata) error {
	return &InsufficientEncryptionPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientEncryptionPolicyException) Code() string {
	return "InsufficientEncryptionPolicyException"
}

// Message returns the exception's message.
func (s *InsufficientEncryptionPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientEncryptionPolicyException) OrigErr() error {
	return nil
}

func (s *InsufficientEncryptionPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientEncryptionPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientEncryptionPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the policy on the S3 bucket is not sufficient.
type InsufficientS3BucketPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientS3BucketPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientS3BucketPolicyException) GoString() string {
	return s.String()
}

func newErrorInsufficientS3BucketPolicyException(v protocol.ResponseMetadata) error {
	return &InsufficientS3BucketPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientS3BucketPolicyException) Code() string {
	return "InsufficientS3BucketPolicyException"
}

// Message returns the exception's message.
func (s *InsufficientS3BucketPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientS3BucketPolicyException) OrigErr() error {
	return nil
}

func (s *InsufficientS3BucketPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientS3BucketPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientS3BucketPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the policy on the Amazon SNS topic is not sufficient.
type InsufficientSnsTopicPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientSnsTopicPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientSnsTopicPolicyException) GoString() string {
	return s.String()
}

func newErrorInsufficientSnsTopicPolicyException(v protocol.ResponseMetadata) error {
	return &InsufficientSnsTopicPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientSnsTopicPolicyException) Code() string {
	return "InsufficientSnsTopicPolicyException"
}

// Message returns the exception's message.
func (s *InsufficientSnsTopicPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientSnsTopicPolicyException) OrigErr() error {
	return nil
}

func (s *InsufficientSnsTopicPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientSnsTopicPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientSnsTopicPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the provided CloudWatch Logs log group is not
// valid.
type InvalidCloudWatchLogsLogGroupArnException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCloudWatchLogsLogGroupArnException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCloudWatchLogsLogGroupArnException) GoString() string {
	return s.String()
}

func newErrorInvalidCloudWatchLogsLogGroupArnException(v protocol.ResponseMetadata) error {
	return &InvalidCloudWatchLogsLogGroupArnException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidCloudWatchLogsLogGroupArnException) Code() string {
	return "InvalidCloudWatchLogsLogGroupArnException"
}

// Message returns the exception's message.
func (s *InvalidCloudWatchLogsLogGroupArnException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidCloudWatchLogsLogGroupArnException) OrigErr() error {
	return nil
}

func (s *InvalidCloudWatchLogsLogGroupArnException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidCloudWatchLogsLogGroupArnException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidCloudWatchLogsLogGroupArnException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the provided role is not valid.
type InvalidCloudWatchLogsRoleArnException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCloudWatchLogsRoleArnException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCloudWatchLogsRoleArnException) GoString() string {
	return s.String()
}

func newErrorInvalidCloudWatchLogsRoleArnException(v protocol.ResponseMetadata) error {
	return &InvalidCloudWatchLogsRoleArnException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidCloudWatchLogsRoleArnException) Code() string {
	return "InvalidCloudWatchLogsRoleArnException"
}

// Message returns the exception's message.
func (s *InvalidCloudWatchLogsRoleArnException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidCloudWatchLogsRoleArnException) OrigErr() error {
	return nil
}

func (s *InvalidCloudWatchLogsRoleArnException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidCloudWatchLogsRoleArnException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidCloudWatchLogsRoleArnException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Occurs if an event category that is not valid is specified as a value of
// EventCategory.
type InvalidEventCategoryException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEventCategoryException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEventCategoryException) GoString() string {
	return s.String()
}

func newErrorInvalidEventCategoryException(v protocol.ResponseMetadata) error {
	return &InvalidEventCategoryException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidEventCategoryException) Code() string {
	return "InvalidEventCategoryException"
}

// Message returns the exception's message.
func (s *InvalidEventCategoryException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidEventCategoryException) OrigErr() error {
	return nil
}

func (s *InvalidEventCategoryException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidEventCategoryException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidEventCategoryException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the PutEventSelectors operation is called with
// a number of event selectors, advanced event selectors, or data resources
// that is not valid. The combination of event selectors or advanced event selectors
// and data resources is not valid. A trail can have up to 5 event selectors.
// If a trail uses advanced event selectors, a maximum of 500 total values for
// all conditions in all advanced event selectors is allowed. A trail is limited
// to 250 data resources. These data resources can be distributed across event
// selectors, but the overall total cannot exceed 250.
//
// You can:
//
//    * Specify a valid number of event selectors (1 to 5) for a trail.
//
//    * Specify a valid number of data resources (1 to 250) for an event selector.
//    The limit of number of resources on an individual event selector is configurable
//    up to 250. However, this upper limit is allowed only if the total number
//    of data resources does not exceed 250 across all event selectors for a
//    trail.
//
//    * Specify up to 500 values for all conditions in all advanced event selectors
//    for a trail.
//
//    * Specify a valid value for a parameter. For example, specifying the ReadWriteType
//    parameter with a value of read-only is not valid.
type InvalidEventSelectorsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEventSelectorsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEventSelectorsException) GoString() string {
	return s.String()
}

func newErrorInvalidEventSelectorsException(v protocol.ResponseMetadata) error {
	return &InvalidEventSelectorsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidEventSelectorsException) Code() string {
	return "InvalidEventSelectorsException"
}

// Message returns the exception's message.
func (s *InvalidEventSelectorsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidEventSelectorsException) OrigErr() error {
	return nil
}

func (s *InvalidEventSelectorsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidEventSelectorsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidEventSelectorsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when an operation is called on a trail from a region
// other than the region in which the trail was created.
type InvalidHomeRegionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidHomeRegionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidHomeRegionException) GoString() string {
	return s.String()
}

func newErrorInvalidHomeRegionException(v protocol.ResponseMetadata) error {
	return &InvalidHomeRegionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidHomeRegionException) Code() string {
	return "InvalidHomeRegionException"
}

// Message returns the exception's message.
func (s *InvalidHomeRegionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidHomeRegionException) OrigErr() error {
	return nil
}

func (s *InvalidHomeRegionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidHomeRegionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidHomeRegionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The formatting or syntax of the InsightSelectors JSON statement in your PutInsightSelectors
// or GetInsightSelectors request is not valid, or the specified insight type
// in the InsightSelectors statement is not a valid insight type.
type InvalidInsightSelectorsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInsightSelectorsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInsightSelectorsException) GoString() string {
	return s.String()
}

func newErrorInvalidInsightSelectorsException(v protocol.ResponseMetadata) error {
	return &InvalidInsightSelectorsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInsightSelectorsException) Code() string {
	return "InvalidInsightSelectorsException"
}

// Message returns the exception's message.
func (s *InvalidInsightSelectorsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInsightSelectorsException) OrigErr() error {
	return nil
}

func (s *InvalidInsightSelectorsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInsightSelectorsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInsightSelectorsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the KMS key ARN is not valid.
type InvalidKmsKeyIdException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidKmsKeyIdException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidKmsKeyIdException) GoString() string {
	return s.String()
}

func newErrorInvalidKmsKeyIdException(v protocol.ResponseMetadata) error {
	return &InvalidKmsKeyIdException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidKmsKeyIdException) Code() string {
	return "InvalidKmsKeyIdException"
}

// Message returns the exception's message.
func (s *InvalidKmsKeyIdException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidKmsKeyIdException) OrigErr() error {
	return nil
}

func (s *InvalidKmsKeyIdException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidKmsKeyIdException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidKmsKeyIdException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Occurs when a lookup attribute is specified that is not valid.
type InvalidLookupAttributesException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidLookupAttributesException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidLookupAttributesException) GoString() string {
	return s.String()
}

func newErrorInvalidLookupAttributesException(v protocol.ResponseMetadata) error {
	return &InvalidLookupAttributesException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidLookupAttributesException) Code() string {
	return "InvalidLookupAttributesException"
}

// Message returns the exception's message.
func (s *InvalidLookupAttributesException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidLookupAttributesException) OrigErr() error {
	return nil
}

func (s *InvalidLookupAttributesException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidLookupAttributesException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidLookupAttributesException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown if the limit specified is not valid.
type InvalidMaxResultsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidMaxResultsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidMaxResultsException) GoString() string {
	return s.String()
}

func newErrorInvalidMaxResultsException(v protocol.ResponseMetadata) error {
	return &InvalidMaxResultsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidMaxResultsException) Code() string {
	return "InvalidMaxResultsException"
}

// Message returns the exception's message.
func (s *InvalidMaxResultsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidMaxResultsException) OrigErr() error {
	return nil
}

func (s *InvalidMaxResultsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidMaxResultsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidMaxResultsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A token that is not valid, or a token that was previously used in a request
// with different parameters. This exception is thrown if the token is not valid.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the combination of parameters provided is not
// valid.
type InvalidParameterCombinationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterCombinationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterCombinationException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterCombinationException(v protocol.ResponseMetadata) error {
	return &InvalidParameterCombinationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterCombinationException) Code() string {
	return "InvalidParameterCombinationException"
}

// Message returns the exception's message.
func (s *InvalidParameterCombinationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterCombinationException) OrigErr() error {
	return nil
}

func (s *InvalidParameterCombinationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterCombinationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterCombinationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the provided S3 bucket name is not valid.
type InvalidS3BucketNameException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidS3BucketNameException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidS3BucketNameException) GoString() string {
	return s.String()
}

func newErrorInvalidS3BucketNameException(v protocol.ResponseMetadata) error {
	return &InvalidS3BucketNameException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidS3BucketNameException) Code() string {
	return "InvalidS3BucketNameException"
}

// Message returns the exception's message.
func (s *InvalidS3BucketNameException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidS3BucketNameException) OrigErr() error {
	return nil
}

func (s *InvalidS3BucketNameException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidS3BucketNameException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidS3BucketNameException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the provided S3 prefix is not valid.
type InvalidS3PrefixException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidS3PrefixException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidS3PrefixException) GoString() string {
	return s.String()
}

func newErrorInvalidS3PrefixException(v protocol.ResponseMetadata) error {
	return &InvalidS3PrefixException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidS3PrefixException) Code() string {
	return "InvalidS3PrefixException"
}

// Message returns the exception's message.
func (s *InvalidS3PrefixException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidS3PrefixException) OrigErr() error {
	return nil
}

func (s *InvalidS3PrefixException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidS3PrefixException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidS3PrefixException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the provided SNS topic name is not valid.
type InvalidSnsTopicNameException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSnsTopicNameException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSnsTopicNameException) GoString() string {
	return s.String()
}

func newErrorInvalidSnsTopicNameException(v protocol.ResponseMetadata) error {
	return &InvalidSnsTopicNameException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSnsTopicNameException) Code() string {
	return "InvalidSnsTopicNameException"
}

// Message returns the exception's message.
func (s *InvalidSnsTopicNameException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSnsTopicNameException) OrigErr() error {
	return nil
}

func (s *InvalidSnsTopicNameException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSnsTopicNameException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSnsTopicNameException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the specified tag key or values are not valid.
// It can also occur if there are duplicate tags or too many tags on the resource.
type InvalidTagParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTagParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTagParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidTagParameterException(v protocol.ResponseMetadata) error {
	return &InvalidTagParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTagParameterException) Code() string {
	return "InvalidTagParameterException"
}

// Message returns the exception's message.
func (s *InvalidTagParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTagParameterException) OrigErr() error {
	return nil
}

func (s *InvalidTagParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTagParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTagParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Occurs if the timestamp values are not valid. Either the start time occurs
// after the end time, or the time range is outside the range of possible values.
type InvalidTimeRangeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTimeRangeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTimeRangeException) GoString() string {
	return s.String()
}

func newErrorInvalidTimeRangeException(v protocol.ResponseMetadata) error {
	return &InvalidTimeRangeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTimeRangeException) Code() string {
	return "InvalidTimeRangeException"
}

// Message returns the exception's message.
func (s *InvalidTimeRangeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTimeRangeException) OrigErr() error {
	return nil
}

func (s *InvalidTimeRangeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTimeRangeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTimeRangeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Reserved for future use.
type InvalidTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidTokenException(v protocol.ResponseMetadata) error {
	return &InvalidTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTokenException) Code() string {
	return "InvalidTokenException"
}

// Message returns the exception's message.
func (s *InvalidTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTokenException) OrigErr() error {
	return nil
}

func (s *InvalidTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the provided trail name is not valid. Trail
// names must meet the following requirements:
//
//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//    (_), or dashes (-)
//
//    * Start with a letter or number, and end with a letter or number
//
//    * Be between 3 and 128 characters
//
//    * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//    and my--namespace are not valid.
//
//    * Not be in IP address format (for example, 192.168.5.4)
type InvalidTrailNameException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTrailNameException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTrailNameException) GoString() string {
	return s.String()
}

func newErrorInvalidTrailNameException(v protocol.ResponseMetadata) error {
	return &InvalidTrailNameException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTrailNameException) Code() string {
	return "InvalidTrailNameException"
}

// Message returns the exception's message.
func (s *InvalidTrailNameException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTrailNameException) OrigErr() error {
	return nil
}

func (s *InvalidTrailNameException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTrailNameException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTrailNameException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when there is an issue with the specified KMS key
// and the trail can’t be updated.
type KmsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsException) GoString() string {
	return s.String()
}

func newErrorKmsException(v protocol.ResponseMetadata) error {
	return &KmsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KmsException) Code() string {
	return "KmsException"
}

// Message returns the exception's message.
func (s *KmsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KmsException) OrigErr() error {
	return nil
}

func (s *KmsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KmsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KmsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is no longer in use.
//
// Deprecated: KmsKeyDisabledException has been deprecated
type KmsKeyDisabledException struct {
	_            struct{}                  `deprecated:"true" type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsKeyDisabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsKeyDisabledException) GoString() string {
	return s.String()
}

func newErrorKmsKeyDisabledException(v protocol.ResponseMetadata) error {
	return &KmsKeyDisabledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KmsKeyDisabledException) Code() string {
	return "KmsKeyDisabledException"
}

// Message returns the exception's message.
func (s *KmsKeyDisabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KmsKeyDisabledException) OrigErr() error {
	return nil
}

func (s *KmsKeyDisabledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KmsKeyDisabledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KmsKeyDisabledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the KMS key does not exist, when the S3 bucket
// and the KMS key are not in the same region, or when the KMS key associated
// with the Amazon SNS topic either does not exist or is not in the same region.
type KmsKeyNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsKeyNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsKeyNotFoundException) GoString() string {
	return s.String()
}

func newErrorKmsKeyNotFoundException(v protocol.ResponseMetadata) error {
	return &KmsKeyNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KmsKeyNotFoundException) Code() string {
	return "KmsKeyNotFoundException"
}

// Message returns the exception's message.
func (s *KmsKeyNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KmsKeyNotFoundException) OrigErr() error {
	return nil
}

func (s *KmsKeyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KmsKeyNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KmsKeyNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Requests the public keys for a specified time range.
type ListPublicKeysInput struct {
	_ struct{} `type:"structure"`

	// Optionally specifies, in UTC, the end of the time range to look up public
	// keys for CloudTrail digest files. If not specified, the current time is used.
	EndTime *time.Time `type:"timestamp"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// Optionally specifies, in UTC, the start of the time range to look up public
	// keys for CloudTrail digest files. If not specified, the current time is used,
	// and the current public key is returned.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPublicKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPublicKeysInput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *ListPublicKeysInput) SetEndTime(v time.Time) *ListPublicKeysInput {
	s.EndTime = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPublicKeysInput) SetNextToken(v string) *ListPublicKeysInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListPublicKeysInput) SetStartTime(v time.Time) *ListPublicKeysInput {
	s.StartTime = &v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type ListPublicKeysOutput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// Contains an array of PublicKey objects.
	//
	// The returned public keys may have validity time ranges that overlap.
	PublicKeyList []*PublicKey `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPublicKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPublicKeysOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPublicKeysOutput) SetNextToken(v string) *ListPublicKeysOutput {
	s.NextToken = &v
	return s
}

// SetPublicKeyList sets the PublicKeyList field's value.
func (s *ListPublicKeysOutput) SetPublicKeyList(v []*PublicKey) *ListPublicKeysOutput {
	s.PublicKeyList = v
	return s
}

// Specifies a list of trail tags to return.
type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// Specifies a list of trail ARNs whose tags will be listed. The list has a
	// limit of 20 ARNs. The following is the format of a trail ARN.
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// ResourceIdList is a required field
	ResourceIdList []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.ResourceIdList == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsInput) SetNextToken(v string) *ListTagsInput {
	s.NextToken = &v
	return s
}

// SetResourceIdList sets the ResourceIdList field's value.
func (s *ListTagsInput) SetResourceIdList(v []*string) *ListTagsInput {
	s.ResourceIdList = v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// A list of resource tags.
	ResourceTagList []*ResourceTag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOutput) SetNextToken(v string) *ListTagsOutput {
	s.NextToken = &v
	return s
}

// SetResourceTagList sets the ResourceTagList field's value.
func (s *ListTagsOutput) SetResourceTagList(v []*ResourceTag) *ListTagsOutput {
	s.ResourceTagList = v
	return s
}

type ListTrailsInput struct {
	_ struct{} `type:"structure"`

	// The token to use to get the next page of results after a previous API call.
	// This token must be passed in with the same parameters that were specified
	// in the the original call. For example, if the original call specified an
	// AttributeKey of 'Username' with a value of 'root', the call with NextToken
	// should include those same parameters.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrailsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrailsInput) SetNextToken(v string) *ListTrailsInput {
	s.NextToken = &v
	return s
}

type ListTrailsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to get the next page of results after a previous API call.
	// If the token does not appear, there are no more results to return. The token
	// must be passed in with the same parameters as the previous call. For example,
	// if the original call specified an AttributeKey of 'Username' with a value
	// of 'root', the call with NextToken should include those same parameters.
	NextToken *string `type:"string"`

	// Returns the name, ARN, and home region of trails in the current account.
	Trails []*TrailInfo `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrailsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrailsOutput) SetNextToken(v string) *ListTrailsOutput {
	s.NextToken = &v
	return s
}

// SetTrails sets the Trails field's value.
func (s *ListTrailsOutput) SetTrails(v []*TrailInfo) *ListTrailsOutput {
	s.Trails = v
	return s
}

// Specifies an attribute and value that filter the events returned.
type LookupAttribute struct {
	_ struct{} `type:"structure"`

	// Specifies an attribute on which to filter the events returned.
	//
	// AttributeKey is a required field
	AttributeKey *string `type:"string" required:"true" enum:"LookupAttributeKey"`

	// Specifies a value for the specified AttributeKey.
	//
	// AttributeValue is a required field
	AttributeValue *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LookupAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LookupAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LookupAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LookupAttribute"}
	if s.AttributeKey == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeKey"))
	}
	if s.AttributeValue == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeKey sets the AttributeKey field's value.
func (s *LookupAttribute) SetAttributeKey(v string) *LookupAttribute {
	s.AttributeKey = &v
	return s
}

// SetAttributeValue sets the AttributeValue field's value.
func (s *LookupAttribute) SetAttributeValue(v string) *LookupAttribute {
	s.AttributeValue = &v
	return s
}

// Contains a request for LookupEvents.
type LookupEventsInput struct {
	_ struct{} `type:"structure"`

	// Specifies that only events that occur before or at the specified time are
	// returned. If the specified end time is before the specified start time, an
	// error is returned.
	EndTime *time.Time `type:"timestamp"`

	// Specifies the event category. If you do not specify an event category, events
	// of the category are not returned in the response. For example, if you do
	// not specify insight as the value of EventCategory, no Insights events are
	// returned.
	EventCategory *string `type:"string" enum:"EventCategory"`

	// Contains a list of lookup attributes. Currently the list can contain only
	// one item.
	LookupAttributes []*LookupAttribute `type:"list"`

	// The number of events to return. Possible values are 1 through 50. The default
	// is 50.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to get the next page of results after a previous API call.
	// This token must be passed in with the same parameters that were specified
	// in the the original call. For example, if the original call specified an
	// AttributeKey of 'Username' with a value of 'root', the call with NextToken
	// should include those same parameters.
	NextToken *string `type:"string"`

	// Specifies that only events that occur after or at the specified time are
	// returned. If the specified start time is after the specified end time, an
	// error is returned.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LookupEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LookupEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LookupEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LookupEventsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.LookupAttributes != nil {
		for i, v := range s.LookupAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LookupAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *LookupEventsInput) SetEndTime(v time.Time) *LookupEventsInput {
	s.EndTime = &v
	return s
}

// SetEventCategory sets the EventCategory field's value.
func (s *LookupEventsInput) SetEventCategory(v string) *LookupEventsInput {
	s.EventCategory = &v
	return s
}

// SetLookupAttributes sets the LookupAttributes field's value.
func (s *LookupEventsInput) SetLookupAttributes(v []*LookupAttribute) *LookupEventsInput {
	s.LookupAttributes = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *LookupEventsInput) SetMaxResults(v int64) *LookupEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *LookupEventsInput) SetNextToken(v string) *LookupEventsInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *LookupEventsInput) SetStartTime(v time.Time) *LookupEventsInput {
	s.StartTime = &v
	return s
}

// Contains a response to a LookupEvents action.
type LookupEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of events returned based on the lookup attributes specified and the
	// CloudTrail event. The events list is sorted by time. The most recent event
	// is listed first.
	Events []*Event `type:"list"`

	// The token to use to get the next page of results after a previous API call.
	// If the token does not appear, there are no more results to return. The token
	// must be passed in with the same parameters as the previous call. For example,
	// if the original call specified an AttributeKey of 'Username' with a value
	// of 'root', the call with NextToken should include those same parameters.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LookupEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LookupEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *LookupEventsOutput) SetEvents(v []*Event) *LookupEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *LookupEventsOutput) SetNextToken(v string) *LookupEventsOutput {
	s.NextToken = &v
	return s
}

// This exception is thrown when the maximum number of trails is reached.
type MaximumNumberOfTrailsExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaximumNumberOfTrailsExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaximumNumberOfTrailsExceededException) GoString() string {
	return s.String()
}

func newErrorMaximumNumberOfTrailsExceededException(v protocol.ResponseMetadata) error {
	return &MaximumNumberOfTrailsExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaximumNumberOfTrailsExceededException) Code() string {
	return "MaximumNumberOfTrailsExceededException"
}

// Message returns the exception's message.
func (s *MaximumNumberOfTrailsExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaximumNumberOfTrailsExceededException) OrigErr() error {
	return nil
}

func (s *MaximumNumberOfTrailsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaximumNumberOfTrailsExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaximumNumberOfTrailsExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the Amazon Web Services account making the
// request to create or update an organization trail is not the management account
// for an organization in Organizations. For more information, see Prepare For
// Creating a Trail For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
type NotOrganizationMasterAccountException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotOrganizationMasterAccountException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotOrganizationMasterAccountException) GoString() string {
	return s.String()
}

func newErrorNotOrganizationMasterAccountException(v protocol.ResponseMetadata) error {
	return &NotOrganizationMasterAccountException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotOrganizationMasterAccountException) Code() string {
	return "NotOrganizationMasterAccountException"
}

// Message returns the exception's message.
func (s *NotOrganizationMasterAccountException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotOrganizationMasterAccountException) OrigErr() error {
	return nil
}

func (s *NotOrganizationMasterAccountException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotOrganizationMasterAccountException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotOrganizationMasterAccountException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the requested operation is not permitted.
type OperationNotPermittedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationNotPermittedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationNotPermittedException) GoString() string {
	return s.String()
}

func newErrorOperationNotPermittedException(v protocol.ResponseMetadata) error {
	return &OperationNotPermittedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperationNotPermittedException) Code() string {
	return "OperationNotPermittedException"
}

// Message returns the exception's message.
func (s *OperationNotPermittedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperationNotPermittedException) OrigErr() error {
	return nil
}

func (s *OperationNotPermittedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperationNotPermittedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperationNotPermittedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when Organizations is not configured to support
// all features. All features must be enabled in Organizations to support creating
// an organization trail. For more information, see Prepare For Creating a Trail
// For Your Organization (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html).
type OrganizationNotInAllFeaturesModeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationNotInAllFeaturesModeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationNotInAllFeaturesModeException) GoString() string {
	return s.String()
}

func newErrorOrganizationNotInAllFeaturesModeException(v protocol.ResponseMetadata) error {
	return &OrganizationNotInAllFeaturesModeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationNotInAllFeaturesModeException) Code() string {
	return "OrganizationNotInAllFeaturesModeException"
}

// Message returns the exception's message.
func (s *OrganizationNotInAllFeaturesModeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationNotInAllFeaturesModeException) OrigErr() error {
	return nil
}

func (s *OrganizationNotInAllFeaturesModeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationNotInAllFeaturesModeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationNotInAllFeaturesModeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the request is made from an Amazon Web Services
// account that is not a member of an organization. To make this request, sign
// in using the credentials of an account that belongs to an organization.
type OrganizationsNotInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationsNotInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationsNotInUseException) GoString() string {
	return s.String()
}

func newErrorOrganizationsNotInUseException(v protocol.ResponseMetadata) error {
	return &OrganizationsNotInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationsNotInUseException) Code() string {
	return "OrganizationsNotInUseException"
}

// Message returns the exception's message.
func (s *OrganizationsNotInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationsNotInUseException) OrigErr() error {
	return nil
}

func (s *OrganizationsNotInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationsNotInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationsNotInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about a returned public key.
type PublicKey struct {
	_ struct{} `type:"structure"`

	// The fingerprint of the public key.
	Fingerprint *string `type:"string"`

	// The ending time of validity of the public key.
	ValidityEndTime *time.Time `type:"timestamp"`

	// The starting time of validity of the public key.
	ValidityStartTime *time.Time `type:"timestamp"`

	// The DER encoded public key value in PKCS#1 format.
	// Value is automatically base64 encoded/decoded by the SDK.
	Value []byte `type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublicKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublicKey) GoString() string {
	return s.String()
}

// SetFingerprint sets the Fingerprint field's value.
func (s *PublicKey) SetFingerprint(v string) *PublicKey {
	s.Fingerprint = &v
	return s
}

// SetValidityEndTime sets the ValidityEndTime field's value.
func (s *PublicKey) SetValidityEndTime(v time.Time) *PublicKey {
	s.ValidityEndTime = &v
	return s
}

// SetValidityStartTime sets the ValidityStartTime field's value.
func (s *PublicKey) SetValidityStartTime(v time.Time) *PublicKey {
	s.ValidityStartTime = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PublicKey) SetValue(v []byte) *PublicKey {
	s.Value = v
	return s
}

type PutEventSelectorsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the settings for advanced event selectors. You can add advanced
	// event selectors, and conditions for your advanced event selectors, up to
	// a maximum of 500 values for all conditions and selectors on a trail. You
	// can use either AdvancedEventSelectors or EventSelectors, but not both. If
	// you apply AdvancedEventSelectors to a trail, any existing EventSelectors
	// are overwritten. For more information about advanced event selectors, see
	// Logging data events for trails (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html)
	// in the CloudTrail User Guide.
	AdvancedEventSelectors []*AdvancedEventSelector `type:"list"`

	// Specifies the settings for your event selectors. You can configure up to
	// five event selectors for a trail. You can use either EventSelectors or AdvancedEventSelectors
	// in a PutEventSelectors request, but not both. If you apply EventSelectors
	// to a trail, any existing AdvancedEventSelectors are overwritten.
	EventSelectors []*EventSelector `type:"list"`

	// Specifies the name of the trail or trail ARN. If you specify a trail name,
	// the string must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-)
	//
	//    * Start with a letter or number, and end with a letter or number
	//
	//    * Be between 3 and 128 characters
	//
	//    * Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//    and my--namespace are not valid.
	//
	//    * Not be in IP address format (for example, 192.168.5.4)
	//
	// If you specify a trail ARN, it must be in the following format.
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// TrailName is a required field
	TrailName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventSelectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventSelectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventSelectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventSelectorsInput"}
	if s.TrailName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrailName"))
	}
	if s.AdvancedEventSelectors != nil {
		for i, v := range s.AdvancedEventSelectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AdvancedEventSelectors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdvancedEventSelectors sets the AdvancedEventSelectors field's value.
func (s *PutEventSelectorsInput) SetAdvancedEventSelectors(v []*AdvancedEventSelector) *PutEventSelectorsInput {
	s.AdvancedEventSelectors = v
	return s
}

// SetEventSelectors sets the EventSelectors field's value.
func (s *PutEventSelectorsInput) SetEventSelectors(v []*EventSelector) *PutEventSelectorsInput {
	s.EventSelectors = v
	return s
}

// SetTrailName sets the TrailName field's value.
func (s *PutEventSelectorsInput) SetTrailName(v string) *PutEventSelectorsInput {
	s.TrailName = &v
	return s
}

type PutEventSelectorsOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the advanced event selectors configured for your trail.
	AdvancedEventSelectors []*AdvancedEventSelector `type:"list"`

	// Specifies the event selectors configured for your trail.
	EventSelectors []*EventSelector `type:"list"`

	// Specifies the ARN of the trail that was updated with event selectors. The
	// following is the format of a trail ARN.
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	TrailARN *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventSelectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventSelectorsOutput) GoString() string {
	return s.String()
}

// SetAdvancedEventSelectors sets the AdvancedEventSelectors field's value.
func (s *PutEventSelectorsOutput) SetAdvancedEventSelectors(v []*AdvancedEventSelector) *PutEventSelectorsOutput {
	s.AdvancedEventSelectors = v
	return s
}

// SetEventSelectors sets the EventSelectors field's value.
func (s *PutEventSelectorsOutput) SetEventSelectors(v []*EventSelector) *PutEventSelectorsOutput {
	s.EventSelectors = v
	return s
}

// SetTrailARN sets the TrailARN field's value.
func (s *PutEventSelectorsOutput) SetTrailARN(v string) *PutEventSelectorsOutput {
	s.TrailARN = &v
	return s
}

type PutInsightSelectorsInput struct {
	_ struct{} `type:"structure"`

	// A JSON string that contains the Insights types that you want to log on a
	// trail. The valid Insights type in this release is ApiCallRateInsight.
	//
	// InsightSelectors is a required field
	InsightSelectors []*InsightSelector `type:"list" required:"true"`

	// The name of the CloudTrail trail for which you want to change or add Insights
	// selectors.
	//
	// TrailName is a required field
	TrailName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInsightSelectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInsightSelectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutInsightSelectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutInsightSelectorsInput"}
	if s.InsightSelectors == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightSelectors"))
	}
	if s.TrailName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrailName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightSelectors sets the InsightSelectors field's value.
func (s *PutInsightSelectorsInput) SetInsightSelectors(v []*InsightSelector) *PutInsightSelectorsInput {
	s.InsightSelectors = v
	return s
}

// SetTrailName sets the TrailName field's value.
func (s *PutInsightSelectorsInput) SetTrailName(v string) *PutInsightSelectorsInput {
	s.TrailName = &v
	return s
}

type PutInsightSelectorsOutput struct {
	_ struct{} `type:"structure"`

	// A JSON string that contains the Insights event types that you want to log
	// on a trail. The valid Insights type in this release is ApiCallRateInsight.
	InsightSelectors []*InsightSelector `type:"list"`

	// The Amazon Resource Name (ARN) of a trail for which you want to change or
	// add Insights selectors.
	TrailARN *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInsightSelectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInsightSelectorsOutput) GoString() string {
	return s.String()
}

// SetInsightSelectors sets the InsightSelectors field's value.
func (s *PutInsightSelectorsOutput) SetInsightSelectors(v []*InsightSelector) *PutInsightSelectorsOutput {
	s.InsightSelectors = v
	return s
}

// SetTrailARN sets the TrailARN field's value.
func (s *PutInsightSelectorsOutput) SetTrailARN(v string) *PutInsightSelectorsOutput {
	s.TrailARN = &v
	return s
}

// Specifies the tags to remove from a trail.
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the trail from which tags should be removed. The format
	// of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Specifies a list of tags to be removed.
	TagsList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.TagsList != nil {
		for i, v := range s.TagsList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagsList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *RemoveTagsInput) SetResourceId(v string) *RemoveTagsInput {
	s.ResourceId = &v
	return s
}

// SetTagsList sets the TagsList field's value.
func (s *RemoveTagsInput) SetTagsList(v []*Tag) *RemoveTagsInput {
	s.TagsList = v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Specifies the type and name of a resource referenced by an event.
type Resource struct {
	_ struct{} `type:"structure"`

	// The name of the resource referenced by the event returned. These are user-created
	// names whose values will depend on the environment. For example, the resource
	// name might be "auto-scaling-test-group" for an Auto Scaling Group or "i-1234567"
	// for an EC2 Instance.
	ResourceName *string `type:"string"`

	// The type of a resource referenced by the event returned. When the resource
	// type cannot be determined, null is returned. Some examples of resource types
	// are: Instance for EC2, Trail for CloudTrail, DBInstance for Amazon RDS, and
	// AccessKey for IAM. To learn more about how to look up and filter events by
	// the resource types supported for a service, see Filtering CloudTrail Events
	// (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/view-cloudtrail-events-console.html#filtering-cloudtrail-events).
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// SetResourceName sets the ResourceName field's value.
func (s *Resource) SetResourceName(v string) *Resource {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Resource) SetResourceType(v string) *Resource {
	s.ResourceType = &v
	return s
}

// This exception is thrown when the specified resource is not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A resource tag.
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the resource.
	ResourceId *string `type:"string"`

	// A list of tags.
	TagsList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTag) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceTag) SetResourceId(v string) *ResourceTag {
	s.ResourceId = &v
	return s
}

// SetTagsList sets the TagsList field's value.
func (s *ResourceTag) SetTagsList(v []*Tag) *ResourceTag {
	s.TagsList = v
	return s
}

// This exception is thrown when the specified resource type is not supported
// by CloudTrail.
type ResourceTypeNotSupportedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTypeNotSupportedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTypeNotSupportedException) GoString() string {
	return s.String()
}

func newErrorResourceTypeNotSupportedException(v protocol.ResponseMetadata) error {
	return &ResourceTypeNotSupportedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceTypeNotSupportedException) Code() string {
	return "ResourceTypeNotSupportedException"
}

// Message returns the exception's message.
func (s *ResourceTypeNotSupportedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceTypeNotSupportedException) OrigErr() error {
	return nil
}

func (s *ResourceTypeNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceTypeNotSupportedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceTypeNotSupportedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the specified S3 bucket does not exist.
type S3BucketDoesNotExistException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3BucketDoesNotExistException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3BucketDoesNotExistException) GoString() string {
	return s.String()
}

func newErrorS3BucketDoesNotExistException(v protocol.ResponseMetadata) error {
	return &S3BucketDoesNotExistException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *S3BucketDoesNotExistException) Code() string {
	return "S3BucketDoesNotExistException"
}

// Message returns the exception's message.
func (s *S3BucketDoesNotExistException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *S3BucketDoesNotExistException) OrigErr() error {
	return nil
}

func (s *S3BucketDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *S3BucketDoesNotExistException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *S3BucketDoesNotExistException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request to CloudTrail to start logging Amazon Web Services API calls
// for an account.
type StartLoggingInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name or the CloudTrail ARN of the trail for which CloudTrail
	// logs Amazon Web Services API calls. The following is the format of a trail
	// ARN.
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartLoggingInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StartLoggingInput) SetName(v string) *StartLoggingInput {
	s.Name = &v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type StartLoggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLoggingOutput) GoString() string {
	return s.String()
}

// Passes the request to CloudTrail to stop logging Amazon Web Services API
// calls for the specified account.
type StopLoggingInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name or the CloudTrail ARN of the trail for which CloudTrail
	// will stop logging Amazon Web Services API calls. The following is the format
	// of a trail ARN.
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopLoggingInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StopLoggingInput) SetName(v string) *StopLoggingInput {
	s.Name = &v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type StopLoggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopLoggingOutput) GoString() string {
	return s.String()
}

// A custom key-value pair associated with a resource such as a CloudTrail trail.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key in a key-value pair. The key must be must be no longer than 128 Unicode
	// characters. The key must be unique for the resource to which it applies.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The value in a key-value pair of a tag. The value must be no longer than
	// 256 Unicode characters.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The number of tags per trail has exceeded the permitted amount. Currently,
// the limit is 50.
type TagsLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagsLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagsLimitExceededException) GoString() string {
	return s.String()
}

func newErrorTagsLimitExceededException(v protocol.ResponseMetadata) error {
	return &TagsLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TagsLimitExceededException) Code() string {
	return "TagsLimitExceededException"
}

// Message returns the exception's message.
func (s *TagsLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TagsLimitExceededException) OrigErr() error {
	return nil
}

func (s *TagsLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TagsLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TagsLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The settings for a trail.
type Trail struct {
	_ struct{} `type:"structure"`

	// Specifies an Amazon Resource Name (ARN), a unique identifier that represents
	// the log group to which CloudTrail logs will be delivered.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies if the trail has custom event selectors.
	HasCustomEventSelectors *bool `type:"boolean"`

	// Specifies whether a trail has insight types specified in an InsightSelector
	// list.
	HasInsightSelectors *bool `type:"boolean"`

	// The region in which the trail was created.
	HomeRegion *string `type:"string"`

	// Set to True to include Amazon Web Services API calls from Amazon Web Services
	// global services such as IAM. Otherwise, False.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail exists only in one region or exists in all regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies whether the trail is an organization trail.
	IsOrganizationTrail *bool `type:"boolean"`

	// Specifies the KMS key ID that encrypts the logs delivered by CloudTrail.
	// The value is a fully specified ARN to a KMS key in the following format.
	//
	// arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies whether log file validation is enabled.
	LogFileValidationEnabled *bool `type:"boolean"`

	// Name of the trail set by calling CreateTrail. The maximum length is 128 characters.
	Name *string `type:"string"`

	// Name of the Amazon S3 bucket into which CloudTrail delivers your trail files.
	// See Amazon S3 Bucket Naming Requirements (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html).
	S3BucketName *string `type:"string"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
	// The maximum length is 200 characters.
	S3KeyPrefix *string `type:"string"`

	// Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications
	// when log files are delivered. The following is the format of a topic ARN.
	//
	// arn:aws:sns:us-east-2:123456789012:MyTopic
	SnsTopicARN *string `type:"string"`

	// This field is no longer in use. Use SnsTopicARN.
	//
	// Deprecated: SnsTopicName has been deprecated
	SnsTopicName *string `deprecated:"true" type:"string"`

	// Specifies the ARN of the trail. The following is the format of a trail ARN.
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	TrailARN *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Trail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Trail) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *Trail) SetCloudWatchLogsLogGroupArn(v string) *Trail {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *Trail) SetCloudWatchLogsRoleArn(v string) *Trail {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetHasCustomEventSelectors sets the HasCustomEventSelectors field's value.
func (s *Trail) SetHasCustomEventSelectors(v bool) *Trail {
	s.HasCustomEventSelectors = &v
	return s
}

// SetHasInsightSelectors sets the HasInsightSelectors field's value.
func (s *Trail) SetHasInsightSelectors(v bool) *Trail {
	s.HasInsightSelectors = &v
	return s
}

// SetHomeRegion sets the HomeRegion field's value.
func (s *Trail) SetHomeRegion(v string) *Trail {
	s.HomeRegion = &v
	return s
}

// SetIncludeGlobalServiceEvents sets the IncludeGlobalServiceEvents field's value.
func (s *Trail) SetIncludeGlobalServiceEvents(v bool) *Trail {
	s.IncludeGlobalServiceEvents = &v
	return s
}

// SetIsMultiRegionTrail sets the IsMultiRegionTrail field's value.
func (s *Trail) SetIsMultiRegionTrail(v bool) *Trail {
	s.IsMultiRegionTrail = &v
	return s
}

// SetIsOrganizationTrail sets the IsOrganizationTrail field's value.
func (s *Trail) SetIsOrganizationTrail(v bool) *Trail {
	s.IsOrganizationTrail = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Trail) SetKmsKeyId(v string) *Trail {
	s.KmsKeyId = &v
	return s
}

// SetLogFileValidationEnabled sets the LogFileValidationEnabled field's value.
func (s *Trail) SetLogFileValidationEnabled(v bool) *Trail {
	s.LogFileValidationEnabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *Trail) SetName(v string) *Trail {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *Trail) SetS3BucketName(v string) *Trail {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *Trail) SetS3KeyPrefix(v string) *Trail {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicARN sets the SnsTopicARN field's value.
func (s *Trail) SetSnsTopicARN(v string) *Trail {
	s.SnsTopicARN = &v
	return s
}

// SetSnsTopicName sets the SnsTopicName field's value.
func (s *Trail) SetSnsTopicName(v string) *Trail {
	s.SnsTopicName = &v
	return s
}

// SetTrailARN sets the TrailARN field's value.
func (s *Trail) SetTrailARN(v string) *Trail {
	s.TrailARN = &v
	return s
}

// This exception is thrown when the specified trail already exists.
type TrailAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrailAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrailAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorTrailAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &TrailAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TrailAlreadyExistsException) Code() string {
	return "TrailAlreadyExistsException"
}

// Message returns the exception's message.
func (s *TrailAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TrailAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *TrailAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TrailAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TrailAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a CloudTrail trail, including the trail's name, home region,
// and Amazon Resource Name (ARN).
type TrailInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services Region in which a trail was created.
	HomeRegion *string `type:"string"`

	// The name of a trail.
	Name *string `type:"string"`

	// The ARN of a trail.
	TrailARN *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrailInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrailInfo) GoString() string {
	return s.String()
}

// SetHomeRegion sets the HomeRegion field's value.
func (s *TrailInfo) SetHomeRegion(v string) *TrailInfo {
	s.HomeRegion = &v
	return s
}

// SetName sets the Name field's value.
func (s *TrailInfo) SetName(v string) *TrailInfo {
	s.Name = &v
	return s
}

// SetTrailARN sets the TrailARN field's value.
func (s *TrailInfo) SetTrailARN(v string) *TrailInfo {
	s.TrailARN = &v
	return s
}

// This exception is thrown when the trail with the given name is not found.
type TrailNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrailNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrailNotFoundException) GoString() string {
	return s.String()
}

func newErrorTrailNotFoundException(v protocol.ResponseMetadata) error {
	return &TrailNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TrailNotFoundException) Code() string {
	return "TrailNotFoundException"
}

// Message returns the exception's message.
func (s *TrailNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TrailNotFoundException) OrigErr() error {
	return nil
}

func (s *TrailNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TrailNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TrailNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is no longer in use.
type TrailNotProvidedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrailNotProvidedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrailNotProvidedException) GoString() string {
	return s.String()
}

func newErrorTrailNotProvidedException(v protocol.ResponseMetadata) error {
	return &TrailNotProvidedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TrailNotProvidedException) Code() string {
	return "TrailNotProvidedException"
}

// Message returns the exception's message.
func (s *TrailNotProvidedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TrailNotProvidedException) OrigErr() error {
	return nil
}

func (s *TrailNotProvidedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TrailNotProvidedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TrailNotProvidedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the requested operation is not supported.
type UnsupportedOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedOperationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedOperationException(v protocol.ResponseMetadata) error {
	return &UnsupportedOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedOperationException) Code() string {
	return "UnsupportedOperationException"
}

// Message returns the exception's message.
func (s *UnsupportedOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedOperationException) OrigErr() error {
	return nil
}

func (s *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies settings to update for the trail.
type UpdateTrailInput struct {
	_ struct{} `type:"structure"`

	// Specifies a log group name using an Amazon Resource Name (ARN), a unique
	// identifier that represents the log group to which CloudTrail logs are delivered.
	// Not required unless you specify CloudWatchLogsRoleArn.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies whether log file validation is enabled. The default is false.
	//
	// When you disable log file integrity validation, the chain of digest files
	// is broken after one hour. CloudTrail does not create digest files for log
	// files that were delivered during a period in which log file integrity validation
	// was disabled. For example, if you enable log file integrity validation at
	// noon on January 1, disable it at noon on January 2, and re-enable it at noon
	// on January 10, digest files will not be created for the log files delivered
	// from noon on January 2 to noon on January 10. The same applies whenever you
	// stop CloudTrail logging or delete a trail.
	EnableLogFileValidation *bool `type:"boolean"`

	// Specifies whether the trail is publishing events from global services such
	// as IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail applies only to the current region or to all
	// regions. The default is false. If the trail exists only in the current region
	// and this value is set to true, shadow trails (replications of the trail)
	// will be created in the other regions. If the trail exists in all regions
	// and this value is set to false, the trail will remain in the region where
	// it was created, and its shadow trails in other regions will be deleted. As
	// a best practice, consider using trails that log events in all regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies whether the trail is applied to all accounts in an organization
	// in Organizations, or only for the current Amazon Web Services account. The
	// default is false, and cannot be true unless the call is made on behalf of
	// an Amazon Web Services account that is the management account for an organization
	// in Organizations. If the trail is not an organization trail and this is set
	// to true, the trail will be created in all Amazon Web Services accounts that
	// belong to the organization. If the trail is an organization trail and this
	// is set to false, the trail will remain in the current Amazon Web Services
	// account but be deleted from all member accounts in the organization.
	IsOrganizationTrail *bool `type:"boolean"`

	// Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail.
	// The value can be an alias name prefixed by "alias/", a fully specified ARN
	// to an alias, a fully specified ARN to a key, or a globally unique identifier.
	//
	// CloudTrail also supports KMS multi-Region keys. For more information about
	// multi-Region keys, see Using multi-Region keys (https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
	// in the Key Management Service Developer Guide.
	//
	// Examples:
	//
	//    * alias/MyAliasName
	//
	//    * arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
	//
	//    * arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//    * 12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies the name of the trail or trail ARN. If Name is a trail name, the
	// string must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-)
	//
	//    * Start with a letter or number, and end with a letter or number
	//
	//    * Be between 3 and 128 characters
	//
	//    * Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//    and my--namespace are not valid.
	//
	//    * Not be in IP address format (for example, 192.168.5.4)
	//
	// If Name is a trail ARN, it must be in the following format.
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Specifies the name of the Amazon S3 bucket designated for publishing log
	// files. See Amazon S3 Bucket Naming Requirements (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html).
	S3BucketName *string `type:"string"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
	// The maximum length is 200 characters.
	S3KeyPrefix *string `type:"string"`

	// Specifies the name of the Amazon SNS topic defined for notification of log
	// file delivery. The maximum length is 256 characters.
	SnsTopicName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTrailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTrailInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *UpdateTrailInput) SetCloudWatchLogsLogGroupArn(v string) *UpdateTrailInput {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *UpdateTrailInput) SetCloudWatchLogsRoleArn(v string) *UpdateTrailInput {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetEnableLogFileValidation sets the EnableLogFileValidation field's value.
func (s *UpdateTrailInput) SetEnableLogFileValidation(v bool) *UpdateTrailInput {
	s.EnableLogFileValidation = &v
	return s
}

// SetIncludeGlobalServiceEvents sets the IncludeGlobalServiceEvents field's value.
func (s *UpdateTrailInput) SetIncludeGlobalServiceEvents(v bool) *UpdateTrailInput {
	s.IncludeGlobalServiceEvents = &v
	return s
}

// SetIsMultiRegionTrail sets the IsMultiRegionTrail field's value.
func (s *UpdateTrailInput) SetIsMultiRegionTrail(v bool) *UpdateTrailInput {
	s.IsMultiRegionTrail = &v
	return s
}

// SetIsOrganizationTrail sets the IsOrganizationTrail field's value.
func (s *UpdateTrailInput) SetIsOrganizationTrail(v bool) *UpdateTrailInput {
	s.IsOrganizationTrail = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateTrailInput) SetKmsKeyId(v string) *UpdateTrailInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateTrailInput) SetName(v string) *UpdateTrailInput {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *UpdateTrailInput) SetS3BucketName(v string) *UpdateTrailInput {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *UpdateTrailInput) SetS3KeyPrefix(v string) *UpdateTrailInput {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicName sets the SnsTopicName field's value.
func (s *UpdateTrailInput) SetSnsTopicName(v string) *UpdateTrailInput {
	s.SnsTopicName = &v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type UpdateTrailOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail
	// logs are delivered.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies whether the trail is publishing events from global services such
	// as IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail exists in one region or in all regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies whether the trail is an organization trail.
	IsOrganizationTrail *bool `type:"boolean"`

	// Specifies the KMS key ID that encrypts the logs delivered by CloudTrail.
	// The value is a fully specified ARN to a KMS key in the following format.
	//
	// arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies whether log file integrity validation is enabled.
	LogFileValidationEnabled *bool `type:"boolean"`

	// Specifies the name of the trail.
	Name *string `type:"string"`

	// Specifies the name of the Amazon S3 bucket designated for publishing log
	// files.
	S3BucketName *string `type:"string"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your IAM Log Files (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
	S3KeyPrefix *string `type:"string"`

	// Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications
	// when log files are delivered. The following is the format of a topic ARN.
	//
	// arn:aws:sns:us-east-2:123456789012:MyTopic
	SnsTopicARN *string `type:"string"`

	// This field is no longer in use. Use UpdateTrailResponse$SnsTopicARN.
	//
	// Deprecated: SnsTopicName has been deprecated
	SnsTopicName *string `deprecated:"true" type:"string"`

	// Specifies the ARN of the trail that was updated. The following is the format
	// of a trail ARN.
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	TrailARN *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrailOutput) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *UpdateTrailOutput) SetCloudWatchLogsLogGroupArn(v string) *UpdateTrailOutput {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *UpdateTrailOutput) SetCloudWatchLogsRoleArn(v string) *UpdateTrailOutput {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetIncludeGlobalServiceEvents sets the IncludeGlobalServiceEvents field's value.
func (s *UpdateTrailOutput) SetIncludeGlobalServiceEvents(v bool) *UpdateTrailOutput {
	s.IncludeGlobalServiceEvents = &v
	return s
}

// SetIsMultiRegionTrail sets the IsMultiRegionTrail field's value.
func (s *UpdateTrailOutput) SetIsMultiRegionTrail(v bool) *UpdateTrailOutput {
	s.IsMultiRegionTrail = &v
	return s
}

// SetIsOrganizationTrail sets the IsOrganizationTrail field's value.
func (s *UpdateTrailOutput) SetIsOrganizationTrail(v bool) *UpdateTrailOutput {
	s.IsOrganizationTrail = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateTrailOutput) SetKmsKeyId(v string) *UpdateTrailOutput {
	s.KmsKeyId = &v
	return s
}

// SetLogFileValidationEnabled sets the LogFileValidationEnabled field's value.
func (s *UpdateTrailOutput) SetLogFileValidationEnabled(v bool) *UpdateTrailOutput {
	s.LogFileValidationEnabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateTrailOutput) SetName(v string) *UpdateTrailOutput {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *UpdateTrailOutput) SetS3BucketName(v string) *UpdateTrailOutput {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *UpdateTrailOutput) SetS3KeyPrefix(v string) *UpdateTrailOutput {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicARN sets the SnsTopicARN field's value.
func (s *UpdateTrailOutput) SetSnsTopicARN(v string) *UpdateTrailOutput {
	s.SnsTopicARN = &v
	return s
}

// SetSnsTopicName sets the SnsTopicName field's value.
func (s *UpdateTrailOutput) SetSnsTopicName(v string) *UpdateTrailOutput {
	s.SnsTopicName = &v
	return s
}

// SetTrailARN sets the TrailARN field's value.
func (s *UpdateTrailOutput) SetTrailARN(v string) *UpdateTrailOutput {
	s.TrailARN = &v
	return s
}

const (
	// EventCategoryInsight is a EventCategory enum value
	EventCategoryInsight = "insight"
)

// EventCategory_Values returns all elements of the EventCategory enum
func EventCategory_Values() []string {
	return []string{
		EventCategoryInsight,
	}
}

const (
	// InsightTypeApiCallRateInsight is a InsightType enum value
	InsightTypeApiCallRateInsight = "ApiCallRateInsight"

	// InsightTypeApiErrorRateInsight is a InsightType enum value
	InsightTypeApiErrorRateInsight = "ApiErrorRateInsight"
)

// InsightType_Values returns all elements of the InsightType enum
func InsightType_Values() []string {
	return []string{
		InsightTypeApiCallRateInsight,
		InsightTypeApiErrorRateInsight,
	}
}

const (
	// LookupAttributeKeyEventId is a LookupAttributeKey enum value
	LookupAttributeKeyEventId = "EventId"

	// LookupAttributeKeyEventName is a LookupAttributeKey enum value
	LookupAttributeKeyEventName = "EventName"

	// LookupAttributeKeyReadOnly is a LookupAttributeKey enum value
	LookupAttributeKeyReadOnly = "ReadOnly"

	// LookupAttributeKeyUsername is a LookupAttributeKey enum value
	LookupAttributeKeyUsername = "Username"

	// LookupAttributeKeyResourceType is a LookupAttributeKey enum value
	LookupAttributeKeyResourceType = "ResourceType"

	// LookupAttributeKeyResourceName is a LookupAttributeKey enum value
	LookupAttributeKeyResourceName = "ResourceName"

	// LookupAttributeKeyEventSource is a LookupAttributeKey enum value
	LookupAttributeKeyEventSource = "EventSource"

	// LookupAttributeKeyAccessKeyId is a LookupAttributeKey enum value
	LookupAttributeKeyAccessKeyId = "AccessKeyId"
)

// LookupAttributeKey_Values returns all elements of the LookupAttributeKey enum
func LookupAttributeKey_Values() []string {
	return []string{
		LookupAttributeKeyEventId,
		LookupAttributeKeyEventName,
		LookupAttributeKeyReadOnly,
		LookupAttributeKeyUsername,
		LookupAttributeKeyResourceType,
		LookupAttributeKeyResourceName,
		LookupAttributeKeyEventSource,
		LookupAttributeKeyAccessKeyId,
	}
}

const (
	// ReadWriteTypeReadOnly is a ReadWriteType enum value
	ReadWriteTypeReadOnly = "ReadOnly"

	// ReadWriteTypeWriteOnly is a ReadWriteType enum value
	ReadWriteTypeWriteOnly = "WriteOnly"

	// ReadWriteTypeAll is a ReadWriteType enum value
	ReadWriteTypeAll = "All"
)

// ReadWriteType_Values returns all elements of the ReadWriteType enum
func ReadWriteType_Values() []string {
	return []string{
		ReadWriteTypeReadOnly,
		ReadWriteTypeWriteOnly,
		ReadWriteTypeAll,
	}
}
