/**
 *    Copyright (C) 2019-present MongoDB, Inc.
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the Server Side Public License, version 1,
 *    as published by MongoDB, Inc.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    Server Side Public License for more details.
 *
 *    You should have received a copy of the Server Side Public License
 *    along with this program. If not, see
 *    <http://www.mongodb.com/licensing/server-side-public-license>.
 *
 *    As a special exception, the copyright holders give permission to link the
 *    code of portions of this program with the OpenSSL library under certain
 *    conditions as described in each individual source file and distribute
 *    linked combinations including the program with the OpenSSL library. You
 *    must comply with the Server Side Public License in all respects for
 *    all of the code used other than as permitted herein. If you modify file(s)
 *    with this exception, you may extend this exception to your version of the
 *    file(s), but you are not obligated to do so. If you do not wish to do so,
 *    delete this exception statement from your version. If you delete this
 *    exception statement from all source files in the program, then also delete
 *    it in the license file.
 */

#pragma once

#include <memory>

#include <boost/smart_ptr/intrusive_ptr.hpp>

#include "mongo/bson/bsonobj.h"
#include "mongo/db/matcher/expression.h"
#include "mongo/db/pipeline/expression_context.h"
#include "mongo/db/pipeline/field_path.h"
#include "mongo/db/query/projection.h"
#include "mongo/db/query/projection_ast.h"
#include "mongo/db/query/projection_policies.h"

namespace mongo {
namespace projection_ast {

/**
 * Turns a BSON-representation of a projection into a walkable tree.
 *
 * 'query' and 'queryObj' refer to the associated filter provided in a find() command.
 */
Projection parseAndAnalyze(boost::intrusive_ptr<ExpressionContext> expCtx,
                           const BSONObj& obj,
                           const MatchExpression* query,
                           const BSONObj& queryObj,
                           ProjectionPolicies policies,
                           bool shouldOptimize = false);

/**
 * Overload of parse() to be used when not parsing a projection from a find() command.
 */
Projection parseAndAnalyze(boost::intrusive_ptr<ExpressionContext> expCtx,
                           const BSONObj& obj,
                           ProjectionPolicies policies,
                           bool shouldOptimize = false);

/**
 * Adds a node to the projection AST rooted at 'root' to the path specified by 'path'.
 */
void addNodeAtPath(ProjectionPathASTNode* root,
                   const FieldPath& path,
                   std::unique_ptr<ASTNode> newChild);

}  // namespace projection_ast
}  // namespace mongo
