/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef jit_LIROpsGenerated_h
#define jit_LIROpsGenerated_h

/* This file is generated by jit/GenerateLIRFiles.py. Do not edit! */

#define LIR_OPCODE_LIST(_)\
_(Phi)\
_(Box)\
_(OsiPoint)\
_(MoveGroup)\
_(Integer)\
_(Integer64)\
_(Pointer)\
_(Double)\
_(Float32)\
_(Value)\
_(NurseryObject)\
_(Parameter)\
_(Callee)\
_(IsConstructing)\
_(Goto)\
_(NewArray)\
_(NewArrayDynamicLength)\
_(NewIterator)\
_(NewTypedArray)\
_(NewTypedArrayDynamicLength)\
_(NewTypedArrayFromArray)\
_(NewTypedArrayFromArrayBuffer)\
_(BindFunction)\
_(NewBoundFunction)\
_(NewObject)\
_(NewPlainObject)\
_(NewArrayObject)\
_(NewNamedLambdaObject)\
_(NewCallObject)\
_(NewStringObject)\
_(InitElemGetterSetter)\
_(MutateProto)\
_(InitPropGetterSetter)\
_(CheckOverRecursed)\
_(WasmTrap)\
_(WasmTrapIfNull)\
_(WasmGcObjectIsSubtypeOfConcrete)\
_(WasmGcObjectIsSubtypeOfAbstract)\
_(WasmGcObjectIsSubtypeOfConcreteAndBranch)\
_(WasmGcObjectIsSubtypeOfAbstractAndBranch)\
_(WasmReinterpret)\
_(WasmReinterpretFromI64)\
_(WasmReinterpretToI64)\
_(Rotate)\
_(RotateI64)\
_(InterruptCheck)\
_(WasmInterruptCheck)\
_(TypeOfV)\
_(TypeOfO)\
_(TypeOfName)\
_(TypeOfIsNonPrimitiveV)\
_(TypeOfIsNonPrimitiveO)\
_(TypeOfIsPrimitive)\
_(ToAsyncIter)\
_(ToPropertyKeyCache)\
_(CreateThis)\
_(CreateArgumentsObject)\
_(CreateInlinedArgumentsObject)\
_(GetInlinedArgument)\
_(GetInlinedArgumentHole)\
_(GetArgumentsObjectArg)\
_(SetArgumentsObjectArg)\
_(LoadArgumentsObjectArg)\
_(LoadArgumentsObjectArgHole)\
_(InArgumentsObjectArg)\
_(ArgumentsObjectLength)\
_(ArrayFromArgumentsObject)\
_(GuardArgumentsObjectFlags)\
_(BoundFunctionNumArgs)\
_(GuardBoundFunctionIsConstructor)\
_(ReturnFromCtor)\
_(BoxNonStrictThis)\
_(ImplicitThis)\
_(StackArgT)\
_(StackArgV)\
_(CallGeneric)\
_(CallKnown)\
_(CallNative)\
_(CallDOMNative)\
_(CallClassHook)\
_(Bail)\
_(Unreachable)\
_(EncodeSnapshot)\
_(UnreachableResultV)\
_(UnreachableResultT)\
_(GetDOMProperty)\
_(GetDOMMemberV)\
_(GetDOMMemberT)\
_(SetDOMProperty)\
_(LoadDOMExpandoValue)\
_(LoadDOMExpandoValueGuardGeneration)\
_(LoadDOMExpandoValueIgnoreGeneration)\
_(GuardDOMExpandoMissingOrGuardShape)\
_(ApplyArgsGeneric)\
_(ApplyArgsObj)\
_(ApplyArrayGeneric)\
_(ConstructArgsGeneric)\
_(ConstructArrayGeneric)\
_(TestIAndBranch)\
_(TestI64AndBranch)\
_(TestDAndBranch)\
_(TestFAndBranch)\
_(TestBIAndBranch)\
_(TestOAndBranch)\
_(TestVAndBranch)\
_(Compare)\
_(CompareI64)\
_(CompareI64AndBranch)\
_(CompareAndBranch)\
_(CompareD)\
_(CompareF)\
_(CompareDAndBranch)\
_(CompareFAndBranch)\
_(CompareS)\
_(CompareSInline)\
_(CompareBigInt)\
_(CompareBigIntInt32)\
_(CompareBigIntDouble)\
_(CompareBigIntString)\
_(BitAndAndBranch)\
_(IsNullOrLikeUndefinedV)\
_(IsNullOrLikeUndefinedT)\
_(IsNull)\
_(IsUndefined)\
_(IsNullOrLikeUndefinedAndBranchV)\
_(IsNullOrLikeUndefinedAndBranchT)\
_(IsNullAndBranch)\
_(IsUndefinedAndBranch)\
_(SameValueDouble)\
_(SameValue)\
_(NotI)\
_(NotI64)\
_(NotD)\
_(NotF)\
_(NotBI)\
_(NotO)\
_(NotV)\
_(BitNotI)\
_(BitNotI64)\
_(BitOpI)\
_(BitOpI64)\
_(ShiftI)\
_(ShiftI64)\
_(SignExtendInt32)\
_(SignExtendInt64)\
_(UrshD)\
_(Return)\
_(Throw)\
_(MinMaxI)\
_(MinMaxD)\
_(MinMaxF)\
_(MinMaxArrayI)\
_(MinMaxArrayD)\
_(NegI)\
_(NegI64)\
_(NegD)\
_(NegF)\
_(AbsI)\
_(AbsD)\
_(AbsF)\
_(CopySignD)\
_(CopySignF)\
_(ClzI)\
_(ClzI64)\
_(CtzI)\
_(CtzI64)\
_(PopcntI)\
_(PopcntI64)\
_(SqrtD)\
_(SqrtF)\
_(Atan2D)\
_(Hypot)\
_(PowI)\
_(PowII)\
_(PowD)\
_(PowOfTwoI)\
_(SignI)\
_(SignD)\
_(SignDI)\
_(MathFunctionD)\
_(MathFunctionF)\
_(AddI)\
_(AddI64)\
_(SubI)\
_(SubI64)\
_(MulI64)\
_(MathD)\
_(MathF)\
_(ModD)\
_(ModPowTwoD)\
_(WasmBuiltinModD)\
_(BigIntAdd)\
_(BigIntSub)\
_(BigIntMul)\
_(BigIntDiv)\
_(BigIntMod)\
_(BigIntPow)\
_(BigIntBitAnd)\
_(BigIntBitOr)\
_(BigIntBitXor)\
_(BigIntLsh)\
_(BigIntRsh)\
_(BigIntIncrement)\
_(BigIntDecrement)\
_(BigIntNegate)\
_(BigIntBitNot)\
_(Int32ToStringWithBase)\
_(NumberParseInt)\
_(DoubleParseInt)\
_(Concat)\
_(LinearizeForCharAccess)\
_(CharCodeAt)\
_(CharCodeAtMaybeOutOfBounds)\
_(CharAtMaybeOutOfBounds)\
_(FromCharCode)\
_(FromCodePoint)\
_(StringIndexOf)\
_(StringStartsWith)\
_(StringStartsWithInline)\
_(StringEndsWith)\
_(StringEndsWithInline)\
_(StringToLowerCase)\
_(StringToUpperCase)\
_(StringSplit)\
_(Substr)\
_(Int32ToDouble)\
_(Float32ToDouble)\
_(DoubleToFloat32)\
_(Int32ToFloat32)\
_(ValueToDouble)\
_(ValueToFloat32)\
_(ValueToInt32)\
_(ValueToBigInt)\
_(DoubleToInt32)\
_(Float32ToInt32)\
_(TruncateDToInt32)\
_(WasmBuiltinTruncateDToInt32)\
_(TruncateFToInt32)\
_(WasmBuiltinTruncateFToInt32)\
_(WasmTruncateToInt32)\
_(WrapInt64ToInt32)\
_(ExtendInt32ToInt64)\
_(BooleanToString)\
_(IntToString)\
_(DoubleToString)\
_(ValueToString)\
_(PowHalfD)\
_(NaNToZero)\
_(OsrEntry)\
_(OsrValue)\
_(OsrEnvironmentChain)\
_(OsrReturnValue)\
_(OsrArgumentsObject)\
_(RegExp)\
_(RegExpMatcher)\
_(RegExpSearcher)\
_(RegExpExecMatch)\
_(RegExpExecTest)\
_(RegExpPrototypeOptimizable)\
_(RegExpInstanceOptimizable)\
_(GetFirstDollarIndex)\
_(StringReplace)\
_(BinaryValueCache)\
_(BinaryBoolCache)\
_(UnaryCache)\
_(ModuleMetadata)\
_(DynamicImport)\
_(Lambda)\
_(FunctionWithProto)\
_(SetFunName)\
_(KeepAliveObject)\
_(DebugEnterGCUnsafeRegion)\
_(DebugLeaveGCUnsafeRegion)\
_(Slots)\
_(Elements)\
_(InitializedLength)\
_(SetInitializedLength)\
_(ArrayLength)\
_(SetArrayLength)\
_(FunctionLength)\
_(FunctionName)\
_(GetNextEntryForIterator)\
_(ArrayBufferByteLength)\
_(ArrayBufferViewLength)\
_(ArrayBufferViewByteOffset)\
_(ArrayBufferViewElements)\
_(TypedArrayElementSize)\
_(GuardHasAttachedArrayBuffer)\
_(GuardNumberToIntPtrIndex)\
_(BoundsCheck)\
_(BoundsCheckRange)\
_(BoundsCheckLower)\
_(SpectreMaskIndex)\
_(LoadElementV)\
_(InArray)\
_(GuardElementNotHole)\
_(LoadElementHole)\
_(StoreElementV)\
_(StoreElementT)\
_(StoreHoleValueElement)\
_(StoreElementHoleV)\
_(StoreElementHoleT)\
_(ArrayPopShift)\
_(ArrayPush)\
_(ArraySlice)\
_(ArgumentsSlice)\
_(FrameArgumentsSlice)\
_(InlineArgumentsSlice)\
_(NormalizeSliceTerm)\
_(ArrayJoin)\
_(LoadUnboxedScalar)\
_(LoadUnboxedBigInt)\
_(LoadDataViewElement)\
_(LoadTypedArrayElementHole)\
_(LoadTypedArrayElementHoleBigInt)\
_(StoreUnboxedScalar)\
_(StoreUnboxedBigInt)\
_(StoreDataViewElement)\
_(StoreTypedArrayElementHole)\
_(StoreTypedArrayElementHoleBigInt)\
_(AtomicIsLockFree)\
_(CompareExchangeTypedArrayElement)\
_(AtomicExchangeTypedArrayElement)\
_(AtomicTypedArrayElementBinop)\
_(AtomicTypedArrayElementBinopForEffect)\
_(AtomicLoad64)\
_(AtomicStore64)\
_(CompareExchangeTypedArrayElement64)\
_(AtomicExchangeTypedArrayElement64)\
_(AtomicTypedArrayElementBinop64)\
_(AtomicTypedArrayElementBinopForEffect64)\
_(EffectiveAddress)\
_(ClampIToUint8)\
_(ClampDToUint8)\
_(ClampVToUint8)\
_(LoadFixedSlotV)\
_(LoadFixedSlotT)\
_(LoadFixedSlotAndUnbox)\
_(LoadDynamicSlotAndUnbox)\
_(LoadElementAndUnbox)\
_(AddAndStoreSlot)\
_(AllocateAndStoreSlot)\
_(AddSlotAndCallAddPropHook)\
_(StoreFixedSlotV)\
_(StoreFixedSlotT)\
_(GetNameCache)\
_(CallGetIntrinsicValue)\
_(GetPropSuperCache)\
_(GetPropertyCache)\
_(BindNameCache)\
_(CallBindVar)\
_(LoadDynamicSlotV)\
_(StoreDynamicSlotV)\
_(StoreDynamicSlotT)\
_(StringLength)\
_(Floor)\
_(FloorF)\
_(Ceil)\
_(CeilF)\
_(Round)\
_(RoundF)\
_(Trunc)\
_(TruncF)\
_(NearbyInt)\
_(NearbyIntF)\
_(FunctionEnvironment)\
_(HomeObject)\
_(HomeObjectSuperBase)\
_(NewLexicalEnvironmentObject)\
_(NewClassBodyEnvironmentObject)\
_(NewVarEnvironmentObject)\
_(MegamorphicSetElement)\
_(CallDeleteProperty)\
_(CallDeleteElement)\
_(ObjectToIterator)\
_(ValueToIterator)\
_(IteratorHasIndicesAndBranch)\
_(LoadSlotByIteratorIndex)\
_(StoreSlotByIteratorIndex)\
_(SetPropertyCache)\
_(GetIteratorCache)\
_(OptimizeSpreadCallCache)\
_(IteratorMore)\
_(IsNoIterAndBranch)\
_(IteratorEnd)\
_(CloseIterCache)\
_(ArgumentsLength)\
_(GetFrameArgument)\
_(GetFrameArgumentHole)\
_(Rest)\
_(Int32ToIntPtr)\
_(NonNegativeIntPtrToInt32)\
_(IntPtrToDouble)\
_(AdjustDataViewLength)\
_(BooleanToInt64)\
_(StringToInt64)\
_(ValueToInt64)\
_(TruncateBigIntToInt64)\
_(Int64ToBigInt)\
_(PostWriteBarrierO)\
_(PostWriteBarrierS)\
_(PostWriteBarrierBI)\
_(PostWriteBarrierV)\
_(PostWriteElementBarrierO)\
_(PostWriteElementBarrierS)\
_(PostWriteElementBarrierBI)\
_(PostWriteElementBarrierV)\
_(AssertCanElidePostWriteBarrier)\
_(GuardObjectIdentity)\
_(GuardSpecificFunction)\
_(GuardSpecificAtom)\
_(GuardSpecificSymbol)\
_(GuardSpecificInt32)\
_(GuardStringToIndex)\
_(GuardStringToInt32)\
_(GuardStringToDouble)\
_(GuardShape)\
_(GuardMultipleShapes)\
_(GuardProto)\
_(GuardNullProto)\
_(GuardIsNativeObject)\
_(GuardGlobalGeneration)\
_(GuardIsProxy)\
_(GuardIsNotProxy)\
_(GuardIsNotDOMProxy)\
_(ProxyGet)\
_(ProxyGetByValue)\
_(ProxyHasProp)\
_(ProxySet)\
_(ProxySetByValue)\
_(CallSetArrayLength)\
_(MegamorphicLoadSlot)\
_(MegamorphicLoadSlotByValue)\
_(MegamorphicStoreSlot)\
_(MegamorphicHasProp)\
_(GuardIsNotArrayBufferMaybeShared)\
_(GuardIsTypedArray)\
_(GuardNoDenseElements)\
_(InCache)\
_(HasOwnCache)\
_(CheckPrivateFieldCache)\
_(NewPrivateName)\
_(InstanceOfO)\
_(InstanceOfV)\
_(InstanceOfCache)\
_(IsCallableO)\
_(IsCallableV)\
_(IsConstructor)\
_(IsCrossRealmArrayConstructor)\
_(IsArrayO)\
_(IsArrayV)\
_(IsTypedArray)\
_(IsObject)\
_(IsObjectAndBranch)\
_(IsNullOrUndefined)\
_(IsNullOrUndefinedAndBranch)\
_(HasClass)\
_(GuardToClass)\
_(GuardToFunction)\
_(ObjectClassToString)\
_(WasmSelect)\
_(WasmSelectI64)\
_(WasmCompareAndSelect)\
_(WasmAddOffset)\
_(WasmAddOffset64)\
_(WasmBoundsCheck)\
_(WasmBoundsCheck64)\
_(WasmExtendU32Index)\
_(WasmWrapU32Index)\
_(WasmAlignmentCheck)\
_(WasmAlignmentCheck64)\
_(WasmLoadInstance)\
_(WasmLoadInstance64)\
_(WasmHeapBase)\
_(WasmLoad)\
_(WasmLoadI64)\
_(WasmStore)\
_(WasmStoreI64)\
_(AsmJSLoadHeap)\
_(AsmJSStoreHeap)\
_(WasmCompareExchangeHeap)\
_(WasmFence)\
_(WasmAtomicExchangeHeap)\
_(WasmAtomicBinopHeap)\
_(WasmAtomicBinopHeapForEffect)\
_(WasmLoadSlot)\
_(WasmLoadSlotI64)\
_(WasmStoreSlot)\
_(WasmStoreSlotI64)\
_(WasmLoadTableElement)\
_(WasmDerivedPointer)\
_(WasmDerivedIndexPointer)\
_(WasmStoreRef)\
_(WasmPostWriteBarrier)\
_(WasmParameter)\
_(WasmParameterI64)\
_(WasmReturn)\
_(WasmReturnI64)\
_(WasmReturnVoid)\
_(WasmStackArg)\
_(WasmStackArgI64)\
_(WasmNullConstant)\
_(WasmCallIndirectAdjunctSafepoint)\
_(WasmCall)\
_(WasmCallLandingPrePad)\
_(WasmRegisterResult)\
_(WasmRegisterPairResult)\
_(WasmStackResultArea)\
_(WasmStackResult)\
_(WasmStackResult64)\
_(AssertRangeI)\
_(AssertRangeD)\
_(AssertRangeF)\
_(AssertRangeV)\
_(AssertClass)\
_(AssertShape)\
_(GuardValue)\
_(GuardNullOrUndefined)\
_(GuardIsNotObject)\
_(GuardFunctionFlags)\
_(GuardFunctionIsNonBuiltinCtor)\
_(GuardFunctionKind)\
_(GuardFunctionScript)\
_(IncrementWarmUpCounter)\
_(LexicalCheck)\
_(ThrowRuntimeLexicalError)\
_(ThrowMsg)\
_(GlobalDeclInstantiation)\
_(MemoryBarrier)\
_(Debugger)\
_(NewTarget)\
_(Random)\
_(CheckReturn)\
_(CheckIsObj)\
_(CheckObjCoercible)\
_(CheckClassHeritage)\
_(CheckThis)\
_(CheckThisReinit)\
_(Generator)\
_(AsyncResolve)\
_(AsyncAwait)\
_(CanSkipAwait)\
_(MaybeExtractAwaitValue)\
_(DebugCheckSelfHosted)\
_(IsPackedArray)\
_(GuardArrayIsPacked)\
_(GetPrototypeOf)\
_(ObjectWithProto)\
_(ObjectStaticProto)\
_(BuiltinObject)\
_(SuperFunction)\
_(InitHomeObject)\
_(IsTypedArrayConstructor)\
_(LoadValueTag)\
_(GuardTagNotEqual)\
_(LoadWrapperTarget)\
_(GuardHasGetterSetter)\
_(GuardIsExtensible)\
_(GuardInt32IsNonNegative)\
_(GuardInt32Range)\
_(GuardIndexIsNotDenseElement)\
_(GuardIndexIsValidUpdateOrAdd)\
_(CallAddOrUpdateSparseElement)\
_(CallGetSparseElement)\
_(CallNativeGetElement)\
_(CallNativeGetElementSuper)\
_(CallObjectHasSparseElement)\
_(BigIntAsIntN)\
_(BigIntAsIntN64)\
_(BigIntAsIntN32)\
_(GuardNonGCThing)\
_(ToHashableNonGCThing)\
_(ToHashableString)\
_(ToHashableValue)\
_(HashNonGCThing)\
_(HashString)\
_(HashSymbol)\
_(HashBigInt)\
_(HashObject)\
_(HashValue)\
_(SetObjectHasNonBigInt)\
_(SetObjectHasBigInt)\
_(SetObjectHasValue)\
_(SetObjectHasValueVMCall)\
_(SetObjectSize)\
_(MapObjectHasNonBigInt)\
_(MapObjectHasBigInt)\
_(MapObjectHasValue)\
_(MapObjectHasValueVMCall)\
_(MapObjectGetNonBigInt)\
_(MapObjectGetBigInt)\
_(MapObjectGetValue)\
_(MapObjectGetValueVMCall)\
_(MapObjectSize)\
_(BigIntAsUintN)\
_(BigIntAsUintN64)\
_(BigIntAsUintN32)\
_(IonToWasmCall)\
_(IonToWasmCallV)\
_(IonToWasmCallI64)\
_(WasmBoxValue)\
_(WasmAnyRefFromJSObject)\
_(Simd128)\
_(WasmTernarySimd128)\
_(WasmBinarySimd128)\
_(WasmBinarySimd128WithConstant)\
_(WasmVariableShiftSimd128)\
_(WasmConstantShiftSimd128)\
_(WasmSignReplicationSimd128)\
_(WasmShuffleSimd128)\
_(WasmPermuteSimd128)\
_(WasmReplaceLaneSimd128)\
_(WasmReplaceInt64LaneSimd128)\
_(WasmScalarToSimd128)\
_(WasmInt64ToSimd128)\
_(WasmUnarySimd128)\
_(WasmReduceSimd128)\
_(WasmReduceAndBranchSimd128)\
_(WasmReduceSimd128ToInt64)\
_(WasmLoadLaneSimd128)\
_(WasmStoreLaneSimd128)\
_(Unbox)\
_(UnboxFloatingPoint)\
_(WasmUint32ToDouble)\
_(WasmUint32ToFloat32)\
_(DivI)\
_(ModI)\
_(DivPowTwoI)\
_(ModPowTwoI)\
_(TableSwitch)\
_(TableSwitchV)\
_(MulI)

#define LIR_OPCODE_CLASS_GENERATED \
class LInteger : public LInstructionHelper<1, 0, 0> {\
  int32_t i32_;\
 public:\
  LIR_HEADER(Integer)\
  explicit LInteger(int32_t i32) : LInstructionHelper(classOpcode), i32_(i32) {\
\
  }\
  int32_t i32() const { return i32_; }\
\
};\
\
class LInteger64 : public LInstructionHelper<INT64_PIECES, 0, 0> {\
  int64_t i64_;\
 public:\
  LIR_HEADER(Integer64)\
  explicit LInteger64(int64_t i64) : LInstructionHelper(classOpcode), i64_(i64) {\
\
  }\
  int64_t i64() const { return i64_; }\
\
};\
\
class LPointer : public LInstructionHelper<1, 0, 0> {\
  gc::Cell* gcptr_;\
 public:\
  LIR_HEADER(Pointer)\
  explicit LPointer(gc::Cell* gcptr) : LInstructionHelper(classOpcode), gcptr_(gcptr) {\
\
  }\
  gc::Cell* gcptr() const { return gcptr_; }\
\
};\
\
class LDouble : public LInstructionHelper<1, 0, 0> {\
  double value_;\
 public:\
  LIR_HEADER(Double)\
  explicit LDouble(double value) : LInstructionHelper(classOpcode), value_(value) {\
\
  }\
  double value() const { return value_; }\
\
};\
\
class LFloat32 : public LInstructionHelper<1, 0, 0> {\
  float value_;\
 public:\
  LIR_HEADER(Float32)\
  explicit LFloat32(float value) : LInstructionHelper(classOpcode), value_(value) {\
\
  }\
  float value() const { return value_; }\
\
};\
\
class LNurseryObject : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(NurseryObject)\
  explicit LNurseryObject() : LInstructionHelper(classOpcode) {\
\
  }\
\
  MNurseryObject* mir() const { return mir_->toNurseryObject(); };\
};\
\
class LParameter : public LInstructionHelper<BOX_PIECES, 0, 0> {\
 public:\
  LIR_HEADER(Parameter)\
  explicit LParameter() : LInstructionHelper(classOpcode) {\
\
  }\
\
};\
\
class LCallee : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(Callee)\
  explicit LCallee() : LInstructionHelper(classOpcode) {\
\
  }\
\
};\
\
class LIsConstructing : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(IsConstructing)\
  explicit LIsConstructing() : LInstructionHelper(classOpcode) {\
\
  }\
\
};\
\
class LNewArrayDynamicLength : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(NewArrayDynamicLength)\
  explicit LNewArrayDynamicLength(const LAllocation& length, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, length);\
    setTemp(0, temp0);\
  }\
  const LAllocation* length() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewArrayDynamicLength* mir() const { return mir_->toNewArrayDynamicLength(); };\
};\
\
class LNewIterator : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewIterator)\
  explicit LNewIterator(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewIterator* mir() const { return mir_->toNewIterator(); };\
};\
\
class LNewTypedArray : public LInstructionHelper<1, 0, 2> {\
 public:\
  LIR_HEADER(NewTypedArray)\
  explicit LNewTypedArray(const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MNewTypedArray* mir() const { return mir_->toNewTypedArray(); };\
};\
\
class LNewTypedArrayDynamicLength : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(NewTypedArrayDynamicLength)\
  explicit LNewTypedArrayDynamicLength(const LAllocation& length, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, length);\
    setTemp(0, temp0);\
  }\
  const LAllocation* length() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewTypedArrayDynamicLength* mir() const { return mir_->toNewTypedArrayDynamicLength(); };\
};\
\
class LNewTypedArrayFromArray : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NewTypedArrayFromArray)\
  explicit LNewTypedArrayFromArray(const LAllocation& array) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, array);\
  }\
  const LAllocation* array() { return getOperand(0); }\
  MNewTypedArrayFromArray* mir() const { return mir_->toNewTypedArrayFromArray(); };\
};\
\
class LNewTypedArrayFromArrayBuffer : public LInstructionHelper<1, 2 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(NewTypedArrayFromArrayBuffer)\
  explicit LNewTypedArrayFromArrayBuffer(const LAllocation& arrayBuffer, const LBoxAllocation& byteOffset, const LBoxAllocation& length) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, arrayBuffer);\
    setBoxOperand(ByteOffsetIndex, byteOffset);\
    setBoxOperand(LengthIndex, length);\
  }\
  const LAllocation* arrayBuffer() { return getOperand(0); }\
  static const size_t ByteOffsetIndex = 1;\
\
  static const size_t LengthIndex = 1 + BOX_PIECES * 1;\
  MNewTypedArrayFromArrayBuffer* mir() const { return mir_->toNewTypedArrayFromArrayBuffer(); };\
};\
\
class LBindFunction : public LInstructionHelper<1, 1, 2> {\
 public:\
  LIR_HEADER(BindFunction)\
  explicit LBindFunction(const LAllocation& target, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, target);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* target() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MBindFunction* mir() const { return mir_->toBindFunction(); };\
};\
\
class LNewBoundFunction : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewBoundFunction)\
  explicit LNewBoundFunction(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewBoundFunction* mir() const { return mir_->toNewBoundFunction(); };\
};\
\
class LNewPlainObject : public LInstructionHelper<1, 0, 3> {\
 public:\
  LIR_HEADER(NewPlainObject)\
  explicit LNewPlainObject(const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MNewPlainObject* mir() const { return mir_->toNewPlainObject(); };\
};\
\
class LNewArrayObject : public LInstructionHelper<1, 0, 2> {\
 public:\
  LIR_HEADER(NewArrayObject)\
  explicit LNewArrayObject(const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MNewArrayObject* mir() const { return mir_->toNewArrayObject(); };\
};\
\
class LNewNamedLambdaObject : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewNamedLambdaObject)\
  explicit LNewNamedLambdaObject(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewNamedLambdaObject* mir() const { return mir_->toNewNamedLambdaObject(); };\
};\
\
class LNewCallObject : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewCallObject)\
  explicit LNewCallObject(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewCallObject* mir() const { return mir_->toNewCallObject(); };\
};\
\
class LNewStringObject : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(NewStringObject)\
  explicit LNewStringObject(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewStringObject* mir() const { return mir_->toNewStringObject(); };\
};\
\
class LInitElemGetterSetter : public LInstructionHelper<0, 1 * BOX_PIECES + 2, 0> {\
 public:\
  LIR_HEADER(InitElemGetterSetter)\
  explicit LInitElemGetterSetter(const LAllocation& object, const LBoxAllocation& id, const LAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setBoxOperand(IdIndex, id);\
    setOperand(1, value);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* value() { return getOperand(1); }\
  static const size_t IdIndex = 2;\
  MInitElemGetterSetter* mir() const { return mir_->toInitElemGetterSetter(); };\
};\
\
class LMutateProto : public LInstructionHelper<0, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(MutateProto)\
  explicit LMutateProto(const LAllocation& object, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  static const size_t ValueIndex = 1;\
};\
\
class LInitPropGetterSetter : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(InitPropGetterSetter)\
  explicit LInitPropGetterSetter(const LAllocation& object, const LAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setOperand(1, value);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* value() { return getOperand(1); }\
  MInitPropGetterSetter* mir() const { return mir_->toInitPropGetterSetter(); };\
};\
\
class LCheckOverRecursed : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(CheckOverRecursed)\
  explicit LCheckOverRecursed() : LInstructionHelper(classOpcode) {\
\
  }\
\
  MCheckOverRecursed* mir() const { return mir_->toCheckOverRecursed(); };\
};\
\
class LWasmTrap : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(WasmTrap)\
  explicit LWasmTrap() : LInstructionHelper(classOpcode) {\
\
  }\
\
  MWasmTrap* mir() const { return mir_->toWasmTrap(); };\
};\
\
class LWasmTrapIfNull : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(WasmTrapIfNull)\
  explicit LWasmTrapIfNull(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  MWasmTrapIfNull* mir() const { return mir_->toWasmTrapIfNull(); };\
};\
\
class LWasmGcObjectIsSubtypeOfConcrete : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(WasmGcObjectIsSubtypeOfConcrete)\
  explicit LWasmGcObjectIsSubtypeOfConcrete(const LAllocation& object, const LAllocation& superSuperTypeVector, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, superSuperTypeVector);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* superSuperTypeVector() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MWasmGcObjectIsSubtypeOfConcrete* mir() const { return mir_->toWasmGcObjectIsSubtypeOfConcrete(); };\
};\
\
class LWasmGcObjectIsSubtypeOfAbstract : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(WasmGcObjectIsSubtypeOfAbstract)\
  explicit LWasmGcObjectIsSubtypeOfAbstract(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmGcObjectIsSubtypeOfAbstract* mir() const { return mir_->toWasmGcObjectIsSubtypeOfAbstract(); };\
};\
\
class LInterruptCheck : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(InterruptCheck)\
  explicit LInterruptCheck() : LInstructionHelper(classOpcode) {\
\
  }\
\
  MInterruptCheck* mir() const { return mir_->toInterruptCheck(); };\
};\
\
class LWasmInterruptCheck : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(WasmInterruptCheck)\
  explicit LWasmInterruptCheck(const LAllocation& instance) : LInstructionHelper(classOpcode) {\
    setOperand(0, instance);\
  }\
  const LAllocation* instance() { return getOperand(0); }\
  MWasmInterruptCheck* mir() const { return mir_->toWasmInterruptCheck(); };\
};\
\
class LTypeOfV : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(TypeOfV)\
  explicit LTypeOfV(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t InputIndex = 0;\
  MTypeOf* mir() const { return mir_->toTypeOf(); };\
};\
\
class LTypeOfO : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(TypeOfO)\
  explicit LTypeOfO(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  MTypeOf* mir() const { return mir_->toTypeOf(); };\
};\
\
class LTypeOfName : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(TypeOfName)\
  explicit LTypeOfName(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MTypeOfName* mir() const { return mir_->toTypeOfName(); };\
};\
\
class LTypeOfIsNonPrimitiveV : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(TypeOfIsNonPrimitiveV)\
  explicit LTypeOfIsNonPrimitiveV(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t InputIndex = 0;\
  MTypeOfIs* mir() const { return mir_->toTypeOfIs(); };\
};\
\
class LTypeOfIsNonPrimitiveO : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(TypeOfIsNonPrimitiveO)\
  explicit LTypeOfIsNonPrimitiveO(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MTypeOfIs* mir() const { return mir_->toTypeOfIs(); };\
};\
\
class LTypeOfIsPrimitive : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(TypeOfIsPrimitive)\
  explicit LTypeOfIsPrimitive(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
\
  static const size_t InputIndex = 0;\
  MTypeOfIs* mir() const { return mir_->toTypeOfIs(); };\
};\
\
class LToAsyncIter : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(ToAsyncIter)\
  explicit LToAsyncIter(const LAllocation& iterator, const LBoxAllocation& nextMethod) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, iterator);\
    setBoxOperand(NextMethodIndex, nextMethod);\
  }\
  const LAllocation* iterator() { return getOperand(0); }\
  static const size_t NextMethodIndex = 1;\
};\
\
class LToPropertyKeyCache : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(ToPropertyKeyCache)\
  explicit LToPropertyKeyCache(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
\
  static const size_t InputIndex = 0;\
  MToPropertyKeyCache* mir() const { return mir_->toToPropertyKeyCache(); };\
};\
\
class LCreateThis : public LInstructionHelper<BOX_PIECES, 2, 0> {\
 public:\
  LIR_HEADER(CreateThis)\
  explicit LCreateThis(const LAllocation& callee, const LAllocation& newTarget) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, callee);\
    setOperand(1, newTarget);\
  }\
  const LAllocation* callee() { return getOperand(0); }\
  const LAllocation* newTarget() { return getOperand(1); }\
  MCreateThis* mir() const { return mir_->toCreateThis(); };\
};\
\
class LCreateArgumentsObject : public LInstructionHelper<1, 1, 3> {\
 public:\
  LIR_HEADER(CreateArgumentsObject)\
  explicit LCreateArgumentsObject(const LAllocation& callObject, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, callObject);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* callObject() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MCreateArgumentsObject* mir() const { return mir_->toCreateArgumentsObject(); };\
};\
\
class LGetArgumentsObjectArg : public LInstructionHelper<BOX_PIECES, 1, 1> {\
 public:\
  LIR_HEADER(GetArgumentsObjectArg)\
  explicit LGetArgumentsObjectArg(const LAllocation& argsObject, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, argsObject);\
    setTemp(0, temp0);\
  }\
  const LAllocation* argsObject() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGetArgumentsObjectArg* mir() const { return mir_->toGetArgumentsObjectArg(); };\
};\
\
class LSetArgumentsObjectArg : public LInstructionHelper<0, 1 * BOX_PIECES + 1, 1> {\
 public:\
  LIR_HEADER(SetArgumentsObjectArg)\
  explicit LSetArgumentsObjectArg(const LAllocation& argsObject, const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, argsObject);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* argsObject() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t ValueIndex = 1;\
  MSetArgumentsObjectArg* mir() const { return mir_->toSetArgumentsObjectArg(); };\
};\
\
class LLoadArgumentsObjectArg : public LInstructionHelper<BOX_PIECES, 2, 1> {\
 public:\
  LIR_HEADER(LoadArgumentsObjectArg)\
  explicit LLoadArgumentsObjectArg(const LAllocation& argsObject, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, argsObject);\
    setOperand(1, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* argsObject() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LLoadArgumentsObjectArgHole : public LInstructionHelper<BOX_PIECES, 2, 1> {\
 public:\
  LIR_HEADER(LoadArgumentsObjectArgHole)\
  explicit LLoadArgumentsObjectArgHole(const LAllocation& argsObject, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, argsObject);\
    setOperand(1, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* argsObject() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LInArgumentsObjectArg : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(InArgumentsObjectArg)\
  explicit LInArgumentsObjectArg(const LAllocation& argsObject, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, argsObject);\
    setOperand(1, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* argsObject() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LArgumentsObjectLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArgumentsObjectLength)\
  explicit LArgumentsObjectLength(const LAllocation& argsObject) : LInstructionHelper(classOpcode) {\
    setOperand(0, argsObject);\
  }\
  const LAllocation* argsObject() { return getOperand(0); }\
};\
\
class LArrayFromArgumentsObject : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArrayFromArgumentsObject)\
  explicit LArrayFromArgumentsObject(const LAllocation& argsObject) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, argsObject);\
  }\
  const LAllocation* argsObject() { return getOperand(0); }\
  MArrayFromArgumentsObject* mir() const { return mir_->toArrayFromArgumentsObject(); };\
};\
\
class LGuardArgumentsObjectFlags : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardArgumentsObjectFlags)\
  explicit LGuardArgumentsObjectFlags(const LAllocation& argsObject, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, argsObject);\
    setTemp(0, temp0);\
  }\
  const LAllocation* argsObject() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardArgumentsObjectFlags* mir() const { return mir_->toGuardArgumentsObjectFlags(); };\
};\
\
class LBoundFunctionNumArgs : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(BoundFunctionNumArgs)\
  explicit LBoundFunctionNumArgs(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
};\
\
class LGuardBoundFunctionIsConstructor : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardBoundFunctionIsConstructor)\
  explicit LGuardBoundFunctionIsConstructor(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
};\
\
class LReturnFromCtor : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(ReturnFromCtor)\
  explicit LReturnFromCtor(const LBoxAllocation& value, const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  static const size_t ValueIndex = 1;\
};\
\
class LBoxNonStrictThis : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(BoxNonStrictThis)\
  explicit LBoxNonStrictThis(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
\
  static const size_t ValueIndex = 0;\
  MBoxNonStrictThis* mir() const { return mir_->toBoxNonStrictThis(); };\
};\
\
class LImplicitThis : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(ImplicitThis)\
  explicit LImplicitThis(const LAllocation& env) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, env);\
  }\
  const LAllocation* env() { return getOperand(0); }\
  MImplicitThis* mir() const { return mir_->toImplicitThis(); };\
};\
\
class LStackArgT : public LInstructionHelper<0, 1, 0> {\
  uint32_t argslot_;\
  MIRType type_;\
 public:\
  LIR_HEADER(StackArgT)\
  explicit LStackArgT(const LAllocation& arg, uint32_t argslot, MIRType type) : LInstructionHelper(classOpcode), argslot_(argslot), type_(type) {\
    setOperand(0, arg);\
  }\
  const LAllocation* arg() { return getOperand(0); }  uint32_t argslot() const { return argslot_; }\
  MIRType type() const { return type_; }\
\
};\
\
class LStackArgV : public LInstructionHelper<0, 1 * BOX_PIECES + 0, 0> {\
  uint32_t argslot_;\
 public:\
  LIR_HEADER(StackArgV)\
  explicit LStackArgV(const LBoxAllocation& value, uint32_t argslot) : LInstructionHelper(classOpcode), argslot_(argslot) {\
    setBoxOperand(ValueIndex, value);\
  }\
  uint32_t argslot() const { return argslot_; }\
\
  static const size_t ValueIndex = 0;\
};\
\
class LBail : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(Bail)\
  explicit LBail() : LInstructionHelper(classOpcode) {\
\
  }\
\
};\
\
class LEncodeSnapshot : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(EncodeSnapshot)\
  explicit LEncodeSnapshot() : LInstructionHelper(classOpcode) {\
\
  }\
\
};\
\
class LUnreachableResultT : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(UnreachableResultT)\
  explicit LUnreachableResultT() : LInstructionHelper(classOpcode) {\
\
  }\
\
};\
\
class LGetDOMMemberT : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(GetDOMMemberT)\
  explicit LGetDOMMemberT(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  MGetDOMMember* mir() const { return mir_->toGetDOMMember(); };\
};\
\
class LLoadDOMExpandoValue : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(LoadDOMExpandoValue)\
  explicit LLoadDOMExpandoValue(const LAllocation& proxy) : LInstructionHelper(classOpcode) {\
    setOperand(0, proxy);\
  }\
  const LAllocation* proxy() { return getOperand(0); }\
  MLoadDOMExpandoValue* mir() const { return mir_->toLoadDOMExpandoValue(); };\
};\
\
class LLoadDOMExpandoValueGuardGeneration : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(LoadDOMExpandoValueGuardGeneration)\
  explicit LLoadDOMExpandoValueGuardGeneration(const LAllocation& proxy) : LInstructionHelper(classOpcode) {\
    setOperand(0, proxy);\
  }\
  const LAllocation* proxy() { return getOperand(0); }\
  MLoadDOMExpandoValueGuardGeneration* mir() const { return mir_->toLoadDOMExpandoValueGuardGeneration(); };\
};\
\
class LLoadDOMExpandoValueIgnoreGeneration : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(LoadDOMExpandoValueIgnoreGeneration)\
  explicit LLoadDOMExpandoValueIgnoreGeneration(const LAllocation& proxy) : LInstructionHelper(classOpcode) {\
    setOperand(0, proxy);\
  }\
  const LAllocation* proxy() { return getOperand(0); }\
  MLoadDOMExpandoValueIgnoreGeneration* mir() const { return mir_->toLoadDOMExpandoValueIgnoreGeneration(); };\
};\
\
class LGuardDOMExpandoMissingOrGuardShape : public LInstructionHelper<0, 1 * BOX_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(GuardDOMExpandoMissingOrGuardShape)\
  explicit LGuardDOMExpandoMissingOrGuardShape(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t InputIndex = 0;\
  MGuardDOMExpandoMissingOrGuardShape* mir() const { return mir_->toGuardDOMExpandoMissingOrGuardShape(); };\
};\
\
class LCompareD : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(CompareD)\
  explicit LCompareD(const LAllocation& left, const LAllocation& right) : LInstructionHelper(classOpcode) {\
    setOperand(0, left);\
    setOperand(1, right);\
  }\
  const LAllocation* left() { return getOperand(0); }\
  const LAllocation* right() { return getOperand(1); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
\
class LCompareF : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(CompareF)\
  explicit LCompareF(const LAllocation& left, const LAllocation& right) : LInstructionHelper(classOpcode) {\
    setOperand(0, left);\
    setOperand(1, right);\
  }\
  const LAllocation* left() { return getOperand(0); }\
  const LAllocation* right() { return getOperand(1); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
\
class LCompareS : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(CompareS)\
  explicit LCompareS(const LAllocation& left, const LAllocation& right) : LInstructionHelper(classOpcode) {\
    setOperand(0, left);\
    setOperand(1, right);\
  }\
  const LAllocation* left() { return getOperand(0); }\
  const LAllocation* right() { return getOperand(1); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
\
class LCompareSInline : public LInstructionHelper<1, 1, 0> {\
  JSLinearString* constant_;\
 public:\
  LIR_HEADER(CompareSInline)\
  explicit LCompareSInline(const LAllocation& input, JSLinearString* constant) : LInstructionHelper(classOpcode), constant_(constant) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }  JSLinearString* constant() const { return constant_; }\
\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
\
class LCompareBigInt : public LInstructionHelper<1, 2, 3> {\
 public:\
  LIR_HEADER(CompareBigInt)\
  explicit LCompareBigInt(const LAllocation& left, const LAllocation& right, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(0, left);\
    setOperand(1, right);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* left() { return getOperand(0); }\
  const LAllocation* right() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
\
class LCompareBigIntInt32 : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(CompareBigIntInt32)\
  explicit LCompareBigIntInt32(const LAllocation& left, const LAllocation& right, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, left);\
    setOperand(1, right);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* left() { return getOperand(0); }\
  const LAllocation* right() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
\
class LCompareBigIntDouble : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(CompareBigIntDouble)\
  explicit LCompareBigIntDouble(const LAllocation& left, const LAllocation& right) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, left);\
    setOperand(1, right);\
  }\
  const LAllocation* left() { return getOperand(0); }\
  const LAllocation* right() { return getOperand(1); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
\
class LCompareBigIntString : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(CompareBigIntString)\
  explicit LCompareBigIntString(const LAllocation& left, const LAllocation& right) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, left);\
    setOperand(1, right);\
  }\
  const LAllocation* left() { return getOperand(0); }\
  const LAllocation* right() { return getOperand(1); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
\
class LIsNullOrLikeUndefinedV : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(IsNullOrLikeUndefinedV)\
  explicit LIsNullOrLikeUndefinedV(const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t ValueIndex = 0;\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
\
class LIsNullOrLikeUndefinedT : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsNullOrLikeUndefinedT)\
  explicit LIsNullOrLikeUndefinedT(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
\
class LIsNull : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(IsNull)\
  explicit LIsNull(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
\
  static const size_t ValueIndex = 0;\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
\
class LIsUndefined : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(IsUndefined)\
  explicit LIsUndefined(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
\
  static const size_t ValueIndex = 0;\
  MCompare* mir() const { return mir_->toCompare(); };\
};\
\
class LSameValueDouble : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(SameValueDouble)\
  explicit LSameValueDouble(const LAllocation& left, const LAllocation& right, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, left);\
    setOperand(1, right);\
    setTemp(0, temp0);\
  }\
  const LAllocation* left() { return getOperand(0); }\
  const LAllocation* right() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LSameValue : public LInstructionHelper<1, 2 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(SameValue)\
  explicit LSameValue(const LBoxAllocation& lhs, const LBoxAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setBoxOperand(LhsIndex, lhs);\
    setBoxOperand(RhsIndex, rhs);\
  }\
\
  static const size_t LhsIndex = 0;\
\
  static const size_t RhsIndex = 0 + BOX_PIECES * 1;\
};\
\
class LNotI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NotI)\
  explicit LNotI(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
};\
\
class LNotI64 : public LInstructionHelper<1, 1 * INT64_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(NotI64)\
  explicit LNotI64(const LInt64Allocation& inputI64) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputI64Index, inputI64);\
  }\
  const LInt64Allocation inputI64() { return getInt64Operand(InputI64Index); }\
  static const size_t InputI64Index = 0;\
};\
\
class LNotD : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NotD)\
  explicit LNotD(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MNot* mir() const { return mir_->toNot(); };\
};\
\
class LNotF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NotF)\
  explicit LNotF(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MNot* mir() const { return mir_->toNot(); };\
};\
\
class LNotBI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NotBI)\
  explicit LNotBI(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MNot* mir() const { return mir_->toNot(); };\
};\
\
class LNotO : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NotO)\
  explicit LNotO(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MNot* mir() const { return mir_->toNot(); };\
};\
\
class LNotV : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 2> {\
 public:\
  LIR_HEADER(NotV)\
  explicit LNotV(const LBoxAllocation& input, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  static const size_t InputIndex = 0;\
  MNot* mir() const { return mir_->toNot(); };\
};\
\
class LSignExtendInt32 : public LInstructionHelper<1, 1, 0> {\
  MSignExtendInt32::Mode mode_;\
 public:\
  LIR_HEADER(SignExtendInt32)\
  explicit LSignExtendInt32(const LAllocation& num, MSignExtendInt32::Mode mode) : LInstructionHelper(classOpcode), mode_(mode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }  MSignExtendInt32::Mode mode() const { return mode_; }\
\
};\
\
class LThrow : public LInstructionHelper<0, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(Throw)\
  explicit LThrow(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
  }\
\
  static const size_t ValueIndex = 0;\
};\
\
class LNegI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NegI)\
  explicit LNegI(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LNegI64 : public LInstructionHelper<INT64_PIECES, 1 * INT64_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(NegI64)\
  explicit LNegI64(const LInt64Allocation& num) : LInstructionHelper(classOpcode) {\
    setInt64Operand(NumIndex, num);\
  }\
  const LInt64Allocation num() { return getInt64Operand(NumIndex); }\
  static const size_t NumIndex = 0;\
};\
\
class LNegD : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NegD)\
  explicit LNegD(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LNegF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NegF)\
  explicit LNegF(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LAbsI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(AbsI)\
  explicit LAbsI(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
  MAbs* mir() const { return mir_->toAbs(); };\
};\
\
class LAbsD : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(AbsD)\
  explicit LAbsD(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LAbsF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(AbsF)\
  explicit LAbsF(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LClzI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ClzI)\
  explicit LClzI(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
  MClz* mir() const { return mir_->toClz(); };\
};\
\
class LClzI64 : public LInstructionHelper<INT64_PIECES, 1 * INT64_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(ClzI64)\
  explicit LClzI64(const LInt64Allocation& num) : LInstructionHelper(classOpcode) {\
    setInt64Operand(NumIndex, num);\
  }\
  const LInt64Allocation num() { return getInt64Operand(NumIndex); }\
  static const size_t NumIndex = 0;\
  MClz* mir() const { return mir_->toClz(); };\
};\
\
class LCtzI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(CtzI)\
  explicit LCtzI(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
  MCtz* mir() const { return mir_->toCtz(); };\
};\
\
class LCtzI64 : public LInstructionHelper<INT64_PIECES, 1 * INT64_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(CtzI64)\
  explicit LCtzI64(const LInt64Allocation& num) : LInstructionHelper(classOpcode) {\
    setInt64Operand(NumIndex, num);\
  }\
  const LInt64Allocation num() { return getInt64Operand(NumIndex); }\
  static const size_t NumIndex = 0;\
  MCtz* mir() const { return mir_->toCtz(); };\
};\
\
class LPopcntI : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(PopcntI)\
  explicit LPopcntI(const LAllocation& num, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
    setTemp(0, temp0);\
  }\
  const LAllocation* num() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPopcnt* mir() const { return mir_->toPopcnt(); };\
};\
\
class LPopcntI64 : public LInstructionHelper<INT64_PIECES, 1 * INT64_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(PopcntI64)\
  explicit LPopcntI64(const LInt64Allocation& num, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setInt64Operand(NumIndex, num);\
    setTemp(0, temp0);\
  }\
  const LInt64Allocation num() { return getInt64Operand(NumIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t NumIndex = 0;\
  MPopcnt* mir() const { return mir_->toPopcnt(); };\
};\
\
class LSqrtD : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SqrtD)\
  explicit LSqrtD(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LSqrtF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SqrtF)\
  explicit LSqrtF(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LPowI : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(PowI)\
  explicit LPowI(const LAllocation& value, const LAllocation& power) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, value);\
    setOperand(1, power);\
  }\
  const LAllocation* value() { return getOperand(0); }\
  const LAllocation* power() { return getOperand(1); }\
};\
\
class LPowII : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(PowII)\
  explicit LPowII(const LAllocation& value, const LAllocation& power, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, value);\
    setOperand(1, power);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* value() { return getOperand(0); }\
  const LAllocation* power() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MPow* mir() const { return mir_->toPow(); };\
};\
\
class LPowD : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(PowD)\
  explicit LPowD(const LAllocation& value, const LAllocation& power) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, value);\
    setOperand(1, power);\
  }\
  const LAllocation* value() { return getOperand(0); }\
  const LAllocation* power() { return getOperand(1); }\
};\
\
class LPowOfTwoI : public LInstructionHelper<1, 1, 0> {\
  uint32_t base_;\
 public:\
  LIR_HEADER(PowOfTwoI)\
  explicit LPowOfTwoI(const LAllocation& power, uint32_t base) : LInstructionHelper(classOpcode), base_(base) {\
    setOperand(0, power);\
  }\
  const LAllocation* power() { return getOperand(0); }  uint32_t base() const { return base_; }\
\
};\
\
class LSignI : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SignI)\
  explicit LSignI(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LSignD : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SignD)\
  explicit LSignD(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LSignDI : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(SignDI)\
  explicit LSignDI(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LWasmBuiltinModD : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(WasmBuiltinModD)\
  explicit LWasmBuiltinModD(const LAllocation& lhs, const LAllocation& rhs, const LAllocation& instance) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, lhs);\
    setOperand(1, rhs);\
    setOperand(2, instance);\
  }\
  const LAllocation* lhs() { return getOperand(0); }\
  const LAllocation* rhs() { return getOperand(1); }\
  const LAllocation* instance() { return getOperand(2); }\
  MWasmBuiltinModD* mir() const { return mir_->toWasmBuiltinModD(); };\
};\
\
class LInt32ToStringWithBase : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(Int32ToStringWithBase)\
  explicit LInt32ToStringWithBase(const LAllocation& input, const LAllocation& base, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
    setOperand(1, base);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  const LAllocation* base() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MInt32ToStringWithBase* mir() const { return mir_->toInt32ToStringWithBase(); };\
};\
\
class LNumberParseInt : public LInstructionHelper<BOX_PIECES, 2, 1> {\
 public:\
  LIR_HEADER(NumberParseInt)\
  explicit LNumberParseInt(const LAllocation& string, const LAllocation& radix, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, string);\
    setOperand(1, radix);\
    setTemp(0, temp0);\
  }\
  const LAllocation* string() { return getOperand(0); }\
  const LAllocation* radix() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNumberParseInt* mir() const { return mir_->toNumberParseInt(); };\
};\
\
class LDoubleParseInt : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(DoubleParseInt)\
  explicit LDoubleParseInt(const LAllocation& number, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, number);\
    setTemp(0, temp0);\
  }\
  const LAllocation* number() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MDoubleParseInt* mir() const { return mir_->toDoubleParseInt(); };\
};\
\
class LConcat : public LInstructionHelper<1, 2, 5> {\
 public:\
  LIR_HEADER(Concat)\
  explicit LConcat(const LAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3, const LDefinition& temp4) : LInstructionHelper(classOpcode) {\
    setOperand(0, lhs);\
    setOperand(1, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
    setTemp(4, temp4);\
  }\
  const LAllocation* lhs() { return getOperand(0); }\
  const LAllocation* rhs() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  const LDefinition* temp4() { return getTemp(4); }\
};\
\
class LLinearizeForCharAccess : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(LinearizeForCharAccess)\
  explicit LLinearizeForCharAccess(const LAllocation& str, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(0, str);\
    setOperand(1, index);\
  }\
  const LAllocation* str() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  MLinearizeForCharAccess* mir() const { return mir_->toLinearizeForCharAccess(); };\
};\
\
class LCharCodeAt : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(CharCodeAt)\
  explicit LCharCodeAt(const LAllocation& str, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, str);\
    setOperand(1, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* str() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
\
class LCharCodeAtMaybeOutOfBounds : public LInstructionHelper<BOX_PIECES, 2, 2> {\
 public:\
  LIR_HEADER(CharCodeAtMaybeOutOfBounds)\
  explicit LCharCodeAtMaybeOutOfBounds(const LAllocation& str, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, str);\
    setOperand(1, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* str() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
\
class LCharAtMaybeOutOfBounds : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(CharAtMaybeOutOfBounds)\
  explicit LCharAtMaybeOutOfBounds(const LAllocation& str, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, str);\
    setOperand(1, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* str() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
\
class LFromCharCode : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(FromCharCode)\
  explicit LFromCharCode(const LAllocation& code) : LInstructionHelper(classOpcode) {\
    setOperand(0, code);\
  }\
  const LAllocation* code() { return getOperand(0); }\
};\
\
class LFromCodePoint : public LInstructionHelper<1, 1, 2> {\
 public:\
  LIR_HEADER(FromCodePoint)\
  explicit LFromCodePoint(const LAllocation& codePoint, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, codePoint);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* codePoint() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
\
class LStringIndexOf : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(StringIndexOf)\
  explicit LStringIndexOf(const LAllocation& string, const LAllocation& searchString) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, string);\
    setOperand(1, searchString);\
  }\
  const LAllocation* string() { return getOperand(0); }\
  const LAllocation* searchString() { return getOperand(1); }\
};\
\
class LStringStartsWith : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(StringStartsWith)\
  explicit LStringStartsWith(const LAllocation& string, const LAllocation& searchString) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, string);\
    setOperand(1, searchString);\
  }\
  const LAllocation* string() { return getOperand(0); }\
  const LAllocation* searchString() { return getOperand(1); }\
};\
\
class LStringStartsWithInline : public LInstructionHelper<1, 1, 1> {\
  JSLinearString* searchString_;\
 public:\
  LIR_HEADER(StringStartsWithInline)\
  explicit LStringStartsWithInline(const LAllocation& string, const LDefinition& temp0, JSLinearString* searchString) : LInstructionHelper(classOpcode), searchString_(searchString) {\
    setOperand(0, string);\
    setTemp(0, temp0);\
  }\
  const LAllocation* string() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }  JSLinearString* searchString() const { return searchString_; }\
\
};\
\
class LStringEndsWith : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(StringEndsWith)\
  explicit LStringEndsWith(const LAllocation& string, const LAllocation& searchString) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, string);\
    setOperand(1, searchString);\
  }\
  const LAllocation* string() { return getOperand(0); }\
  const LAllocation* searchString() { return getOperand(1); }\
};\
\
class LStringEndsWithInline : public LInstructionHelper<1, 1, 1> {\
  JSLinearString* searchString_;\
 public:\
  LIR_HEADER(StringEndsWithInline)\
  explicit LStringEndsWithInline(const LAllocation& string, const LDefinition& temp0, JSLinearString* searchString) : LInstructionHelper(classOpcode), searchString_(searchString) {\
    setOperand(0, string);\
    setTemp(0, temp0);\
  }\
  const LAllocation* string() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }  JSLinearString* searchString() const { return searchString_; }\
\
};\
\
class LStringToLowerCase : public LInstructionHelper<1, 1, 5> {\
 public:\
  LIR_HEADER(StringToLowerCase)\
  explicit LStringToLowerCase(const LAllocation& string, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3, const LDefinition& temp4) : LInstructionHelper(classOpcode) {\
    setOperand(0, string);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
    setTemp(4, temp4);\
  }\
  const LAllocation* string() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  const LDefinition* temp4() { return getTemp(4); }\
  MStringConvertCase* mir() const { return mir_->toStringConvertCase(); };\
};\
\
class LStringToUpperCase : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(StringToUpperCase)\
  explicit LStringToUpperCase(const LAllocation& string) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, string);\
  }\
  const LAllocation* string() { return getOperand(0); }\
  MStringConvertCase* mir() const { return mir_->toStringConvertCase(); };\
};\
\
class LStringSplit : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(StringSplit)\
  explicit LStringSplit(const LAllocation& string, const LAllocation& separator) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, string);\
    setOperand(1, separator);\
  }\
  const LAllocation* string() { return getOperand(0); }\
  const LAllocation* separator() { return getOperand(1); }\
  MStringSplit* mir() const { return mir_->toStringSplit(); };\
};\
\
class LSubstr : public LInstructionHelper<1, 3, 3> {\
 public:\
  LIR_HEADER(Substr)\
  explicit LSubstr(const LAllocation& string, const LAllocation& begin, const LAllocation& length, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(0, string);\
    setOperand(1, begin);\
    setOperand(2, length);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* string() { return getOperand(0); }\
  const LAllocation* begin() { return getOperand(1); }\
  const LAllocation* length() { return getOperand(2); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MStringSplit* mir() const { return mir_->toStringSplit(); };\
};\
\
class LInt32ToDouble : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Int32ToDouble)\
  explicit LInt32ToDouble(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
};\
\
class LFloat32ToDouble : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Float32ToDouble)\
  explicit LFloat32ToDouble(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
};\
\
class LDoubleToFloat32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(DoubleToFloat32)\
  explicit LDoubleToFloat32(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
};\
\
class LInt32ToFloat32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Int32ToFloat32)\
  explicit LInt32ToFloat32(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
};\
\
class LValueToDouble : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(ValueToDouble)\
  explicit LValueToDouble(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
\
  static const size_t InputIndex = 0;\
  MToDouble* mir() const { return mir_->toToDouble(); };\
};\
\
class LValueToFloat32 : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(ValueToFloat32)\
  explicit LValueToFloat32(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
\
  static const size_t InputIndex = 0;\
  MToFloat32* mir() const { return mir_->toToFloat32(); };\
};\
\
class LValueToBigInt : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(ValueToBigInt)\
  explicit LValueToBigInt(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
\
  static const size_t InputIndex = 0;\
  MToBigInt* mir() const { return mir_->toToBigInt(); };\
};\
\
class LDoubleToInt32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(DoubleToInt32)\
  explicit LDoubleToInt32(const LAllocation& in) : LInstructionHelper(classOpcode) {\
    setOperand(0, in);\
  }\
  const LAllocation* in() { return getOperand(0); }\
  MToNumberInt32* mir() const { return mir_->toToNumberInt32(); };\
};\
\
class LFloat32ToInt32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Float32ToInt32)\
  explicit LFloat32ToInt32(const LAllocation& in) : LInstructionHelper(classOpcode) {\
    setOperand(0, in);\
  }\
  const LAllocation* in() { return getOperand(0); }\
  MToNumberInt32* mir() const { return mir_->toToNumberInt32(); };\
};\
\
class LTruncateDToInt32 : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(TruncateDToInt32)\
  explicit LTruncateDToInt32(const LAllocation& in, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, in);\
    setTemp(0, temp0);\
  }\
  const LAllocation* in() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MTruncateToInt32* mir() const { return mir_->toTruncateToInt32(); };\
};\
\
class LWasmBuiltinTruncateDToInt32 : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(WasmBuiltinTruncateDToInt32)\
  explicit LWasmBuiltinTruncateDToInt32(const LAllocation& in, const LAllocation& instance, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, in);\
    setOperand(1, instance);\
    setTemp(0, temp0);\
  }\
  const LAllocation* in() { return getOperand(0); }\
  const LAllocation* instance() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmBuiltinTruncateToInt32* mir() const { return mir_->toWasmBuiltinTruncateToInt32(); };\
};\
\
class LTruncateFToInt32 : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(TruncateFToInt32)\
  explicit LTruncateFToInt32(const LAllocation& in, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, in);\
    setTemp(0, temp0);\
  }\
  const LAllocation* in() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MTruncateToInt32* mir() const { return mir_->toTruncateToInt32(); };\
};\
\
class LWasmBuiltinTruncateFToInt32 : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(WasmBuiltinTruncateFToInt32)\
  explicit LWasmBuiltinTruncateFToInt32(const LAllocation& in, const LAllocation& instance, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, in);\
    setOperand(1, instance);\
    setTemp(0, temp0);\
  }\
  const LAllocation* in() { return getOperand(0); }\
  const LAllocation* instance() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmBuiltinTruncateToInt32* mir() const { return mir_->toWasmBuiltinTruncateToInt32(); };\
};\
\
class LWasmTruncateToInt32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmTruncateToInt32)\
  explicit LWasmTruncateToInt32(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MWasmTruncateToInt32* mir() const { return mir_->toWasmTruncateToInt32(); };\
};\
\
class LWrapInt64ToInt32 : public LInstructionHelper<1, 1 * INT64_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(WrapInt64ToInt32)\
  explicit LWrapInt64ToInt32(const LInt64Allocation& input) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputIndex, input);\
  }\
  const LInt64Allocation input() { return getInt64Operand(InputIndex); }\
  static const size_t InputIndex = 0;\
  MWrapInt64ToInt32* mir() const { return mir_->toWrapInt64ToInt32(); };\
};\
\
class LExtendInt32ToInt64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(ExtendInt32ToInt64)\
  explicit LExtendInt32ToInt64(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MExtendInt32ToInt64* mir() const { return mir_->toExtendInt32ToInt64(); };\
};\
\
class LBooleanToString : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(BooleanToString)\
  explicit LBooleanToString(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MToString* mir() const { return mir_->toToString(); };\
};\
\
class LIntToString : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IntToString)\
  explicit LIntToString(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MToString* mir() const { return mir_->toToString(); };\
};\
\
class LDoubleToString : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(DoubleToString)\
  explicit LDoubleToString(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MToString* mir() const { return mir_->toToString(); };\
};\
\
class LValueToString : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(ValueToString)\
  explicit LValueToString(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t InputIndex = 0;\
  MToString* mir() const { return mir_->toToString(); };\
};\
\
class LNaNToZero : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(NaNToZero)\
  explicit LNaNToZero(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNaNToZero* mir() const { return mir_->toNaNToZero(); };\
};\
\
class LOsrValue : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(OsrValue)\
  explicit LOsrValue(const LAllocation& entry) : LInstructionHelper(classOpcode) {\
    setOperand(0, entry);\
  }\
  const LAllocation* entry() { return getOperand(0); }\
  MOsrValue* mir() const { return mir_->toOsrValue(); };\
};\
\
class LOsrEnvironmentChain : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(OsrEnvironmentChain)\
  explicit LOsrEnvironmentChain(const LAllocation& entry) : LInstructionHelper(classOpcode) {\
    setOperand(0, entry);\
  }\
  const LAllocation* entry() { return getOperand(0); }\
  MOsrEnvironmentChain* mir() const { return mir_->toOsrEnvironmentChain(); };\
};\
\
class LOsrReturnValue : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(OsrReturnValue)\
  explicit LOsrReturnValue(const LAllocation& entry) : LInstructionHelper(classOpcode) {\
    setOperand(0, entry);\
  }\
  const LAllocation* entry() { return getOperand(0); }\
  MOsrReturnValue* mir() const { return mir_->toOsrReturnValue(); };\
};\
\
class LOsrArgumentsObject : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(OsrArgumentsObject)\
  explicit LOsrArgumentsObject(const LAllocation& entry) : LInstructionHelper(classOpcode) {\
    setOperand(0, entry);\
  }\
  const LAllocation* entry() { return getOperand(0); }\
  MOsrArgumentsObject* mir() const { return mir_->toOsrArgumentsObject(); };\
};\
\
class LRegExp : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(RegExp)\
  explicit LRegExp(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MRegExp* mir() const { return mir_->toRegExp(); };\
};\
\
class LRegExpMatcher : public LInstructionHelper<BOX_PIECES, 3, 0> {\
 public:\
  LIR_HEADER(RegExpMatcher)\
  explicit LRegExpMatcher(const LAllocation& regexp, const LAllocation& string, const LAllocation& lastIndex) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, regexp);\
    setOperand(1, string);\
    setOperand(2, lastIndex);\
  }\
  const LAllocation* regexp() { return getOperand(0); }\
  const LAllocation* string() { return getOperand(1); }\
  const LAllocation* lastIndex() { return getOperand(2); }\
  MRegExpMatcher* mir() const { return mir_->toRegExpMatcher(); };\
};\
\
class LRegExpSearcher : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(RegExpSearcher)\
  explicit LRegExpSearcher(const LAllocation& regexp, const LAllocation& string, const LAllocation& lastIndex) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, regexp);\
    setOperand(1, string);\
    setOperand(2, lastIndex);\
  }\
  const LAllocation* regexp() { return getOperand(0); }\
  const LAllocation* string() { return getOperand(1); }\
  const LAllocation* lastIndex() { return getOperand(2); }\
  MRegExpSearcher* mir() const { return mir_->toRegExpSearcher(); };\
};\
\
class LRegExpExecMatch : public LInstructionHelper<BOX_PIECES, 2, 0> {\
 public:\
  LIR_HEADER(RegExpExecMatch)\
  explicit LRegExpExecMatch(const LAllocation& regexp, const LAllocation& string) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, regexp);\
    setOperand(1, string);\
  }\
  const LAllocation* regexp() { return getOperand(0); }\
  const LAllocation* string() { return getOperand(1); }\
  MRegExpExecMatch* mir() const { return mir_->toRegExpExecMatch(); };\
};\
\
class LRegExpExecTest : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(RegExpExecTest)\
  explicit LRegExpExecTest(const LAllocation& regexp, const LAllocation& string) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, regexp);\
    setOperand(1, string);\
  }\
  const LAllocation* regexp() { return getOperand(0); }\
  const LAllocation* string() { return getOperand(1); }\
  MRegExpExecTest* mir() const { return mir_->toRegExpExecTest(); };\
};\
\
class LRegExpPrototypeOptimizable : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(RegExpPrototypeOptimizable)\
  explicit LRegExpPrototypeOptimizable(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MRegExpPrototypeOptimizable* mir() const { return mir_->toRegExpPrototypeOptimizable(); };\
};\
\
class LRegExpInstanceOptimizable : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(RegExpInstanceOptimizable)\
  explicit LRegExpInstanceOptimizable(const LAllocation& object, const LAllocation& proto, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, proto);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* proto() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MRegExpInstanceOptimizable* mir() const { return mir_->toRegExpInstanceOptimizable(); };\
};\
\
class LGetFirstDollarIndex : public LInstructionHelper<1, 1, 3> {\
 public:\
  LIR_HEADER(GetFirstDollarIndex)\
  explicit LGetFirstDollarIndex(const LAllocation& str, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(0, str);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* str() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
};\
\
class LStringReplace : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(StringReplace)\
  explicit LStringReplace(const LAllocation& string, const LAllocation& pattern, const LAllocation& replacement) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, string);\
    setOperand(1, pattern);\
    setOperand(2, replacement);\
  }\
  const LAllocation* string() { return getOperand(0); }\
  const LAllocation* pattern() { return getOperand(1); }\
  const LAllocation* replacement() { return getOperand(2); }\
  MStringReplace* mir() const { return mir_->toStringReplace(); };\
};\
\
class LBinaryValueCache : public LInstructionHelper<BOX_PIECES, 2 * BOX_PIECES + 0, 2> {\
 public:\
  LIR_HEADER(BinaryValueCache)\
  explicit LBinaryValueCache(const LBoxAllocation& lhs, const LBoxAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(LhsIndex, lhs);\
    setBoxOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  static const size_t LhsIndex = 0;\
\
  static const size_t RhsIndex = 0 + BOX_PIECES * 1;\
  MBinaryCache* mir() const { return mir_->toBinaryCache(); };\
};\
\
class LBinaryBoolCache : public LInstructionHelper<1, 2 * BOX_PIECES + 0, 2> {\
 public:\
  LIR_HEADER(BinaryBoolCache)\
  explicit LBinaryBoolCache(const LBoxAllocation& lhs, const LBoxAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(LhsIndex, lhs);\
    setBoxOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  static const size_t LhsIndex = 0;\
\
  static const size_t RhsIndex = 0 + BOX_PIECES * 1;\
  MBinaryCache* mir() const { return mir_->toBinaryCache(); };\
};\
\
class LUnaryCache : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(UnaryCache)\
  explicit LUnaryCache(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
\
  static const size_t InputIndex = 0;\
};\
\
class LModuleMetadata : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(ModuleMetadata)\
  explicit LModuleMetadata() : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
\
  }\
\
  MModuleMetadata* mir() const { return mir_->toModuleMetadata(); };\
};\
\
class LDynamicImport : public LInstructionHelper<1, 2 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(DynamicImport)\
  explicit LDynamicImport(const LBoxAllocation& specifier, const LBoxAllocation& options) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(SpecifierIndex, specifier);\
    setBoxOperand(OptionsIndex, options);\
  }\
\
  static const size_t SpecifierIndex = 0;\
\
  static const size_t OptionsIndex = 0 + BOX_PIECES * 1;\
  MDynamicImport* mir() const { return mir_->toDynamicImport(); };\
};\
\
class LLambda : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(Lambda)\
  explicit LLambda(const LAllocation& environmentChain, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, environmentChain);\
    setTemp(0, temp0);\
  }\
  const LAllocation* environmentChain() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MLambda* mir() const { return mir_->toLambda(); };\
};\
\
class LFunctionWithProto : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(FunctionWithProto)\
  explicit LFunctionWithProto(const LAllocation& envChain, const LAllocation& prototype) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, envChain);\
    setOperand(1, prototype);\
  }\
  const LAllocation* envChain() { return getOperand(0); }\
  const LAllocation* prototype() { return getOperand(1); }\
  MFunctionWithProto* mir() const { return mir_->toFunctionWithProto(); };\
};\
\
class LSetFunName : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(SetFunName)\
  explicit LSetFunName(const LAllocation& fun, const LBoxAllocation& name) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, fun);\
    setBoxOperand(NameIndex, name);\
  }\
  const LAllocation* fun() { return getOperand(0); }\
  static const size_t NameIndex = 1;\
  MSetFunName* mir() const { return mir_->toSetFunName(); };\
};\
\
class LKeepAliveObject : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(KeepAliveObject)\
  explicit LKeepAliveObject(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
};\
\
class LDebugEnterGCUnsafeRegion : public LInstructionHelper<0, 0, 1> {\
 public:\
  LIR_HEADER(DebugEnterGCUnsafeRegion)\
  explicit LDebugEnterGCUnsafeRegion(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LDebugLeaveGCUnsafeRegion : public LInstructionHelper<0, 0, 1> {\
 public:\
  LIR_HEADER(DebugLeaveGCUnsafeRegion)\
  explicit LDebugLeaveGCUnsafeRegion(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LSlots : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Slots)\
  explicit LSlots(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
};\
\
class LElements : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Elements)\
  explicit LElements(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  MElements* mir() const { return mir_->toElements(); };\
};\
\
class LInitializedLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(InitializedLength)\
  explicit LInitializedLength(const LAllocation& elements) : LInstructionHelper(classOpcode) {\
    setOperand(0, elements);\
  }\
  const LAllocation* elements() { return getOperand(0); }\
};\
\
class LSetInitializedLength : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(SetInitializedLength)\
  explicit LSetInitializedLength(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(0, elements);\
    setOperand(1, index);\
  }\
  const LAllocation* elements() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
};\
\
class LArrayLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArrayLength)\
  explicit LArrayLength(const LAllocation& elements) : LInstructionHelper(classOpcode) {\
    setOperand(0, elements);\
  }\
  const LAllocation* elements() { return getOperand(0); }\
};\
\
class LSetArrayLength : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(SetArrayLength)\
  explicit LSetArrayLength(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(0, elements);\
    setOperand(1, index);\
  }\
  const LAllocation* elements() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
};\
\
class LFunctionLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(FunctionLength)\
  explicit LFunctionLength(const LAllocation& function) : LInstructionHelper(classOpcode) {\
    setOperand(0, function);\
  }\
  const LAllocation* function() { return getOperand(0); }\
};\
\
class LFunctionName : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(FunctionName)\
  explicit LFunctionName(const LAllocation& function) : LInstructionHelper(classOpcode) {\
    setOperand(0, function);\
  }\
  const LAllocation* function() { return getOperand(0); }\
};\
\
class LGetNextEntryForIterator : public LInstructionHelper<1, 2, 3> {\
 public:\
  LIR_HEADER(GetNextEntryForIterator)\
  explicit LGetNextEntryForIterator(const LAllocation& iter, const LAllocation& result, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(0, iter);\
    setOperand(1, result);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* iter() { return getOperand(0); }\
  const LAllocation* result() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MGetNextEntryForIterator* mir() const { return mir_->toGetNextEntryForIterator(); };\
};\
\
class LArrayBufferByteLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArrayBufferByteLength)\
  explicit LArrayBufferByteLength(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
};\
\
class LArrayBufferViewLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArrayBufferViewLength)\
  explicit LArrayBufferViewLength(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  MArrayBufferViewLength* mir() const { return mir_->toArrayBufferViewLength(); };\
};\
\
class LArrayBufferViewByteOffset : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArrayBufferViewByteOffset)\
  explicit LArrayBufferViewByteOffset(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
};\
\
class LArrayBufferViewElements : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ArrayBufferViewElements)\
  explicit LArrayBufferViewElements(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
};\
\
class LTypedArrayElementSize : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(TypedArrayElementSize)\
  explicit LTypedArrayElementSize(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
};\
\
class LGuardHasAttachedArrayBuffer : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardHasAttachedArrayBuffer)\
  explicit LGuardHasAttachedArrayBuffer(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LGuardNumberToIntPtrIndex : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(GuardNumberToIntPtrIndex)\
  explicit LGuardNumberToIntPtrIndex(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  MGuardNumberToIntPtrIndex* mir() const { return mir_->toGuardNumberToIntPtrIndex(); };\
};\
\
class LBoundsCheck : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(BoundsCheck)\
  explicit LBoundsCheck(const LAllocation& index, const LAllocation& length) : LInstructionHelper(classOpcode) {\
    setOperand(0, index);\
    setOperand(1, length);\
  }\
  const LAllocation* index() { return getOperand(0); }\
  const LAllocation* length() { return getOperand(1); }\
  MBoundsCheck* mir() const { return mir_->toBoundsCheck(); };\
};\
\
class LBoundsCheckLower : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(BoundsCheckLower)\
  explicit LBoundsCheckLower(const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(0, index);\
  }\
  const LAllocation* index() { return getOperand(0); }\
  MBoundsCheckLower* mir() const { return mir_->toBoundsCheckLower(); };\
};\
\
class LSpectreMaskIndex : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(SpectreMaskIndex)\
  explicit LSpectreMaskIndex(const LAllocation& index, const LAllocation& length) : LInstructionHelper(classOpcode) {\
    setOperand(0, index);\
    setOperand(1, length);\
  }\
  const LAllocation* index() { return getOperand(0); }\
  const LAllocation* length() { return getOperand(1); }\
  MSpectreMaskIndex* mir() const { return mir_->toSpectreMaskIndex(); };\
};\
\
class LInArray : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(InArray)\
  explicit LInArray(const LAllocation& elements, const LAllocation& index, const LAllocation& initLength) : LInstructionHelper(classOpcode) {\
    setOperand(0, elements);\
    setOperand(1, index);\
    setOperand(2, initLength);\
  }\
  const LAllocation* elements() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LAllocation* initLength() { return getOperand(2); }\
  MInArray* mir() const { return mir_->toInArray(); };\
};\
\
class LGuardElementNotHole : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(GuardElementNotHole)\
  explicit LGuardElementNotHole(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(0, elements);\
    setOperand(1, index);\
  }\
  const LAllocation* elements() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
};\
\
class LStoreHoleValueElement : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(StoreHoleValueElement)\
  explicit LStoreHoleValueElement(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(0, elements);\
    setOperand(1, index);\
  }\
  const LAllocation* elements() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
};\
\
class LStoreElementHoleV : public LInstructionHelper<0, 1 * BOX_PIECES + 3, 1> {\
 public:\
  LIR_HEADER(StoreElementHoleV)\
  explicit LStoreElementHoleV(const LAllocation& object, const LAllocation& elements, const LAllocation& index, const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, elements);\
    setOperand(2, index);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* elements() { return getOperand(1); }\
  const LAllocation* index() { return getOperand(2); }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t ValueIndex = 3;\
  MStoreElementHole* mir() const { return mir_->toStoreElementHole(); };\
};\
\
class LStoreElementHoleT : public LInstructionHelper<0, 4, 1> {\
 public:\
  LIR_HEADER(StoreElementHoleT)\
  explicit LStoreElementHoleT(const LAllocation& object, const LAllocation& elements, const LAllocation& index, const LAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, elements);\
    setOperand(2, index);\
    setOperand(3, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* elements() { return getOperand(1); }\
  const LAllocation* index() { return getOperand(2); }\
  const LAllocation* value() { return getOperand(3); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MStoreElementHole* mir() const { return mir_->toStoreElementHole(); };\
};\
\
class LArrayPush : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 2> {\
 public:\
  LIR_HEADER(ArrayPush)\
  explicit LArrayPush(const LAllocation& object, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  static const size_t ValueIndex = 1;\
  MArrayPush* mir() const { return mir_->toArrayPush(); };\
};\
\
class LArraySlice : public LInstructionHelper<1, 3, 2> {\
 public:\
  LIR_HEADER(ArraySlice)\
  explicit LArraySlice(const LAllocation& object, const LAllocation& begin, const LAllocation& end, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setOperand(1, begin);\
    setOperand(2, end);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* begin() { return getOperand(1); }\
  const LAllocation* end() { return getOperand(2); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MArraySlice* mir() const { return mir_->toArraySlice(); };\
};\
\
class LArgumentsSlice : public LInstructionHelper<1, 3, 2> {\
 public:\
  LIR_HEADER(ArgumentsSlice)\
  explicit LArgumentsSlice(const LAllocation& object, const LAllocation& begin, const LAllocation& end, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setOperand(1, begin);\
    setOperand(2, end);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* begin() { return getOperand(1); }\
  const LAllocation* end() { return getOperand(2); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MArgumentsSlice* mir() const { return mir_->toArgumentsSlice(); };\
};\
\
class LFrameArgumentsSlice : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(FrameArgumentsSlice)\
  explicit LFrameArgumentsSlice(const LAllocation& begin, const LAllocation& count, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, begin);\
    setOperand(1, count);\
    setTemp(0, temp0);\
  }\
  const LAllocation* begin() { return getOperand(0); }\
  const LAllocation* count() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MFrameArgumentsSlice* mir() const { return mir_->toFrameArgumentsSlice(); };\
};\
\
class LNormalizeSliceTerm : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(NormalizeSliceTerm)\
  explicit LNormalizeSliceTerm(const LAllocation& value, const LAllocation& length) : LInstructionHelper(classOpcode) {\
    setOperand(0, value);\
    setOperand(1, length);\
  }\
  const LAllocation* value() { return getOperand(0); }\
  const LAllocation* length() { return getOperand(1); }\
  MNormalizeSliceTerm* mir() const { return mir_->toNormalizeSliceTerm(); };\
};\
\
class LArrayJoin : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(ArrayJoin)\
  explicit LArrayJoin(const LAllocation& array, const LAllocation& separator, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, array);\
    setOperand(1, separator);\
    setTemp(0, temp0);\
  }\
  const LAllocation* array() { return getOperand(0); }\
  const LAllocation* separator() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MArrayJoin* mir() const { return mir_->toArrayJoin(); };\
};\
\
class LLoadUnboxedScalar : public LInstructionHelper<1, 2, 1> {\
 public:\
  LIR_HEADER(LoadUnboxedScalar)\
  explicit LLoadUnboxedScalar(const LAllocation& elements, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, elements);\
    setOperand(1, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* elements() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MLoadUnboxedScalar* mir() const { return mir_->toLoadUnboxedScalar(); };\
};\
\
class LLoadTypedArrayElementHole : public LInstructionHelper<BOX_PIECES, 2, 1> {\
 public:\
  LIR_HEADER(LoadTypedArrayElementHole)\
  explicit LLoadTypedArrayElementHole(const LAllocation& object, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MLoadTypedArrayElementHole* mir() const { return mir_->toLoadTypedArrayElementHole(); };\
};\
\
class LStoreUnboxedScalar : public LInstructionHelper<0, 3, 0> {\
 public:\
  LIR_HEADER(StoreUnboxedScalar)\
  explicit LStoreUnboxedScalar(const LAllocation& elements, const LAllocation& index, const LAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(0, elements);\
    setOperand(1, index);\
    setOperand(2, value);\
  }\
  const LAllocation* elements() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LAllocation* value() { return getOperand(2); }\
  MStoreUnboxedScalar* mir() const { return mir_->toStoreUnboxedScalar(); };\
};\
\
class LStoreTypedArrayElementHole : public LInstructionHelper<0, 4, 1> {\
 public:\
  LIR_HEADER(StoreTypedArrayElementHole)\
  explicit LStoreTypedArrayElementHole(const LAllocation& elements, const LAllocation& length, const LAllocation& index, const LAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, elements);\
    setOperand(1, length);\
    setOperand(2, index);\
    setOperand(3, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* elements() { return getOperand(0); }\
  const LAllocation* length() { return getOperand(1); }\
  const LAllocation* index() { return getOperand(2); }\
  const LAllocation* value() { return getOperand(3); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MStoreTypedArrayElementHole* mir() const { return mir_->toStoreTypedArrayElementHole(); };\
};\
\
class LAtomicIsLockFree : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(AtomicIsLockFree)\
  explicit LAtomicIsLockFree(const LAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(0, value);\
  }\
  const LAllocation* value() { return getOperand(0); }\
};\
\
class LEffectiveAddress : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(EffectiveAddress)\
  explicit LEffectiveAddress(const LAllocation& base, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(0, base);\
    setOperand(1, index);\
  }\
  const LAllocation* base() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  MEffectiveAddress* mir() const { return mir_->toEffectiveAddress(); };\
};\
\
class LClampIToUint8 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ClampIToUint8)\
  explicit LClampIToUint8(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
};\
\
class LClampDToUint8 : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(ClampDToUint8)\
  explicit LClampDToUint8(const LAllocation& in, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, in);\
    setTemp(0, temp0);\
  }\
  const LAllocation* in() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LClampVToUint8 : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(ClampVToUint8)\
  explicit LClampVToUint8(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t InputIndex = 0;\
  MClampToUint8* mir() const { return mir_->toClampToUint8(); };\
};\
\
class LLoadFixedSlotV : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(LoadFixedSlotV)\
  explicit LLoadFixedSlotV(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  MLoadFixedSlot* mir() const { return mir_->toLoadFixedSlot(); };\
};\
\
class LLoadFixedSlotT : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(LoadFixedSlotT)\
  explicit LLoadFixedSlotT(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  MLoadFixedSlot* mir() const { return mir_->toLoadFixedSlot(); };\
};\
\
class LLoadFixedSlotAndUnbox : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(LoadFixedSlotAndUnbox)\
  explicit LLoadFixedSlotAndUnbox(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  MLoadFixedSlotAndUnbox* mir() const { return mir_->toLoadFixedSlotAndUnbox(); };\
};\
\
class LLoadDynamicSlotAndUnbox : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(LoadDynamicSlotAndUnbox)\
  explicit LLoadDynamicSlotAndUnbox(const LAllocation& slots) : LInstructionHelper(classOpcode) {\
    setOperand(0, slots);\
  }\
  const LAllocation* slots() { return getOperand(0); }\
  MLoadDynamicSlotAndUnbox* mir() const { return mir_->toLoadDynamicSlotAndUnbox(); };\
};\
\
class LLoadElementAndUnbox : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(LoadElementAndUnbox)\
  explicit LLoadElementAndUnbox(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(0, elements);\
    setOperand(1, index);\
  }\
  const LAllocation* elements() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  MLoadElementAndUnbox* mir() const { return mir_->toLoadElementAndUnbox(); };\
};\
\
class LAddAndStoreSlot : public LInstructionHelper<0, 1 * BOX_PIECES + 1, 1> {\
 public:\
  LIR_HEADER(AddAndStoreSlot)\
  explicit LAddAndStoreSlot(const LAllocation& object, const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t ValueIndex = 1;\
  MAddAndStoreSlot* mir() const { return mir_->toAddAndStoreSlot(); };\
};\
\
class LAllocateAndStoreSlot : public LInstructionHelper<0, 1 * BOX_PIECES + 1, 2> {\
 public:\
  LIR_HEADER(AllocateAndStoreSlot)\
  explicit LAllocateAndStoreSlot(const LAllocation& object, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  static const size_t ValueIndex = 1;\
  MAllocateAndStoreSlot* mir() const { return mir_->toAllocateAndStoreSlot(); };\
};\
\
class LAddSlotAndCallAddPropHook : public LInstructionHelper<0, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(AddSlotAndCallAddPropHook)\
  explicit LAddSlotAndCallAddPropHook(const LAllocation& object, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  static const size_t ValueIndex = 1;\
  MAddSlotAndCallAddPropHook* mir() const { return mir_->toAddSlotAndCallAddPropHook(); };\
};\
\
class LStoreFixedSlotV : public LInstructionHelper<0, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(StoreFixedSlotV)\
  explicit LStoreFixedSlotV(const LAllocation& obj, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(0, obj);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* obj() { return getOperand(0); }\
  static const size_t ValueIndex = 1;\
  MStoreFixedSlot* mir() const { return mir_->toStoreFixedSlot(); };\
};\
\
class LStoreFixedSlotT : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(StoreFixedSlotT)\
  explicit LStoreFixedSlotT(const LAllocation& obj, const LAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(0, obj);\
    setOperand(1, value);\
  }\
  const LAllocation* obj() { return getOperand(0); }\
  const LAllocation* value() { return getOperand(1); }\
  MStoreFixedSlot* mir() const { return mir_->toStoreFixedSlot(); };\
};\
\
class LGetNameCache : public LInstructionHelper<BOX_PIECES, 1, 1> {\
 public:\
  LIR_HEADER(GetNameCache)\
  explicit LGetNameCache(const LAllocation& envObj, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, envObj);\
    setTemp(0, temp0);\
  }\
  const LAllocation* envObj() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGetNameCache* mir() const { return mir_->toGetNameCache(); };\
};\
\
class LCallGetIntrinsicValue : public LInstructionHelper<BOX_PIECES, 0, 0> {\
 public:\
  LIR_HEADER(CallGetIntrinsicValue)\
  explicit LCallGetIntrinsicValue() : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
\
  }\
\
  MCallGetIntrinsicValue* mir() const { return mir_->toCallGetIntrinsicValue(); };\
};\
\
class LGetPropSuperCache : public LInstructionHelper<BOX_PIECES, 2 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(GetPropSuperCache)\
  explicit LGetPropSuperCache(const LAllocation& obj, const LBoxAllocation& receiver, const LBoxAllocation& id) : LInstructionHelper(classOpcode) {\
    setOperand(0, obj);\
    setBoxOperand(ReceiverIndex, receiver);\
    setBoxOperand(IdIndex, id);\
  }\
  const LAllocation* obj() { return getOperand(0); }\
  static const size_t ReceiverIndex = 1;\
\
  static const size_t IdIndex = 1 + BOX_PIECES * 1;\
  MGetPropSuperCache* mir() const { return mir_->toGetPropSuperCache(); };\
};\
\
class LGetPropertyCache : public LInstructionHelper<BOX_PIECES, 2 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(GetPropertyCache)\
  explicit LGetPropertyCache(const LBoxAllocation& value, const LBoxAllocation& id) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setBoxOperand(IdIndex, id);\
  }\
\
  static const size_t ValueIndex = 0;\
\
  static const size_t IdIndex = 0 + BOX_PIECES * 1;\
  MGetPropertyCache* mir() const { return mir_->toGetPropertyCache(); };\
};\
\
class LBindNameCache : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(BindNameCache)\
  explicit LBindNameCache(const LAllocation& environmentChain, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, environmentChain);\
    setTemp(0, temp0);\
  }\
  const LAllocation* environmentChain() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MBindNameCache* mir() const { return mir_->toBindNameCache(); };\
};\
\
class LCallBindVar : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(CallBindVar)\
  explicit LCallBindVar(const LAllocation& environmentChain) : LInstructionHelper(classOpcode) {\
    setOperand(0, environmentChain);\
  }\
  const LAllocation* environmentChain() { return getOperand(0); }\
  MCallBindVar* mir() const { return mir_->toCallBindVar(); };\
};\
\
class LLoadDynamicSlotV : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(LoadDynamicSlotV)\
  explicit LLoadDynamicSlotV(const LAllocation& in) : LInstructionHelper(classOpcode) {\
    setOperand(0, in);\
  }\
  const LAllocation* in() { return getOperand(0); }\
  MLoadDynamicSlot* mir() const { return mir_->toLoadDynamicSlot(); };\
};\
\
class LStoreDynamicSlotV : public LInstructionHelper<0, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(StoreDynamicSlotV)\
  explicit LStoreDynamicSlotV(const LAllocation& slots, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(0, slots);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* slots() { return getOperand(0); }\
  static const size_t ValueIndex = 1;\
  MStoreDynamicSlot* mir() const { return mir_->toStoreDynamicSlot(); };\
};\
\
class LStoreDynamicSlotT : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(StoreDynamicSlotT)\
  explicit LStoreDynamicSlotT(const LAllocation& slots, const LAllocation& value) : LInstructionHelper(classOpcode) {\
    setOperand(0, slots);\
    setOperand(1, value);\
  }\
  const LAllocation* slots() { return getOperand(0); }\
  const LAllocation* value() { return getOperand(1); }\
  MStoreDynamicSlot* mir() const { return mir_->toStoreDynamicSlot(); };\
};\
\
class LStringLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(StringLength)\
  explicit LStringLength(const LAllocation& string) : LInstructionHelper(classOpcode) {\
    setOperand(0, string);\
  }\
  const LAllocation* string() { return getOperand(0); }\
};\
\
class LFloor : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Floor)\
  explicit LFloor(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LFloorF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(FloorF)\
  explicit LFloorF(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LCeil : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Ceil)\
  explicit LCeil(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LCeilF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(CeilF)\
  explicit LCeilF(const LAllocation& string) : LInstructionHelper(classOpcode) {\
    setOperand(0, string);\
  }\
  const LAllocation* string() { return getOperand(0); }\
};\
\
class LRound : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(Round)\
  explicit LRound(const LAllocation& num, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
    setTemp(0, temp0);\
  }\
  const LAllocation* num() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MRound* mir() const { return mir_->toRound(); };\
};\
\
class LRoundF : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(RoundF)\
  explicit LRoundF(const LAllocation& num, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
    setTemp(0, temp0);\
  }\
  const LAllocation* num() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MRound* mir() const { return mir_->toRound(); };\
};\
\
class LTrunc : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Trunc)\
  explicit LTrunc(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LTruncF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(TruncF)\
  explicit LTruncF(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
};\
\
class LNearbyInt : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NearbyInt)\
  explicit LNearbyInt(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
  MNearbyInt* mir() const { return mir_->toNearbyInt(); };\
};\
\
class LNearbyIntF : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NearbyIntF)\
  explicit LNearbyIntF(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
  MNearbyInt* mir() const { return mir_->toNearbyInt(); };\
};\
\
class LFunctionEnvironment : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(FunctionEnvironment)\
  explicit LFunctionEnvironment(const LAllocation& function) : LInstructionHelper(classOpcode) {\
    setOperand(0, function);\
  }\
  const LAllocation* function() { return getOperand(0); }\
};\
\
class LHomeObject : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(HomeObject)\
  explicit LHomeObject(const LAllocation& function) : LInstructionHelper(classOpcode) {\
    setOperand(0, function);\
  }\
  const LAllocation* function() { return getOperand(0); }\
};\
\
class LHomeObjectSuperBase : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(HomeObjectSuperBase)\
  explicit LHomeObjectSuperBase(const LAllocation& homeObject) : LInstructionHelper(classOpcode) {\
    setOperand(0, homeObject);\
  }\
  const LAllocation* homeObject() { return getOperand(0); }\
};\
\
class LNewLexicalEnvironmentObject : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewLexicalEnvironmentObject)\
  explicit LNewLexicalEnvironmentObject(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewLexicalEnvironmentObject* mir() const { return mir_->toNewLexicalEnvironmentObject(); };\
};\
\
class LNewClassBodyEnvironmentObject : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewClassBodyEnvironmentObject)\
  explicit LNewClassBodyEnvironmentObject(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewClassBodyEnvironmentObject* mir() const { return mir_->toNewClassBodyEnvironmentObject(); };\
};\
\
class LNewVarEnvironmentObject : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(NewVarEnvironmentObject)\
  explicit LNewVarEnvironmentObject(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MNewVarEnvironmentObject* mir() const { return mir_->toNewVarEnvironmentObject(); };\
};\
\
class LMegamorphicSetElement : public LInstructionHelper<0, 2 * BOX_PIECES + 1, 3> {\
 public:\
  LIR_HEADER(MegamorphicSetElement)\
  explicit LMegamorphicSetElement(const LAllocation& object, const LBoxAllocation& index, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setBoxOperand(IndexIndex, index);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  static const size_t IndexIndex = 1;\
\
  static const size_t ValueIndex = 1 + BOX_PIECES * 1;\
  MMegamorphicSetElement* mir() const { return mir_->toMegamorphicSetElement(); };\
};\
\
class LCallDeleteProperty : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(CallDeleteProperty)\
  explicit LCallDeleteProperty(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
  }\
\
  static const size_t ValueIndex = 0;\
  MDeleteProperty* mir() const { return mir_->toDeleteProperty(); };\
};\
\
class LCallDeleteElement : public LInstructionHelper<1, 2 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(CallDeleteElement)\
  explicit LCallDeleteElement(const LBoxAllocation& value, const LBoxAllocation& index) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
    setBoxOperand(IndexIndex, index);\
  }\
\
  static const size_t ValueIndex = 0;\
\
  static const size_t IndexIndex = 0 + BOX_PIECES * 1;\
  MDeleteElement* mir() const { return mir_->toDeleteElement(); };\
};\
\
class LObjectToIterator : public LInstructionHelper<1, 1, 3> {\
 public:\
  LIR_HEADER(ObjectToIterator)\
  explicit LObjectToIterator(const LAllocation& object, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MObjectToIterator* mir() const { return mir_->toObjectToIterator(); };\
};\
\
class LValueToIterator : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(ValueToIterator)\
  explicit LValueToIterator(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
  }\
\
  static const size_t ValueIndex = 0;\
  MValueToIterator* mir() const { return mir_->toValueToIterator(); };\
};\
\
class LLoadSlotByIteratorIndex : public LInstructionHelper<BOX_PIECES, 2, 2> {\
 public:\
  LIR_HEADER(LoadSlotByIteratorIndex)\
  explicit LLoadSlotByIteratorIndex(const LAllocation& object, const LAllocation& iterator, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, iterator);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* iterator() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
\
class LStoreSlotByIteratorIndex : public LInstructionHelper<0, 1 * BOX_PIECES + 2, 2> {\
 public:\
  LIR_HEADER(StoreSlotByIteratorIndex)\
  explicit LStoreSlotByIteratorIndex(const LAllocation& object, const LAllocation& iterator, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, iterator);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* iterator() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  static const size_t ValueIndex = 2;\
  MStoreSlotByIteratorIndex* mir() const { return mir_->toStoreSlotByIteratorIndex(); };\
};\
\
class LSetPropertyCache : public LInstructionHelper<0, 2 * BOX_PIECES + 1, 2> {\
 public:\
  LIR_HEADER(SetPropertyCache)\
  explicit LSetPropertyCache(const LAllocation& object, const LBoxAllocation& id, const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setBoxOperand(IdIndex, id);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  static const size_t IdIndex = 1;\
\
  static const size_t ValueIndex = 1 + BOX_PIECES * 1;\
  MSetPropertyCache* mir() const { return mir_->toSetPropertyCache(); };\
};\
\
class LGetIteratorCache : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 2> {\
 public:\
  LIR_HEADER(GetIteratorCache)\
  explicit LGetIteratorCache(const LBoxAllocation& value, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  static const size_t ValueIndex = 0;\
  MGetIteratorCache* mir() const { return mir_->toGetIteratorCache(); };\
};\
\
class LOptimizeSpreadCallCache : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(OptimizeSpreadCallCache)\
  explicit LOptimizeSpreadCallCache(const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t ValueIndex = 0;\
  MOptimizeSpreadCallCache* mir() const { return mir_->toOptimizeSpreadCallCache(); };\
};\
\
class LIteratorMore : public LInstructionHelper<BOX_PIECES, 1, 1> {\
 public:\
  LIR_HEADER(IteratorMore)\
  explicit LIteratorMore(const LAllocation& iterator, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, iterator);\
    setTemp(0, temp0);\
  }\
  const LAllocation* iterator() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MIteratorMore* mir() const { return mir_->toIteratorMore(); };\
};\
\
class LIteratorEnd : public LInstructionHelper<0, 1, 3> {\
 public:\
  LIR_HEADER(IteratorEnd)\
  explicit LIteratorEnd(const LAllocation& object, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MIteratorEnd* mir() const { return mir_->toIteratorEnd(); };\
};\
\
class LCloseIterCache : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(CloseIterCache)\
  explicit LCloseIterCache(const LAllocation& iter, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, iter);\
    setTemp(0, temp0);\
  }\
  const LAllocation* iter() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MCloseIterCache* mir() const { return mir_->toCloseIterCache(); };\
};\
\
class LArgumentsLength : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(ArgumentsLength)\
  explicit LArgumentsLength() : LInstructionHelper(classOpcode) {\
\
  }\
\
};\
\
class LGetFrameArgument : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(GetFrameArgument)\
  explicit LGetFrameArgument(const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(0, index);\
  }\
  const LAllocation* index() { return getOperand(0); }\
};\
\
class LGetFrameArgumentHole : public LInstructionHelper<BOX_PIECES, 2, 1> {\
 public:\
  LIR_HEADER(GetFrameArgumentHole)\
  explicit LGetFrameArgumentHole(const LAllocation& index, const LAllocation& length, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, index);\
    setOperand(1, length);\
    setTemp(0, temp0);\
  }\
  const LAllocation* index() { return getOperand(0); }\
  const LAllocation* length() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LRest : public LInstructionHelper<1, 1, 3> {\
 public:\
  LIR_HEADER(Rest)\
  explicit LRest(const LAllocation& numActuals, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, numActuals);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* numActuals() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MRest* mir() const { return mir_->toRest(); };\
};\
\
class LInt32ToIntPtr : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(Int32ToIntPtr)\
  explicit LInt32ToIntPtr(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MInt32ToIntPtr* mir() const { return mir_->toInt32ToIntPtr(); };\
};\
\
class LNonNegativeIntPtrToInt32 : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(NonNegativeIntPtrToInt32)\
  explicit LNonNegativeIntPtrToInt32(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
};\
\
class LIntPtrToDouble : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IntPtrToDouble)\
  explicit LIntPtrToDouble(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
};\
\
class LAdjustDataViewLength : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(AdjustDataViewLength)\
  explicit LAdjustDataViewLength(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MAdjustDataViewLength* mir() const { return mir_->toAdjustDataViewLength(); };\
};\
\
class LBooleanToInt64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(BooleanToInt64)\
  explicit LBooleanToInt64(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MToInt64* mir() const { return mir_->toToInt64(); };\
};\
\
class LStringToInt64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(StringToInt64)\
  explicit LStringToInt64(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MToInt64* mir() const { return mir_->toToInt64(); };\
};\
\
class LValueToInt64 : public LInstructionHelper<INT64_PIECES, 1 * BOX_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(ValueToInt64)\
  explicit LValueToInt64(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t InputIndex = 0;\
  MToInt64* mir() const { return mir_->toToInt64(); };\
};\
\
class LTruncateBigIntToInt64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(TruncateBigIntToInt64)\
  explicit LTruncateBigIntToInt64(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MTruncateBigIntToInt64* mir() const { return mir_->toTruncateBigIntToInt64(); };\
};\
\
class LInt64ToBigInt : public LInstructionHelper<1, 1 * INT64_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(Int64ToBigInt)\
  explicit LInt64ToBigInt(const LInt64Allocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setInt64Operand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LInt64Allocation input() { return getInt64Operand(InputIndex); }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t InputIndex = 0;\
  MInt64ToBigInt* mir() const { return mir_->toInt64ToBigInt(); };\
};\
\
class LPostWriteBarrierO : public LInstructionHelper<0, 2, 1> {\
 public:\
  LIR_HEADER(PostWriteBarrierO)\
  explicit LPostWriteBarrierO(const LAllocation& object, const LAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* value() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteBarrier* mir() const { return mir_->toPostWriteBarrier(); };\
};\
\
class LPostWriteBarrierS : public LInstructionHelper<0, 2, 1> {\
 public:\
  LIR_HEADER(PostWriteBarrierS)\
  explicit LPostWriteBarrierS(const LAllocation& object, const LAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* value() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteBarrier* mir() const { return mir_->toPostWriteBarrier(); };\
};\
\
class LPostWriteBarrierBI : public LInstructionHelper<0, 2, 1> {\
 public:\
  LIR_HEADER(PostWriteBarrierBI)\
  explicit LPostWriteBarrierBI(const LAllocation& object, const LAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* value() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteBarrier* mir() const { return mir_->toPostWriteBarrier(); };\
};\
\
class LPostWriteBarrierV : public LInstructionHelper<0, 1 * BOX_PIECES + 1, 1> {\
 public:\
  LIR_HEADER(PostWriteBarrierV)\
  explicit LPostWriteBarrierV(const LAllocation& object, const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t ValueIndex = 1;\
  MPostWriteBarrier* mir() const { return mir_->toPostWriteBarrier(); };\
};\
\
class LPostWriteElementBarrierO : public LInstructionHelper<0, 3, 1> {\
 public:\
  LIR_HEADER(PostWriteElementBarrierO)\
  explicit LPostWriteElementBarrierO(const LAllocation& object, const LAllocation& value, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, value);\
    setOperand(2, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* value() { return getOperand(1); }\
  const LAllocation* index() { return getOperand(2); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteElementBarrier* mir() const { return mir_->toPostWriteElementBarrier(); };\
};\
\
class LPostWriteElementBarrierS : public LInstructionHelper<0, 3, 1> {\
 public:\
  LIR_HEADER(PostWriteElementBarrierS)\
  explicit LPostWriteElementBarrierS(const LAllocation& object, const LAllocation& value, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, value);\
    setOperand(2, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* value() { return getOperand(1); }\
  const LAllocation* index() { return getOperand(2); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteElementBarrier* mir() const { return mir_->toPostWriteElementBarrier(); };\
};\
\
class LPostWriteElementBarrierBI : public LInstructionHelper<0, 3, 1> {\
 public:\
  LIR_HEADER(PostWriteElementBarrierBI)\
  explicit LPostWriteElementBarrierBI(const LAllocation& object, const LAllocation& value, const LAllocation& index, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, value);\
    setOperand(2, index);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* value() { return getOperand(1); }\
  const LAllocation* index() { return getOperand(2); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MPostWriteElementBarrier* mir() const { return mir_->toPostWriteElementBarrier(); };\
};\
\
class LPostWriteElementBarrierV : public LInstructionHelper<0, 1 * BOX_PIECES + 2, 1> {\
 public:\
  LIR_HEADER(PostWriteElementBarrierV)\
  explicit LPostWriteElementBarrierV(const LAllocation& object, const LAllocation& index, const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, index);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t ValueIndex = 2;\
  MPostWriteElementBarrier* mir() const { return mir_->toPostWriteElementBarrier(); };\
};\
\
class LAssertCanElidePostWriteBarrier : public LInstructionHelper<0, 1 * BOX_PIECES + 1, 1> {\
 public:\
  LIR_HEADER(AssertCanElidePostWriteBarrier)\
  explicit LAssertCanElidePostWriteBarrier(const LAllocation& object, const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t ValueIndex = 1;\
};\
\
class LGuardObjectIdentity : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(GuardObjectIdentity)\
  explicit LGuardObjectIdentity(const LAllocation& input, const LAllocation& expected) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
    setOperand(1, expected);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  const LAllocation* expected() { return getOperand(1); }\
  MGuardObjectIdentity* mir() const { return mir_->toGuardObjectIdentity(); };\
};\
\
class LGuardSpecificFunction : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(GuardSpecificFunction)\
  explicit LGuardSpecificFunction(const LAllocation& input, const LAllocation& expected) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
    setOperand(1, expected);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  const LAllocation* expected() { return getOperand(1); }\
};\
\
class LGuardSpecificAtom : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardSpecificAtom)\
  explicit LGuardSpecificAtom(const LAllocation& str, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, str);\
    setTemp(0, temp0);\
  }\
  const LAllocation* str() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardSpecificAtom* mir() const { return mir_->toGuardSpecificAtom(); };\
};\
\
class LGuardSpecificSymbol : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardSpecificSymbol)\
  explicit LGuardSpecificSymbol(const LAllocation& symbol) : LInstructionHelper(classOpcode) {\
    setOperand(0, symbol);\
  }\
  const LAllocation* symbol() { return getOperand(0); }\
  MGuardSpecificSymbol* mir() const { return mir_->toGuardSpecificSymbol(); };\
};\
\
class LGuardSpecificInt32 : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardSpecificInt32)\
  explicit LGuardSpecificInt32(const LAllocation& num) : LInstructionHelper(classOpcode) {\
    setOperand(0, num);\
  }\
  const LAllocation* num() { return getOperand(0); }\
  MGuardSpecificInt32* mir() const { return mir_->toGuardSpecificInt32(); };\
};\
\
class LGuardStringToIndex : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(GuardStringToIndex)\
  explicit LGuardStringToIndex(const LAllocation& string) : LInstructionHelper(classOpcode) {\
    setOperand(0, string);\
  }\
  const LAllocation* string() { return getOperand(0); }\
};\
\
class LGuardStringToInt32 : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(GuardStringToInt32)\
  explicit LGuardStringToInt32(const LAllocation& string, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, string);\
    setTemp(0, temp0);\
  }\
  const LAllocation* string() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LGuardStringToDouble : public LInstructionHelper<1, 1, 2> {\
 public:\
  LIR_HEADER(GuardStringToDouble)\
  explicit LGuardStringToDouble(const LAllocation& string, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, string);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* string() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
\
class LGuardShape : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(GuardShape)\
  explicit LGuardShape(const LAllocation& in, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, in);\
    setTemp(0, temp0);\
  }\
  const LAllocation* in() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardShape* mir() const { return mir_->toGuardShape(); };\
};\
\
class LGuardMultipleShapes : public LInstructionHelper<1, 2, 4> {\
 public:\
  LIR_HEADER(GuardMultipleShapes)\
  explicit LGuardMultipleShapes(const LAllocation& object, const LAllocation& shapeList, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, shapeList);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* shapeList() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MGuardMultipleShapes* mir() const { return mir_->toGuardMultipleShapes(); };\
};\
\
class LGuardProto : public LInstructionHelper<0, 2, 1> {\
 public:\
  LIR_HEADER(GuardProto)\
  explicit LGuardProto(const LAllocation& object, const LAllocation& expected, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, expected);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* expected() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LGuardNullProto : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardNullProto)\
  explicit LGuardNullProto(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LGuardIsNativeObject : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsNativeObject)\
  explicit LGuardIsNativeObject(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LGuardGlobalGeneration : public LInstructionHelper<0, 0, 1> {\
 public:\
  LIR_HEADER(GuardGlobalGeneration)\
  explicit LGuardGlobalGeneration(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardGlobalGeneration* mir() const { return mir_->toGuardGlobalGeneration(); };\
};\
\
class LGuardIsProxy : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsProxy)\
  explicit LGuardIsProxy(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LGuardIsNotProxy : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsNotProxy)\
  explicit LGuardIsNotProxy(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LGuardIsNotDOMProxy : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsNotDOMProxy)\
  explicit LGuardIsNotDOMProxy(const LAllocation& proxy, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, proxy);\
    setTemp(0, temp0);\
  }\
  const LAllocation* proxy() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LProxyGet : public LInstructionHelper<BOX_PIECES, 1, 1> {\
 public:\
  LIR_HEADER(ProxyGet)\
  explicit LProxyGet(const LAllocation& proxy, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, proxy);\
    setTemp(0, temp0);\
  }\
  const LAllocation* proxy() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MProxyGet* mir() const { return mir_->toProxyGet(); };\
};\
\
class LProxyGetByValue : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(ProxyGetByValue)\
  explicit LProxyGetByValue(const LAllocation& proxy, const LBoxAllocation& id) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, proxy);\
    setBoxOperand(IdIndex, id);\
  }\
  const LAllocation* proxy() { return getOperand(0); }\
  static const size_t IdIndex = 1;\
};\
\
class LProxyHasProp : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(ProxyHasProp)\
  explicit LProxyHasProp(const LAllocation& proxy, const LBoxAllocation& id) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, proxy);\
    setBoxOperand(IdIndex, id);\
  }\
  const LAllocation* proxy() { return getOperand(0); }\
  static const size_t IdIndex = 1;\
  MProxyHasProp* mir() const { return mir_->toProxyHasProp(); };\
};\
\
class LProxySet : public LInstructionHelper<0, 1 * BOX_PIECES + 1, 1> {\
 public:\
  LIR_HEADER(ProxySet)\
  explicit LProxySet(const LAllocation& proxy, const LBoxAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, proxy);\
    setBoxOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* proxy() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t RhsIndex = 1;\
  MProxySet* mir() const { return mir_->toProxySet(); };\
};\
\
class LProxySetByValue : public LInstructionHelper<0, 2 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(ProxySetByValue)\
  explicit LProxySetByValue(const LAllocation& proxy, const LBoxAllocation& id, const LBoxAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, proxy);\
    setBoxOperand(IdIndex, id);\
    setBoxOperand(RhsIndex, rhs);\
  }\
  const LAllocation* proxy() { return getOperand(0); }\
  static const size_t IdIndex = 1;\
\
  static const size_t RhsIndex = 1 + BOX_PIECES * 1;\
  MProxySetByValue* mir() const { return mir_->toProxySetByValue(); };\
};\
\
class LCallSetArrayLength : public LInstructionHelper<0, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(CallSetArrayLength)\
  explicit LCallSetArrayLength(const LAllocation& obj, const LBoxAllocation& rhs) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, obj);\
    setBoxOperand(RhsIndex, rhs);\
  }\
  const LAllocation* obj() { return getOperand(0); }\
  static const size_t RhsIndex = 1;\
  MCallSetArrayLength* mir() const { return mir_->toCallSetArrayLength(); };\
};\
\
class LMegamorphicLoadSlot : public LInstructionHelper<BOX_PIECES, 1, 4> {\
 public:\
  LIR_HEADER(MegamorphicLoadSlot)\
  explicit LMegamorphicLoadSlot(const LAllocation& object, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  MMegamorphicLoadSlot* mir() const { return mir_->toMegamorphicLoadSlot(); };\
};\
\
class LMegamorphicLoadSlotByValue : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 1, 3> {\
 public:\
  LIR_HEADER(MegamorphicLoadSlotByValue)\
  explicit LMegamorphicLoadSlotByValue(const LAllocation& object, const LBoxAllocation& id, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setBoxOperand(IdIndex, id);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  static const size_t IdIndex = 1;\
  MMegamorphicLoadSlotByValue* mir() const { return mir_->toMegamorphicLoadSlotByValue(); };\
};\
\
class LMegamorphicStoreSlot : public LInstructionHelper<0, 1 * BOX_PIECES + 1, 3> {\
 public:\
  LIR_HEADER(MegamorphicStoreSlot)\
  explicit LMegamorphicStoreSlot(const LAllocation& object, const LBoxAllocation& rhs, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setBoxOperand(RhsIndex, rhs);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  static const size_t RhsIndex = 1;\
  MMegamorphicStoreSlot* mir() const { return mir_->toMegamorphicStoreSlot(); };\
};\
\
class LMegamorphicHasProp : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 3> {\
 public:\
  LIR_HEADER(MegamorphicHasProp)\
  explicit LMegamorphicHasProp(const LAllocation& object, const LBoxAllocation& id, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setBoxOperand(IdIndex, id);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  static const size_t IdIndex = 1;\
  MMegamorphicHasProp* mir() const { return mir_->toMegamorphicHasProp(); };\
};\
\
class LGuardIsNotArrayBufferMaybeShared : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsNotArrayBufferMaybeShared)\
  explicit LGuardIsNotArrayBufferMaybeShared(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LGuardIsTypedArray : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsTypedArray)\
  explicit LGuardIsTypedArray(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LGuardNoDenseElements : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardNoDenseElements)\
  explicit LGuardNoDenseElements(const LAllocation& in, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, in);\
    setTemp(0, temp0);\
  }\
  const LAllocation* in() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LInCache : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 1> {\
 public:\
  LIR_HEADER(InCache)\
  explicit LInCache(const LBoxAllocation& lhs, const LAllocation& rhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(LhsIndex, lhs);\
    setOperand(0, rhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* rhs() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t LhsIndex = 1;\
  MInCache* mir() const { return mir_->toInCache(); };\
};\
\
class LHasOwnCache : public LInstructionHelper<1, 2 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(HasOwnCache)\
  explicit LHasOwnCache(const LBoxAllocation& value, const LBoxAllocation& id) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setBoxOperand(IdIndex, id);\
  }\
\
  static const size_t ValueIndex = 0;\
\
  static const size_t IdIndex = 0 + BOX_PIECES * 1;\
  MHasOwnCache* mir() const { return mir_->toHasOwnCache(); };\
};\
\
class LCheckPrivateFieldCache : public LInstructionHelper<1, 2 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(CheckPrivateFieldCache)\
  explicit LCheckPrivateFieldCache(const LBoxAllocation& value, const LBoxAllocation& id) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setBoxOperand(IdIndex, id);\
  }\
\
  static const size_t ValueIndex = 0;\
\
  static const size_t IdIndex = 0 + BOX_PIECES * 1;\
  MCheckPrivateFieldCache* mir() const { return mir_->toCheckPrivateFieldCache(); };\
};\
\
class LNewPrivateName : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(NewPrivateName)\
  explicit LNewPrivateName() : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
\
  }\
\
  MNewPrivateName* mir() const { return mir_->toNewPrivateName(); };\
};\
\
class LInstanceOfO : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(InstanceOfO)\
  explicit LInstanceOfO(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setOperand(0, lhs);\
    setOperand(1, rhs);\
  }\
  const LAllocation* lhs() { return getOperand(0); }\
  const LAllocation* rhs() { return getOperand(1); }\
  MInstanceOf* mir() const { return mir_->toInstanceOf(); };\
};\
\
class LInstanceOfV : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(InstanceOfV)\
  explicit LInstanceOfV(const LBoxAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setBoxOperand(LhsIndex, lhs);\
    setOperand(0, rhs);\
  }\
  const LAllocation* rhs() { return getOperand(0); }\
  static const size_t LhsIndex = 1;\
  MInstanceOf* mir() const { return mir_->toInstanceOf(); };\
};\
\
class LIsCallableO : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsCallableO)\
  explicit LIsCallableO(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  MIsCallable* mir() const { return mir_->toIsCallable(); };\
};\
\
class LIsCallableV : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(IsCallableV)\
  explicit LIsCallableV(const LBoxAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ObjectIndex, object);\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t ObjectIndex = 0;\
  MIsCallable* mir() const { return mir_->toIsCallable(); };\
};\
\
class LIsConstructor : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsConstructor)\
  explicit LIsConstructor(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  MIsConstructor* mir() const { return mir_->toIsConstructor(); };\
};\
\
class LIsCrossRealmArrayConstructor : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsCrossRealmArrayConstructor)\
  explicit LIsCrossRealmArrayConstructor(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
};\
\
class LIsArrayO : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsArrayO)\
  explicit LIsArrayO(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  MIsArray* mir() const { return mir_->toIsArray(); };\
};\
\
class LIsArrayV : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(IsArrayV)\
  explicit LIsArrayV(const LBoxAllocation& value, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t ValueIndex = 0;\
  MIsArray* mir() const { return mir_->toIsArray(); };\
};\
\
class LIsTypedArray : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsTypedArray)\
  explicit LIsTypedArray(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  MIsTypedArray* mir() const { return mir_->toIsTypedArray(); };\
};\
\
class LIsObject : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(IsObject)\
  explicit LIsObject(const LBoxAllocation& object) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ObjectIndex, object);\
  }\
\
  static const size_t ObjectIndex = 0;\
  MIsObject* mir() const { return mir_->toIsObject(); };\
};\
\
class LIsNullOrUndefined : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(IsNullOrUndefined)\
  explicit LIsNullOrUndefined(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
\
  static const size_t InputIndex = 0;\
  MIsNullOrUndefined* mir() const { return mir_->toIsNullOrUndefined(); };\
};\
\
class LHasClass : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(HasClass)\
  explicit LHasClass(const LAllocation& lhs) : LInstructionHelper(classOpcode) {\
    setOperand(0, lhs);\
  }\
  const LAllocation* lhs() { return getOperand(0); }\
  MHasClass* mir() const { return mir_->toHasClass(); };\
};\
\
class LGuardToClass : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(GuardToClass)\
  explicit LGuardToClass(const LAllocation& lhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, lhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardToClass* mir() const { return mir_->toGuardToClass(); };\
};\
\
class LGuardToFunction : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(GuardToFunction)\
  explicit LGuardToFunction(const LAllocation& lhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, lhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardToFunction* mir() const { return mir_->toGuardToFunction(); };\
};\
\
class LObjectClassToString : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(ObjectClassToString)\
  explicit LObjectClassToString(const LAllocation& lhs, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, lhs);\
    setTemp(0, temp0);\
  }\
  const LAllocation* lhs() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MObjectClassToString* mir() const { return mir_->toObjectClassToString(); };\
};\
\
class LWasmAddOffset : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmAddOffset)\
  explicit LWasmAddOffset(const LAllocation& base) : LInstructionHelper(classOpcode) {\
    setOperand(0, base);\
  }\
  const LAllocation* base() { return getOperand(0); }\
  MWasmAddOffset* mir() const { return mir_->toWasmAddOffset(); };\
};\
\
class LWasmAddOffset64 : public LInstructionHelper<INT64_PIECES, 1 * INT64_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(WasmAddOffset64)\
  explicit LWasmAddOffset64(const LInt64Allocation& base) : LInstructionHelper(classOpcode) {\
    setInt64Operand(BaseIndex, base);\
  }\
  const LInt64Allocation base() { return getInt64Operand(BaseIndex); }\
  static const size_t BaseIndex = 0;\
  MWasmAddOffset* mir() const { return mir_->toWasmAddOffset(); };\
};\
\
class LWasmBoundsCheck : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(WasmBoundsCheck)\
  explicit LWasmBoundsCheck(const LAllocation& ptr, const LAllocation& boundsCheckLimit) : LInstructionHelper(classOpcode) {\
    setOperand(0, ptr);\
    setOperand(1, boundsCheckLimit);\
  }\
  const LAllocation* ptr() { return getOperand(0); }\
  const LAllocation* boundsCheckLimit() { return getOperand(1); }\
  MWasmBoundsCheck* mir() const { return mir_->toWasmBoundsCheck(); };\
};\
\
class LWasmExtendU32Index : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmExtendU32Index)\
  explicit LWasmExtendU32Index(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MWasmExtendU32Index* mir() const { return mir_->toWasmExtendU32Index(); };\
};\
\
class LWasmWrapU32Index : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmWrapU32Index)\
  explicit LWasmWrapU32Index(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MWasmWrapU32Index* mir() const { return mir_->toWasmWrapU32Index(); };\
};\
\
class LWasmAlignmentCheck : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(WasmAlignmentCheck)\
  explicit LWasmAlignmentCheck(const LAllocation& ptr) : LInstructionHelper(classOpcode) {\
    setOperand(0, ptr);\
  }\
  const LAllocation* ptr() { return getOperand(0); }\
  MWasmAlignmentCheck* mir() const { return mir_->toWasmAlignmentCheck(); };\
};\
\
class LWasmAlignmentCheck64 : public LInstructionHelper<0, 1 * INT64_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(WasmAlignmentCheck64)\
  explicit LWasmAlignmentCheck64(const LInt64Allocation& ptr) : LInstructionHelper(classOpcode) {\
    setInt64Operand(PtrIndex, ptr);\
  }\
  const LInt64Allocation ptr() { return getInt64Operand(PtrIndex); }\
  static const size_t PtrIndex = 0;\
  MWasmAlignmentCheck* mir() const { return mir_->toWasmAlignmentCheck(); };\
};\
\
class LWasmLoadInstance : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmLoadInstance)\
  explicit LWasmLoadInstance(const LAllocation& instance) : LInstructionHelper(classOpcode) {\
    setOperand(0, instance);\
  }\
  const LAllocation* instance() { return getOperand(0); }\
  MWasmLoadInstance* mir() const { return mir_->toWasmLoadInstance(); };\
};\
\
class LWasmLoadInstance64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(WasmLoadInstance64)\
  explicit LWasmLoadInstance64(const LAllocation& instance) : LInstructionHelper(classOpcode) {\
    setOperand(0, instance);\
  }\
  const LAllocation* instance() { return getOperand(0); }\
  MWasmLoadInstance* mir() const { return mir_->toWasmLoadInstance(); };\
};\
\
class LWasmHeapBase : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmHeapBase)\
  explicit LWasmHeapBase(const LAllocation& instance) : LInstructionHelper(classOpcode) {\
    setOperand(0, instance);\
  }\
  const LAllocation* instance() { return getOperand(0); }\
  MWasmHeapBase* mir() const { return mir_->toWasmHeapBase(); };\
};\
\
class LAsmJSLoadHeap : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(AsmJSLoadHeap)\
  explicit LAsmJSLoadHeap(const LAllocation& ptr, const LAllocation& boundsCheckLimit, const LAllocation& memoryBase) : LInstructionHelper(classOpcode) {\
    setOperand(0, ptr);\
    setOperand(1, boundsCheckLimit);\
    setOperand(2, memoryBase);\
  }\
  const LAllocation* ptr() { return getOperand(0); }\
  const LAllocation* boundsCheckLimit() { return getOperand(1); }\
  const LAllocation* memoryBase() { return getOperand(2); }\
  MAsmJSLoadHeap* mir() const { return mir_->toAsmJSLoadHeap(); };\
};\
\
class LAsmJSStoreHeap : public LInstructionHelper<1, 4, 0> {\
 public:\
  LIR_HEADER(AsmJSStoreHeap)\
  explicit LAsmJSStoreHeap(const LAllocation& ptr, const LAllocation& value, const LAllocation& boundsCheckLimit, const LAllocation& memoryBase) : LInstructionHelper(classOpcode) {\
    setOperand(0, ptr);\
    setOperand(1, value);\
    setOperand(2, boundsCheckLimit);\
    setOperand(3, memoryBase);\
  }\
  const LAllocation* ptr() { return getOperand(0); }\
  const LAllocation* value() { return getOperand(1); }\
  const LAllocation* boundsCheckLimit() { return getOperand(2); }\
  const LAllocation* memoryBase() { return getOperand(3); }\
  MAsmJSStoreHeap* mir() const { return mir_->toAsmJSStoreHeap(); };\
};\
\
class LWasmFence : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(WasmFence)\
  explicit LWasmFence() : LInstructionHelper(classOpcode) {\
\
  }\
\
};\
\
class LWasmLoadSlot : public LInstructionHelper<1, 1, 0> {\
  size_t offset_;\
  MIRType type_;\
  MWideningOp wideningOp_;\
  MaybeTrapSiteInfo maybeTrap_;\
 public:\
  LIR_HEADER(WasmLoadSlot)\
  explicit LWasmLoadSlot(const LAllocation& containerRef, size_t offset, MIRType type, MWideningOp wideningOp, MaybeTrapSiteInfo maybeTrap) : LInstructionHelper(classOpcode), offset_(offset), type_(type), wideningOp_(wideningOp), maybeTrap_(maybeTrap) {\
    setOperand(0, containerRef);\
  }\
  const LAllocation* containerRef() { return getOperand(0); }  size_t offset() const { return offset_; }\
  MIRType type() const { return type_; }\
  MWideningOp wideningOp() const { return wideningOp_; }\
  MaybeTrapSiteInfo maybeTrap() const { return maybeTrap_; }\
\
};\
\
class LWasmLoadSlotI64 : public LInstructionHelper<INT64_PIECES, 1, 0> {\
  size_t offset_;\
  MaybeTrapSiteInfo maybeTrap_;\
 public:\
  LIR_HEADER(WasmLoadSlotI64)\
  explicit LWasmLoadSlotI64(const LAllocation& containerRef, size_t offset, MaybeTrapSiteInfo maybeTrap) : LInstructionHelper(classOpcode), offset_(offset), maybeTrap_(maybeTrap) {\
    setOperand(0, containerRef);\
  }\
  const LAllocation* containerRef() { return getOperand(0); }  size_t offset() const { return offset_; }\
  MaybeTrapSiteInfo maybeTrap() const { return maybeTrap_; }\
\
};\
\
class LWasmStoreSlot : public LInstructionHelper<0, 2, 0> {\
  size_t offset_;\
  MIRType type_;\
  MNarrowingOp narrowingOp_;\
  MaybeTrapSiteInfo maybeTrap_;\
 public:\
  LIR_HEADER(WasmStoreSlot)\
  explicit LWasmStoreSlot(const LAllocation& value, const LAllocation& containerRef, size_t offset, MIRType type, MNarrowingOp narrowingOp, MaybeTrapSiteInfo maybeTrap) : LInstructionHelper(classOpcode), offset_(offset), type_(type), narrowingOp_(narrowingOp), maybeTrap_(maybeTrap) {\
    setOperand(0, value);\
    setOperand(1, containerRef);\
  }\
  const LAllocation* value() { return getOperand(0); }\
  const LAllocation* containerRef() { return getOperand(1); }  size_t offset() const { return offset_; }\
  MIRType type() const { return type_; }\
  MNarrowingOp narrowingOp() const { return narrowingOp_; }\
  MaybeTrapSiteInfo maybeTrap() const { return maybeTrap_; }\
\
};\
\
class LWasmStoreSlotI64 : public LInstructionHelper<0, 1 * INT64_PIECES + 1, 0> {\
  size_t offset_;\
  MaybeTrapSiteInfo maybeTrap_;\
 public:\
  LIR_HEADER(WasmStoreSlotI64)\
  explicit LWasmStoreSlotI64(const LInt64Allocation& value, const LAllocation& containerRef, size_t offset, MaybeTrapSiteInfo maybeTrap) : LInstructionHelper(classOpcode), offset_(offset), maybeTrap_(maybeTrap) {\
    setInt64Operand(ValueIndex, value);\
    setOperand(0, containerRef);\
  }\
  const LInt64Allocation value() { return getInt64Operand(ValueIndex); }\
  const LAllocation* containerRef() { return getOperand(0); }  size_t offset() const { return offset_; }\
  MaybeTrapSiteInfo maybeTrap() const { return maybeTrap_; }\
\
  static const size_t ValueIndex = 1;\
};\
\
class LWasmLoadTableElement : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(WasmLoadTableElement)\
  explicit LWasmLoadTableElement(const LAllocation& elements, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(0, elements);\
    setOperand(1, index);\
  }\
  const LAllocation* elements() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
};\
\
class LWasmStoreRef : public LInstructionHelper<0, 3, 1> {\
  uint32_t offset_;\
  MaybeTrapSiteInfo maybeTrap_;\
  WasmPreBarrierKind preBarrierKind_;\
 public:\
  LIR_HEADER(WasmStoreRef)\
  explicit LWasmStoreRef(const LAllocation& instance, const LAllocation& valueBase, const LAllocation& value, const LDefinition& temp0, uint32_t offset, MaybeTrapSiteInfo maybeTrap, WasmPreBarrierKind preBarrierKind) : LInstructionHelper(classOpcode), offset_(offset), maybeTrap_(maybeTrap), preBarrierKind_(preBarrierKind) {\
    setOperand(0, instance);\
    setOperand(1, valueBase);\
    setOperand(2, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* instance() { return getOperand(0); }\
  const LAllocation* valueBase() { return getOperand(1); }\
  const LAllocation* value() { return getOperand(2); }\
  const LDefinition* temp0() { return getTemp(0); }  uint32_t offset() const { return offset_; }\
  MaybeTrapSiteInfo maybeTrap() const { return maybeTrap_; }\
  WasmPreBarrierKind preBarrierKind() const { return preBarrierKind_; }\
\
  MWasmStoreRef* mir() const { return mir_->toWasmStoreRef(); };\
};\
\
class LWasmPostWriteBarrier : public LInstructionHelper<0, 4, 1> {\
  uint32_t valueOffset_;\
 public:\
  LIR_HEADER(WasmPostWriteBarrier)\
  explicit LWasmPostWriteBarrier(const LAllocation& instance, const LAllocation& object, const LAllocation& valueBase, const LAllocation& value, const LDefinition& temp0, uint32_t valueOffset) : LInstructionHelper(classOpcode), valueOffset_(valueOffset) {\
    setOperand(0, instance);\
    setOperand(1, object);\
    setOperand(2, valueBase);\
    setOperand(3, value);\
    setTemp(0, temp0);\
  }\
  const LAllocation* instance() { return getOperand(0); }\
  const LAllocation* object() { return getOperand(1); }\
  const LAllocation* valueBase() { return getOperand(2); }\
  const LAllocation* value() { return getOperand(3); }\
  const LDefinition* temp0() { return getTemp(0); }  uint32_t valueOffset() const { return valueOffset_; }\
\
  MWasmPostWriteBarrier* mir() const { return mir_->toWasmPostWriteBarrier(); };\
};\
\
class LWasmParameter : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(WasmParameter)\
  explicit LWasmParameter() : LInstructionHelper(classOpcode) {\
\
  }\
\
};\
\
class LWasmReturn : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(WasmReturn)\
  explicit LWasmReturn(const LAllocation& rval, const LAllocation& instance) : LInstructionHelper(classOpcode) {\
    setOperand(0, rval);\
    setOperand(1, instance);\
  }\
  const LAllocation* rval() { return getOperand(0); }\
  const LAllocation* instance() { return getOperand(1); }\
};\
\
class LWasmReturnI64 : public LInstructionHelper<0, 1 * INT64_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(WasmReturnI64)\
  explicit LWasmReturnI64(const LInt64Allocation& rval, const LAllocation& instance) : LInstructionHelper(classOpcode) {\
    setInt64Operand(RvalIndex, rval);\
    setOperand(0, instance);\
  }\
  const LInt64Allocation rval() { return getInt64Operand(RvalIndex); }\
  const LAllocation* instance() { return getOperand(0); }\
  static const size_t RvalIndex = 1;\
};\
\
class LWasmReturnVoid : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(WasmReturnVoid)\
  explicit LWasmReturnVoid(const LAllocation& rval) : LInstructionHelper(classOpcode) {\
    setOperand(0, rval);\
  }\
  const LAllocation* rval() { return getOperand(0); }\
};\
\
class LWasmStackArg : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(WasmStackArg)\
  explicit LWasmStackArg(const LAllocation& arg) : LInstructionHelper(classOpcode) {\
    setOperand(0, arg);\
  }\
  const LAllocation* arg() { return getOperand(0); }\
  MWasmStackArg* mir() const { return mir_->toWasmStackArg(); };\
};\
\
class LWasmStackArgI64 : public LInstructionHelper<0, 1 * INT64_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(WasmStackArgI64)\
  explicit LWasmStackArgI64(const LInt64Allocation& arg) : LInstructionHelper(classOpcode) {\
    setInt64Operand(ArgIndex, arg);\
  }\
  const LInt64Allocation arg() { return getInt64Operand(ArgIndex); }\
  static const size_t ArgIndex = 0;\
  MWasmStackArg* mir() const { return mir_->toWasmStackArg(); };\
};\
\
class LWasmNullConstant : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(WasmNullConstant)\
  explicit LWasmNullConstant() : LInstructionHelper(classOpcode) {\
\
  }\
\
};\
\
class LWasmCallLandingPrePad : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(WasmCallLandingPrePad)\
  explicit LWasmCallLandingPrePad() : LInstructionHelper(classOpcode) {\
\
  }\
\
  MWasmCallLandingPrePad* mir() const { return mir_->toWasmCallLandingPrePad(); };\
};\
\
class LWasmStackResultArea : public LInstructionHelper<1, 0, 1> {\
 public:\
  LIR_HEADER(WasmStackResultArea)\
  explicit LWasmStackResultArea(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MWasmStackResultArea* mir() const { return mir_->toWasmStackResultArea(); };\
};\
\
class LAssertClass : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(AssertClass)\
  explicit LAssertClass(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MAssertClass* mir() const { return mir_->toAssertClass(); };\
};\
\
class LAssertShape : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(AssertShape)\
  explicit LAssertShape(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MAssertShape* mir() const { return mir_->toAssertShape(); };\
};\
\
class LGuardValue : public LInstructionHelper<0, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(GuardValue)\
  explicit LGuardValue(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
\
  static const size_t InputIndex = 0;\
  MGuardValue* mir() const { return mir_->toGuardValue(); };\
};\
\
class LGuardNullOrUndefined : public LInstructionHelper<0, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(GuardNullOrUndefined)\
  explicit LGuardNullOrUndefined(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
\
  static const size_t InputIndex = 0;\
  MGuardNullOrUndefined* mir() const { return mir_->toGuardNullOrUndefined(); };\
};\
\
class LGuardIsNotObject : public LInstructionHelper<0, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(GuardIsNotObject)\
  explicit LGuardIsNotObject(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
\
  static const size_t InputIndex = 0;\
  MGuardIsNotObject* mir() const { return mir_->toGuardIsNotObject(); };\
};\
\
class LGuardFunctionFlags : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardFunctionFlags)\
  explicit LGuardFunctionFlags(const LAllocation& function) : LInstructionHelper(classOpcode) {\
    setOperand(0, function);\
  }\
  const LAllocation* function() { return getOperand(0); }\
  MGuardFunctionFlags* mir() const { return mir_->toGuardFunctionFlags(); };\
};\
\
class LGuardFunctionIsNonBuiltinCtor : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardFunctionIsNonBuiltinCtor)\
  explicit LGuardFunctionIsNonBuiltinCtor(const LAllocation& function, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, function);\
    setTemp(0, temp0);\
  }\
  const LAllocation* function() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LGuardFunctionKind : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardFunctionKind)\
  explicit LGuardFunctionKind(const LAllocation& function, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, function);\
    setTemp(0, temp0);\
  }\
  const LAllocation* function() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  MGuardFunctionKind* mir() const { return mir_->toGuardFunctionKind(); };\
};\
\
class LGuardFunctionScript : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardFunctionScript)\
  explicit LGuardFunctionScript(const LAllocation& function) : LInstructionHelper(classOpcode) {\
    setOperand(0, function);\
  }\
  const LAllocation* function() { return getOperand(0); }\
  MGuardFunctionScript* mir() const { return mir_->toGuardFunctionScript(); };\
};\
\
class LIncrementWarmUpCounter : public LInstructionHelper<0, 0, 1> {\
 public:\
  LIR_HEADER(IncrementWarmUpCounter)\
  explicit LIncrementWarmUpCounter(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  MIncrementWarmUpCounter* mir() const { return mir_->toIncrementWarmUpCounter(); };\
};\
\
class LLexicalCheck : public LInstructionHelper<0, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(LexicalCheck)\
  explicit LLexicalCheck(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
\
  static const size_t InputIndex = 0;\
  MLexicalCheck* mir() const { return mir_->toLexicalCheck(); };\
};\
\
class LThrowRuntimeLexicalError : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(ThrowRuntimeLexicalError)\
  explicit LThrowRuntimeLexicalError() : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
\
  }\
\
  MThrowRuntimeLexicalError* mir() const { return mir_->toThrowRuntimeLexicalError(); };\
};\
\
class LThrowMsg : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(ThrowMsg)\
  explicit LThrowMsg() : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
\
  }\
\
  MThrowMsg* mir() const { return mir_->toThrowMsg(); };\
};\
\
class LGlobalDeclInstantiation : public LInstructionHelper<0, 0, 0> {\
 public:\
  LIR_HEADER(GlobalDeclInstantiation)\
  explicit LGlobalDeclInstantiation() : LInstructionHelper(classOpcode) {\
\
  }\
\
  MGlobalDeclInstantiation* mir() const { return mir_->toGlobalDeclInstantiation(); };\
};\
\
class LDebugger : public LInstructionHelper<0, 0, 1> {\
 public:\
  LIR_HEADER(Debugger)\
  explicit LDebugger(const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LNewTarget : public LInstructionHelper<BOX_PIECES, 0, 0> {\
 public:\
  LIR_HEADER(NewTarget)\
  explicit LNewTarget() : LInstructionHelper(classOpcode) {\
\
  }\
\
};\
\
class LCheckReturn : public LInstructionHelper<BOX_PIECES, 2 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(CheckReturn)\
  explicit LCheckReturn(const LBoxAllocation& returnValue, const LBoxAllocation& thisValue) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ReturnValueIndex, returnValue);\
    setBoxOperand(ThisValueIndex, thisValue);\
  }\
\
  static const size_t ReturnValueIndex = 0;\
\
  static const size_t ThisValueIndex = 0 + BOX_PIECES * 1;\
};\
\
class LCheckIsObj : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(CheckIsObj)\
  explicit LCheckIsObj(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
\
  static const size_t ValueIndex = 0;\
  MCheckIsObj* mir() const { return mir_->toCheckIsObj(); };\
};\
\
class LCheckObjCoercible : public LInstructionHelper<0, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(CheckObjCoercible)\
  explicit LCheckObjCoercible(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
\
  static const size_t ValueIndex = 0;\
};\
\
class LCheckClassHeritage : public LInstructionHelper<0, 1 * BOX_PIECES + 0, 2> {\
 public:\
  LIR_HEADER(CheckClassHeritage)\
  explicit LCheckClassHeritage(const LBoxAllocation& heritage, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setBoxOperand(HeritageIndex, heritage);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  static const size_t HeritageIndex = 0;\
};\
\
class LCheckThis : public LInstructionHelper<0, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(CheckThis)\
  explicit LCheckThis(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
\
  static const size_t ValueIndex = 0;\
};\
\
class LCheckThisReinit : public LInstructionHelper<0, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(CheckThisReinit)\
  explicit LCheckThisReinit(const LBoxAllocation& thisValue) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ThisValueIndex, thisValue);\
  }\
\
  static const size_t ThisValueIndex = 0;\
};\
\
class LGenerator : public LInstructionHelper<1, 3, 0> {\
 public:\
  LIR_HEADER(Generator)\
  explicit LGenerator(const LAllocation& callee, const LAllocation& environmentChain, const LAllocation& argsObject) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, callee);\
    setOperand(1, environmentChain);\
    setOperand(2, argsObject);\
  }\
  const LAllocation* callee() { return getOperand(0); }\
  const LAllocation* environmentChain() { return getOperand(1); }\
  const LAllocation* argsObject() { return getOperand(2); }\
  MGenerator* mir() const { return mir_->toGenerator(); };\
};\
\
class LAsyncResolve : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(AsyncResolve)\
  explicit LAsyncResolve(const LAllocation& generator, const LBoxAllocation& valueOrReason) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, generator);\
    setBoxOperand(ValueOrReasonIndex, valueOrReason);\
  }\
  const LAllocation* generator() { return getOperand(0); }\
  static const size_t ValueOrReasonIndex = 1;\
  MAsyncResolve* mir() const { return mir_->toAsyncResolve(); };\
};\
\
class LAsyncAwait : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(AsyncAwait)\
  explicit LAsyncAwait(const LBoxAllocation& value, const LAllocation& generator) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
    setOperand(0, generator);\
  }\
  const LAllocation* generator() { return getOperand(0); }\
  static const size_t ValueIndex = 1;\
  MAsyncAwait* mir() const { return mir_->toAsyncAwait(); };\
};\
\
class LCanSkipAwait : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(CanSkipAwait)\
  explicit LCanSkipAwait(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
  }\
\
  static const size_t ValueIndex = 0;\
  MCanSkipAwait* mir() const { return mir_->toCanSkipAwait(); };\
};\
\
class LMaybeExtractAwaitValue : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(MaybeExtractAwaitValue)\
  explicit LMaybeExtractAwaitValue(const LBoxAllocation& value, const LAllocation& canSkip) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
    setOperand(0, canSkip);\
  }\
  const LAllocation* canSkip() { return getOperand(0); }\
  static const size_t ValueIndex = 1;\
  MMaybeExtractAwaitValue* mir() const { return mir_->toMaybeExtractAwaitValue(); };\
};\
\
class LDebugCheckSelfHosted : public LInstructionHelper<0, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(DebugCheckSelfHosted)\
  explicit LDebugCheckSelfHosted(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(ValueIndex, value);\
  }\
\
  static const size_t ValueIndex = 0;\
};\
\
class LIsPackedArray : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(IsPackedArray)\
  explicit LIsPackedArray(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LGuardArrayIsPacked : public LInstructionHelper<0, 1, 2> {\
 public:\
  LIR_HEADER(GuardArrayIsPacked)\
  explicit LGuardArrayIsPacked(const LAllocation& array, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, array);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* array() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  MGuardArrayIsPacked* mir() const { return mir_->toGuardArrayIsPacked(); };\
};\
\
class LGetPrototypeOf : public LInstructionHelper<BOX_PIECES, 1, 0> {\
 public:\
  LIR_HEADER(GetPrototypeOf)\
  explicit LGetPrototypeOf(const LAllocation& target) : LInstructionHelper(classOpcode) {\
    setOperand(0, target);\
  }\
  const LAllocation* target() { return getOperand(0); }\
};\
\
class LObjectWithProto : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(ObjectWithProto)\
  explicit LObjectWithProto(const LBoxAllocation& prototype) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setBoxOperand(PrototypeIndex, prototype);\
  }\
\
  static const size_t PrototypeIndex = 0;\
};\
\
class LObjectStaticProto : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ObjectStaticProto)\
  explicit LObjectStaticProto(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
};\
\
class LBuiltinObject : public LInstructionHelper<1, 0, 0> {\
 public:\
  LIR_HEADER(BuiltinObject)\
  explicit LBuiltinObject() : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
\
  }\
\
  MBuiltinObject* mir() const { return mir_->toBuiltinObject(); };\
};\
\
class LSuperFunction : public LInstructionHelper<BOX_PIECES, 1, 1> {\
 public:\
  LIR_HEADER(SuperFunction)\
  explicit LSuperFunction(const LAllocation& callee, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, callee);\
    setTemp(0, temp0);\
  }\
  const LAllocation* callee() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LInitHomeObject : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(InitHomeObject)\
  explicit LInitHomeObject(const LAllocation& function, const LBoxAllocation& homeObject) : LInstructionHelper(classOpcode) {\
    setOperand(0, function);\
    setBoxOperand(HomeObjectIndex, homeObject);\
  }\
  const LAllocation* function() { return getOperand(0); }\
  static const size_t HomeObjectIndex = 1;\
};\
\
class LIsTypedArrayConstructor : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(IsTypedArrayConstructor)\
  explicit LIsTypedArrayConstructor(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
};\
\
class LLoadValueTag : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(LoadValueTag)\
  explicit LLoadValueTag(const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    setBoxOperand(ValueIndex, value);\
  }\
\
  static const size_t ValueIndex = 0;\
};\
\
class LGuardTagNotEqual : public LInstructionHelper<0, 2, 0> {\
 public:\
  LIR_HEADER(GuardTagNotEqual)\
  explicit LGuardTagNotEqual(const LAllocation& lhs, const LAllocation& rhs) : LInstructionHelper(classOpcode) {\
    setOperand(0, lhs);\
    setOperand(1, rhs);\
  }\
  const LAllocation* lhs() { return getOperand(0); }\
  const LAllocation* rhs() { return getOperand(1); }\
};\
\
class LLoadWrapperTarget : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(LoadWrapperTarget)\
  explicit LLoadWrapperTarget(const LAllocation& object) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
  }\
  const LAllocation* object() { return getOperand(0); }\
};\
\
class LGuardHasGetterSetter : public LInstructionHelper<0, 1, 3> {\
 public:\
  LIR_HEADER(GuardHasGetterSetter)\
  explicit LGuardHasGetterSetter(const LAllocation& object, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  MGuardHasGetterSetter* mir() const { return mir_->toGuardHasGetterSetter(); };\
};\
\
class LGuardIsExtensible : public LInstructionHelper<0, 1, 1> {\
 public:\
  LIR_HEADER(GuardIsExtensible)\
  explicit LGuardIsExtensible(const LAllocation& object, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setTemp(0, temp0);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LGuardInt32IsNonNegative : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardInt32IsNonNegative)\
  explicit LGuardInt32IsNonNegative(const LAllocation& index) : LInstructionHelper(classOpcode) {\
    setOperand(0, index);\
  }\
  const LAllocation* index() { return getOperand(0); }\
};\
\
class LGuardInt32Range : public LInstructionHelper<0, 1, 0> {\
 public:\
  LIR_HEADER(GuardInt32Range)\
  explicit LGuardInt32Range(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  MGuardInt32Range* mir() const { return mir_->toGuardInt32Range(); };\
};\
\
class LGuardIndexIsNotDenseElement : public LInstructionHelper<0, 2, 2> {\
 public:\
  LIR_HEADER(GuardIndexIsNotDenseElement)\
  explicit LGuardIndexIsNotDenseElement(const LAllocation& object, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
\
class LGuardIndexIsValidUpdateOrAdd : public LInstructionHelper<0, 2, 2> {\
 public:\
  LIR_HEADER(GuardIndexIsValidUpdateOrAdd)\
  explicit LGuardIndexIsValidUpdateOrAdd(const LAllocation& object, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, object);\
    setOperand(1, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
\
class LCallAddOrUpdateSparseElement : public LInstructionHelper<0, 1 * BOX_PIECES + 2, 0> {\
 public:\
  LIR_HEADER(CallAddOrUpdateSparseElement)\
  explicit LCallAddOrUpdateSparseElement(const LAllocation& object, const LAllocation& index, const LBoxAllocation& value) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setOperand(1, index);\
    setBoxOperand(ValueIndex, value);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  static const size_t ValueIndex = 2;\
  MCallAddOrUpdateSparseElement* mir() const { return mir_->toCallAddOrUpdateSparseElement(); };\
};\
\
class LCallGetSparseElement : public LInstructionHelper<BOX_PIECES, 2, 0> {\
 public:\
  LIR_HEADER(CallGetSparseElement)\
  explicit LCallGetSparseElement(const LAllocation& object, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setOperand(1, index);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
};\
\
class LCallNativeGetElement : public LInstructionHelper<BOX_PIECES, 2, 0> {\
 public:\
  LIR_HEADER(CallNativeGetElement)\
  explicit LCallNativeGetElement(const LAllocation& object, const LAllocation& index) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setOperand(1, index);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
};\
\
class LCallNativeGetElementSuper : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 2, 0> {\
 public:\
  LIR_HEADER(CallNativeGetElementSuper)\
  explicit LCallNativeGetElementSuper(const LAllocation& object, const LAllocation& index, const LBoxAllocation& receiver) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setOperand(1, index);\
    setBoxOperand(ReceiverIndex, receiver);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  static const size_t ReceiverIndex = 2;\
};\
\
class LCallObjectHasSparseElement : public LInstructionHelper<1, 2, 2> {\
 public:\
  LIR_HEADER(CallObjectHasSparseElement)\
  explicit LCallObjectHasSparseElement(const LAllocation& object, const LAllocation& index, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, object);\
    setOperand(1, index);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* object() { return getOperand(0); }\
  const LAllocation* index() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
};\
\
class LBigIntAsIntN : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntAsIntN)\
  explicit LBigIntAsIntN(const LAllocation& bits, const LAllocation& input) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, bits);\
    setOperand(1, input);\
  }\
  const LAllocation* bits() { return getOperand(0); }\
  const LAllocation* input() { return getOperand(1); }\
};\
\
class LGuardNonGCThing : public LInstructionHelper<0, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(GuardNonGCThing)\
  explicit LGuardNonGCThing(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
\
  static const size_t InputIndex = 0;\
};\
\
class LToHashableNonGCThing : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(ToHashableNonGCThing)\
  explicit LToHashableNonGCThing(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t InputIndex = 0;\
};\
\
class LToHashableString : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(ToHashableString)\
  explicit LToHashableString(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
};\
\
class LToHashableValue : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(ToHashableValue)\
  explicit LToHashableValue(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t InputIndex = 0;\
};\
\
class LHashNonGCThing : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 1> {\
 public:\
  LIR_HEADER(HashNonGCThing)\
  explicit LHashNonGCThing(const LBoxAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
  }\
  const LDefinition* temp0() { return getTemp(0); }\
  static const size_t InputIndex = 0;\
};\
\
class LHashString : public LInstructionHelper<1, 1, 1> {\
 public:\
  LIR_HEADER(HashString)\
  explicit LHashString(const LAllocation& input, const LDefinition& temp0) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
    setTemp(0, temp0);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
};\
\
class LHashSymbol : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(HashSymbol)\
  explicit LHashSymbol(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
};\
\
class LHashBigInt : public LInstructionHelper<1, 1, 3> {\
 public:\
  LIR_HEADER(HashBigInt)\
  explicit LHashBigInt(const LAllocation& input, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
  }\
  const LAllocation* input() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
};\
\
class LHashObject : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 4> {\
 public:\
  LIR_HEADER(HashObject)\
  explicit LHashObject(const LAllocation& setObject, const LBoxAllocation& input, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(0, setObject);\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* setObject() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  static const size_t InputIndex = 1;\
};\
\
class LHashValue : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 4> {\
 public:\
  LIR_HEADER(HashValue)\
  explicit LHashValue(const LAllocation& setObject, const LBoxAllocation& input, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(0, setObject);\
    setBoxOperand(InputIndex, input);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* setObject() { return getOperand(0); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  static const size_t InputIndex = 1;\
};\
\
class LSetObjectHasNonBigInt : public LInstructionHelper<1, 1 * BOX_PIECES + 2, 2> {\
 public:\
  LIR_HEADER(SetObjectHasNonBigInt)\
  explicit LSetObjectHasNonBigInt(const LAllocation& setObject, const LBoxAllocation& input, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, setObject);\
    setBoxOperand(InputIndex, input);\
    setOperand(1, hash);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* setObject() { return getOperand(0); }\
  const LAllocation* hash() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  static const size_t InputIndex = 2;\
};\
\
class LSetObjectHasBigInt : public LInstructionHelper<1, 1 * BOX_PIECES + 2, 4> {\
 public:\
  LIR_HEADER(SetObjectHasBigInt)\
  explicit LSetObjectHasBigInt(const LAllocation& setObject, const LBoxAllocation& input, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(0, setObject);\
    setBoxOperand(InputIndex, input);\
    setOperand(1, hash);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* setObject() { return getOperand(0); }\
  const LAllocation* hash() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  static const size_t InputIndex = 2;\
};\
\
class LSetObjectHasValue : public LInstructionHelper<1, 1 * BOX_PIECES + 2, 4> {\
 public:\
  LIR_HEADER(SetObjectHasValue)\
  explicit LSetObjectHasValue(const LAllocation& setObject, const LBoxAllocation& input, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(0, setObject);\
    setBoxOperand(InputIndex, input);\
    setOperand(1, hash);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* setObject() { return getOperand(0); }\
  const LAllocation* hash() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  static const size_t InputIndex = 2;\
};\
\
class LSetObjectHasValueVMCall : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(SetObjectHasValueVMCall)\
  explicit LSetObjectHasValueVMCall(const LAllocation& setObject, const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, setObject);\
    setBoxOperand(InputIndex, input);\
  }\
  const LAllocation* setObject() { return getOperand(0); }\
  static const size_t InputIndex = 1;\
};\
\
class LSetObjectSize : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(SetObjectSize)\
  explicit LSetObjectSize(const LAllocation& setObject) : LInstructionHelper(classOpcode) {\
    setOperand(0, setObject);\
  }\
  const LAllocation* setObject() { return getOperand(0); }\
};\
\
class LMapObjectHasNonBigInt : public LInstructionHelper<1, 1 * BOX_PIECES + 2, 2> {\
 public:\
  LIR_HEADER(MapObjectHasNonBigInt)\
  explicit LMapObjectHasNonBigInt(const LAllocation& mapObject, const LBoxAllocation& input, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, mapObject);\
    setBoxOperand(InputIndex, input);\
    setOperand(1, hash);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* mapObject() { return getOperand(0); }\
  const LAllocation* hash() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  static const size_t InputIndex = 2;\
};\
\
class LMapObjectHasBigInt : public LInstructionHelper<1, 1 * BOX_PIECES + 2, 4> {\
 public:\
  LIR_HEADER(MapObjectHasBigInt)\
  explicit LMapObjectHasBigInt(const LAllocation& mapObject, const LBoxAllocation& input, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(0, mapObject);\
    setBoxOperand(InputIndex, input);\
    setOperand(1, hash);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* mapObject() { return getOperand(0); }\
  const LAllocation* hash() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  static const size_t InputIndex = 2;\
};\
\
class LMapObjectHasValue : public LInstructionHelper<1, 1 * BOX_PIECES + 2, 4> {\
 public:\
  LIR_HEADER(MapObjectHasValue)\
  explicit LMapObjectHasValue(const LAllocation& mapObject, const LBoxAllocation& input, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(0, mapObject);\
    setBoxOperand(InputIndex, input);\
    setOperand(1, hash);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* mapObject() { return getOperand(0); }\
  const LAllocation* hash() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  static const size_t InputIndex = 2;\
};\
\
class LMapObjectHasValueVMCall : public LInstructionHelper<1, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(MapObjectHasValueVMCall)\
  explicit LMapObjectHasValueVMCall(const LAllocation& mapObject, const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, mapObject);\
    setBoxOperand(InputIndex, input);\
  }\
  const LAllocation* mapObject() { return getOperand(0); }\
  static const size_t InputIndex = 1;\
};\
\
class LMapObjectGetNonBigInt : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 2, 2> {\
 public:\
  LIR_HEADER(MapObjectGetNonBigInt)\
  explicit LMapObjectGetNonBigInt(const LAllocation& mapObject, const LBoxAllocation& input, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1) : LInstructionHelper(classOpcode) {\
    setOperand(0, mapObject);\
    setBoxOperand(InputIndex, input);\
    setOperand(1, hash);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
  }\
  const LAllocation* mapObject() { return getOperand(0); }\
  const LAllocation* hash() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  static const size_t InputIndex = 2;\
};\
\
class LMapObjectGetBigInt : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 2, 4> {\
 public:\
  LIR_HEADER(MapObjectGetBigInt)\
  explicit LMapObjectGetBigInt(const LAllocation& mapObject, const LBoxAllocation& input, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(0, mapObject);\
    setBoxOperand(InputIndex, input);\
    setOperand(1, hash);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* mapObject() { return getOperand(0); }\
  const LAllocation* hash() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  static const size_t InputIndex = 2;\
};\
\
class LMapObjectGetValue : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 2, 4> {\
 public:\
  LIR_HEADER(MapObjectGetValue)\
  explicit LMapObjectGetValue(const LAllocation& mapObject, const LBoxAllocation& input, const LAllocation& hash, const LDefinition& temp0, const LDefinition& temp1, const LDefinition& temp2, const LDefinition& temp3) : LInstructionHelper(classOpcode) {\
    setOperand(0, mapObject);\
    setBoxOperand(InputIndex, input);\
    setOperand(1, hash);\
    setTemp(0, temp0);\
    setTemp(1, temp1);\
    setTemp(2, temp2);\
    setTemp(3, temp3);\
  }\
  const LAllocation* mapObject() { return getOperand(0); }\
  const LAllocation* hash() { return getOperand(1); }\
  const LDefinition* temp0() { return getTemp(0); }\
  const LDefinition* temp1() { return getTemp(1); }\
  const LDefinition* temp2() { return getTemp(2); }\
  const LDefinition* temp3() { return getTemp(3); }\
  static const size_t InputIndex = 2;\
};\
\
class LMapObjectGetValueVMCall : public LInstructionHelper<BOX_PIECES, 1 * BOX_PIECES + 1, 0> {\
 public:\
  LIR_HEADER(MapObjectGetValueVMCall)\
  explicit LMapObjectGetValueVMCall(const LAllocation& mapObject, const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, mapObject);\
    setBoxOperand(InputIndex, input);\
  }\
  const LAllocation* mapObject() { return getOperand(0); }\
  static const size_t InputIndex = 1;\
};\
\
class LMapObjectSize : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(MapObjectSize)\
  explicit LMapObjectSize(const LAllocation& mapObject) : LInstructionHelper(classOpcode) {\
    setOperand(0, mapObject);\
  }\
  const LAllocation* mapObject() { return getOperand(0); }\
};\
\
class LBigIntAsUintN : public LInstructionHelper<1, 2, 0> {\
 public:\
  LIR_HEADER(BigIntAsUintN)\
  explicit LBigIntAsUintN(const LAllocation& bits, const LAllocation& input) : LInstructionHelper(classOpcode) {\
    this->setIsCall();\
    setOperand(0, bits);\
    setOperand(1, input);\
  }\
  const LAllocation* bits() { return getOperand(0); }\
  const LAllocation* input() { return getOperand(1); }\
};\
\
class LWasmBoxValue : public LInstructionHelper<1, 1 * BOX_PIECES + 0, 0> {\
 public:\
  LIR_HEADER(WasmBoxValue)\
  explicit LWasmBoxValue(const LBoxAllocation& input) : LInstructionHelper(classOpcode) {\
    setBoxOperand(InputIndex, input);\
  }\
\
  static const size_t InputIndex = 0;\
};\
\
class LWasmAnyRefFromJSObject : public LInstructionHelper<1, 1, 0> {\
 public:\
  LIR_HEADER(WasmAnyRefFromJSObject)\
  explicit LWasmAnyRefFromJSObject(const LAllocation& input) : LInstructionHelper(classOpcode) {\
    setOperand(0, input);\
  }\
  const LAllocation* input() { return getOperand(0); }\
};\
\
class LSimd128 : public LInstructionHelper<1, 0, 0> {\
  SimdConstant simd128_;\
 public:\
  LIR_HEADER(Simd128)\
  explicit LSimd128(SimdConstant simd128) : LInstructionHelper(classOpcode), simd128_(simd128) {\
\
  }\
  SimdConstant simd128() const { return simd128_; }\
\
};\




#endif // jit_LIROpsGenerated_h
