.\" $NCDId: @(#)AuElNEvt.man,v 1.1 1994/09/27 00:25:57 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id$
.TH AuElementNotifyEvent 3 "1.2" "audiolib - events"
.SH \fBName\fP
\fBAuElementNotifyEvent\fP \- element notify event structure
.SH \fBStructures\fP
#include <audio/audiolib.h>
.sp 1
typedef union _AuEvent
.br
{
.br
    . . .
.br
    \fBAuElementNotifyEvent\fP \fIauelementnotify\fP;
.br
    . . .
.br
}\fBAuEvent\fP;
.sp 1
typedef struct _AuElementNotifyEvent
.br
{
.br
    int \fItype\fP;
.br
    \fBAuUint32\fP \fIserial\fP;
.br
    \fBAuBool\fP \fIsend_event\fP;
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    \fBAuTime\fP \fItime\fP;
.br
    \fBAuFlowID\fP \fIflow\fP;
.br
    unsigned char \fIelement_num\fP;
.br
    unsigned char \fIkind\fP;
.br
    unsigned char \fIprev_state\fP;
.br
    unsigned char \fIcur_state\fP;
.br
    unsigned char \fIreason\fP;
.br
    \fBAuUint32\fP \fInum_bytes\fP;
.br
}\fBAuElementNotifyEvent\fP;
.SH \fBMembers\fP
.IP \fItype\fP 1i
The event type.
ElementNotify events are type \fBAuEventTypeElementNotify\fP.
.IP \fIserial\fP 1i
The serial ID of the event expanded from the 16 bit value sent by the server.
.IP \fIsend_event\fP 1i
\fBAuTrue\fP if the event came from a \fBSendEvent\fP protocol request.
.IP \fIserver\fP 1i
The connection to the audio server that the event was read from.
.IP \fItime\fP 1i
The server time in milliseconds when the event was generated.
.IP \fIflow\fP 1i
The ID of the flow that caused the event.
.IP \fIelement_num\fP 1i
The index of the element that caused the event or \fBAuElementAll\fP to indicate the flow.
.IP \fIkind\fP 1i
The kind of notify event.
This will be one of these constants: \fBAuElementNotifyKindLowWater\fP, \fBAuElementNotifyKindHighWater\fP, or \fBAuElementNotifyKindState\fP.
.IP \fIprev_state\fP 1i
The previous state of the element indexed by \fIelement_num\fP.
This will be one of these constants: \fBAuStateStop\fP, \fBAuStateStart\fP, or \fBAuStatePause\fP.
.IP \fIcur_state\fP 1i
The current state of the element indexed by \fIelement_num\fP.
This will be one of these constants: \fBAuStateStop\fP, \fBAuStateStart\fP, or \fBAuStatePause\fP.
.IP \fIreason\fP 1i
The reason for the notify event.
This will be one of these constants: \fBAuReasonUser\fP, \fBAuReasonUnderrun\fP, \fBAuReasonOverrun\fP, \fBAuReasonEOF\fP, \fBAuReasonWatermark\fP, or \fBAuReasonHardware\fP.
.IP \fInum_bytes\fP 1i
The number of bytes to send or receive.
Only valid if the the element indexed by \fIelement_num\fP is an ImportClient or ExportClient.
.SH \fBDescription\fP
ElementNotify events are sent to client applications to notify them of a watermark condition or state change.
If \fIkind\fP is \fBAuElementNotifyKindLowWater\fP, the ImportClient element indexed by \fIelement_num\fP in \fIflow\fP is ready to receive \fInum_bytes\fP of audio data from the client application.
If \fIkind\fP is \fBAuElementNotifyKindHighWater\fP, the ExportClient element indexed by \fIelement_num\fP in \fIflow\fP is ready to send \fInum_bytes\fP of audio data to the client application.
If \fIkind\fP is \fBAuElementNotifyKindState\fP, the element indexed by \fIelement_num\fP (or flow if \fIelement_num\fP is \fBAuElementAll\fP) has made a state transition from \fIprev_state\fP to \fIcur_state\fP triggering the event.
Reguardless of \fIkind\fP, \fIprev_state\fP and \fIcur_state\fP contain the old and new states and \fIreason\fP contains the reason for the event.
.SH \fBSee Also\fP
\fBAuAnyEvent\fP,
\fBAuErrorEvent\fP,
\fBAuGrabNotifyEvent\fP,
\fBAuMakeSendNotifyAction\fP,
\fBAuMonitorNotifyEvent\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
