/*
 * SSMFlagbyteDefinitions_de.cpp - SSM flagbyte definitions (de)
 *
 * Copyright (C) 2008-2019 Comer352L
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "SSMFlagbyteDefinitions_de.h"


// Messwertblöcke:
const QStringList SSMFlagbyteDefinitions_de::_MB_defs_de =
	QStringList()
	<< "1;1;3;00000F;00000E;Motordrehzahl;U/Min;/4;0"
	<< "1;2;1;00000D;;Absoluter Saugrohrdruck;kPa;*1;0"
	<< "1;3;1;00000C;;Gemischlernwert 2;%;-128/128*100;1"
	<< "1;4;1;00000B;;Gemischkorrektur 2;%;-128/128*100;1"
	<< "1;5;1;00000A;;Gemischlernwert 1;%;-128/128*100;1"
	<< "1;6;1;000009;;Gemischkorrektur 1;%;-128/128*100;1"
	<< "1;7;1;000008;;Kühlmitteltemperatur;°C;-40;0"
	<< "1;8;1;000007;;Motorlast;%;/255*100;1"
	<< "2;1;1;00001B;00001A;Vordere Lambdasonde Nr.2 Spannung;V;/200;3"
	<< "2;2;1;000019;000018;Hintere Lambdasonde Spannung;V;/200;3"
	<< "2;3;1;000017;000016;Vordere Lambdasonde Nr.1 Spannung;V;/200;3"
	<< "2;4;1;000015;;Drosselklappenöffnung;%;/255*100;1"
	<< "2;5;1;000014;000013;Luftmassenstrom;g/s;/100;2"
	<< "2;6;1;000012;;Ansauglufttemperatur;°C;-40;0"
	<< "2;7;1;000011;;Zündzeitpunkt;Grad;-128/2;1"
	<< "2;8;1;000010;;Fahrzeuggeschwindigkeit;km/h;*1;0"
	<< "3;1;1;000023;;Atmosphärendruck;kPa;*1;0"
	<< "3;2;1;000022;;Klopfkorrektur;Grad;-128/2;1"
	<< "3;3;1;000021;;Einspritzimpuls 2;ms;*256/1000;2"
	<< "3;4;1;000020;;Einspritzimpuls 1;ms;*256/1000;2"
	<< "3;5;1;00001F;;Differenzdrucksensor Spannung;V;/50;2"
	<< "3;6;3;00001E;;Drosselklappensensor Spannung;V;/50;2"
	<< "3;7;3;00001D;;Luftmassenmesser Spannung;V;/50;2"
	<< "3;8;3;00001C;;Batteriespannung;V;*2/25;1"
	<< "4;1;1;00002B;;Vordere Lambdasonde Nr.1 Heizstrom;A;/255*10;2"
	<< "4;2;1;00002A;;Kraftstofftemperatur;°C;-40;0"
	<< "4;3;3;000029;;Gaspedal-Betätigungsweg;%;/255*100;1"
	<< "4;4;1;000028;;Zündverstellung gelernt;Grad;-128/2;1"
	<< "4;5;1;000027;;CO-Einstellung Spannung;V;/50;2"
	<< "4;6;1;000026;;Kraftstofftankdruck;kPa;-128/40;2"
	<< "4;7;1;000025;;Differenzdrucksensor;kPa;-128;0"
	<< "4;8;1;000024;;Relativer Saugrohrdruck;kPa;-128;0"
	<< "5;1;1;000033;;Tumble-Ventil (TGV) Positionssensor (Rechts);V;/50;2"
	<< "5;2;1;000032;;Tankentlüftung/Aktivkohlebehälter (CPC) relative Einschaltdauer;%;/255*100;0"
	<< "5;3;1;000031;;Sekundäre Wastegate-Steuerung Arbeitszyklus;%;/255*100;1"
	<< "5;4;1;000030;;Primäre Wastegate-Steuerung Arbeitszyklus;%;/255*100;1"
	<< "5;5;1;00002F;;Kühlerlüfterregelung;%;*1;0"
	<< "5;6;1;00002E;;Kraftstoffstandsensor Spannung;V;/50;2"
	<< "5;7;1;00002D;;Vordere Lambdasonde Nr.2 Heizstrom;A;/255*10;2"
	<< "5;8;1;00002C;;Hintere Lambdasonde Heizstrom;A;/255*10;2"
	<< "6;1;1;00003B;;Kraftstoffpumpe Arbeitszyklus;%;/255*100;0"
	<< "6;2;1;00003A;;Lichtmaschine Arbeitszyklus;%;*1;0"
	<< "6;3;1;000039;;Abgasrückführung (EGR) Ventilschritte;Schritte;*1;0"
	<< "6;4;1;000038;;Leerlaufregelung (ISC) Ventilschritte;Schritte;*1;0"
	<< "6;5;1;000037;;Gemischwärmer Rbeitszyklus;%;/255*100;1"
	<< "6;6;1;000036;;Magergemischkorrektur;%;/255*100;0"
	<< "6;7;1;000035;;Leerlaufregelung (ISC) relative Einschaltdauer;%;/2;1"
	<< "6;8;1;000034;;Tumble-Ventil (TGV) Positionssensor (Links);V;/50;2"
	<< "7;1;1;000043;;Gemischsensor Nr.2 Strom;mA;-128/8;2"
	<< "7;2;1;000042;;Gemischsensor Nr.1 Strom;mA;-128/8;2"
	<< "7;3;1;000041;;Ölfluss-Steuermagnetventil (OCV) Strom (Links, Einlass);mA;*32;0"
	<< "7;4;1;000040;;Ölfluss-Steuermagnetventil (OCV) Strom (Rechts, Einlass);mA;*32;0"
	<< "7;5;1;00003F;;Ölfluss-Steuermagnetventil (OCV) Arbeitszyklus (Links, Einlass);%;/255*100;1"
	<< "7;6;1;00003E;;Ölfluss-Steuermagnetventil (OCV) Arbeitszyklus (Rechts, Einlass);%;/255*100;1"
	<< "7;7;1;00003D;;Variable Ventilsteuerung (VVT) Verstellwinkel (Links, Einlass);Grad;-50;0"
	<< "7;8;1;00003C;;Variable Ventilsteuerung (VVT) Verstellwinkel (Rechts, Einlass);Grad;-50;0"
	<< "8;1;1;0000D3;;Gemisch-Einstellspannung;V;/50;2"
	<< "8;2;1;0000D2;;Hintere Lambdasonde Heizspannung;V;/50;2"
	<< "8;3;1;0000D1;;Gemischlernwert 3;%;-128/128*100;2"
	<< "8;4;1;0000D0;;Gemischkorrektur 3;%;-64/128*10;2"
	<< "8;5;1;000047;;Gemischsensor Nr.2 Lambda;;/128;2"
	<< "8;6;1;000046;;Gemischsensor Nr.1 Lambda;;/128;2"
	<< "8;7;1;000045;;Gemischsensor Nr.2 Widerstand;Ohm;*1;0"
	<< "8;8;1;000044;;Gemischsensor Nr.1 Widerstand;Ohm;*1;0"
	<< "9;1;2;00004F;;Turbinendrehzahl;U/Min;*32;0"
	<< "9;2;2;00004E;;Drosselklappensensor Spannung;V;/45;2"
	<< "9;3;2;00004D;;Allradkupplung Taktverhältnis;%;/2;1"
	<< "9;4;2;00004C;;Überbrückungskupplung Taktverhältnis;%;/2;1"
	<< "9;5;2;00004B;;Hauptdruck Taktverhältnis;%;/2;1"
	<< "9;6;3;00004A;;Gang-Stellung;Gang;+1;0"
	<< "9;7;2;000049;;ATF-Temperatur;°C;0=-60,1=-60,2=-51,3=-45,4=-40,5=-37,6=-34,7=-31,8=-29,9=-27,10=-25,11=-23,12=-22,13=-20,14=-19,15=-17,16=-16,17=-15,18=-14,19=-13,20=-12,21=-10,22=-9,23=-9,24=-8,25=-7,26=-6,27=-5,28=-4,29=-3,30=-2,31=-2,32=-1,33=0,34=1,35=1,36=2,37=3,38=3,39=4,40=5,41=5,42=6,43=7,44=7,45=8,46=8,47=9,48=10,49=10,50=11,51=11,52=12,53=12,54=13,55=13,56=14,57=15,58=15,59=16,60=16,61=17,62=17,63=18,64=18,65=19,66=19,67=20,68=20,69=21,70=21,71=22,72=22,73=23,74=23,75=23,76=24,77=24,78=25,79=25,80=26,81=26,82=27,83=27,84=28,85=28,86=29,87=29,88=29,89=30,90=30,91=31,92=31,93=32,94=32,95=33,96=33,97=33,98=34,99=34,100=35,101=35,102=36,103=36,104=37,105=37,106=37,107=38,108=38,109=39,110=39,111=40,112=40,113=41,114=41,115=41,116=42,117=42,118=43,119=43,120=44,121=44,122=45,123=45,124=45,125=46,126=46,127=47,128=47,129=48,130=48,131=49,132=49,133=50,134=50,135=50,136=51,137=51,138=52,139=52,140=53,141=53,142=54,143=54,144=55,145=55,146=56,147=56,148=57,149=57,150=58,151=58,152=59,153=59,154=60,155=60,156=61,157=61,158=62,159=62,160=63,161=63,162=64,163=65,164=65,165=66,166=66,167=67,168=67,169=68,170=68,171=69,172=70,173=70,174=71,175=71,176=72,177=73,178=73,179=74,180=75,181=75,182=76,183=77,184=77,185=78,186=79,187=79,188=80,189=81,190=81,191=82,192=83,193=84,194=84,195=85,196=86,197=87,198=88,199=88,200=89,201=90,202=91,203=92,204=93,205=94,206=95,207=96,208=97,209=98,210=99,211=100,212=101,213=102,214=103,215=104,216=105,217=107,218=108,219=109,220=110,221=112,222=113,223=115,224=116,225=118,226=119,227=121,228=123,229=125,230=127,231=129,232=131,233=133,234=135,235=138,236=140,237=143,238=146,239=149,240=152,241=156,242=159,243=164,244=168,245=173,246=179,247=186,248=193,249=202,250=212,251=225,252=241,253=264,254=300,255=373;0"
	<< "9;8;2;000048;;Radgeschwindigkeit vorne;km/h;*1;0"
	<< "10;1;2;000057;;Niedriggang-Kupplung Arbeitszyklus;%;/2;1"
	<< "10;2;2;000056;;ATF-Temperatur;°C;-50;0"
	<< "10;3;2;000055;;Querbeschleunigungssensor Spannung;V;/50;2"
	<< "10;4;1;000054;;Gemischsensor Nr.2 Heizstrom;A;/10;1"
	<< "10;5;1;000053;;Gemischsensor Nr.1 Heizstrom;A;/10;1"
	<< "10;6;2;000052;;Krümmerdrucksensor Spannung;V;/50;2"
	<< "10;7;2;000051;;Radgeschwindigkeit hinten;km/h;*1;0"
	<< "10;8;2;000050;;Bremskupplung/Bremsband Taktverhälnis;%;/2;1"
	<< "11;1;2;00005F;;Angezeigter Zentraldifferential-Strom;A;/32;2"
	<< "11;2;2;00005E;;Tatsächlicher Zentraldifferential-Strom;A;/32;2"
	<< "11;3;2;00005D;;Automatikgetriebe Turbinendrehzahl 2;U/Min;*32;0"
	<< "11;4;2;00005C;;Automatikgetriebe Turbinendrehzahl 1;U/Min;*32;0"
	<< "11;5;2;00005B;;Spannung Zentraldifferential-Schalter;V;/51;2"
	<< "11;6;2;00005A;;ATF-Temperatur 2;°C;-50;0"
	<< "11;7;2;000059;;Bremse für Nieddrig- und Rückwärtsgang (L&R B) Zyklus;%;/2;1"
	<< "11;8;2;000058;;Schnellgang-Kupplung Arbeitszyklus;%;/2;1"
	<< "31;5;1;0000FB;;Drosselklappenmotor Spannung;V;*2/25;1"
	<< "31;6;1;0000FA;;Drosselklappenmotor Arbeitszyklus;%;-128/128*100;0"
	<< "31;7;1;00016B;;Drosselklappe geschlossen Spannung;V;/50;2"
	<< "31;8;3;00016A;;SI-Drive Modus;;0=---,1=S,2=S#,3=I,8=S#,16=I;"
	<< "33;1;1;000107;;Abgastemperatur 2;°C;*5+200;0"
	<< "33;2;1;000106;;Abgastemperatur;°C;*5+200;0"
	<< "33;3;1;000105;;Kraftstoffdruck;kPa;*2;0"
	//<< "33;4;1;1;000104;;Bremskraftverstärker Druck;kPa;*1;0"			// UNBESTÄTIGT !!!
	<< "33;5;1;000103;;Haupt-Gaspedalsensor Spannung;V;/50;2"
	<< "33;6;3;000102;;Neben-Gaspedalsensor Spannung;V;/50;2"
	<< "33;7;1;000101;;Haupt-Drosselklappensensor Spannung;V;/50;2"
	<< "33;8;1;000100;;Neben-Drosselklappensensor Spannung;V;/50;2"
	<< "34;1;1;000173;000172;Kraftstofftankdruck;MPa;/100;1"
	<< "34;2;1;00010F;00010E;Wegstreckenzähler;km;*2;0"
	<< "34;3;1;00010D;;Kraftstoffstandsensor Widerstand;Ohm;*4/2;1"
	<< "34;4;1;00010C;;Gemischlernwert 4;%;-128/128*100;2"
	<< "34;5;1;00010B;;Gemischkorrektur 4;%;-64/128*10;2"
	<< "34;6;1;00010A;;Gespeicherte Zielgeschwindigkeit;km/h;*1;0"
	<< "34;7;1;000183;000182;Sekundärluft-Massenstrom;g/s;/100;2"
	<< "34;8;1;000108;;Sekundärluft-Druck;kPa;*1;0"
	<< "35;1;1;000117;;Öldruck-Schaltmagnetventil (OSV) Strom (Links);mA;*32;0"
	<< "35;2;1;000116;;Öldruck-Schaltmagnetventil (OSV) Strom (Rechts);mA;*32;0"
	<< "35;3;1;000115;;Öldruck-Schaltmagnetventil (OSV) Zyklus (Links);%;/255*100;1"
	<< "35;4;1;000114;;Öldruck-Schaltmagnetventil (OSV) Zyklus (Rechts);%;/255*100;1"
	<< "35;5;1;000113;;Öltemperatur;°C;-40;0"
	<< "36;2;1;00011E;;Variabler Ventilhub (VVL) Hubmodus;;*1;0"
	<< "36;3;1;00011D;;Ölfluss-Steuermagnetventil (OCV) Strom (Links, Auslass);mA;*32;0"
	<< "36;4;1;00011C;;Ölfluss-Steuermagnetventil (OCV) Strom (Rechts, Auslass);mA;*32;0"
	<< "36;5;1;00011B;;Ölfluss-Steuermagnetventil (OCV) Arbeitszyklus (Links, Auslass);%;/255*100;1"
	<< "36;6;1;00011A;;Ölfluss-Steuermagnetventil (OCV) Arbeitszyklus (Rechts, Auslass);%;/255*100;1"
	<< "36;7;1;000119;;Variable Ventilsteuerung (VVT) Verzögerungswinkel (Links, Auslass);Grad;-50;0"
	<< "36;8;1;000118;;Variable Ventilsteuerung (VVT) Verzögerungswinkel (Rechts, Auslass);Grad;-50;0"
	<< "43;1;2;000147;;Giergeschwindigkeitssensor Spannung;V;/51;2"
	<< "43;2;2;000146;;AWD-Magnetventil Strom;A;/255;2"
	<< "43;3;2;000145;;L/U-Magnetventil Strom;A;/255;2"
	<< "43;4;2;000144;;P/L-Magnetventil Strom;A;/255;2"
	<< "43;5;2;000143;;I/C-Magnetventil Strom;A;/255;2"
	<< "43;6;2;000142;;F/B-Magnetventil Strom;A;/255;2"
	<< "43;7;2;000141;;D/C-Magnetventil Strom;A;/255;2"
	<< "43;8;2;000140;;H&LR/C-Magnetventil Strom;A;/255;2"
	<< "44;1;2;00014F;;Giergeschwindigkeits- & Beschleunigungssensor Referenzspannung;V;/51;2"
	<< "44;2;2;00014E;;AWD-Magnetventil Druck;kPa;*10;0"
	<< "44;3;2;00014D;;L/U-Magnetventil Druck;kPa;*10;0"
	<< "44;4;2;00014C;;P/L-Magnetventil Druck;kPa;*10;0"
	<< "44;5;2;00014B;;I/C-Magnetventil Druck;kPa;*10;0"
	<< "44;6;2;00014A;;F/B-Magnetventil Druck;kPa;*10;0"
	<< "44;7;2;000149;;D/C-Magnetventil Druck;kPa;*10;0"
	<< "44;8;2;000148;;H&LR/C-Magnetventil Druck;kPa;*10;0"
	<< "45;1;2;000186;;Fwd/B-Magnetventil Zieldruck;kPa;*10;0"
	<< "45;2;2;000185;;Fwd/B-Magnetventil Strom;A;/255;2"
	<< "45;4;2;00015A;00008D;Lenkwinkelsensor;deg;s16*1;0"
	<< "45;5;2;00013F;;Radgeschwindigkeit hinten links;km/h;*1;0"
	<< "45;6;2;00013E;;Radgeschwindigkeit hinten rechts;km/h;*1;0"
	<< "45;7;2;00013D;;Radgeschwindigkeit vorne links;km/h;*1;0"
	<< "45;8;2;00013C;;Radgeschwindigkeit vorne rechts;km/h;*1;0"
	<< "48;1;1;000199;;Klopfkorrektur;Grad;-128/4;1"
	<< "48;2;1;0000F9;;Gelernte Zündzeitpunkts-Korrektur;Grad;/16;1"
	<< "48;3;1;0000F8;;Rauhigkeit Zylinder #6;;*1;0"
	<< "48;4;1;0000EF;;Rauhigkeit Zylinder #5;;*1;0"
	<< "48;5;1;0000D9;;Rauhigkeit Zylinder #4;;*1;0"
	<< "48;6;1;0000D8;;Rauhigkeit Zylinder #3;;*1;0"
	<< "48;7;1;0000CF;;Rauhigkeit Zylinder #2;;*1;0"
	<< "48;8;1;0000CE;;Rauhigkeit Zylinder #1;;*1;0"
	<< "52;8;1;00019A;;Kraftstofftankdruck;kPa;-128/20;2"
	<< "53;1;1;0001E9;;Abgasrückführung (AGR) Ventilöffnungswinkel;Grad;-50;0"
	<< "53;2;1;0001E8;;Abgasrückführung (AGR) Ziel-Ventilöffnungswinkel;Grad;-50;0"
	<< "53;3;1;0001E7;;Luftmasse;mg/Zyl;*10;0"
	<< "53;4;1;0001E6;;Ansaugluft-Zielmenge;mg/Zyl;*10;0"
	<< "53;5;1;0001E5;;Ansaugkrümmer-Zieldruck;kPa;*1;0"
	<< "53;6;1;0001E4;;Anzahl der Einspritzungen;;*1;0"
	<< "53;7;1;0001E3;0001E2;Endeinspritzmenge;mm³;/256;4"
	<< "53;8;1;0001E1;;Haupteinspritzungszeitraum;°KW;/5-15;1"
	<< "54;1;1;0001F7;0001F6;Ziel-Kraftstoffpumpenstrom;mA;*1;0"
	<< "54;2;1;0001F5;;Elektrische Servolenkung Strom;A;*1;0"
	<< "54;3;1;0001F0;;Ladedruck-Rückkopplung;%;-128;0"
	<< "54;4;1;0001EF;0001EE;Motor-Zieldrehzahl;U/Min;/4;0"
	<< "54;5;1;0001ED;;Ansauglufttemperatur (kombiniert);°C;-40;0"
	<< "54;6;1;0001EC;;Common-Rail-Druck;MPa;*1;0"
	<< "54;7;1;0001EB;;Common-Rail-Zieldruck;MPa;*1;0"
	<< "54;8;1;0001EA;;Abgasrückführung (AGR) Auslastung;%;*1;0"
	<< "55;5;2;0001F4;;Einstellbares Zentraldifferential (DCCD) Modus;;*1;0"
	<< "55;6;2;0001F3;;Einstellbares Zentraldifferential (DCCD) Drehmomentverteilung;;*1;0"
	<< "55;7;2;0001F2;;Längs-Beschleunigung;m/s²;s8*1.0862;2"
	<< "55;8;2;0001F1;;Gier-Geschwindigkeit;Grad/s;s8*0.19118;0"
	<< "56;1;1;000260;;Mengenkorrektur Zylinder #4;ms;-100/100;2"
	<< "56;2;1;00025F;;Mengenkorrektur Zylinder #3;ms;-100/100;2"
	<< "56;3;1;00025E;;Mengenkorrektur Zylinder #2;ms;-100/100;2"
	<< "56;4;1;00025D;;Mengenkorrektur Zylinder #1;ms;-100/100;2"
	<< "56;5;1;000270;;Innenraumheizung;Stufe;*1;0"
	<< "56;6;1;000205;000204;Kilometerstand nach Injektor-Auswechselung;km;*5;0"
	<< "56;7;1;0001FB;0001FA;Kilometerstand nach Injektor-Lernen;km;*5;0"
	<< "56;8;1;0001F9;0001F8;Tatsächlicher Kraftstoffpumpenstrom;mA;*1;0"
	<< "57;6;1;000272;;Generator-Steuerungsmodus;;0=Hoch,1=Extra Hoch,2=Niedrig,3=Mittel;0"
	<< "57;7;1;000273;;Batterietemperatur;°C;-40;0"
	<< "57;8;1;000271;;Batteriestrom;A;-128;0"
	<< "63;1;1;00027C;;Ölverdünnungsverhältnis;%;*1;0"
	<< "63;2;1;00027B;;Rußansammlungsverhältnis;%;*1;0"
	<< "63;3;1;00027A;;Geschätzte Temperatur des Dieselpartikelfilters (DPF);°C;*5-40;0"
	<< "63;4;1;000279;;Geschätzte Katalysatortemperatur;°C;*5-40;0"
	<< "63;5;1;000278;;Abgastemperatur am Einlass des Dieselpartikelfilters (DPF);°C;*5-40;0"
	<< "63;6;1;000277;;Abgastemperatur am Katalysatoreinlass;°C;*5-40;0"
	<< "63;7;1;000276;;Druckdifferenz zwischen Einlass- und Auslassseite des Dieselpartikelfilters (DPF);kPa;*1;0"
	<< "63;8;1;000275;;Kumulatives Ascheverhältnis;%;*1;0"
	<< "64;5;2;000297;000296;Automatikgetriebeöl (ATF) Verschlechterungsgrad;%;*40/13107;0"
	<< "64;6;2;000295;;Durchschnittliche Hinterradgeschwindigkeit ABS/VDC;km/h;*230/255;0"
	<< "64;7;2;000294;;Durchschnittliche Vorderradgeschwindigkeit ABS/VDC;km/h;*230/255;0"
	<< "64;8;2;000293;;Rad-Rotationsrate vorne-hinten;;/128;3"
	<< "65;1;1;00023E;;Endgültiger Lernwert 1-2 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "65;2;1;00023D;;Endgültiger Lernwert 1-1 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "65;3;1;00029E;00029D;Dieselpartikelfilter (DPF) Regenerierungszählwert;Mal;*1;0"
	<< "65;4;1;00029C;00029B;Fahrstrecke seit letzter Regenerierung des Dieselpartikelfilters (DPF);km;*1;0"
	<< "65;5;1;00029A;;Geschätzte Fahrstrecke bis zum Ölwechsel;km;*100;0"
	<< "65;6;1;00021F;;Tatsächlicher Raildruck (zeitsynchronisiert);MPa;*1;0"
	<< "65;7;1;000299;;Kumulativer Zählwert für Überdrehzahlen (hohe Drehzahlen);Mal;*1;0"
	<< "65;8;1;000298;;Kumulativer Zählwert für Überdrehzahlen (sehr hohe Drehzahlen);Mal;*1;0"
	<< "66;1;1;000246;;Endgültiger Lernwert 3-2 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "66;2;1;000245;;Endgültiger Lernwert 3-1 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "66;3;1;000244;;Endgültiger Lernwert 2-4 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "66;4;1;000243;;Endgültiger Lernwert 2-3 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "66;5;1;000242;;Endgültiger Lernwert 2-2 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "66;6;1;000241;;Endgültiger Lernwert 2-1 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "66;7;1;000240;;Endgültiger Lernwert 1-4 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "66;8;1;00023F;;Endgültiger Lernwert 1-3 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "67;1;1;00024E;;Endgültiger Lernwert 5-2 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "67;2;1;00024D;;Endgültiger Lernwert 5-1 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "67;3;1;00024C;;Endgültiger Lernwert 4-4 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "67;4;1;00024B;;Endgültiger Lernwert 4-3 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "67;5;1;00024A;;Endgültiger Lernwert 4-2 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "67;6;1;000249;;Endgültiger Lernwert 4-1 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "67;7;1;000248;;Endgültiger Lernwert 3-4 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "67;8;1;000247;;Endgültiger Lernwert 3-3 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "69;5;1;000258;000257;Dauer der finalen Haupteinspritzung;ms;/1000;3"
	<< "69;6;1;000239;000238;Lernwert für individuellen Pumpenunterschied;mA;-1000;0"
	<< "69;7;1;000250;;Endgültiger Lernwert 5-4 für Mikro-Einspritzmenge;ms;-128/200;3"
	<< "69;8;1;00024F;;Endgültiger Lernwert 5-3 für Mikro-Einspritzmenge;ms;-128/200;3";


// Schalter:
const QStringList SSMFlagbyteDefinitions_de::_SW_defs_de =
	QStringList()
	<< "12;1;1;000061;Klemme ''Speicher Löschen'';Aus/Ein"
	<< "12;2;1;000061;Liefermodus-Stecker (Testmodus-Stecker);Aus/Ein"
	<< "12;3;1;000061;Flag ''D-Prüfung erforderlich'';Aus/Ein"
	<< "12;5;1;000061;Speicherlesemodussignal;Aus/Ein"
	<< "12;6;1;000061;Testmodussignal;Aus/Ein"
	<< "12;7;1;000061;Automatikgetriebe-Fahrzeug Identifierung;Aus/Ein"
	<< "13;2;1;000062;Klimaanlagenschalter;Aus/Ein"
	<< "13;3;1;000062;Servolenkungsschalter;Aus/Ein"
	<< "13;4;3;000062;Zündschalter;Aus/Ein"
	<< "13;5;1;000062;Ladeluftkühler-Befeuchtungsschalter;Aus/Ein"
	<< "13;7;1;000062;Leerlaufschalter;Aus/Ein"
	<< "13;8;3;000062;Neutralpositionsschalter;Aus/Ein"
	<< "14;1;1;000063;Elektrisches Belastungssignal;Aus/Ein"
	<< "14;2;1;000063;Klopfsignal 2;Aus/Ein"
	<< "14;3;1;000063;Klopfsignal 1;Aus/Ein"
	<< "14;4;1;000063;Vordere Lambdasonde 2 fett;Aus/Ein"
	<< "14;5;1;000063;Hintere Lambdasonde fett;Aus/Ein"
	<< "14;6;1;000063;Vordere Lambdasonde 1 fett;Aus/Ein"
	<< "14;7;1;000063;Anlasserschalter;Aus/Ein"
	<< "14;8;1;000063;Lenkradschalter;Hoher Eingang\\Niedriger Eingang"
	<< "15;1;1;000064;Klimaanlagen-Mitteldruckschalter;Aus/Ein"
	<< "15;2;1;000064;Klimakompressor Einkupplungssignal;Aus/Ein"
	<< "15;3;1;000064;Wischerschalter;Aus/Ein"
	<< "15;4;1;000064;Lichtschalter;Aus/Ein"
	<< "15;5;1;000064;Gebläseschalter (Innenraum);Aus/Ein"
	<< "15;6;1;000064;Heckscheibenheizungsschalter;Aus/Ein"
	<< "15;7;1;000064;Nockenwellenpositionssignal;Aus/Ein"
	<< "15;8;1;000064;Kurbelwellenpositionssignal;Aus/Ein"
	<< "16;1;1;000065;Durchblasleck-Anschluss;Aus/Ein"
	<< "16;2;1;000065;Tankentlüftung (CPC) Aktivkohlebehälter-Magnetventil;Aus/Ein"
	<< "16;3;1;000065;Ladeluftkühler-Befeuchtungsrelais;Aus/Ein"
	<< "16;4;1;000065;Kraftstoffpumpenrelais;Aus/Ein"
	<< "16;5;1;000065;Kühlerlüfterrelais 2;Aus/Ein"
	<< "16;6;1;000065;Kühlerlüfterrelais 1;Aus/Ein"
	<< "16;7;1;000065;Kühlerlüfterrelais 3;Aus/Ein"
	<< "16;8;1;000065;Klimakompressorsignal;Aus/Ein"
	<< "17;1;1;000066;Zusatzluftmagnetventil;Aus/Ein"
	<< "17;2;1;000066;Servolenkungsmagnetventil;Aus/Ein"
	<< "17;3;1;000066;Belüftungsmagnetventil;Aus/Ein"
	<< "17;4;1;000066;Druckquellenwechsel;Aus/Ein"
	<< "17;5;1;000066;Variable Ansaugluft Magnetventil;Aus/Ein"
	<< "17;6;1;000066;Tumbleventil (TGV) Antrieb;Zu/Auf"
	<< "17;7;1;000066;Tumbleventil (TGV) Ausgang;Aus/Ein"
	<< "17;8;1;000066;Kurbelgehäuseentlüftung (PCV) Magnetventil;Aus/Ein"
	<< "18;1;1;000067;Schalldämpfersteuerung;Aus/Ein"
	<< "18;2;1;000067;Ansaugluftmagnetventil;Aus/Ein"
	<< "18;3;1;000067;Abgasunterdruck;Aus/Ein"
	<< "18;4;1;000067;Abgasüberdruck;Aus/Ein"
	<< "18;5;1;000067;Traktionskontrolle (TCS) Druckmindermagnetventil;Aus/Ein"
	<< "18;6;1;000067;Überdruckmagnetventil 2;Aus/Ein"
	<< "18;7;1;000067;Überdruckmagnetventil 1;Aus/Ein"
	<< "18;8;1;000067;Tanksensor-Steuerventil;Aus/Ein"
	<< "19;1;1;000068;Anforderung Drehmoment senken VDC;Aus/Ein"
	<< "19;2;1;000068;Sperre für Drehmomentsenkung;Ein\\Aus"
	<< "19;3;1;000068;Automatikgetriebe Kraftstoff-Abschaltsignal;Aus/Ein"
	<< "19;4;1;000068;Automatikgetriebe Verzögerungssignal;Aus/Ein"
	<< "19;5;1;000068;Tankentlüftung (CPC) Magnetventil 2;Aus/Ein"
	<< "19;6;1;000068;Motoröldruckschalter 2;Aus/Ein"
	<< "19;7;1;000068;Motoröldruckschalter 1;Aus/Ein"
	<< "19;8;1;000068;Abgas-Bypassventil;Aus/Ein"
	<< "20;1;1;000069;Automatikgetriebe Motordrehmoment-Forderung (AET) Signal;Hoch\\Niedrig"
	<< "20;2;1;000069;Automatikgetriebe-Koopeartion Fettgemischsignal;Aus/Ein"
	<< "20;3;1;000069;Automatikgetriebe-Kooperation Magergemischsignal;Aus/Ein"
	<< "20;4;1;000069;Automatikgetriebe-Kooperation Blockiersignal;Aus/Ein"
	<< "20;5;1;000069;Motor Automatikgetriebe Masking Flag (EAM) Signal;Hoch\\Niedrig"
	<< "20;6;1;000069;Drehmomenterlaubnissignal;Aus/Ein"
	<< "20;7;1;000069;Drehmomentregelsignal 2;Aus/Ein"
	<< "20;8;1;000069;Drehmomentregelsignal 1;Aus/Ein"
	<< "21;1;2;00006A;Frontantrieb (FWD) Schalter;Aus/Ein"
	<< "21;2;3;00006A;Kick-Down-Schalter;Aus/Ein"
	<< "21;3;2;00006A;''Gang hoch''-Schalter;Aus/Ein"
	<< "21;4;2;00006A;Stoplichtschalter;Aus/Ein"
	<< "21;5;2;00006A;''Gang runter''-Schalter;Aus/Ein"
	<< "21;6;2;00006A;ABS-Signal;Aus/Ein"
	<< "21;7;2;00006A;Tempomatsignal;Aus/Ein"
	<< "21;8;2;00006A;Tiptronic-Betriebsschalter;Aus/Ein"
	<< "22;1;2;00006B;Neutral-/Parkstellungsschalter;Aus/Ein"
	<< "22;2;2;00006B;R-Stellungssignal;Aus/Ein"
	<< "22;3;2;00006B;D-Stellungssignal;Aus/Ein"
	<< "22;4;2;00006B;3er Gang Signal;Aus/Ein"
	<< "22;5;2;00006B;2er Gang Signal;Aus/Ein"
	<< "22;6;2;00006B;1er Gang Signal;Aus/Ein"
	<< "22;7;2;00006B;Hold-/Manuell-Schalter;Aus/Ein"
	<< "22;8;2;00006B;Power-Schalter;Aus/Ein"
	<< "23;1;2;00006C;Gangschalt-Magnetventil 1;Aus/Ein"
	<< "23;2;2;00006C;Gangschalt-Magnetventil 2;Aus/Ein"
	<< "23;3;2;00006C;Niedriggang-Kupplung Zeitsteuermagnetventil;Aus/Ein"
	<< "23;4;2;00006C;2-4-Bremse Zeitsteuermagnetventil;Aus/Ein"
	<< "23;5;2;00006C;Drehmomentregelsignal 2;Aus/Ein"
	<< "23;6;2;00006C;Drehmomentregelsignal 1;Aus/Ein"
	<< "23;7;2;00006C;Tiptronic Magnetventil;Aus/Ein"
	<< "23;8;2;00006C;4er Gang Signal;Aus/Ein"
	<< "24;1;2;00006D;Schaltsperrenmagnetventil;Aus/Ein"
	<< "24;2;2;00006D;ATF-Temperaturleuchte;Aus/Ein"
	<< "24;3;2;00006D;Hinterachsdifferential Öltemperaturschalter;Aus/Ein"
	<< "24;4;2;00006D;Diagnoseleuchte;Aus/Ein"
	<< "24;5;2;00006D;Gangwechsel-Schaltausgang 1;Aus/Ein"
	<< "24;6;2;00006D;Gangwechsel-Schaltausgang 2;Aus/Ein"
	<< "24;7;2;00006D;Gangwechsel-Schaltausgang 3;Aus/Ein"
	<< "24;8;2;00006D;Gangwechsel-Schaltausgang 4;Aus/Ein"
	<< "25;1;2;00006E;Neutralposition;Aus/Ein"
	<< "25;2;2;00006E;Hold Leuchte;Aus/Ein"
	<< "25;3;2;00006E;Traktionskontrolle (TCS) Schalter;Aus/Ein"
	<< "25;4;2;00006E;P/N Signal;Aus/Ein"
	<< "25;5;2;00006E;Drehmomentsteuerung Unterbrechungs-Signal;Aus/Ein"
	<< "25;6;2;00006E;Parkposition;Aus/Ein"
	<< "25;7;2;00006E;Power-Modus-Leuchte;Aus/Ein"
	<< "25;8;3;00006E;Economy-Schalter;Aus/Ein"
	<< "28;1;2;0000D4;Automatikgetriebe Leistungsrelais;Aus/Ein"
	<< "28;2;2;0000D4;Rückleuchtenrelais;Aus/Ein"
	<< "28;3;2;0000D4;Sperrschalter 3 Kontrolle;Niedrig/Hoch"
	<< "28;4;2;0000D4;Sperrschalter 4;Niedrig/Hoch"
	<< "28;5;2;0000D4;Sperrschalter 3;Niedrig/Hoch"
	<< "28;6;2;0000D4;Sperrschalter 2;Niedrig/Hoch"
	<< "28;7;2;0000D4;Sperrschalter 1;Niedrig/Hoch"
	<< "28;8;2;0000D4;Beurteilung Allradantrieb (AWD);Aus/Ein"
	<< "32;1;2;0000D5;Identifiziertes Steuergerät (ECM) Signal;Aus/Ein"
	<< "32;2;2;0000D5;LC/B Flüssigkeitsdruck;Aus/Ein"
	<< "32;3;2;0000D5;I/C Flüssigkeitsdruck;Aus/Ein"
	<< "32;4;2;0000D5;F/B Flüssigkeitsdruck;Aus/Ein"
	<< "32;5;2;0000D5;D/C Flüssigkeitsdruck;Aus/Ein"
	<< "32;6;2;0000D5;H&LR/C Flüssigkeitsdruck;Aus/Ein"
	<< "37;6;1;000120;Einspritzventil-Treiberrelais;Aus/Ein"
	<< "37;7;1;000120;Elektronische Drosselklappensteuerung (ETC) Motorrelais;Aus/Ein"
	<< "37;8;1;000120;Leerlaufschalter;Aus/Ein"
	<< "38;1;3;000121;Tempomat Status;Aus/Ein"
	<< "38;2;1;000121;Tempomat Hauptschalter (Cruise);Aus/Ein"
	<< "38;3;1;000121;Sperrschalter;Aus/Ein"
	<< "38;4;1;000121;Bremslichtschalter;Aus/Ein"
	<< "38;5;1;000121;Resume/Accel-Schalter;Aus/Ein"
	<< "38;6;1;000121;Set/Coast-Schalter;Aus/Ein"
	<< "38;7;1;000121;Stopplichtschalter;Aus/Ein"
	<< "38;8;1;000121;Kupplungsschalter;Aus/Ein"
	<< "39;1;2;000122;Zentraldifferential-Anzeige Leuchte 6;Aus/Ein"
	<< "39;2;2;000122;Zentraldifferential-Anzeige Leuchte 5;Aus/Ein"
	<< "39;3;2;000122;Zentraldifferential-Anzeige Leuchte 4;Aus/Ein"
	<< "39;4;2;000122;Zentraldifferential-Anzeige Leuchte 3;Aus/Ein"
	<< "39;5;2;000122;Zentraldifferential-Anzeige Leuchte 2;Aus/Ein"
	<< "39;6;2;000122;Zentraldifferential-Anzeige Leuchte 1;Aus/Ein"
	<< "39;7;2;000122;LU&FWD/B Magnetventil;Aus/Ein"
	<< "39;8;2;000122;LC/B Magnetventil;Aus/Ein"
	<< "46;3;2;0000D6;Automatikgetriebe-Lernprozess;Nicht Abgeschlossen/Abgeschlossen"
	<< "46;4;2;0000D6;Hydraulikdruck-Schalter Vorw./B;Aus/Ein"
	<< "46;5;2;0000D6;AUTO-Modus Kontrolleuchte;Aus/Ein"
	<< "46;6;2;0000D6;AUTO/MANUAL Schalter;Aus/Ein"
	<< "46;7;2;0000D6;Zentraldifferentialrelais;Aus/Ein"
	<< "46;8;2;0000D6;Parkpositionsschalter;Aus/Ein"
	<< "47;1;1;0000D7;Geschwindigkeitsregelanlage Abstellschalter;Aus/Ein"
	<< "47;2;1;0000D7;Abstands-Änderungsschalter;Aus/Ein"
	<< "47;3;1;0000D7;Sekundärluft-Kombiventil Relais 1;Aus/Ein"
	<< "47;4;1;0000D7;Sekundärluftpumpe Relais;Aus/Ein"
	<< "47;5;1;0000D7;Sekundärluft-Kombiventil Relais 2;Aus/Ein"
	<< "47;7;1;0000D7;Karosseriemodul Zähler;Ein\\Aus"
	<< "47;8;1;0000D7;Karosseriemodul Wert;Ein\\Aus"
	<< "49;6;1;000196;Ölstandsschalter;Niedriger Ölstand/Hoher Ölstand"
	<< "49;7;1;000196;Kraftstoffdruck-Schaltmagnetventil;Aus/Ein"
	<< "49;8;1;000196;Flag ''Störungsleuchte an'';Aus/Ein"
	<< "50;1;1;000197;Einspritzventillernen;Nicht Abgeschlossen/Abgeschlossen"
	<< "50;2;1;000197;Kraftstoffpumpenlernen;Nicht Abgeschlossen/Abgeschlossen"
	<< "50;3;1;000197;Anforderung von ''Kompressor EIN'';Aus/Ein"
	<< "50;4;1;000197;Hilfskraftstoffpumpenrelais;Aus/Ein"
	<< "50;5;1;000197;Wirbelsteuerrelais;Offen\\Geschlossen"
	<< "50;6;1;000197;Vorglührelais;Aus/Ein"
	<< "50;7;1;000197;Abgasrückführung (AGR) Steuermodus;Offen/Rückführung"
	<< "50;8;1;000197;Ladedrucksteuermodus;Offen/Rückführung"
	<< "60;7;2;0001CD;Wandlerüberbrückung Ein/Aus-Magnetventil;Aus/Ein"
	<< "60;8;2;0001CD;Selbstabschaltrelais-Ausgang;Aus/Ein"
	<< "62;4;1;0001CE;Dieselpartikelfilter (DPF) Regenerierung;findet nicht statt/findet statt"
	<< "62;5;1;0001CE;Kupplungsschalter für Smart-System;Aus/Ein"
	<< "62;6;1;0001CE;Kraftstoffpumpenmodus;Offen/Rückführung"
	<< "62;7;1;0001CE;Kraftstoffabsperrung;Nicht Angefordert/Angefordert"
	<< "62;8;1;0001CE;Abgasrückführung (AGR) Lernprozess;Nicht Abgeschlossen/Abgeschlossen";


// SUBARU-Fehlercodes:
const QStringList SSMFlagbyteDefinitions_de::_DTC_SUBARU_defs_de =
	QStringList()
	<< "00008E;0000A4;1;24;Leerlaufregelungssystem Fehlfunktion"
	<< "00008E;0000A4;2;23;Luftmassenmesser"
	<< "00008E;0000A4;3;22;Klopfsensor"
	<< "00008E;0000A4;4;21;Kühlmitteltemperatursensor"
	<< "00008E;0000A4;5;18;Elektrisches Belastungssignal"
	<< "00008E;0000A4;6;13;Nockenwellensensor"
	<< "00008E;0000A4;7;12;Anlassersignal"
	<< "00008E;0000A4;8;11;Kurbelwellensensor"
	<< "00008F;0000A5;1;37;Störung im hinteren Lambdasondenkreis / Gemischsensorkreis Fehlfuntion"
	<< "00008F;0000A5;2;35;Tankentlüftungssteuerung (Aktivkohlebehälter)"
	<< "00008F;0000A5;3;33;Fahrzeuggeschwindigkeitssensor (vorne)"
	<< "00008F;0000A5;4;32;Lambdasonde"
	<< "00008F;0000A5;5;31;Drosselklappensensor"
	<< "00008F;0000A5;6;29;Kurbelwellensensor 2"
	<< "00008F;0000A5;7;28;Klopfsensor #2"
	<< "00008F;0000A5;8;26;Ansauglufttemperatursensor"
	<< "000090;0000A6;1;45;Drucksensor"
	<< "000090;0000A6;2;44;Ladedruckregelung Ausgangssignal"
	<< "000090;0000A6;3;43;Gaspedalschalter"
	<< "000090;0000A6;4;42;Leerlaufschalter"
	<< "000090;0000A6;5;39;Traktionskontrollsystem (TCS/ASR)"
	<< "000090;0000A6;6;38;Drehmomenterlaubnissignal"
	<< "000090;0000A6;7;38;Drehmomentforderungssignal 2"
	<< "000090;0000A6;8;38;Drehmomentforderungssignal 1"
	<< "000091;0000A7;1;62;Magnetventil für Abgaskrümmer-Unterdruckregelung"
	<< "000091;0000A7;2;61;Ansaugluft-Regelmagnetventil"
	<< "000091;0000A7;3;56;Abgasrückführungssystem (EGR/AGR)"
	<< "000091;0000A7;4;55;Hubsensor des Abgasrückführungsventils (EGR/AGR-Ventil)"
	<< "000091;0000A7;5;54;Lufteinlaßsystem"
	<< "000091;0000A7;6;51;Leerlaufstellungsschalter"
	<< "000091;0000A7;7;49;CO Widerstand"
	<< "000091;0000A7;8;48;Magerverbrennungssystem"
	<< "000092;0000A8;1;53;Anti-Quick-Betriebsmodus"
	<< "000092;0000A8;2;66;Doppel-Turbolader System (T)"
	<< "000092;0000A8;3;66;Doppel-Turbolader System (S)"
	<< "000092;0000A8;4;66;Doppel-Turbolader System (H)"
	<< "000092;0000A8;5;66;Zweistufen-Doppelturbolader-System"
	<< "000092;0000A8;6;65;Differenzdrucksensor"
	<< "000092;0000A8;7;64;Überdruckventilregelung Magnetventil 1"
	<< "000092;0000A8;8;63;Überdruckventilregelung Magnetventil 2"
	<< "000093;0000A9;1;53;EEPROM des Wegfahrsperren-Steuergeräts"
	<< "000093;0000A9;2;53;EEPROM des Steuergeräts der Elektronischen Einspritzanlage (EGI)"
	<< "000093;0000A9;3;53;Falscher/Nicht registrierter Wegfahrsperrenschlüssel"
	<< "000093;0000A9;4;53;Schlüssel-Kommunikationsfehler"
	<< "000093;0000A9;5;53;Kommunikationsfehler (Zeit abgelaufen)"
	<< "000093;0000A9;6;53;Fehler im Schaltkreis der Wegfahrsperre (ausgenommen Antennenschaltkreis)"
	<< "000093;0000A9;7;53;Bezugscode fehlerhaft"
	<< "000093;0000A9;8;53;Antenne"
	<< "000094;0000AA;1;89;Variable Ventilsteuerung (VVT) Systeme (rechts)"
	<< "000094;0000AA;2;88;Störung im Kraftstoffpumpenschaltkreis"
	<< "000094;0000AA;3;87;Störung im Schaltkreis des Magnetventils für variablen Einlass (Ansaugung)"
	<< "000094;0000AA;4;86;CAN Kommunikationssystem"
	<< "000094;0000AA;5;85;Störung im Ladesystemschaltkreis (Generator)"
	<< "000094;0000AA;6;81;Regelventil für Drehmomentanhebung"
	<< "000094;0000AA;7;68;Ladedruckregelung Ausgangssignal 2"
	<< "000094;0000AA;8;67;Magnetventil für Abgaskrümmer-Überdruckregelung"
	<< "000095;0000AB;1;89;Variable Ventilsteuerung (VVT) Systeme (links)"
	<< "000095;0000AB;3;24;Leerlaufregelventil (ISC-Ventil) klemmt"
	<< "000095;0000AB;4;24;Unterbrechung/Kurzschluss im Schaltkreis des Leerlaufregelventils"
	<< "000095;0000AB;5;32;Gemischsensor Nr. 2 System"
	<< "000095;0000AB;6;32;Gemischsensor Nr. 1 System"
	<< "000095;0000AB;7;92;Störung im Stromerzeugungs-Regelsignalkreis"
	<< "000095;0000AB;8;91;Traktionskontrolle (TCS/ASR) Druckminderventil"
	<< "000096;0000AC;1;71;Schaltmagnetventil #1"
	<< "000096;0000AC;2;72;Schaltmagnetventil #2"
	<< "000096;0000AC;3;73;Zeitsteuermagnetventil für Niedriggang-Kupplung"
	<< "000096;0000AC;4;74;Zeitsteuermagnetventil für Lamellenbremse 2-4"
	<< "000096;0000AC;5;77;Arbeitsphasen-Magnetventil für Überbrückungskupplung"
	<< "000096;0000AC;6;75;Arbeitsphasen-Magnetventil für Hauptleitungsdruck"
	<< "000096;0000AC;7;76;Störung im Schaltkreis des Arbeitsphasen-Magnetventils für Lamellenbremse 2-4"
	<< "000096;0000AC;8;79;Arbeitsphasen-Magnetventil für Verteilergetriebekupplung (Allradkupplung)"
	<< "000097;0000AD;1;93;Fahrzeuggeschwindigkeitssensor #1 (hinten)"
	<< "000097;0000AD;2;27;Temperatursensor für Automatikgetriebeöl (ATF)"
	<< "000097;0000AD;3;94;Störung im Schaltkreis des Querbeschleunigungssensors (G-Sensor)"
	<< "000097;0000AD;4;11;Motordrehzahlsignal"
	<< "000097;0000AD;5;5-11;Koordinationssignalleitung"
	<< "000097;0000AD;6;38;Drehmomentregelungssystem Signal"
	<< "000097;0000AD;7;36;Drehmomentwandler-Turbinendrehzahlsignal"
	<< "000097;0000AD;8;78;Tiptronic-Magnetventilsystem";


// OBD-Fehlercodes:
const QStringList SSMFlagbyteDefinitions_de::_DTC_OBD_defs_de =
	QStringList()
	<< "00008E;0000AE;1;P0335;Kurbelwellensensor A Schaltkreis Fehlfunktion"
	<< "00008E;0000AE;3;P0336;Kurbelwellensensor A Bereich/Funktion Problem"
	<< "00008E;0000AE;4;P0341;Bereich/Leistung von Nockenwellenpositionssensor A"
	<< "00008E;0000AE;5;P0340;Kreis von Nockenwellenpositionssensor A"
	<< "00008E;0000AE;7;P0604;Fehler im RAM-Speicher des internen Steuermoduls"
	<< "00008E;0000AE;8;P0601;Internes Steuermodul - Speicher-Prüfsummenfehler"
	<< "00008F;0000AF;1;P0102;Kreis des Masse- oder Volumen- Luftmengensensors (niedrig)"
	<< "00008F;0000AF;2;P0103;Kreis des Masse- oder Volumen- Luftmengensensors (hoch)"
	<< "00008F;0000AF;3;P1141;Bereich/Leistung des Masse- oder Volumen-Luftmengensensors (niedrig)"
	<< "00008F;0000AF;4;P0101;Bereich/Leistung des Masse- oder Volumen-Luftmengensensors (hoch)"
	<< "00008F;0000AF;5;P0500;Fahrzeuggeschwindigkeitssensor"
	<< "00008F;0000AF;6;P1540;Fahrzeuggeschwindigkeitssensor Fehlfunktion bei niedriger Geschwindigkeit"
	<< "00008F;0000AF;7;P0332;Störung im Kreis von Klopfsensor 2 (niedriger Eingang)"
	<< "00008F;0000AF;8;P0333;Störung im Kreis von Klopfsensor 2 (hoher Eingang)"
	<< "000090;0000B0;1;P0325;Störung im Kreis von Klopfsensor 1"
	<< "000090;0000B0;2;P0330;Klopfsensor 2"
	<< "000090;0000B0;3;P0327;Störung im Kreis von Klopfsensor 1 (niedriger Eingang)"
	<< "000090;0000B0;4;P0328;Störung im Kreis von Klopfsensor 1 (hoher Eingang)"
	<< "000090;0000B0;5;P0122;Drosselklappenpositionssensor A (niedriger Eingang)"
	<< "000090;0000B0;6;P0123;Drosselklappenpositionssensor A (hoher Eingang)"
	<< "000090;0000B0;7;P1142;Drosselklappensensorfunktion Problem Eingangssignal niedrig"
	<< "000090;0000B0;8;P0121;Drosselklappenpositionssensor Leistungsproblem (hoher Eingang)"
	<< "000091;0000B1;1;P0117;Kühlmitteltemperatursensor Schaltkreis Eingangssignal niedrig"
	<< "000091;0000B1;2;P0118;Kühlmitteltemperatursensor Schaltkreis Eingangssignal hoch"
	<< "000091;0000B1;3;P0464;Kraftstoffstandsensorkreis Unterbrochen"
	<< "000091;0000B1;4;P0125;Unzureichende Kühlwassertemperatur für Kraftstoffregelung"
	<< "000091;0000B1;5;P0462;Kraftstoffstandgeberschaltkreis Eingangssignal niedrig"
	<< "000091;0000B1;6;P0463;Kraftstoffstandgeberschaltkreis Eingangssignal hoch"
	<< "000091;0000B1;7;P0461;Kraftstoffstandgeberfunktion Problem"
	<< "000091;0000B1;8;P1442;Kraftstoffstandgeberfunktion Problem (Fahrtstrecke)"
	<< "000092;0000B2;1;P0107;Drucksensorschaltkreis Eingangssignal niedrig"
	<< "000092;0000B2;2;P0108;Drucksensorschaltkreis Eingangssignal hoch"
	<< "000092;0000B2;3;P1143;Bereich/Leistung des Drucksensorkreises (niedrig)"
	<< "000092;0000B2;4;P1144;Bereich/Leistung des Drucksensorkreises (hoch)"
	<< "000092;0000B2;5;P0106;Bereich/Leistung des Drucksensorkreises"
	<< "000092;0000B2;6;P0350;Störung im Zündspulen-Primär Sekundärkreis"
	<< "000092;0000B2;7;P1518;Anlasserschaltkreis Eingangssignal niedrig"
	<< "000092;0000B2;8;P0512;Anlasserschaltkreis Eingangssignal hoch"
	<< "000093;0000B3;1;P0452;Kraftstofftankdrucksensor Schaltkreis Eingangssignal niedrig"
	<< "000093;0000B3;2;P0453;Kraftstofftankdrucksensor Schaltkreis Eingangssignal hoch"
	<< "000093;0000B3;4;P0451;Kraftstofftankdrucksensor Funktionsproblem"
	<< "000093;0000B3;5;P1237;Abgassteuerung Magnetventilkreis (niedrig) (Überdruck)"
	<< "000093;0000B3;6;P1238;Abgassteuerung Magnetventilkreis (hoch) (Überdruck)"
	<< "000093;0000B3;7;P1239;Abgassteuerung Magnetventilkreis (niedrig) (Unterdruck)"
	<< "000093;0000B3;8;P1240;Abgassteuerung Magnetventilkreis (hoch) (Unterdruck)"
	<< "000094;0000B4;1;P1590;Neutralstellungsschaltkreis (AT) Eingangssignal hoch"
	<< "000094;0000B4;2;P1591;Neutralstellungsschaltkreis (AT) Eingangssignal niedrig"
	<< "000094;0000B4;3;P1592;Leerlaufstellungsschalter (MT) Schaltkreis Fehlfunktion"
	<< "000094;0000B4;4;P0851;Neutralschalter-Eingangskreis (niedrig)"
	<< "000094;0000B4;5;P0182;Kraftstofftemperatursensorfunktion A Schaltkreis-Eingangssignal niedrig"
	<< "000094;0000B4;6;P0183;Kraftstofftemperatursensorfunktion A Schaltkreis-Eingangssignal hoch"
	<< "000094;0000B4;7;P0181;Kraftstofftemperatursensorfunktion A Problem"
	<< "000094;0000B4;8;P0852;Neutralschalter-Eingangskreis (hoch)"
	<< "000095;0000B5;1;P1510;Störung im Kreis für ISC-Magnetventilsignal #1 (niedriger Eingang)"
	<< "000095;0000B5;2;P1511;Störung im Kreis für ISC-Magnetventilsignal #1 (hoher Eingang)"
	<< "000095;0000B5;3;P1512;Störung im Kreis für ISC-Magnetventilsignal #2 (niedriger Eingang)"
	<< "000095;0000B5;4;P1513;Störung im Kreis für ISC-Magnetventilsignal #2 (hoher Eingang)"
	<< "000095;0000B5;5;P1514;Störung im Kreis für ISC-Magnetventilsignal #3 (niedriger Eingang)"
	<< "000095;0000B5;6;P1515;Störung im Kreis für ISC-Magnetventilsignal #3 (hoher Eingang)"
	<< "000095;0000B5;7;P1516;Störung im Kreis für ISC-Magnetventilsignal #4 (niedriger Eingang)"
	<< "000095;0000B5;8;P1517;Störung im Kreis für ISC-Magnetventilsignal #4 (hoher Eingang)"
	<< "000096;0000B6;1;P1492;Störung im Kreis für AGR-Magnetventilsignal #1 (niedriger Eingang)"
	<< "000096;0000B6;2;P1493;Störung im Kreis für AGR-Magnetventilsignal #1 (hoher Eingang)"
	<< "000096;0000B6;3;P1494;Störung im Kreis für AGR-Magnetventilsignal #2 (niedriger Eingang)"
	<< "000096;0000B6;4;P1495;Störung im Kreis für AGR-Magnetventilsignal #2 (hoher Eingang)"
	<< "000096;0000B6;5;P1496;Störung im Kreis für AGR-Magnetventilsignal #3 (niedriger Eingang)"
	<< "000096;0000B6;6;P1497;Störung im Kreis für AGR-Magnetventilsignal #3 (hoher Eingang)"
	<< "000096;0000B6;7;P1498;Störung im Kreis für AGR-Magnetventilsignal #4 (niedriger Eingang)"
	<< "000096;0000B6;8;P1499;Störung im Kreis für AGR-Magnetventilsignal #4 (hoher Eingang)"
	<< "000097;0000B7;1;P1102;Atmosphären-/Ansaugdruckumschaltung Magnetventil-Schaltkreissignal niedrig"
	<< "000097;0000B7;2;P1122;Atmosphären-/Ansaugdruckumschaltung Magnetventil-Schaltkreissignal hoch"
	<< "000097;0000B7;3;P1446;Kreis des Kraftstofftanksensor-Steuerventils (niedrig)"
	<< "000097;0000B7;4;P1447;Kreis des Kraftstofftanksensor-Steuerventils (hoch)"
	<< "000097;0000B7;5;P1090;TGV-System 1 (Ventil offen)"
	<< "000097;0000B7;6;P1091;TGV-System 1 (Ventil geschlossen)"
	<< "000097;0000B7;7;P1092;TGV-System 2 (Ventil offen)"
	<< "000097;0000B7;8;P1093;TGV-System 2 (Ventil geschlossen)"
	<< "000098;0000B8;1;P0508;Kreis des Leerlaufdrehzahl-Regelsystems (niedrig)"
	<< "000098;0000B8;2;P0509;Kreis des Leerlaufdrehzahl-Regelsystems (hoch)"
	<< "000098;0000B8;3;P1507;Leerlaufregelungssystem (Notlauffunktion)"
	<< "000098;0000B8;4;P0506;Leerlaufregelung: Ist-Drehzahl niedriger als erwartet"
	<< "000098;0000B8;5;P0507;Leerlaufregelung: Ist-Drehzahl hoeher als erwartet"
	<< "000098;0000B8;6;P1698;Störung im Sperrsignalkreis für Motordrehmomentregelung (niedriger Eingang)"
	<< "000098;0000B8;7;P1699;Störung im Sperrsignalkreis für Motordrehmomentregelung (hoher Eingang)"
	<< "000098;0000B8;8;P1448;Bereich/Leistung des Kraftstofftanksensor-Steuerventils"
	<< "000099;0000B9;1;P0444;Schaltkreis Spülluftmagnetventil Signal niedrig"
	<< "000099;0000B9;2;P0445;Schaltkreis Spülluftmagnetventil Signal hoch"
	<< "000099;0000B9;3;P0691;Kühlerlüfterrelais 1 Schaltkreis Signal niedrig"
	<< "000099;0000B9;4;P0692;Kühlerlüfterrelais 1 Schaltkreis Signal hoch"
	<< "000099;0000B9;5;P0480;Kühlerlüfterrelais 1 Schaltkreis Signal niedrig"
	<< "000099;0000B9;6;P1480;Kühlerlüfterrelais 1 Schaltkreis Signal hoch"
	<< "000099;0000B9;7;P0483;Kühlerlüfterfunktion Problem"
	<< "000099;0000B9;8;P0864;Bereich/Leistung des TCM-Kommunikationskreises"
	<< "00009A;0000BA;1;P0365;Kreis von Nockenwellenpositionssensor B (Bank 1)"
	<< "00009A;0000BA;2;P0390;Kreis von Nockenwellenpositionssensor B (Bank 2)"
	<< "00009A;0000BA;3;P0011;Leistung/Bereich des A Nocken- wellenpositionssystems (Bank 1)"
	<< "00009A;0000BA;4;P0021;Leistung/Bereich des A Nocken- wellenpositionssystems (Bank 2)"
	<< "00009A;0000BA;5;P1400;Kraftstofftankdruckregelung: Magnetventil-Schaltkreis: Signal niedrig"
	<< "00009A;0000BA;6;P1420;Kraftstofftankdruckregelung: Magnetventil-Schaltkreis: Signal hoch"
	<< "00009A;0000BA;7;P0458;Schaltkreis Spülluftmagnetventil Signal niedrig"
	<< "00009A;0000BA;8;P0459;Schaltkreis Spülluftmagnetventil Signal hoch"
	<< "00009B;0000BB;1;P0865;TCM-Kommunikationskreis (niedrig)"
	<< "00009B;0000BB;2;P0866;TCM-Kommunikationskreis (hoch)"
	<< "00009B;0000BB;3;P1443;CPC-Pruefmagnetventil Funktionsbereich Problem"
	<< "00009B;0000BB;4;P1559;Lufteinlaßsystem"
	<< "00009B;0000BB;5;P0661;Kreis des Ansaugkrümmer-Einstellventils (niedrig)"
	<< "00009B;0000BB;6;P0662;Kreis des Ansaugkrümmer-Einstellventils (hoch)"
	<< "00009B;0000BB;7;P0447;Offener Lüftungsregelkreis des EVAP-Regelsystems"
	<< "00009B;0000BB;8;P0448;Kurzschluss im Lüftungsregelkreis des EVAP-Regelsystems"
	<< "00009C;0000BC;1;P0720;AT Fahrzeug-Geschwindigkeitssensor"
	<< "00009C;0000BC;2;P0725;Motordrehzahlimpulseingang Fehlfunktion"
	<< "00009C;0000BC;3;P1700;Drosselklappensensor Fehlfunktion für AT"
	<< "00009C;0000BC;4;P0710;ATF Temperatursensor Fehlfunktion"
	<< "00009C;0000BC;5;P0705;AT Bereichsschalter"
	<< "00009C;0000BC;6;P1701;Tempomat SET Signal Fehlfunktion"
	<< "00009C;0000BC;7;P0703;Bremslichtschaltersignal Fehlfunktion für AT"
	<< "00009C;0000BC;8;P0741;AT Wandlerüberbrückung Funktion"
	<< "00009D;0000BD;1;P0753;Schaltmagnetventil A fehlerhaft"
	<< "00009D;0000BD;2;P0758;Schaltmagnetventil B fehlerhaft"
	<< "00009D;0000BD;3;P1706;Störung im Raddrehzahlsensorkreis (Hinterrad) (Automatikgetriebe)"
	<< "00009D;0000BD;4;P0748;AT Hauptdruckmagnetventil (A)"
	<< "00009D;0000BD;5;P0743;AT Hauptdruckmagnetventil (B)"
	<< "00009D;0000BD;6;P0731;1. Gang inkorrekte Übersetzung"
	<< "00009D;0000BD;7;P0732;2. Gang inkorrekte Übersetzung"
	<< "00009D;0000BD;8;P0733;3. Gang inkorrekte Übersetzung"
	<< "00009E;0000BE;1;P0734;4. Gang inkorrekte Übersetzung"
	<< "00009E;0000BE;2;P1707;Störung im Allradantriebs-Magnetventilstromkreis (Automatikgetriebe)"
	<< "00009E;0000BE;3;P1595;AT Diagnose Eingangssignal Schaltkreis Eingangssignal niedrig"
	<< "00009E;0000BE;4;P1596;AT Diagnose Eingangssignal Schaltkreis Eingangssignal hoch"
	<< "00009E;0000BE;5;P0135;Lambdasondenheizungskreis (Bank 1 Sonde 1)"
	<< "00009E;0000BE;6;P0141;Lambdasondenheizungskreis (Bank 1 Sonde 2)"
	<< "00009E;0000BE;7;P1593;Störung im TCM-Kommunikationskreis"
	<< "00009E;0000BE;8;P1594;AT Diagnose Eingangssignal Schaltkreis Fehlfunktion"
	<< "00009F;0000BF;1;P0133;Langsames Ansprechen des Lambdasondenkreises (Bank 1 Sonde 1)"
	<< "00009F;0000BF;2;P0130;Lambdasondenkreis (Bank 1 Sonde 1)"
	<< "00009F;0000BF;3;P0139;Langsames Ansprechen des Lambdasondenkreises (Bank 1 Sonde 2)"
	<< "00009F;0000BF;4;P0136;Lambdasondenkreis (Bank 1 Sonde 2)"
	<< "00009F;0000BF;5;P1152;Bereich/Leistung des Lambdasondenkreises (niedrig) (Bank 1 Sonde 1)"
	<< "00009F;0000BF;6;P1153;Bereich/Leistung des Lambdasondenkreises (hoch) (Bank 1 Sonde 1)"
	<< "00009F;0000BF;7;P0174;System zu mager (Bank 2)"
	<< "00009F;0000BF;8;P0175;System zu fett (Bank 2)"
	<< "0000A0;0000C0;1;P0420;Katalysator Konvertierungsrate unterhalb der Sollgrenze"
	<< "0000A0;0000C0;2;P0442;Undichtigkeit im EVAP-Regelsystem (kleines Leck)"
	<< "0000A0;0000C0;3;P0170;Kraftstofftrimmung (Bank 1)"
	<< "0000A0;0000C0;4;P0456;Undichtigkeit im EVAP-Regelsystem (sehr kleines Leck)"
	<< "0000A0;0000C0;5;P0400;EGR-System"
	<< "0000A0;0000C0;6;P1230;Kraftstoffpumpen-Steuergerät"
	<< "0000A0;0000C0;7;P0171;System zu mager (Bank 1)"
	<< "0000A0;0000C0;8;P0172;System zu fett (Bank 1)"
	<< "0000A1;0000C1;1;P0301;Zylinder 1 Fehlzündung erkannt"
	<< "0000A1;0000C1;2;P0302;Zylinder 2 Fehlzündung erkannt"
	<< "0000A1;0000C1;3;P0303;Zylinder 3 Fehlzündung erkannt"
	<< "0000A1;0000C1;4;P0304;Zylinder 4 Fehlzündung erkannt"
	<< "0000A1;0000C1;5;P0305;Zylinder 5 Fehlzündung erkannt"
	<< "0000A1;0000C1;6;P0306;Zylinder 6 Fehlzündung erkannt"
	<< "0000A1;0000C1;7;P1301;Fehlzündung festgestellt (hohe Abgastemperatur)"
	<< "0000A1;0000C1;8;P0457;Undichtigkeit im EVAP-Regelsystem (Tankdeckel lose/ab)"
	<< "0000A2;0000C2;1;;"	// => IGNORIEREN
	<< "0000A2;0000C2;2;;"	// => IGNORIEREN
	<< "0000A2;0000C2;3;P1235;Einlasssteuerung Magnetventilkreis (niedrig)"
	<< "0000A2;0000C2;4;P1236;Einlasssteuerung Magnetventilkreis (hoch)"
	<< "0000A2;0000C2;5;P1597;TCS Signal Schaltkreis Eingangsignal niedrig"
	<< "0000A2;0000C2;6;P1598;TCS Signal Schaltkreis Eingangsignal hoch"
	<< "0000A2;0000C2;7;P0034;Regelkreis des Turbolader- Umgehungsventils (niedrig)"
	<< "0000A2;0000C2;8;P0035;Regelkreis des Turbolader- Umgehungsventils (hoch)"
	<< "0000A3;0000C3;1;P0137;Niedrige Spannung im Lambdasondenkreis (Bank 1 Sonde 2)"
	<< "0000A3;0000C3;2;P1134;Problem im Gemischsensor-Mikroprozessor"
	<< "0000A3;0000C3;3;P0131;Niedrige Spannung im Lambdasondenkreis (Bank 1 Sonde 1)"
	<< "0000A3;0000C3;4;P0151;Niedrige Spannung im Lambdasondenkreis (Bank 2 Sonde 1)"
	<< "0000A3;0000C3;5;P0132;Hohe Spannung im Lambdasondenkreis (Bank 1 Sonde 1)"
	<< "0000A3;0000C3;6;P0152;Hohe Spannung im Lambdasondenkreis (Bank 2 Sonde 1)"
	<< "0000A3;0000C3;7;P0138;Hohe Spannung im Lambdasondenkreis (Bank 1 Sonde 2)"
	<< "0000A3;0000C3;8;P0153;Langsames Ansprechen des Lambdasondenkreises (Bank 2 Sonde 1)"
	<< "0000A4;0000C4;1;P0112;Störung des Ansauglufttemperatur-Sensorkreises (niedriger Eingang)"
	<< "0000A4;0000C4;2;P0113;Störung des Ansauglufttemperatur-Sensorkreises (hoher Eingang)"
	<< "0000A4;0000C4;3;P0111;Bereichs/Leistungsproblem des Ansauglufttemperatursensors"
	<< "0000A4;0000C4;4;P1546;Störung im Kreis des Abgastemperatursensors 2 (hoher Eingang)"
	<< "0000A4;0000C4;5;P0038;Lambdasondenheizungskreis (hoch) (Bank 1 Sonde 2)"
	<< "0000A4;0000C4;6;P0032;Lambdasondenheizungskreis (hoch) (Bank 1 Sonde 1)"
	<< "0000A4;0000C4;7;P0037;Lambdasondenheizungskreis (niedrig) (Bank 1 Sonde 2)"
	<< "0000A4;0000C4;8;P0031;Lambdasondenheizungskreis (niedrig) (Bank 1 Sonde 1)"
	<< "0000A5;0000C5;1;P1110;Störung im Luftdrucksensorkreis (niedriger Eingang)"
	<< "0000A5;0000C5;2;P1111;Störung im Luftdrucksensorkreis (hoher Eingang)"
	<< "0000A5;0000C5;3;P1112;Problem mit Drucksensor-Bereich/-Leistung"
	<< "0000A5;0000C5;4;P0106;Bereichs/Leistungsproblem des Krümmerdrucksensorkreises"
	<< "0000A5;0000C5;5;P0107;Störung des Krümmerdruck-Sensorkreises (niedriger Eingang)"
	<< "0000A5;0000C5;6;P0108;Störung des Krümmerdruck-Sensorkreises (hoher Eingang)"
	<< "0000A5;0000C5;7;P1545;Störung im Kreis des Abgastemperatursensors 2 (niedriger Eingang)"
	<< "0000A5;0000C5;8;P1146;Bereichs/Leistungsproblem des Krümmerdrucksensorkreises"
	<< "0000A6;0000C6;1;P1139;Bereich/Leistung des Lambdasonden-Heizungskreises (Bank 1 Sonde 1)"
	<< "0000A6;0000C6;2;P1140;Bereich/Leistung des Lambdasonden-Heizungskreises (Bank 2 Sonde 1)"
	<< "0000A6;0000C6;3;P1711;Störung im Kreis des Motordrehmoment-Steuersignals Nr. 1"
	<< "0000A6;0000C6;4;P1712;Störung im Kreis des Motordrehmoment-Steuersignals Nr. 2"
	<< "0000A6;0000C6;5;P0715;Störung im Drehmomentwandler-Drehzahlsignalkreis"
	<< "0000A6;0000C6;6;P1703;Störung im AT L-Kupplungssteuerungs-Solenoidventilkreis"
	<< "0000A6;0000C6;7;P0785;Störung im AT 2-4 Bremssteuerungs-Magnetventilkreis"
	<< "0000A6;0000C6;8;P0778;Störung im AT 2-4 Bremsdruck-Magnetventilkreis"
	<< "0000A7;0000C7;1;P1130;Lambdasondenkreis (offen) (Bank 1 Sonde 1)"
	<< "0000A7;0000C7;2;P1135;Lambdasondenkreis (offen) (Bank 2 Sonde 1)"
	<< "0000A7;0000C7;3;P1131;Lambdasondenkreis (Kurzschluss) (Bank 1 Sonde 1)"
	<< "0000A7;0000C7;4;P1136;Lambdasondenkreis (Kurzschluss) (Bank 2 Sonde 1)"
	<< "0000A7;0000C7;5;P1154;Bereich/Leistung des Lambdasondenkreises (niedrig) (Bank 2 Sonde 1)"
	<< "0000A7;0000C7;6;P1155;Bereich/Leistung des Lambdasondenkreises (hoch) (Bank 2 Sonde 1)"
	<< "0000A7;0000C7;7;P0052;Lambdasondenheizungskreis (hoch) (Bank 2 Sonde 1)"
	<< "0000A7;0000C7;8;P0051;Lambdasondenheizungskreis (niedrig) (Bank 2 Sonde 1)"
	<< "0000A8;0000C8;1;P0128;Kuehlmittelthermostat"
	<< "0000A8;0000C8;2;P1491;Funktionsstörung der positiven Kurbelgehäuseentlüftung (PCV) (Durchblasen)"
	<< "0000A8;0000C8;3;P0066;Kreis der luftunterstützten Einspritzregelung (niedrig)"
	<< "0000A8;0000C8;4;P0067;Kreis der luftunterstützten Einspritzregelung (hoch)"
	<< "0000A8;0000C8;5;P0065;Leistung/Bereich der luftunterstützten Einspritzregelung"
	<< "0000A8;0000C8;6;P0130;Lambdasondenkreis (mager) (Bank 1 Sonde 1)"
	<< "0000A8;0000C8;7;P1137;Lambdasondenkreis (Lambda=1) (Bank 1 Sonde 1)"
	<< "0000A8;0000C8;8;P1137;Lambdasondenkreis (mittlerer) (Bank 1 Sonde 1)"
	<< "0000A9;0000C9;1;P1248;Kreis von Überdruckventil-Steuermagnetventil 1 (hoch)"
	<< "0000A9;0000C9;2;P1249;Kreis von Überdruckventil-Steuermagnetventil 2 (niedrig)"
	<< "0000A9;0000C9;3;P1250;Kreis von Überdruckventil-Steuermagnetventil 2 (hoch)"
	<< "0000A9;0000C9;4;P1560;Störung im Sperrspannungskreis"
	<< "0000A9;0000C9;5;P0192;Kraftstoffdrucksensorkreis (niedrig)"
	<< "0000A9;0000C9;6;P0193;Kraftstoffdrucksensorkreis (hoch)"
	<< "0000A9;0000C9;7;P0562;Systemspannung (niedrig)"
	<< "0000A9;0000C9;8;P0563;Systemspannung (hoch)"
	<< "0000AA;0000CA;1;P0245;Ladedruckregelventil Magnetventil A (niedrig)"
	<< "0000AA;0000CA;2;P0246;Ladedruckregelventil Magnetventil A (hoch)"
	<< "0000AA;0000CA;3;P1244;Bereich/Leistung des Ladedruck-Magnetventils A (niedriger Eingang)"
	<< "0000AA;0000CA;4;P0244;Bereich/Leistung des Ladedruck-Magnetventils A (hoher Eingang)"
	<< "0000AA;0000CA;5;P1245;Bereich/Leistung des Ladedruck-Magnetventils A (Failsafe)"
	<< "0000AA;0000CA;6;P0249;Ladedruckregelventil Magnetventil B (niedrig)"
	<< "0000AA;0000CA;7;P0250;Ladedruckregelventil Magnetventil B (hoch)"
	<< "0000AA;0000CA;8;P1247;Stromkreis von Überdruckventil-Steuermagnetventil 1 (niedrig)"
	<< "0000AB;0000CB;1;P1577;Wegfahrsperre (WFS) Fehlerhafter EEPROM des Steuergeräts"
	<< "0000AB;0000CB;2;P1576;Elektronische Kraftstoffeinspritzung (EGI) Fehlerhafter EEPROM des Steuergeräts"
	<< "0000AB;0000CB;3;P0513;Falscher Wegfahrsperrenschlüssel"
	<< "0000AB;0000CB;4;P1574;Schlüssel-Kommunikationsfehler"
	<< "0000AB;0000CB;5;P1578;Instrumentenstörung"
	<< "0000AB;0000CB;6;P1572;Systemkreisunterbrechung der Wegfahrsperre (WFS) (ausgenommen Antennenstromkreis)"
	<< "0000AB;0000CB;7;P1571;Bezugscode fehlerhaft"
	<< "0000AB;0000CB;8;P1570;Antenne"
	<< "0000AC;0000CC;1;P1095;Störung im Signalkreis von Tumble-Ventil (TGV) 1 (Kurzschluss)"
	<< "0000AC;0000CC;2;P1097;Störung im Signalkreis von Tumble-Ventil (TGV) 2 (Kurzschluss)"
	<< "0000AC;0000CC;3;P1094;Störung im Signalkreis von Tumble-Ventil (TGV) 1 (offen)"
	<< "0000AC;0000CC;4;P1096;Störung im Signalkreis von Tumble-Ventil (TGV) 2 (offen)"
	<< "0000AC;0000CC;5;P0261;Einspritzventilschaltkreis #1 Signal niedrig"
	<< "0000AC;0000CC;6;P0264;Einspritzventilschaltkreis #2 Signal niedrig"
	<< "0000AC;0000CC;7;P0267;Einspritzventilschaltkreis #3 Signal niedrig"
	<< "0000AC;0000CC;8;P0270;Einspritzventilschaltkreis #4 Signal niedrig"
	<< "0000AD;0000CD;1;P0545;Störung im Abgastemperatursensorkreis (niedriger Eingang)"
	<< "0000AD;0000CD;2;P0546;Störung im Abgastemperatursensorkreis (hoher Eingang)"
	<< "0000AD;0000CD;3;P1312;Abgastemperatursensor Störung"
	<< "0000AD;0000CD;4;P1544;Abgastemperatur zu hoch"
	<< "0000AD;0000CD;5;P1306;Störung im Signalkreis von Ölfluss-Steuermagnetventil (OCV) 1 (offen)"
	<< "0000AD;0000CD;6;P1308;Störung im Signalkreis von Ölfluss-Steuermagnetventil (OCV) 2 (offen)"
	<< "0000AD;0000CD;7;P1307;Störung im Signalkreis von Ölfluss-Steuermagnetventil (OCV) 1 (Kurzschluss)"
	<< "0000AD;0000CD;8;P1309;Störung im Signalkreis von Ölfluss-Steuermagnetventil (OCV) 2 (Kurzschluss)"
	<< "0000F0;0000F4;1;P1719;ECU-Kommunikationskreis"
	<< "0000F0;0000F4;2;P1242;2-stufiges Twin-TURBO-System (doppelt)"
	<< "0000F0;0000F4;3;P1241;2-stufiges Twin-TURBO-System (einfach)"
	<< "0000F0;0000F4;4;P1199;Differenzdrucksensor"
	<< "0000F0;0000F4;5;P1086;Stromkreis des Positionssensors von Tumble-Ventil (TGV) 2 (niedrig)"
	<< "0000F0;0000F4;6;P1087;Stromkreis des Positionssensors von Tumble-Ventil (TGV) 2 (hoch)"
	<< "0000F0;0000F4;7;P1088;Stromkreis des Positionssensors von Tumble-Ventil (TGV) 1 (niedrig)"
	<< "0000F0;0000F4;8;P1089;Stromkreis des Positionssensors von Tumble-Ventil (TGV) 1 (hoch)"
	<< "0000F1;0000F5;1;P0801;Steuerkreis der Rückwärtsgangsperre"
	<< "0000F1;0000F5;2;P0768;Schaltmagnetventil D Elektrik"
	<< "0000F1;0000F5;3;P0763;Schaltmagnetventil C Elektrik"
	<< "0000F1;0000F5;4;P0736;Falsches Rückwärtsgang-Verhältnis"
	<< "0000F1;0000F5;5;P0724;Bremsschalterkreis (hoch)"
	<< "0000F1;0000F5;6;P0719;Bremsschalterkreis (niedrig)"
	<< "0000F1;0000F5;7;P0713;ATF-Temperatursensorkreis (hoch)"
	<< "0000F1;0000F5;8;P0712;ATF-Temperatursensorkreis (niedrig)"
	<< "0000F2;0000F6;1;P1817;Sportmodusschalter-Signal"
	<< "0000F2;0000F6;2;P1762;Querbeschleunigungssensorkreis (hoch)"
	<< "0000F2;0000F6;3;P1761;Querbeschleunigungssensorkreis (niedrig)"
	<< "0000F2;0000F6;4;P1760;Querbeschleunigungsensor Leistungsproblem"
	<< "0000F2;0000F6;5;P1718;AT CAN Kommunikation"
	<< "0000F2;0000F6;6;P1714;Drosselklappenpositionssensor Spannungsversorgungskreis"
	<< "0000F2;0000F6;7;P1709;Drosselklappensensorschaltkreis Eingangssignal hoch"
	<< "0000F2;0000F6;8;P1708;Drosselklappensensorschaltkreis Eingangssignal niedrig"
	<< "0000F3;0000F7;1;P1600;Falsche CAN-Kommunikation"
	<< "0000F3;0000F7;2;P2709;Schaltmagnetventil F Elektrik"
	<< "0000F3;0000F7;3;P0773;Schaltmagnetventil E Elektrik"
	<< "0000F3;0000F7;4;P0735;5. Gang inkorrekte Übersetzung"
	<< "0000F3;0000F7;5;P1799;Verriegelung"
	<< "0000F3;0000F7;6;P1798;1. Gang Motorbremsung"
	<< "0000F3;0000F7;7;P1314;Fehlzündungsdetektor-Signalkreis (niedrig)"
	<< "0000F3;0000F7;8;P1313;Fehlzündungsdetektor-Signalkreis (hoch)"
	<< "000123;00012B;1;P1710;Störung in Drehzahl-Signalkreis von Drehmomentwandler-Turbine 2"
	<< "000123;00012B;2;P1717;Kreis von ATF-Temperatursensor 2 (hoch)"
	<< "000123;00012B;3;P1716;Kreis von ATF-Temperatursensor 2 (niedrig)"
	<< "000123;00012B;4;P0771;Störung im AT L-Kupplungssteuerungs-Magnetventilschaltkreis"
	<< "000123;00012B;5;P0716;Störung im Drehmomentwandler-Drehzahlsignalkreis"
	<< "000123;00012B;6;P0726;Motordrehzahlimpulseingang Fehlfunktion"
	<< "000123;00012B;7;P0720;AT-Geschwindigkeitssensorkreis (hoch)"
	<< "000123;00012B;8;P0722;AT-Geschwindigkeitssensorkreis (niedrig)"
	<< "000124;00012C;1;P2707;Störung von Schaltmagnetventil F"
	<< "000124;00012C;2;P0771;Störung von Schaltmagnetventil E"
	<< "000124;00012C;3;P0766;Störung von Schaltmagnetventil D"
	<< "000124;00012C;4;P0761;Störung von Schaltmagnetventil C"
	<< "000124;00012C;5;P0756;Störung von Schaltmagnetventil B"
	<< "000124;00012C;6;P0751;Störung von Schaltmagnetventil A"
	<< "000124;00012C;7;P1769;Giermoment- und Querbeschleunigungs-Sensorfehler"
	<< "000124;00012C;8;P1282;Kreis des PCV-Systems (Unterbrechung)"
	<< "000125;00012D;1;P1844;Kreis von Getriebeflüssigkeits-Drucksensorschalter E"
	<< "000125;00012D;2;P1843;Kreis von Getriebeflüssigkeits-Drucksensorschalter D"
	<< "000125;00012D;3;P1842;Kreis von Getriebeflüssigkeits-Drucksensorschalter C"
	<< "000125;00012D;4;P1841;Kreis von Getriebeflüssigkeits-Drucksensorschalter B"
	<< "000125;00012D;5;P1840;Kreis von Getriebeflüssigkeits-Drucksensorschalter A"
	<< "000125;00012D;6;P1875;Kreis des Zentraldifferentials"
	<< "000125;00012D;7;P0558;Lichtmaschinenkreis (niedrig)"
	<< "000125;00012D;8;P0559;Lichtmaschinenkreis (hoch)"
	<< "000126;00012E;1;P0502;Fahrzeuggeschwindigkeitssensor (niedrige Geschwindigkeit)"
	<< "000126;00012E;2;P0230;Kraftstoffpumpen-Steuergerät"
	<< "000126;00012E;3;P0565;Tempomat-Einstellsignal"
	<< "000126;00012E;4;P0068;Bereich/Leistung des Krümmerdrucksensors"
	<< "000126;00012E;5;P0129;Bereich/Leistung des Luftdrucksensors"
	<< "000126;00012E;6;P0519;Leerlaufregelungssystem (Notlauffunktion)"
	<< "000126;00012E;7;P0345;Kreis von Nockenwellenpositionssensor A (Bank 2)"
	<< "000126;00012E;8;P0101;Bereich/Leistung des Masse- oder Volumen-Luftmengensensors"
	<< "000127;00012F;1;P0154;Lambdasondenkreis (offen) (Bank 2 Sonde 1)"
	<< "000127;00012F;2;P0134;Lambdasondenkreis (offen) (Bank 1 Sonde 1)"
	<< "000127;00012F;3;P0150;Lambdasondenkreis (Bank 2 Sonde 1)"
	<< "000127;00012F;4;P0130;Lambdasondenkreis (Bank 1 Sonde 1)"
	<< "000127;00012F;5;P0050;Bereich/Leistung des Lambdasonden-Heizungskreises (Bank 2 Sonde 1)"
	<< "000127;00012F;6;P0030;Bereich/Leistung des Lambdasonden-Heizungskreises (Bank 1 Sonde 1)"
	<< "000127;00012F;7;P0501;Fahrzeuggeschwindigkeitssensor Fehlfunktion bei niedriger Geschwindigkeit"
	<< "000127;00012F;8;P0503;Fahrzeuggeschwindigkeitssensor (hohe Geschwindigkeit)"
	<< "000128;000130;1;P0142;Lambdasondenkreis (Bank 1 Sonde 3)"
	<< "000128;000130;2;P0145;Langsames Ansprechen des Lambdasondenkreises (Bank 1 Sonde 3)"
	<< "000128;000130;3;P0156;Lambdasondenkreis (Bank 2 Sonde 2)"
	<< "000128;000130;4;P0159;Langsames Ansprechen des Lambdasondenkreises (Bank 2 Sonde 2)"
	<< "000128;000130;5;P0162;Lambdasondenkreis (Bank 2 Sonde 3)"
	<< "000128;000130;6;P0165;Langsames Ansprechen des Lambdasondenkreises (Bank 2 Sonde 3)"
	<< "000128;000130;7;P0043;Lambdasondenheizungskreis (niedrig) (Bank 1 Sonde 3)"
	<< "000128;000130;8;P0044;Lambdasondenheizungskreis (hoch) (Bank 1 Sonde 3)"
	<< "000129;000131;1;P0057;Lambdasondenheizungskreis (niedrig) (Bank 2 Sonde 2)"
	<< "000129;000131;2;P0058;Lambdasondenheizungskreis (hoch) (Bank 2 Sonde 2)"
	<< "000129;000131;3;P0063;Lambdasondenheizungskreis (niedrig) (Bank 2 Sonde 3)"
	<< "000129;000131;4;P0064;Lambdasondenheizungskreis (hoch) (Bank 2 Sonde 3)"
	<< "000129;000131;5;P0157;Niedrige Spannung im Lambdasondenkreis (Bank 2 Sonde 2)"
	<< "000129;000131;6;P0158;Hohe Spannung im Lambdasondenkreis (Bank 2 Sonde 2)"
	<< "000129;000131;7;P0143;Niedrige Spannung im Lambdasondenkreis (Bank 1 Sonde 3)"
	<< "000129;000131;8;P0144;Hohe Spannung im Lambdasondenkreis (Bank 1 Sonde 3)"
	<< "00012A;000132;1;P2109;Drosselklappenwinkelsensor"
	<< "00012A;000132;2;P1759;Kreis des Querbeschleunigungssensorsystems"
	<< "00012A;000132;3;P1873;Radsensor hinten rechts abnormales Signal"
	<< "00012A;000132;4;P1872;Radsensor hinten links abnormales Signal"
	<< "00012A;000132;5;P1871;Radsensor vorne rechts abnormales Signal"
	<< "00012A;000132;6;P1870;Radsensor vorne links abnormales Signal"
	<< "00012A;000132;7;P2125;Gaspedal-Positionssensor E"
	<< "00012A;000132;8;P1700;Drosselklappensensorschaltkreis Fehlfunktion"
	<< "000150;000155;1;P0222;Drosselklappenpositionssensor B (niedriger Eingang)"
	<< "000150;000155;2;P0223;Drosselklappenpositionssensor B (hoher Eingang)"
	<< "000150;000155;3;P1160;Versagen der Rückholfeder"
	<< "000150;000155;4;P2102;Drosselklappen-Stellmotorkreis (niedriger Eingang)"
	<< "000150;000155;5;P2103;Drosselklappen-Stellmotorkreis (hoher Eingang)"
	<< "000150;000155;6;P2101;Bereich/Leistung des Drosselklappen-Stellmotorkreises"
	<< "000150;000155;7;P2096;Nach-Katalysator-Kraftstofftrimmung zu mager (Bank 1)"
	<< "000150;000155;8;P0638;Bereichs-/Leistungsproblem des Drosselklappen-Steuerkreises"
	<< "000151;000156;1;P0607;Bereich/Leistung des Drosselklappen-Steuersystemkreises"
	<< "000151;000156;2;P2138;Bereich/Leistung des Gaspedal- Positionssensorkreises"
	<< "000151;000156;3;P2127;Gaspedal-Positionssensor E (niedriger Eingang)"
	<< "000151;000156;4;P2128;Gaspedal-Positionssensor E (hoher Eingang)"
	<< "000151;000156;5;P2122;Gaspedal-Positionssensor D (niedriger Eingang)"
	<< "000151;000156;6;P2123;Gaspedal-Positionssensor D (hoher Eingang)"
	<< "000151;000156;7;P2135;Bereich/Leistung des Drosselklappen-Positionssensorkreises"
	<< "000151;000156;8;P2097;Nach-Katalysator-Kraftstofftrimmung zu fett (Bank 1)"
	<< "000152;000157;1;P0600;Falsche CAN-Kommunikation"
	<< "000152;000157;2;P0390;Kreis von Nockenwellenpositionssensor B (Bank 2)"
	<< "000152;000157;3;P0365;Kreis von Nockenwellenpositionssensor B (Bank 1)"
	<< "000152;000157;4;P0345;Kreis von Nockenwellenpositionssensor A (Bank 2)"
	<< "000152;000157;5;P0340;Kreis von Nockenwellenpositionssensor A (Bank 1)"
	<< "000152;000157;6;P0605;ROM-Fehler des internen Steuermoduls"
	<< "000152;000157;7;P1521;Leistungsproblem des Brems- schalterkreises (hoher Eingang)"
	<< "000152;000157;8;P0579;Leistungsproblem des Tempomat- Schalterkreises (hoher Eingang)"
	<< "000153;000158;1;P2095;Kurzschluss im Signal-B-Kreis des OCV-Magnetventils (Bank 2)"
	<< "000153;000158;2;P2094;Unterbrechung im Signal-B-Kreis des OCV-Magnetventils (Bank 2)"
	<< "000153;000158;3;P2091;Kurzschluss im Signal-B-Kreis des OCV-Magnetventils (Bank 1)"
	<< "000153;000158;4;P2090;Unterbrechung im Signal-B-Kreis des OCV-Magnetventils (Bank 1)"
	<< "000153;000158;5;P2093;Kurzschluss im Signal-A-Kreis des OCV-Magnetventils (Bank 2)"
	<< "000153;000158;6;P2092;Unterbrechung im Signal-A-Kreis des OCV-Magnetventils (Bank 2)"
	<< "000153;000158;7;P2089;Kurzschluss im Signal-A-Kreis des OCV-Magnetventils (Bank 1)"
	<< "000153;000158;8;P2088;Unterbrechung im Signal-A-Kreis des OCV-Magnetventils (Bank 1)"
	<< "000154;000159;1;P0197;Störung im Kreis des Öltemperatursensors (niedrig)"
	<< "000154;000159;2;P1547;Störung des Abgastemperatursensors"
	<< "000154;000159;3;P1476;Störung des Abgas-Bypass-Magnetventils (hoch)"
	<< "000154;000159;4;P1475;Störung des Abgas-Bypass-Magnetventils (niedrig)"
	<< "000154;000159;5;P1477;Funktion des Abgas-Bypassventils"
	<< "000154;000159;6;P2099;Nach-Katalysator-Kraftstofftrimmung zu fett (Bank 2)"
	<< "000154;000159;7;P2098;Nach-Katalysator-Kraftstofftrimmung zu mager (Bank 2)"
	<< "000154;000159;8;P0700;Anforderung AT MIL ein"
	<< "000160;000165;1;P0028;Störung des Öldruck-Schaltmagnetventils (OSV) links"
	<< "000160;000165;2;P0083;Störung im Stromkreis des Öldruck-Schaltmagnetventils (OSV) links (hoch)"
	<< "000160;000165;3;P0082;Störung im Stromkreis des Öldruck-Schaltmagnetventils (OSV) links (niedrig)"
	<< "000160;000165;4;P0026;Störung des Öldruck-Schaltmagnetventils (OSV) rechts"
	<< "000160;000165;5;P0077;Störung im Stromkreis des Öldruck-Schaltmagnetventils (OSV) rechts (hoch)"
	<< "000160;000165;6;P0076;Störung im Stromkreis des Öldruck-Schaltmagnetventils (OSV) rechts (niedrig)"
	<< "000160;000165;7;P0196;Bereichs-/Leistungsproblem des Öltemperatursensorkreises"
	<< "000160;000165;8;P0198;Störung im Kreis des Öltemperatursensors (hoch)"
	<< "000161;000166;1;P2100;Drosselklappen-Stellmotorkreis (offen)"
	<< "000161;000166;2;P2111;Drosselklappe klemmt (offen)"
	<< "000161;000166;3;P2504;Lichtmaschinenkreis (hoch)"
	<< "000161;000166;4;P2503;Lichtmaschinenkreis (niedrig)"
	<< "000161;000166;5;P1462;Kraftstoff-Zylinderinnendruck Sensor Systemkreislauf (niedrig)"
	<< "000161;000166;6;P1463;Kraftstoff-Zylinderinnendruck Sensor Systemkreislauf (hoch)"
	<< "000161;000166;7;P1028;Leistung der VVL-Systeme 2"
	<< "000161;000166;8;P1026;Leistung der VVL-Systeme 1"
	<< "000162;000167;1;P0958;Rückfahrlicht Relais Ausgang (hoch)"
	<< "000162;000167;2;P0957;Rückfahrlicht Relais Ausgang (niedrig)"
	<< "000162;000167;3;P0955;Rückfahrlicht Relais Ausgang (offen)"
	<< "000162;000167;4;P0883;PVIGN Stromversorgung (hoch)"
	<< "000162;000167;5;P0882;PVIGN Stromversorgung (niedrig)"
	<< "000162;000167;6;P0880;PVIGN Stromversorgungskreis"
	<< "000162;000167;7;P0817;PN Signalausgangskreis"
	<< "000162;000167;8;P1601;Getriebesteuergerät (TCU) Kommunikationsstörung"
	<< "000163;000168;1;P2004;Tumble-Ventil (TGV) System 1 (Ventil offen)"
	<< "000163;000168;2;P2006;Tumble-Ventil (TGV) System 1 (Ventil geschlossen)"
	<< "000163;000168;3;P2005;Tumble-Ventil (TGV) System 2 (Ventil offen)"
	<< "000163;000168;4;P2007;Tumble-Ventil (TGV) System 2 (Ventil geschlossen)"
	<< "000163;000168;5;P2227;Bereich/Leistung des Luftdrucksensors"
	<< "000163;000168;6;P0126;Kühlwasser-Temperatur"
	<< "000163;000168;7;P2229;Luftdrucksensorkreislauf Störung (hoher Eingang)"
	<< "000163;000168;8;P2228;Luftdrucksensorkreislauf Störung (niedriger Eingang)"
	<< "000164;000169;1;P2016;Stromkreis des Positionssensors von Tumble-Ventil (TGV) 1 (niedrig)"
	<< "000164;000169;2;P2017;Stromkreis des Positionssensors von Tumble-Ventil (TGV) 1 (hoch)"
	<< "000164;000169;3;P2021;Stromkreis des Positionssensors von Tumble-Ventil (TGV) 2 (niedrig)"
	<< "000164;000169;4;P2022;Stromkreis des Positionssensors von Tumble-Ventil (TGV) 2 (hoch)"
	<< "000164;000169;5;P2009;Störung im Signalkreis von Tumble-Ventil (TGV) 1 (Kurzschluss)"
	<< "000164;000169;6;P2012;Störung im Signalkreis von Tumble-Ventil (TGV) 2 (Kurzschluss)"
	<< "000164;000169;7;P2008;Störung im Signalkreis von Tumble-Ventil (TGV) 1 (offen)"
	<< "000164;000169;8;P2011;Störung im Signalkreis von Tumble-Ventil (TGV) 2 (offen)"
	<< "000174;00017B;1;P1579;Fernanlassfunktion abnormal"
	<< "000175;00017C;1;P0850;Schaltkreis des Neutralpositionsschalters"
	<< "000175;00017C;2;P1721;DCCD Motordrehzahlsignal Systemkreislauf"
	<< "000175;00017C;3;P1720;DCCD CAN Systemkreislauf"
	<< "000175;00017C;4;P1765;Giermoment- und Querbeschleunigungssensor Referenzspannung Systemkreislauf"
	<< "000175;00017C;5;P1764;Giermomentsensor-Systemkreislauf"
	<< "000175;00017C;6;P1767;DCCD-Lenkwinkelsensorschaltkreis"
	<< "000175;00017C;7;P1723;Schaltkreis ATF-Temperatursensor 2 Bereich/Funktion"
	<< "000175;00017C;8;P0711;Bereich/Leistung des ATF-Temperatursensorkreises"
	<< "000176;00017D;1;P2444;Sekundärluftpumpe EIN Störung"
	<< "000176;00017D;2;P0411;Sekundärluftsystem abnormal"
	<< "000176;00017D;3;P0410;Sekundärluftsystem-Funktion"
	<< "000176;00017D;4;P2431;Sekundärluft-Drucksensor Eigenschaft"
	<< "000176;00017D;5;P2433;Sekundärluft-Drucksensor (hoch)"
	<< "000176;00017D;6;P2432;Sekundärluft-Drucksensor (niedrig)"
	<< "000176;00017D;7;P0413;Sekundärluft-Kombinationsventil Schaltkreis 1 (niedrig)"
	<< "000176;00017D;8;P0418;Sekundärluft-Pumpenrelais (niedrig)"
	<< "000177;00017E;1;P0140;Bereich/Leistung des Lambdasondenkreises (Bank 1 Sonde 2)"
	<< "000177;00017E;2;P0160;Bereich/Leistung des Lambdasondenkreises (Bank 2 Sonde 2)"
	<< "000177;00017E;3;P0146;Bereich/Leistung des Lambdasondenkreises (Bank 1 Sonde 3)"
	<< "000177;00017E;4;P1602;Steuergeräte-Programmierfehler"
	<< "000177;00017E;5;P0414;Sekundärluft-Kombinationsventil Schaltkreis 1 (hoch)"
	<< "000177;00017E;6;P1418;Sekundärluft-Pumpenrelais (hoch)"
	<< "000177;00017E;7;P0018;Kurbel- und Nockenwellensteuerung A Ausfall (Bank 2)"
	<< "000177;00017E;8;P0016;Kurbel- und Nockenwellensteuerung A Ausfall (Bank 1)"
	<< "000178;00017F;1;P0602;Steuergerät-Programmierfehler"
	<< "000178;00017F;2;P1410;Sekundärluft-Kombinationsventil hängt im offenen Zustand"
	<< "000178;00017F;3;P2443;Sekundärluftsystem hängt im geschlossenen Zustand (Bank 2)"
	<< "000178;00017F;4;P2442;Sekundärluftsystem hängt im offenen Zustand (Bank 2)"
	<< "000178;00017F;5;P2441;Sekundärluftsystem hängt im geschlossenen Zustand (Bank 1)"
	<< "000178;00017F;6;P2440;Sekundärluftsystem hängt im offenen Zustand (Bank 1)"
	<< "000178;00017F;7;P0417;Sekundärluft-Kombinationsventil Schaltkreis 2 (hoch)"
	<< "000178;00017F;8;P0416;Sekundärluft-Kombinationsventil Schaltkreis 2 (niedrig)"
	<< "000179;000180;1;P0024;Aktives Ventilsteuerungssystem (AVCS) 2 Auslassseite (Bereich/Leistung)"
	<< "000179;000180;2;P0014;Aktives Ventilsteuerungssystem (AVCS) 1 Auslassseite (Bereich/Leistung)"
	<< "000179;000180;3;P1616;Anlasser-Unterbrechungsrelais Systemschaltkreis (niedrig)"
	<< "000179;000180;4;P1520;Anlasserschalter 2 Systemschaltkreis (deaktiviert)"
	<< "000179;000180;5;P1519;Anlasserschalter 2 Systemschaltkreis (aktiviert)"
	<< "000179;000180;6;P0441;Kraftstoffverdunstungsanlage falscher Spülfluss"
	<< "000179;000180;7;P2419;Spülluft-Magnetventil-Stromkreis Signal niedrig"
	<< "000179;000180;8;P2420;Spülluft-Magnetventil-Stromkreis Signal hoch"
	<< "00017A;000181;1;P2634;Hilfskraftstoffpumpenrelais (hoch)"
	<< "00017A;000181;2;P2633;Hilfskraftstoffpumpenrelais (niedrig)"
	<< "00017A;000181;5;P0091;Kraftstoffdruck-Schaltmagnetventil (Stromkreis niedrig)"
	<< "00017A;000181;6;P0092;Kraftstoffdruck-Schaltmagnetventil (Stromkreis hoch)"
	<< "00017A;000181;7;P0019;Versagen des Kurbelwellen- und Nockenwellen-Steuerungssystems B (Bank 2)"
	<< "00017A;000181;8;P0017;Versagen des Kurbelwellen- und Nockenwellen-Steuerungssystems B (Bank 1)"
	<< "0001C5;0001CB;1;P0201;Fehler im Stromkreis von Einspritzventil #1"
	<< "0001C5;0001CB;2;P1213;Einspritzventiltreiber (niedrige Ladung)"
	<< "0001C5;0001CB;3;P2148;Einspritzventiltreiber (Kurzschluss nach Plus)"
	<< "0001C5;0001CB;4;P0704;Fehlfunktion im Schaltkreis des Kupplungsschalters"
	<< "0001C5;0001CB;5;P0096;Ansauglufttemperatursensor #2 Bereichs-/Leistungsproblem"
	<< "0001C5;0001CB;6;P0097;Ansauglufttemperatursensor #2 Schaltkreis (niedrig)"
	<< "0001C5;0001CB;7;P0098;Ansauglufttemperatursensor #2 Schaltkreis (hoch)"
	<< "0001C5;0001CB;8;P0116;Bereich/Funktion des Kühlmitteltemperatursensors"
	<< "0001C6;0001CC;1;P0088;Kraftstoff-Raildruck abnorm (zu hoch)"
	<< "0001C6;0001CC;2;P0191;Bereich/Funktion des Kraftstoff-Raildrucksensor-Schaltkreises"
	<< "0001C6;0001CC;3;P1214;Einspritzventiltreiber (Überladung)"
	<< "0001C6;0001CC;4;P2149;Kraftstoffeinspritzventil Stromversorgung B - offener Stromkreis"
	<< "0001C6;0001CC;5;P2146;Kraftstoffeinspritzventil Stromversorgung A - offener Stromkreis"
	<< "0001C6;0001CC;6;P0204;Fehler im Stromkreis von Einspritzventil #4"
	<< "0001C6;0001CC;7;P0203;Fehler im Stromkreis von Einspritzventil #3"
	<< "0001C6;0001CC;8;P0202;Fehler im Stromkreis von Einspritzventil #2"
	<< "00020A;00020E;1;P0093;Kraftstoffsystem undicht (großes Leck)"
	<< "00020A;00020E;2;P1234;Kraftstoffdruck abnorm (Kraftstoffpumpe Ausfall 2)"
	<< "00020A;00020E;3;P1233;Kraftstoffdruck abnorm (Kraftstoffpumpe Ausfall 1)"
	<< "00020A;00020E;4;P1232;Kraftstoffpumpen-Fehlfunktion"
	<< "00020A;00020E;5;P2635;Hängenbleiben des Kraftstoffpumpen-Ansaugregelventils"
	<< "00020A;00020E;6;P0628;Stromkreis des Kraftstoffpumpen-Ansaugregelventils (Kurzschluss nach Masse)"
	<< "00020A;00020E;7;P0629;Stromkreis des Kraftstoffpumpen-Ansaugregelventils (Kurzschluss nach Plus)"
	<< "00020A;00020E;8;P0089;Funktion/Leistung des Kraftstoffdruckreglers (Öffnungsproblem des Druckbegrenzungsventils)"
	<< "00020B;00020F;1;P0401;Abgasrückführung (AGR) unzureichende Flussrate festgestellt"
	<< "00020B;00020F;2;P0402;Abgasrückführung (AGR) übermäßige Flussrate festgestellt"
	<< "00020B;00020F;3;P0299;Ladedruck zu gering (Unterladung)"
	<< "00020B;00020F;4;P0234;Ladedruck zu hoch (Überladung)"
	<< "00020B;00020F;5;P0606;Fehler im Mikroprozessor (CPU) des Steuergeräts"
	<< "00020B;00020F;6;P1203;Einspritzventil-Code Eingangsfehler"
	<< "00020B;00020F;7;P1202;Einspritzventil-Code Daten abnorm"
	<< "00020B;00020F;8;P1201;Einspritzventil-Code Fehler (nicht geschrieben)"
	<< "00020C;000210;1;P1382;Glührelaisschaltkreis (hoch)"
	<< "00020C;000210;2;P0219;Motorüberdrehung"
	<< "00020C;000210;3;P0046;Bereich/Leistung des Ladedruck-Steuermagnetventilschaltkreises"
	<< "00020C;000210;4;P0404;Abgasrückführung (AGR) Betriebsstromkreis abnorm"
	<< "00020C;000210;5;P0403;Abgasrückführung (AGR) Systemausfall (Stromkreislast)"
	<< "00020C;000210;6;P0409;Abgasrückführung (AGR) Positionssensorleistung"
	<< "00020C;000210;7;P0405;Abgasrückführung (AGR) Positionssensorschaltkreis (niedrig)"
	<< "00020C;000210;8;P0406;Abgasrückführung (AGR) Positionssensorschaltkreis (hoch)"
	<< "00020D;000211;2;P2413;Hängenbleiben des Abgasrückführungsventils"
	<< "00020D;000211;3;P1009;Wirbelsteuerventilschaltkreis (niedrig)"
	<< "00020D;000211;4;P1607;Überwachungsstromkreis abnorm"
	<< "00020D;000211;5;P2147;Einspritzventiltreiber (Kurzschluss nach Masse)"
	<< "00020D;000211;6;P2010;Wirbelsteuerventilschaltkreis (hoch)"
	<< "00020D;000211;7;P0687;Ausfall des Selbstabschaltrelais für das Motor-/Antriebsstrang-Steuergerät"
	<< "00020D;000211;8;P1380;Glührelaisschaltkreis (niedrig)"
	<< "000263;000268;4;P1532;Ladesteuerungssystem abnorm"
	<< "000263;000268;5;P1531;Batteriestromsensor Schaltkreis (hoch)"
	<< "000263;000268;6;P1530;Batteriestromsensor Schaltkreis (niedrig)"
	<< "000263;000268;7;P0517;Batterietemperatursensor Schaltkreis (hoch)"
	<< "000263;000268;8;P0516;Batterietemperatursensor Schaltkreis (niedrig)"
	<< "000264;000269;8;P0161;Lambdasonde (O2-Sensor) Fehlfunktion Heizungsstromkreis (Bank 2 Sensor 2)"
	<< "000265;00026A;1;P1468;Ölverdünnung"
	<< "000265;00026A;2;P1467;Dieselpartikelfilter (DPF) Ascheüberfüllung"
	<< "000265;00026A;3;P1466;Dieselpartikelfilter (DPF) Trägermaterial defekt"
	<< "000265;00026A;4;P1465;Dieselpartikelfilter (DPF) Teilchenüberfüllung"
	<< "000265;00026A;5;P1473;Dieselpartikelfilter (DPF) Einlass-Auslass-Differenzdrucksensor (hoch)"
	<< "000265;00026A;6;P1472;Dieselpartikelfilter (DPF) Einlass-Auslass-Differenzdrucksensor (niedrig)"
	<< "000265;00026A;7;P2033;Abgastemperatursensor 2 (hoch)"
	<< "000265;00026A;8;P2032;Abgastemperatursensor 2 (niedrig)"
	<< "000266;00026B;7;P1471;Rohrleitungsstörung stromauf vom Dieselpartikelfilter-Differentialdrucksensor"
	<< "000266;00026B;8;P1469;Dieselpartikelfilter (DPF) Notlaufmodus";


// Abbruchcodes der integrierten Geschwindigkeits-Regelanlage:
const QStringList SSMFlagbyteDefinitions_de::_CC_defs_de =
	QStringList()
	<< "000133;000137;1;22;Ungewöhnliche Änderung der Fahrzeuggeschwindigkeit"
	<< "000133;000137;2;21;Schalterstörung beim Einschalten der Zündung"
	<< "000133;000137;3;16;Zündschalter"
	<< "000133;000137;4;15;Abbruchschalter"
	<< "000133;000137;5;14;Anlasssperrschalter"
	<< "000133;000137;6;13;Kupplungsschalter"
	<< "000133;000137;7;12;Bremslicht- und Bremsschalter"
	<< "000133;000137;8;11;Hauptschalter"
	<< "000134;000138;1;35;Sperrung der Tempomat-Regelung bei Geschwindigkeits-F/B-Störung"
	<< "000134;000138;2;34;Sperrung der Tempomat-Regelung bei anhaltend grossem Gaspedalweg"
	<< "000134;000138;3;33;Sperrung des WARTEN-Zustands nach Gaspedalbetätigung"
	<< "000134;000138;4;32;Tempomat ausserhalb Bereich"
	<< "000134;000138;5;31;Ungewöhnliches Motordrehzahl-Signal"
	<< "000134;000138;6;25;Störung im Eingangskreis des Bremsschalters"
	<< "000134;000138;7;24;Störung von Schaltern des Tempomat-Systems"
	<< "000134;000138;8;23;Störung in Sensoren für Motorfunktionen"
	<< "000135;000139;1;52;Active Driving Assist (ADA) Zielgeschwindigkeits-Fehler"
	<< "000135;000139;2;51;Active Driving Assist (ADA) Zwangsabbruch"
	<< "000135;000139;3;46;Antriebsstrang-Steuergerät (PCU) Fehler"
	<< "000135;000139;4;45;Kombiinstrumenten-Fehler"
	<< "000135;000139;5;44;Fehlfunktion der integrierten Karosserie-Einheit"
	<< "000135;000139;6;43;ABS/VDC-Fehler"
	<< "000135;000139;7;42;Fehlerhafte Hochgeschwindigkeits-CAN-Kommunikation"
	<< "000135;000139;8;41;VDC/TCS in Betrieb"
	<< "000136;00013A;1;66;Tempomat-Berechnungsfehler"
	<< "000136;00013A;2;25;Störung im Eingangskreis des Bremsschalters"
	<< "000136;00013A;3;65;Störung 1 bei Schaltern für Tempomat"
	<< "000136;00013A;4;64;Motorbezogener Sensor-Fehler 1"
	<< "000136;00013A;5;63;Ungewöhnliche Änderung 1 der Fahrzeuggeschwindigkeit"
	<< "000136;00013A;6;21;Schalterstörung beim Einschalten der Zündung"
	<< "000136;00013A;7;62;Fehlfunktion des Neutralstellungsschalters"
	<< "000136;00013A;8;61;Bremsschalter-Fehlfunktion";


// Aktuatoren:
const QStringList SSMFlagbyteDefinitions_de::_actuator_defs_de =
	QStringList()
	<< "29;7;000089;8;Kraftstoffpumpenrelais"
	<< "29;7;000089;7;Tankentlüftung (CPC) Steuerventil"
	<< "29;7;000089;6;Kühlerlüfterrelais"
	<< "29;7;000089;5;Klimakompressorrelais"
	<< "29;7;000089;4;Abgasrückführung (EGR) Magnetventil"
	<< "29;7;000089;3;Saugluftmagnetventil (ASV)"
	<< "29;7;000089;2;Kurbelgehäuseentlüftung (PCV) Magnetventil"
	<< "29;7;000089;1;Belüftungsmagnetventil"
	<< "29;7;00008A;8;Leerlaufanhebung (FICD) Magnetventil"
	<< "29;7;00008A;7;Druckschaltmagnetventil 1"
	<< "29;7;00008A;6;Druckschaltmagnetventil 2"
	<< "29;7;00008A;5;Magnetventil für luftunterstütze Einspritzventile (AAI)"
	<< "29;7;00008A;4;Kraftstofftanksensor-Steuerventil"
	<< "29;7;00008A;3;Turbolader Wastegate-Magnetventil"
	<< "29;7;00008A;2;Genehmigungszeichen für Abgas-Bypassregelung"
	<< "29;7;00008A;1;Sekundärluft-Kombiventil 1"
	<< "42;2;00018D;8;Sekundärluft-Kombiventil 2"
	<< "42;2;00018D;7;Sekundärluftpumpenrelais"
	<< "42;2;00018D;6;Tankentlüftung (CPC) Steuerventil 2"
	<< "42;2;00018D;5;Hilfskraftstoffpumpenrelais"
	<< "42;2;00018D;4;Kraftstoffdruck-Schaltmagnetventil";


// Einstellwerte:
const QStringList SSMFlagbyteDefinitions_de::_adjustment_defs_de =
	QStringList()
	<< "26-5;0;6F;;Korrektur des Zündzeitpunkts;Grad;0;5;0;*-1;0"
	<< "26-4;0;70;;Korrektur der Leerlaufdrehzahl (Klima aus);U/Min;124;140;128;-128*25;0"
	<< "26-3;0;71;;Korrektur der Leerlaufdrehzahl (Klima ein);U/Min;124;140;128;-128*25;0"
	<< "26-1;1;72;;Leitungsdruck (Hauptdruck);%;90;110;100;-100;0"
	<< "A11020;1;73;;Leitungs-Schaltdruck-Korrektur - 1ter nach 2ter Gang;kgf;90;110;100;-100/50;2"
	<< "A11020;1;74;;Leitungs-Schaltdruck-Korrektur - 2ter nach 3ter Gang;kgf;90;110;100;-100/50;2"
	<< "A11020;1;75;;Leitungs-Schaltdruck-Korrektur - 3ter nach 4ter Gang;kgf;90;110;100;-100/50;2"
	<< "A11020;1;76;;Leitungs-Schaltdruck-Korrektur - 4ter nach 3ter Gang;kgf;90;110;100;-100/50;2"
	<< "A11020;1;77;;Leitungs-Schaltdruck-Korrektur - 4ter nach 2ter Gang;kgf;90;110;100;-100/50;2"
	<< "A11020;1;78;;Leitungs-Schaltdruck-Korrektur - 3ter nach 2ter Gang;kgf;90;110;100;-100/50;2"
	<< "27-8;1;79;;Korrektur 2-4-Bremse Druck 1;%;90;110;100;-100;0"
	<< "27-7;1;7A;;Korrektur 2-4-Bremse Druck 2 - 1ter nach 2ter Gang;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7B;;Korrektur 2-4-Bremse Druck 2 - 2ter nach 3ter Gang;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7C;;Korrektur 2-4-Bremse Druck 2 - 3ter nach 4ter Gang;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7D;;Korrektur 2-4-Bremse Druck 2 - 4ter nach 3ter Gang;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7E;;Korrektur 2-4-Bremse Druck 2 - 4ter nach 2ter Gang;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7F;;Korrektur 2-4-Bremse Druck 2 - 3ter nach 2ter Gang;kgf;90;110;100;-100/50;2"
	<< "27-6;1;80;;Korrektur des Allrad-Lastverhältnisses;%;90;110;100;-100;0"
	<< "27-5;1;81;;Bergabfahrt-Regelung;;0;1;0;0=Zugriff erlaubt,1=Kein Zugriff;"
	<< "27-4;1;82;;Zentral-Differential;%;50;150;100;*1;0"
	<< "27-3;1;171;170;Korrektur des Allradkupplungs-Drehmoments;Nm;63535;2000;0;s16/50;0";


const QStringList SSMFlagbyteDefinitions_de::MBrawDefs()
{
	return _MB_defs_de;
}


const QStringList SSMFlagbyteDefinitions_de::SWrawDefs()
{
	return _SW_defs_de;
}


const QStringList SSMFlagbyteDefinitions_de::SUBDTCrawDefs()
{
	return _DTC_SUBARU_defs_de;
}


const QStringList SSMFlagbyteDefinitions_de::OBDDTCrawDefs()
{
	return _DTC_OBD_defs_de;
}


const QStringList SSMFlagbyteDefinitions_de::CCCCrawDefs()
{
	return _CC_defs_de;
}


const QStringList SSMFlagbyteDefinitions_de::ActuatorRawDefs()
{
	return _actuator_defs_de;
}


const QStringList SSMFlagbyteDefinitions_de::AdjustmentRawDefs()
{
	return _adjustment_defs_de;
}

