# MBROLA voices database

This project provides list of [MBROLA](https://github.com/numediart/MBROLA) speech synthesizer voices. It is intended to provide easier collaboration and automatic updates for individual users and packagers.

If you want to use this database look at [License](LICENSE.md),
or, if you want to contribute with new voice data, read [New MBROLA databases](https://github.com/numediart/MBROLATOR) page.

To download data file for particular voice, click on filename you want to download and save it in MBROLA data folder:
e.g. `C:/Program Files/eSpeak/espeak-ng-data/mbrola` for Windows systems, or `/usr/share/mbrola/xxN/` for Unix-like systems.

See more at [eSpeak NG speech engine documentation](https://github.com/espeak-ng/espeak-ng/blob/master/docs/mbrola.md).

|  Filename                     | Language             | Gender | Provider                                                                     |
|-------------------------------|----------------------|--------|------------------------------------------------------------------------------|
| [af1](/data/af1/af1?raw=true) | Afrikaans            | Male   | [Daan Wissing](mailto:ntldpw@puk.ac.za)                                      |
| [ar1](/data/ar1/ar1?raw=true) | Arabic               | Male   | [Faculte Polytech. De Mons](mailto:mbrola@tcts.fpms.ac.be)                   |
| [ar2](/data/ar2/ar2?raw=true) | Arabic               | Male   | [Abdel Muez Abukhalaf](mailto:amuez@sedco-online.com)                        |
| [br1](/data/br1/br1?raw=true) | Brazillian Portuguese| Male   | [Denis R.Costa](mailto:dcosta@ams.com.br)                                    |
| [br2](/data/br2/br2?raw=true) | Brazillian Portuguese| Male   | [Denis R.Costa](mailto:dcosta@micropower.com.br)                             |
| [br3](/data/br3/br3?raw=true) | Brazillian Portuguese| Male   | [Denis R.Costa](mailto:dcosta@micropower.com.br)                             |
| [br4](/data/br4/br4?raw=true) | Brazillian Portuguese| Female | [Dilson Jose Dos Santos](mailto:dilson-jose.santos@serpro.gov.br)            |
| [bz1](/data/bz1/bz1?raw=true) | Breton               | Female | [Jean Pierre Messager](mailto:Jean-Pierre.Messager@enssat.fr)                |
| [ca1](/data/ca1/ca1?raw=true) | Canadian French      | Male   | [Vincent Arnaud](http://www.smithware.ca/qcmbrola/)                          |
| [ca2](/data/ca2/ca2?raw=true) | Canadian French      | Male   | [Silex Creations Inc.](mailto:lanctot@silexcreations.com)                    |
| [cn1](/data/cn1/cn1?raw=true) | Mandarin Chinese     | Female | [Liu Ning](mailto:liuningchine@yahoo.fr)                                     |
| [cr1](/data/cr1/cr1?raw=true) | Croatian             | Male   | [Juraj Bakran](mailto:juraj.bakran@ffzg.hr)                                  |
| [cz1](/data/cz1/cz1?raw=true) | Czech                | Female | [Mikulas Pinos](mailto:pinos@fi.muni.cz)                                     |
| [cz2](/data/cz2/cz2?raw=true) | Czech                | Male   | [Mikulas Pinos](mailto:pinos@fi.muni.cz)                                     |
| [de1](/data/de1/de1?raw=true) | German               | Female | [Fred Englert](mailto:englert@ieee.org)                                      |
| [de2](/data/de2/de2?raw=true) | German               | Male   | [ATIP](mailto:info@atip.de)                                                  |
| [de3](/data/de3/de3?raw=true) | German               | Female | [ATIP](mailto:info@atip.de)                                                  |
| [de4](/data/de4/de4?raw=true) | German               | Male   | [University of Stuttgart](mailto:antje.schweitzer@ims.uni-stuttgart.de)      |
| [de5](/data/de5/de5?raw=true) | German               | Female | [ATIP](mailto:info@atip.de)                                                  |
| [de6](/data/de6/de6?raw=true) | German               | Male   | [Saarland University](mailto:marc.schroeder@dfki.de)                         |
| [de7](/data/de7/de7?raw=true) | German               | Female | [DFKI](mailto:marc.schroeder@dfki.de)                                        |
| [de8](/data/de8/de8?raw=true) | German-Bavarian      | Male   | [Markus Binsteiner](mailto:bairisch.m@rkusiminter.net)                       |
| [ee1](/data/ee1/ee1?raw=true) | Estonian             | Male   | [Meelis Mihkla](mailto:meelis@eki.ee)                                        |
| [en1](/data/en1/en1?raw=true) | British English      | Male   | [Alan V. Black](mailto:awb@cs.cmu.edu)                                       |
| [es1](/data/es1/es1?raw=true) | Spanish              | Male   | [Alistair Conkie](mailto:alistair@liceu.uab.es)                              |
| [es2](/data/es2/es2?raw=true) | Spanish              | Male   | [TCC Communications Corp.](mailto:tcc@tcc.bc.ca)                             |
| [es3](/data/es3/es3?raw=true) | Spanish              | Female | [Universidad Carlos III de Madrid](mailto:jgorosti@ing.uc3m.es)              |
| [es4](/data/es4/es4?raw=true) | Spanish              | Male   | [Universidad de Valladolid](mailto:cesargf@infor.uva.es)                     |
| [fr1](/data/fr1/fr1?raw=true) | French               | Male   | [Faculte Polytech. De Mons](mailto:mbrola@tcts.fpms.ac.be)                   |
| [fr2](/data/fr2/fr2?raw=true) | French               | Female | [Celine Egea](mailto:egea@univ-valenciennes.fr)                              |
| [fr3](/data/fr3/fr3?raw=true) | French               | Male   | [Babel Technology](mailto:pagel@babeltech.com)                               |
| [fr4](/data/fr4/fr4?raw=true) | French               | Female | [Babel Technology](mailto:pagel@babeltech.com)                               |
| [fr5](/data/fr5/fr5?raw=true) | French Belgian       | Male   | [Faculte Polytech. De Mons](mailto:mbrola@tcts.fpms.ac.be)                   |
| [fr6](/data/fr6/fr6?raw=true) | French               | Male   | [Faculte Polytech. De Mons](mailto:mbrola@tcts.fpms.ac.be)                   |
| [fr7](/data/fr7/fr7?raw=true) | French Belgian       | Male   | [Faculte Polytech. De Mons](mailto:mbrola@tcts.fpms.ac.be)                   |
| [gr1](/data/gr1/gr1?raw=true) | Greek                | Male   | [George Sergiadis](mailto:sergiadi@vergina.eng.auth.gr)                      |
| [gr2](/data/gr2/gr2?raw=true) | Greek                | Male   | [Gerasimos Xydas](mailto:gxydas@di.uoa.gr)                                   |
| [hb1](/data/hb1/hb1?raw=true) | Hebrew               | Male   | [Yoram Meron](mailto:meron@gavo.t.u-tokyo.ac.jp)                             |
| [hb2](/data/hb2/hb2?raw=true) | Hebrew               | Female | [Esther Raizen](mailto:er@uts.cc.utexas.edu)                                 |
| [hn1](/data/hn1/hn1?raw=true) | Korean               | Male   | [Kyongsok Gim](mailto:gimgs@asadal.cs.pusan.ac.kr)                           |
| [hu1](/data/hu1/hu1?raw=true) | Hungarian            | Female | [Eleonora Klein](mailto:eleonora45@gmx.net)                                  |
| [ic1](/data/ic1/ic1?raw=true) | Icelandic            | Male   | [Björn Kristinsson](mailto:bjorbjorn@hotmail.com)                            |
| [id1](/data/id1/id1?raw=true) | Indonesian           | Male   | [Arry Arman](mailto:aa@lss.ee.itb.ac.id)                                     |
| [in1](/data/in1/in1?raw=true) | Hindi                | Male   | [Amin Charaniya](mailto:amin@cse.ucsc.edu)                                   |
| [in2](/data/in2/in2?raw=true) | Hindi                | Female | [Amin Charaniya](mailto:amin@cse.ucsc.edu)                                   |
| [ir1](/data/ir1/ir1?raw=true) | Iranian              | Male   | [Alireza Farhadi](mailto:leadstar2k@yahoo.com)                               |
| [it1](/data/it1/it1?raw=true) | Italian              | Male   | [Claudia Citta](mailto:ccitta@hotmail.com)                                   |
| [it2](/data/it2/it2?raw=true) | Italian              | Female | [Claudia Citta](mailto:ccitta@hotmail.com)                                   |
| [it3](/data/it3/it3?raw=true) | Italian              | Male   | [Piero Cosi](mailto:cosi@csrf.pd.cnr.it)                                     |
| [it4](/data/it4/it4?raw=true) | Italian              | Female | [ITC-irst](mailto:gretter@itc.it)                                            |
| [jp1](/data/jp1/jp1?raw=true) | Japanese             | Male   | [Yoram Meron](mailto:meron_y@yahoo.com)                                      |
| [jp2](/data/jp2/jp2?raw=true) | Japanese             | Female | [Tomohisa Tachiki](mailto:tachiki@gmx.de)                                    |
| [jp3](/data/jp3/jp3?raw=true) | Japanese             | Female | [Yoram Meron](mailto:meron_y@yahoo.com)                                      |
| [la1](/data/la1/la1?raw=true) | Classical Latin      | Male   | [Olivier Bianchi](mailto:Olivier.Bianchi@unil.ch)                            |
| [lt1](/data/lt1/lt1?raw=true) | Lithuanian           | Male   | [Pijus Kasparaitis & Aleksas Girdenis](mailto:girdenis@eunet.lt)             |
| [lt2](/data/lt2/lt2?raw=true) | Lithuanian           | Male   | [Pijus Kasparaitis & Aleksas Girdenis](mailto:girdenis@eunet.lt)             |
| [ma1](/data/ma1/ma1?raw=true) | Malay                | Female | [Kow Weng Onn](mailto:kwonn@mimos.my)                                        |
| [mx1](/data/mx1/mx1?raw=true) | Spanish Mexican      | Male   | [Oregon Gr.Inst.Sci.Tech.](mailto:macon@ece.ogi.edu)                         |
| [mx2](/data/mx2/mx2?raw=true) | Spanish Mexican      | Male   | [Humberto Pérez Espinosa](mailto:humbertop@ccc.inaoep.mx)                    |
| [nl1](/data/nl1/nl1?raw=true) | Small Dutch          | Male   | [Arthur Dirksen](mailto:arthur.dirksen@fluency.nl)                           |
| [nl2](/data/nl2/nl2?raw=true) | Dutch                | Male   | [Arthur Dirksen](mailto:arthur.dirksen@fluency.nl)                           |
| [nl3](/data/nl3/nl3?raw=true) | Dutch                | Female | [Raymond Veldhuis](mailto:veldhuis@ipo.tue.nl)                               |
| [nz1](/data/nz1/nz1?raw=true) | Maori                | Male   | [Mark R. Laws](mailto:maaka@kel.otago.ac.nz)                                 |
| [pl1](/data/pl1/pl1?raw=true) | Polish               | Female | [PJWSTK](mailto:krzysztof.szklanny@pjwstk.edu.pl)                            |
| [pt1](/data/pt1/pt1?raw=true) | European Portuguese  | Female | [Babel Technology](mailto:pagel@babeltech.com)                               |
| [ro1](/data/ro1/ro1?raw=true) | Romanian             | Male   | [Marian Boldea](mailto:boldea@utt.ro)                                        |
| [sw1](/data/sw1/sw1?raw=true) | Swedish              | Male   | [Marcus Filipsson](http://www.ling.lu.se/)                                   |
| [sw2](/data/sw2/sw2?raw=true) | Swedish              | Female | [Adina Svensson](mailto:adinas@home.se)                                      |
| [tl1](/data/tl1/tl1?raw=true) | Telugu               | Female | [Kalpana Reddy KVK](mailto:kvk_kalpana@yahoo.com)                            |
| [tr1](/data/tr1/tr1?raw=true) | Turkish              | Male   | [Faculte Polytech. De Mons](mailto:bozkurt@tcts.fpms.ac.be)                  |
| [tr2](/data/tr2/tr2?raw=true) | Turkish              | Female | [Faculte Polytech. De Mons](mailto:bozkurt@tcts.fpms.ac.be)                  |
| [us1](/data/us1/us1?raw=true) | American English     | Female | [Babel Technology](mailto:secr@babeltech.be)                                 |
| [us2](/data/us2/us2?raw=true) | American English     | Male   | [Babel Technology](mailto:secr@babeltech.be)                                 |
| [us3](/data/us3/us3?raw=true) | American English     | Male   | [Mike Macon](mailto:macon@cse.ogi.edu)                                       |
| [vz1](/data/vz1/vz1?raw=true) | Venezuelan Spanish   | Male   | [Manuel Rodriguez Hourcadette](mailto:hourcade@ula.ve)                       |
