/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.server;

import java.util.Vector;
import org.jrobin.mrtg.Debug;
import org.jrobin.mrtg.MrtgConstants;
import org.jrobin.mrtg.server.Device;
import org.jrobin.mrtg.server.DeviceList;
import org.jrobin.mrtg.server.Port;
import org.jrobin.mrtg.server.Server;
import org.jrobin.mrtg.server.SnmpReader;

class Timer
extends Thread
implements MrtgConstants {
    private volatile boolean active = true;

    Timer() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DeviceList deviceList = Server.getInstance().getDeviceList();
        Debug.print("Scheduler started");
        while (this.active) {
            Vector vector = deviceList.getRouters();
            for (int i = 0; i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                Vector vector2 = device.getLinks();
                for (int j = 0; j < vector2.size(); ++j) {
                    Port port = (Port)vector2.get(j);
                    if (!device.isActive() || !port.isActive() || !port.isDue() || port.isSampling()) continue;
                    new SnmpReader(device, port).start();
                    try {
                        Timer.sleep((long)(1.0 + Math.random() * 20.0));
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            Timer timer = this;
            synchronized (timer) {
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        Debug.print("Scheduler ended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        this.active = false;
        Timer timer = this;
        synchronized (timer) {
            this.notify();
        }
    }
}

