/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.xmlrpc.XmlRpcException;
import org.jrobin.mrtg.MrtgException;
import org.jrobin.mrtg.client.AboutDialog;
import org.jrobin.mrtg.client.EditLinkDialog;
import org.jrobin.mrtg.client.EditRouterDialog;
import org.jrobin.mrtg.client.GraphFrame;
import org.jrobin.mrtg.client.HelpDialog;
import org.jrobin.mrtg.client.HostDialog;
import org.jrobin.mrtg.client.LinkInfo;
import org.jrobin.mrtg.client.MrtgData;
import org.jrobin.mrtg.client.Resources;
import org.jrobin.mrtg.client.RouterInfo;
import org.jrobin.mrtg.client.ServerInfo;
import org.jrobin.mrtg.client.SplashWindow;
import org.jrobin.mrtg.client.TreeElementInfo;
import org.jrobin.mrtg.client.TreeRenderer;
import org.jrobin.mrtg.client.Util;

class Client
extends JFrame {
    static final String RESOURCE_PATH = "res/mrtg/";
    static final String TITLE = "JRobin-MRTG client";
    static final String SUBTITLE = "http://www.jrobin.org";
    static final String COPYRIGHT = "Copyright \u00a9 2004 Sasa Markovic";
    static final String ICON = "res/mrtg/icon.png";
    static Dimension MAIN_TREE_SIZE = new Dimension(320, 400);
    static Dimension INFO_PANE_SIZE = new Dimension(320, 400);
    static String DEFAULT_HOST = "localhost";
    static final int HGAP = 1;
    static final int VGAP = 1;
    static final int DIVIDER_SIZE = 3;
    JTree mainTree = new JTree();
    JTextPane infoTextPane = new JTextPane();
    JMenuBar menuBar = new JMenuBar();
    JMenu mrtgMenu = new JMenu("MRTG");
    JMenuItem newHostMenuItem = new JMenuItem("Connect to JRobin-MRTG server...", 67);
    JMenuItem reloadMenuItem = new JMenuItem("Reload data from JRobin-MRTG server", 76);
    JMenuItem exitMenuItem = new JMenuItem("Exit", 88);
    JMenu routersMenu = new JMenu("Router actions");
    JMenuItem newRouterItem = new JMenuItem("Add router...", 65);
    JMenuItem editRouterItem = new JMenuItem("Edit router data...", 69);
    JMenuItem deleteRouterItem = new JMenuItem("Remove router", 86);
    JMenu linksMenu = new JMenu("Interface actions");
    JMenuItem newLinkItem = new JMenuItem("Add interface(s)...", 78);
    JMenuItem editLinkItem = new JMenuItem("Edit interface data...", 69);
    JMenuItem deleteLinkItem = new JMenuItem("Remove interface", 86);
    JMenuItem quickGraphItem = new JMenuItem("Quick graph (last 24hr)...", 81);
    JMenuItem dailyGraphItem = new JMenuItem("Daily graph...", 68);
    JMenuItem weeklyGraphItem = new JMenuItem("Weekly graph...", 87);
    JMenuItem monthlyGraphItem = new JMenuItem("Monthly graph...", 79);
    JMenuItem yearlyGraphItem = new JMenuItem("Yearly graph...", 89);
    JMenuItem customGraphItem = new JMenuItem("Custom graph...", 67);
    JMenu helpMenu = new JMenu("Help");
    JMenuItem helpItem = new JMenuItem("Help...", 72);
    JMenuItem aboutItem = new JMenuItem("About...", 65);
    JPopupMenu mrtgPopupMenu = new JPopupMenu();
    JMenuItem mrtgPopupReloadMenuItem = new JMenuItem("Reload data from JRobin-MRTG server");
    JMenuItem mrtgPopupAddRouterMenuItem = new JMenuItem("Add router...");
    JMenuItem mrtgPopupExitMenuItem = new JMenuItem("Exit");
    JPopupMenu routerPopupMenu = new JPopupMenu();
    JMenuItem routerPopupEditRouterMenuItem = new JMenuItem("Edit router data...");
    JMenuItem routerPopupAddLinksMenuItem = new JMenuItem("Add interface(s)...");
    JMenuItem routerPopupRemoveRouterMenuItem = new JMenuItem("Remove router");
    JPopupMenu linksPopupMenu = new JPopupMenu();
    JMenuItem linksPopupEditLinkMenuItem = new JMenuItem("Edit interface data...");
    JMenuItem linksPopupRemoveLinkMenuItem = new JMenuItem("Remove interface");
    JMenuItem linksPopupQuickGraphMenuItem = new JMenuItem("Quick graph (last 24hr)...");
    JMenuItem linksPopupDailyGraphMenuItem = new JMenuItem("Daily graph...");
    JMenuItem linksPopupWeeklyGraphMenuItem = new JMenuItem("Weekly graph...");
    JMenuItem linksPopupMonthlyGraphMenuItem = new JMenuItem("Monthly graph...");
    JMenuItem linksPopupYearlyGraphMenuItem = new JMenuItem("Yearly graph...");
    JMenuItem linksPopupCustomGraphMenuItem = new JMenuItem("Custom graph...");
    private MrtgData mrtgData = MrtgData.getInstance();

    Client() throws IOException, XmlRpcException {
        super(TITLE);
        this.constructUI();
        this.pack();
    }

    private void constructUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(1, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.mainTree);
        jPanel2.add(jScrollPane);
        jPanel2.setPreferredSize(MAIN_TREE_SIZE);
        this.mainTree.getSelectionModel().setSelectionMode(1);
        this.mainTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Client.this.nodeChangedAction();
            }
        });
        TreeRenderer treeRenderer = new TreeRenderer();
        this.mainTree.setCellRenderer(treeRenderer);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane(this.infoTextPane);
        jPanel3.add(jScrollPane2);
        jScrollPane2.setPreferredSize(INFO_PANE_SIZE);
        this.infoTextPane.setEditable(false);
        JSplitPane jSplitPane = new JSplitPane(1, true, jPanel2, jPanel3);
        jSplitPane.setDividerSize(3);
        jPanel.add((Component)jSplitPane, "Center");
        this.newHostMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.selectNewHost();
            }
        });
        this.mrtgMenu.add(this.newHostMenuItem);
        this.reloadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.reloadDataFromHost();
            }
        });
        this.mrtgMenu.add(this.reloadMenuItem);
        this.mrtgMenu.addSeparator();
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.mrtgMenu.add(this.exitMenuItem);
        this.mrtgMenu.setMnemonic(77);
        this.menuBar.add(this.mrtgMenu);
        this.newRouterItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.addRouter();
            }
        });
        this.routersMenu.add(this.newRouterItem);
        this.editRouterItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.editRouter();
            }
        });
        this.routersMenu.add(this.editRouterItem);
        this.routersMenu.addSeparator();
        this.deleteRouterItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.removeRouter();
            }
        });
        this.routersMenu.add(this.deleteRouterItem);
        this.routersMenu.setMnemonic(82);
        this.menuBar.add(this.routersMenu);
        this.newLinkItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.addLink();
            }
        });
        this.linksMenu.add(this.newLinkItem);
        this.editLinkItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.editLink();
            }
        });
        this.linksMenu.add(this.editLinkItem);
        this.linksMenu.addSeparator();
        this.deleteLinkItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.removeLink();
            }
        });
        this.linksMenu.add(this.deleteLinkItem);
        this.linksMenu.addSeparator();
        this.quickGraphItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.graph(1);
            }
        });
        this.linksMenu.add(this.quickGraphItem);
        this.dailyGraphItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.graph(2);
            }
        });
        this.linksMenu.add(this.dailyGraphItem);
        this.weeklyGraphItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.graph(3);
            }
        });
        this.linksMenu.add(this.weeklyGraphItem);
        this.monthlyGraphItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.graph(4);
            }
        });
        this.linksMenu.add(this.monthlyGraphItem);
        this.yearlyGraphItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.graph(5);
            }
        });
        this.linksMenu.add(this.yearlyGraphItem);
        this.linksMenu.addSeparator();
        this.customGraphItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.graph(6);
            }
        });
        this.linksMenu.add(this.customGraphItem);
        this.linksMenu.setMnemonic(73);
        this.menuBar.add(this.linksMenu);
        this.helpMenu.setMnemonic(72);
        this.helpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new HelpDialog(Client.this);
            }
        });
        this.helpMenu.add(this.helpItem);
        this.helpMenu.addSeparator();
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new AboutDialog(Client.this);
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.menuBar.add(this.helpMenu);
        this.mrtgPopupReloadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.reloadDataFromHost();
            }
        });
        this.mrtgPopupMenu.add(this.mrtgPopupReloadMenuItem);
        this.mrtgPopupAddRouterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.addRouter();
            }
        });
        this.mrtgPopupMenu.add(this.mrtgPopupAddRouterMenuItem);
        this.mrtgPopupMenu.addSeparator();
        this.mrtgPopupExitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.mrtgPopupMenu.add(this.mrtgPopupExitMenuItem);
        this.routerPopupEditRouterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.editRouter();
            }
        });
        this.routerPopupMenu.add(this.routerPopupEditRouterMenuItem);
        this.routerPopupAddLinksMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.addLink();
            }
        });
        this.routerPopupMenu.add(this.routerPopupAddLinksMenuItem);
        this.routerPopupMenu.addSeparator();
        this.routerPopupRemoveRouterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.removeRouter();
            }
        });
        this.routerPopupMenu.add(this.routerPopupRemoveRouterMenuItem);
        this.linksPopupEditLinkMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.editLink();
            }
        });
        this.linksPopupMenu.add(this.linksPopupEditLinkMenuItem);
        this.linksPopupMenu.addSeparator();
        this.linksPopupQuickGraphMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.graph(1);
            }
        });
        this.linksPopupMenu.add(this.linksPopupQuickGraphMenuItem);
        this.linksPopupDailyGraphMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.graph(2);
            }
        });
        this.linksPopupMenu.add(this.linksPopupDailyGraphMenuItem);
        this.linksPopupWeeklyGraphMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.graph(3);
            }
        });
        this.linksPopupMenu.add(this.linksPopupWeeklyGraphMenuItem);
        this.linksPopupMonthlyGraphMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.graph(4);
            }
        });
        this.linksPopupMenu.add(this.linksPopupMonthlyGraphMenuItem);
        this.linksPopupYearlyGraphMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.graph(5);
            }
        });
        this.linksPopupMenu.add(this.linksPopupYearlyGraphMenuItem);
        this.linksPopupMenu.addSeparator();
        this.linksPopupCustomGraphMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.graph(6);
            }
        });
        this.linksPopupMenu.add(this.linksPopupCustomGraphMenuItem);
        this.linksPopupMenu.addSeparator();
        this.linksPopupRemoveLinkMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Client.this.removeLink();
            }
        });
        this.linksPopupMenu.add(this.linksPopupRemoveLinkMenuItem);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = Client.this.mainTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    TreePath treePath = Client.this.mainTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n != -1) {
                        Client.this.mainTree.setSelectionPath(treePath);
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        Object object = defaultMutableTreeNode.getUserObject();
                        if (object instanceof ServerInfo) {
                            Client.this.mrtgPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        } else if (object instanceof RouterInfo) {
                            Client.this.routerPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        } else if (object instanceof LinkInfo) {
                            Client.this.linksPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                }
            }
        };
        this.mainTree.addMouseListener(mouseAdapter);
        try {
            this.setIconImage(Resources.getImage(ICON));
        }
        catch (MrtgException mrtgException) {
            mrtgException.printStackTrace();
        }
        this.setJMenuBar(this.menuBar);
        this.clearUI();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowOpened(WindowEvent windowEvent) {
                Client.this.selectNewHost();
            }
        });
        Util.centerOnScreen(this);
        this.mainTree.requestFocus();
    }

    private void clearUI() {
        this.mainTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Not connected")));
        this.infoTextPane.setText("No info available");
    }

    private void selectNewHost() {
        try {
            HostDialog hostDialog = new HostDialog(this);
            String string = hostDialog.getHost();
            if (string != null) {
                this.mrtgData.setHost(string);
                this.reloadData();
            }
        }
        catch (Exception exception) {
            this.clearUI();
            this.handleException("Host is not responding", exception);
        }
    }

    private void nodeChangedAction() {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mainTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null && (object = defaultMutableTreeNode.getUserObject()) instanceof TreeElementInfo) {
            TreeElementInfo treeElementInfo = (TreeElementInfo)object;
            this.infoTextPane.setText(treeElementInfo.getInfo());
        }
    }

    private void reloadDataFromHost() {
        try {
            this.mrtgData.reload();
            this.reloadData();
        }
        catch (Exception exception) {
            this.clearUI();
            this.handleException("Could not reload data from host", exception);
        }
    }

    private void reloadData() {
        try {
            TreeModel treeModel = this.mrtgData.getTreeModel();
            this.mainTree.setModel(treeModel);
            this.mainTree.setSelectionRow(0);
            for (int i = this.mainTree.getRowCount() - 1; i > 0; --i) {
                this.mainTree.expandRow(i);
            }
        }
        catch (Exception exception) {
            this.clearUI();
            this.handleException("Could not reload data from host", exception);
        }
    }

    private boolean isConnected() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mainTree.getModel().getRoot();
        return defaultMutableTreeNode.getUserObject() instanceof ServerInfo;
    }

    private void addRouter() {
        if (!this.isConnected()) {
            Util.error(this, "Connect to MRTG server first");
            return;
        }
        EditRouterDialog editRouterDialog = new EditRouterDialog(this);
        RouterInfo routerInfo = editRouterDialog.getRouterInfo();
        if (routerInfo != null) {
            try {
                if (this.mrtgData.addRouter(routerInfo) == 0) {
                    Util.info(this, "Router " + routerInfo.getHost() + " added succesfully");
                    this.reloadData();
                } else {
                    Util.error(this, "Router " + routerInfo.getHost() + " not added");
                }
            }
            catch (Exception exception) {
                this.handleException("Could not add router", exception);
            }
        }
    }

    private void editRouter() {
        RouterInfo routerInfo = this.findSelectedRouter();
        if (routerInfo == null) {
            Util.warn(this, "Please, select router first");
            return;
        }
        EditRouterDialog editRouterDialog = new EditRouterDialog((Frame)this, routerInfo);
        if ((routerInfo = editRouterDialog.getRouterInfo()) != null) {
            try {
                if (this.mrtgData.updateRouter(routerInfo) == 0) {
                    Util.info(this, "Router " + routerInfo.getHost() + " updated succesfully");
                    this.reloadData();
                } else {
                    Util.error(this, "Router " + routerInfo.getHost() + " not updated");
                }
            }
            catch (Exception exception) {
                this.handleException("Could not edit router data", exception);
            }
        }
    }

    private void removeRouter() {
        RouterInfo routerInfo = this.findSelectedRouter();
        if (routerInfo == null) {
            Util.warn(this, "Please, select router first");
            return;
        }
        int n = routerInfo.getLinkInfo().length;
        if (n > 0) {
            Util.error(this, "To remove router " + routerInfo.getHost() + " please delete associated interfaces first (" + n + " found)");
            return;
        }
        try {
            if (this.mrtgData.deleteRouter(routerInfo) == 0) {
                Util.info(this, "Router " + routerInfo.getHost() + " deleted succesfully");
                this.reloadData();
            } else {
                Util.error(this, "Router " + routerInfo.getHost() + " not deleted");
            }
        }
        catch (Exception exception) {
            this.handleException("Could not delete router", exception);
        }
    }

    private void addLink() {
        RouterInfo routerInfo = this.findSelectedRouter();
        if (routerInfo == null) {
            Util.warn(this, "Please, select router first");
            return;
        }
        try {
            String[] stringArray = this.mrtgData.getAvailableLinks(routerInfo);
            if (stringArray == null || stringArray.length == 0) {
                Util.error(this, "No interfaces are available on this router");
                return;
            }
            EditLinkDialog editLinkDialog = new EditLinkDialog((Frame)this, routerInfo, stringArray);
            LinkInfo[] linkInfoArray = editLinkDialog.getLinkInfo();
            if (linkInfoArray != null) {
                int n = 0;
                int n2 = 0;
                String string = "";
                for (int i = 0; i < linkInfoArray.length; ++i) {
                    if (this.mrtgData.addLink(routerInfo, linkInfoArray[i]) == 0) {
                        ++n;
                        continue;
                    }
                    ++n2;
                    string = string + linkInfoArray[i].getIfDescr() + "@" + routerInfo.getHost() + "\n";
                }
                String string2 = n + " interface(s) added successfully\n";
                if (n2 != 0) {
                    string2 = string2 + n2 + " interface(s) not added:\n" + string;
                    Util.error(this, string2);
                } else {
                    Util.info(this, string2);
                }
                this.reloadData();
            }
        }
        catch (Exception exception) {
            this.handleException("Could not add new link", exception);
        }
    }

    private void editLink() {
        RouterInfo routerInfo = this.findSelectedRouter();
        LinkInfo linkInfo = this.findSelectedLink();
        if (routerInfo == null || linkInfo == null) {
            Util.warn(this, "Please, select interface first");
            return;
        }
        try {
            EditLinkDialog editLinkDialog = new EditLinkDialog((Frame)this, routerInfo, linkInfo);
            LinkInfo[] linkInfoArray = editLinkDialog.getLinkInfo();
            if (linkInfoArray != null) {
                if (this.mrtgData.updateLink(routerInfo, linkInfoArray[0]) == 0) {
                    Util.info(this, "Interface " + linkInfoArray[0].getIfDescr() + "@" + routerInfo.getHost() + " updated successfully");
                    this.reloadData();
                } else {
                    Util.error(this, "Interface " + linkInfoArray[0].getIfDescr() + "@" + routerInfo.getHost() + " NOT updated");
                }
            }
        }
        catch (Exception exception) {
            this.handleException("Could not edit link data", exception);
        }
    }

    private void removeLink() {
        RouterInfo routerInfo = this.findSelectedRouter();
        LinkInfo linkInfo = this.findSelectedLink();
        if (routerInfo == null || linkInfo == null) {
            Util.warn(this, "Please, select interface first");
            return;
        }
        try {
            if (this.mrtgData.removeLink(routerInfo, linkInfo) == 0) {
                Util.info(this, "Interface " + linkInfo.getIfDescr() + "@" + routerInfo.getHost() + " removed successfully");
                this.reloadData();
            } else {
                Util.error(this, "Interface " + linkInfo.getIfDescr() + "@" + routerInfo.getHost() + " NOT removed");
            }
        }
        catch (Exception exception) {
            this.handleException("Could not remove link", exception);
        }
    }

    private void graph(int n) {
        RouterInfo routerInfo = this.findSelectedRouter();
        LinkInfo linkInfo = this.findSelectedLink();
        if (routerInfo == null || linkInfo == null) {
            Util.warn(this, "Please, select interface first");
            return;
        }
        new GraphFrame(this, routerInfo, linkInfo, n);
    }

    private RouterInfo findSelectedRouter() {
        TreePath treePath = this.mainTree.getSelectionPath();
        if (treePath == null || treePath.getPathCount() < 2) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        return (RouterInfo)defaultMutableTreeNode.getUserObject();
    }

    private LinkInfo findSelectedLink() {
        TreePath treePath = this.mainTree.getSelectionPath();
        if (treePath == null || treePath.getPathCount() < 3) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return (LinkInfo)defaultMutableTreeNode.getUserObject();
    }

    private void handleException(String string, Exception exception) {
        Util.error(this, string + ":\n" + exception);
    }

    public static void main(String[] stringArray) throws IOException, XmlRpcException, InterruptedException {
        SplashWindow splashWindow = new SplashWindow();
        Thread.sleep(1000L);
        Client client = new Client();
        client.setVisible(true);
        splashWindow.close();
    }
}

