/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import org.jrobin.mrtg.MrtgException;
import org.jrobin.mrtg.client.LinkInfo;
import org.jrobin.mrtg.client.MrtgData;
import org.jrobin.mrtg.client.Resources;
import org.jrobin.mrtg.client.RouterInfo;
import org.jrobin.mrtg.client.RpcClient;
import org.jrobin.mrtg.client.Util;

class GraphFrame
extends JFrame {
    static final int TYPE_QUICK = 1;
    static final int TYPE_DAILY = 2;
    static final int TYPE_WEEKLY = 3;
    static final int TYPE_MONTHLY = 4;
    static final int TYPE_YEARLY = 5;
    static final int TYPE_CUSTOM = 6;
    static int START_YEAR = 2000;
    static int END_YEAR = 2010;
    static Dimension GRAPH_SIZE = new Dimension(600, 400);
    static final int REFRESH_INTERVAL = 300;
    private JComboBox startDay = new JComboBox();
    private JComboBox startMonth = new JComboBox();
    private JComboBox startYear = new JComboBox();
    private JComboBox startHour = new JComboBox();
    private JComboBox endDay = new JComboBox();
    private JComboBox endMonth = new JComboBox();
    private JComboBox endYear = new JComboBox();
    private JComboBox endHour = new JComboBox();
    private JButton refreshButton = Util.largeButton("Refresh");
    private JButton leftButton = Util.standardButton("<< Left");
    private JButton rightButton = Util.standardButton("Right >>");
    private JButton saveButton = Util.standardButton("Save graph...");
    private JButton closeButton = Util.standardButton("Close");
    private JLabel graphLabel = new JLabel();
    private byte[] graphBytes;
    private String mrtgHost = MrtgData.getInstance().getMrtgHost();
    private RpcClient client;
    private RouterInfo routerInfo;
    private LinkInfo linkInfo;
    private int type;
    private Refresher refresher = new Refresher();
    private JLabel infoLabel = new JLabel();

    GraphFrame(JFrame jFrame, RouterInfo routerInfo, LinkInfo linkInfo, int n) {
        super(linkInfo.getIfDescr() + "@" + routerInfo.getHost() + " [graph]");
        this.setResizable(false);
        this.routerInfo = routerInfo;
        this.linkInfo = linkInfo;
        this.type = n;
        this.constructUI();
        this.setInitialDates();
        this.createGraph();
        this.pack();
        this.setVisible(true);
    }

    private void constructUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(3, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(3, 3));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(new JLabel("From: "));
        jPanel3.add(this.startMonth);
        jPanel3.add(this.startDay);
        jPanel3.add(this.startYear);
        jPanel3.add(this.startHour);
        jPanel3.add(new JLabel(" To: "));
        jPanel3.add(this.endMonth);
        jPanel3.add(this.endDay);
        jPanel3.add(this.endYear);
        jPanel3.add(this.endHour);
        if (this.type != 6) {
            this.startMonth.setEnabled(false);
            this.startDay.setEnabled(false);
            this.startYear.setEnabled(false);
            this.startHour.setEnabled(false);
            this.endMonth.setEnabled(false);
            this.endDay.setEnabled(false);
            this.endYear.setEnabled(false);
            this.endHour.setEnabled(false);
        }
        jPanel2.add((Component)jPanel3, "North");
        this.graphLabel.setPreferredSize(GRAPH_SIZE);
        this.graphLabel.setBorder(BorderFactory.createBevelBorder(1));
        jPanel2.add((Component)this.graphLabel, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1));
        this.leftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.shift(false);
            }
        });
        if (this.type != 6) {
            jPanel4.add(this.leftButton);
        }
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.createGraph();
            }
        });
        jPanel4.add(this.refreshButton);
        this.rightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.shift(true);
            }
        });
        if (this.type != 6) {
            jPanel4.add(this.rightButton);
        }
        jPanel2.add((Component)jPanel4, "South");
        jPanel.add((Component)jPanel2, "Center");
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut((int)jPanel3.getPreferredSize().getHeight()));
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.save();
            }
        });
        box.add(this.saveButton);
        box.add(Box.createVerticalStrut(3));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.close();
            }
        });
        box.add(this.closeButton);
        box.add(Box.createVerticalStrut(20));
        box.add(this.infoLabel);
        jPanel.add((Component)box, "East");
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("<< Left");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.shift(false);
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Right >>");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.shift(true);
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("Refresh graph");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.refreshButton.doClick();
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem("Save graph...");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.save();
            }
        });
        JMenuItem jMenuItem5 = new JMenuItem("Close window");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.close();
            }
        });
        if (this.type != 6) {
            jPopupMenu.add(jMenuItem);
            jPopupMenu.add(jMenuItem2);
        }
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem5);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.graphLabel.addMouseListener(mouseAdapter);
        this.fillDays(this.startDay);
        this.fillDays(this.endDay);
        this.fillMonths(this.startMonth);
        this.fillMonths(this.endMonth);
        this.fillYears(this.startYear);
        this.fillYears(this.endYear);
        this.fillHours(this.startHour);
        this.fillHours(this.endHour);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GraphFrame.this.refresher.terminate();
            }
        });
        this.getRootPane().setDefaultButton(this.saveButton);
        this.saveButton.setMnemonic(83);
        this.closeButton.setMnemonic(67);
        this.refreshButton.setMnemonic(70);
        this.leftButton.setMnemonic(76);
        this.rightButton.setMnemonic(82);
        this.setDefaultCloseOperation(2);
        try {
            this.setIconImage(Resources.getImage("res/mrtg/icon.png"));
        }
        catch (MrtgException mrtgException) {
            mrtgException.printStackTrace();
        }
        Util.centerOnScreen(this);
    }

    private void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void save() {
        if (this.graphBytes == null) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() ? true : file.getAbsolutePath().toLowerCase().endsWith(".png");
            }

            public String getDescription() {
                return "PNG images";
            }
        };
        jFileChooser.setFileFilter(fileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            try {
                Object object;
                int n2;
                File file = jFileChooser.getSelectedFile();
                String string = file.getAbsolutePath();
                if (!string.toLowerCase().endsWith(".png")) {
                    string = string + ".png";
                    file = new File(string);
                }
                if (file.exists() && (n2 = JOptionPane.showConfirmDialog(this, object = "File [" + file.getName() + "] already exists. Do you want to overwrite it?", "File exists", 0)) == 1) {
                    return;
                }
                object = new BufferedOutputStream(new FileOutputStream(file));
                ((FilterOutputStream)object).write(this.graphBytes);
                ((FilterOutputStream)object).close();
            }
            catch (IOException iOException) {
                Util.error(this, "Could not save graph to file:\n" + iOException);
            }
        }
    }

    private void shift(boolean bl) {
        int n = bl ? 1 : -1;
        GregorianCalendar gregorianCalendar = this.getDate(false);
        GregorianCalendar gregorianCalendar2 = this.getDate(true);
        switch (this.type) {
            case 1: 
            case 2: {
                gregorianCalendar.add(5, n * 1);
                gregorianCalendar2.add(5, n * 1);
                break;
            }
            case 3: {
                gregorianCalendar.add(5, n * 7);
                gregorianCalendar2.add(5, n * 7);
                break;
            }
            case 4: {
                gregorianCalendar.add(2, n * 1);
                gregorianCalendar2.add(2, n * 1);
                break;
            }
            case 5: {
                gregorianCalendar.add(1, n * 1);
                gregorianCalendar2.add(1, n * 1);
            }
        }
        this.setDate(gregorianCalendar, false);
        this.setDate(gregorianCalendar2, true);
        this.createGraph();
    }

    private void createGraph() {
        this.refresher.terminate();
        this.refreshButton.setText("Refresh");
        Date date = this.getDate(false).getTime();
        Date date2 = this.getDate(true).getTime();
        Date date3 = new Date();
        if (date.getTime() >= date2.getTime()) {
            Util.error(this, "Invalid time span");
            return;
        }
        try {
            if (this.client == null) {
                this.client = new RpcClient(this.mrtgHost);
            }
            this.graphBytes = this.client.getPngGraph(this.routerInfo, this.linkInfo, date, date2);
            ImageIcon imageIcon = new ImageIcon(this.graphBytes, "PNG graph");
            if ((double)imageIcon.getIconWidth() != GRAPH_SIZE.getWidth() || (double)imageIcon.getIconHeight() != GRAPH_SIZE.getHeight()) {
                GRAPH_SIZE = new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
                this.graphLabel.setPreferredSize(GRAPH_SIZE);
                this.pack();
            }
            this.graphLabel.setIcon(imageIcon);
            if (date.getTime() <= date3.getTime() && date3.getTime() < date2.getTime()) {
                this.refresher = new Refresher();
                this.refresher.start();
            }
        }
        catch (Exception exception) {
            Util.error(this, "Graph could not be generated:\n" + exception);
        }
    }

    private GregorianCalendar getDate(boolean bl) {
        JComboBox jComboBox = bl ? this.endHour : this.startHour;
        JComboBox jComboBox2 = bl ? this.endDay : this.startDay;
        JComboBox jComboBox3 = bl ? this.endMonth : this.startMonth;
        JComboBox jComboBox4 = bl ? this.endYear : this.startYear;
        int n = jComboBox.getSelectedIndex();
        int n2 = jComboBox2.getSelectedIndex() + 1;
        int n3 = jComboBox3.getSelectedIndex();
        int n4 = jComboBox4.getSelectedIndex() + START_YEAR;
        return new GregorianCalendar(n4, n3, n2, n, 0);
    }

    private void fillDays(JComboBox jComboBox) {
        for (int i = 1; i <= 31; ++i) {
            jComboBox.insertItemAt((i < 10 ? "0" : "") + i, i - 1);
        }
        jComboBox.setSelectedIndex(0);
    }

    private void fillMonths(JComboBox jComboBox) {
        String[] stringArray = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Avg", "Sep", "Oct", "Nov", "Dec"};
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.insertItemAt(stringArray[i], i);
        }
        jComboBox.setSelectedIndex(0);
    }

    private void fillYears(JComboBox jComboBox) {
        for (int i = START_YEAR; i <= END_YEAR; ++i) {
            jComboBox.insertItemAt("" + i, i - START_YEAR);
        }
        jComboBox.setSelectedIndex(0);
    }

    private void fillHours(JComboBox jComboBox) {
        for (int i = 0; i < 24; ++i) {
            String string = (i < 10 ? "0" : "") + i + ":00";
            jComboBox.insertItemAt(string, i);
        }
        jComboBox.setSelectedIndex(0);
    }

    private void setDate(GregorianCalendar gregorianCalendar, boolean bl) {
        JComboBox jComboBox = bl ? this.endHour : this.startHour;
        JComboBox jComboBox2 = bl ? this.endDay : this.startDay;
        JComboBox jComboBox3 = bl ? this.endMonth : this.startMonth;
        JComboBox jComboBox4 = bl ? this.endYear : this.startYear;
        jComboBox.setSelectedIndex(gregorianCalendar.get(11));
        jComboBox2.setSelectedIndex(gregorianCalendar.get(5) - 1);
        jComboBox3.setSelectedIndex(gregorianCalendar.get(2));
        jComboBox4.setSelectedIndex(gregorianCalendar.get(1) - START_YEAR);
    }

    private void setInitialDates() {
        GregorianCalendar gregorianCalendar = null;
        GregorianCalendar gregorianCalendar2 = null;
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
        switch (this.type) {
            case 1: {
                gregorianCalendar = new GregorianCalendar(gregorianCalendar3.get(1), gregorianCalendar3.get(2), gregorianCalendar3.get(5) - 1, gregorianCalendar3.get(11) + 1, 0);
                gregorianCalendar2 = new GregorianCalendar(gregorianCalendar3.get(1), gregorianCalendar3.get(2), gregorianCalendar3.get(5), gregorianCalendar3.get(11) + 1, 0);
                break;
            }
            case 2: 
            case 6: {
                gregorianCalendar = new GregorianCalendar(gregorianCalendar3.get(1), gregorianCalendar3.get(2), gregorianCalendar3.get(5));
                gregorianCalendar2 = new GregorianCalendar(gregorianCalendar3.get(1), gregorianCalendar3.get(2), gregorianCalendar3.get(5) + 1);
                break;
            }
            case 3: {
                int n = gregorianCalendar3.get(7) - 1;
                gregorianCalendar = new GregorianCalendar(gregorianCalendar3.get(1), gregorianCalendar3.get(2), gregorianCalendar3.get(5) - n);
                gregorianCalendar2 = new GregorianCalendar(gregorianCalendar3.get(1), gregorianCalendar3.get(2), gregorianCalendar3.get(5) - n + 7);
                break;
            }
            case 4: {
                gregorianCalendar = new GregorianCalendar(gregorianCalendar3.get(1), gregorianCalendar3.get(2), 1);
                gregorianCalendar2 = new GregorianCalendar(gregorianCalendar3.get(1), gregorianCalendar3.get(2) + 1, 1);
                break;
            }
            case 5: {
                gregorianCalendar = new GregorianCalendar(gregorianCalendar3.get(1), 0, 1);
                gregorianCalendar2 = new GregorianCalendar(gregorianCalendar3.get(1) + 1, 0, 1);
            }
        }
        this.setDate(gregorianCalendar, false);
        this.setDate(gregorianCalendar2, true);
    }

    class Refresher
    extends Thread {
        private boolean active = true;
        private int secs = 300;

        Refresher() {
            this.setDaemon(true);
        }

        public void run() {
            while (this.active) {
                this.secs = 300;
                while (this.secs >= 0 && this.active) {
                    GraphFrame.this.refreshButton.setText("Refreshing in " + this.secs + '\"');
                    try {
                        Refresher.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    --this.secs;
                }
                if (!this.active) continue;
                GraphFrame.this.refreshButton.doClick();
            }
        }

        void terminate() {
            this.active = false;
        }

        void reset() {
            this.secs = 300;
        }
    }
}

