/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.convertor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;

class Convertor {
    static final String SUFFIX = ".jrb";
    static final String SEPARATOR = System.getProperty("file.separator");
    static final Runtime RUNTIME = Runtime.getRuntime();
    private String rrdtoolBinary;
    private String workingDirectory;
    private String suffix;
    private int okCount;
    private int badCount;

    private Convertor(String string, String string2, String string3) {
        this.rrdtoolBinary = string;
        this.workingDirectory = string2;
        this.suffix = string3;
    }

    private void convert() {
        File file;
        Convertor.println("Converting RRDTool files to JRobin native format");
        Convertor.println("Converted files will be placed in the same directory, with " + this.suffix + " suffix appended");
        Convertor.println("==========================================");
        long l = System.currentTimeMillis();
        if (!this.workingDirectory.endsWith(SEPARATOR)) {
            this.workingDirectory = this.workingDirectory + SEPARATOR;
        }
        if ((file = new File(this.workingDirectory)).isDirectory() && file.exists()) {
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File file) {
                    try {
                        return !file.isDirectory() && file.getCanonicalPath().endsWith(".rrd");
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
            };
            File[] fileArray = file.listFiles(fileFilter);
            for (int i = 0; i < fileArray.length; ++i) {
                Convertor.print("[" + i + "/" + fileArray.length + "] ");
                this.convertFile(fileArray[i]);
            }
        } else if (!file.isDirectory() && file.exists()) {
            this.convertFile(file);
        } else {
            Convertor.println("Nothing to do");
        }
        Convertor.println("Conversion finished, " + this.okCount + " files ok, " + this.badCount + " files bad");
        long l2 = (System.currentTimeMillis() - l + 500L) / 1000L;
        long l3 = l2 / 60L;
        Convertor.println("Time elapsed: " + l3 + ":" + ((l2 %= 60L) < 10L ? "0" : "") + l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long convertFile(File file) {
        long l;
        long l2 = System.currentTimeMillis();
        String string = null;
        String string2 = null;
        try {
            String string3 = file.getCanonicalPath();
            string = string3 + ".xml";
            string2 = string3 + this.suffix;
            Convertor.print(file.getName() + " ");
            this.xmlDump(string3, string);
            RrdDb rrdDb = new RrdDb(string2, string);
            rrdDb.close();
            rrdDb = null;
            System.gc();
            ++this.okCount;
            long l3 = System.currentTimeMillis() - l2;
            Convertor.println("[OK, " + (double)l3 / 1000.0 + "]");
            l = l3;
        }
        catch (IOException iOException) {
            Convertor.removeFile(string2);
            ++this.badCount;
            Convertor.println("[IO ERROR]");
            long l4 = -1L;
            Convertor.removeFile(string);
            return l4;
        }
        catch (RrdException rrdException) {
            Convertor.removeFile(string2);
            ++this.badCount;
            Convertor.println("[RRD ERROR]");
            long l5 = -2L;
            {
                catch (Throwable throwable) {
                    Convertor.removeFile(string);
                    throw throwable;
                }
            }
            Convertor.removeFile(string);
            return l5;
        }
        Convertor.removeFile(string);
        return l;
    }

    private static boolean removeFile(String string) {
        if (string != null) {
            return new File(string).delete();
        }
        return true;
    }

    private void xmlDump(String string, String string2) throws IOException {
        String[] stringArray = new String[]{this.rrdtoolBinary, "dump", string};
        Process process = RUNTIME.exec(stringArray);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2, false));
        Convertor.transportStream(process.getInputStream(), bufferedOutputStream);
        Convertor.transportStream(process.getErrorStream(), null);
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2 || stringArray.length > 3) {
            Convertor.println("Usage: java -jar convertor.jar <path to RRDTool binary> <RRD directory/file path> [converted file suffix]");
        } else {
            Convertor convertor = new Convertor(stringArray[0], stringArray[1], stringArray.length == 3 ? stringArray[2] : SUFFIX);
            convertor.convert();
        }
    }

    private static final void println(String string) {
        System.out.println(string);
    }

    private static final void print(String string) {
        System.out.print(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transportStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                if (outputStream == null) continue;
                outputStream.write(n);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            inputStream.close();
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
            throw throwable;
        }
        inputStream.close();
        if (outputStream != null) {
            outputStream.flush();
            outputStream.close();
        }
    }
}

