/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.minarea.deltamerge0;

import com.sun.electric.api.minarea.ErrorLogger;
import com.sun.electric.api.minarea.LayoutCell;
import com.sun.electric.api.minarea.ManhattanOrientation;
import com.sun.electric.api.minarea.MinAreaChecker;
import com.sun.electric.api.minarea.geometry.Point;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.bool.DeltaMerge;
import com.sun.electric.database.geometry.bool.PointsSorter;
import com.sun.electric.database.geometry.bool.UnloadPolys;
import com.sun.electric.util.math.DBMath;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SimpleChecker
implements MinAreaChecker {
    @Override
    public String getAlgorithmName() {
        return "DeltaMerge0";
    }

    @Override
    public Properties getDefaultParameters() {
        Properties parameters = new Properties();
        parameters.put("ReportTiles", Boolean.TRUE);
        return parameters;
    }

    @Override
    public void check(LayoutCell topCell, long minArea, Properties parameters, ErrorLogger errorLogger) {
        new Task(topCell, minArea, parameters, errorLogger);
    }

    private static class Task {
        private final int DEBUG = 0;
        private long totalArea;
        private boolean reportTiles;

        private Task(LayoutCell topCell, long minArea, Properties parameters, ErrorLogger errorLogger) {
            this.reportTiles = Boolean.parseBoolean(parameters.get("ReportTiles").toString());
            PointsSorter ps = new PointsSorter();
            this.collect(ps, topCell, 0, 0, ManhattanOrientation.R0);
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(bout);
                DeltaMerge dm = new DeltaMerge();
                dm.loop(ps, out);
                out.close();
                byte[] ba = bout.toByteArray();
                bout = null;
                DataInputStream inpS = new DataInputStream(new ByteArrayInputStream(ba));
                UnloadPolys up = new UnloadPolys();
                Iterable<PolyBase.PolyBaseTree> trees = up.loop(inpS, false);
                inpS.close();
                this.totalArea = 0L;
                for (PolyBase.PolyBaseTree tree : trees) {
                    this.traversePolyTree(tree, 0, minArea, errorLogger);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void collect(final PointsSorter ps, LayoutCell cell, final int x, final int y, final ManhattanOrientation orient) {
            int sz;
            int bufSize = Math.max(1, Math.min(16, cell.getNumRectangles()));
            int[] coords = new int[4 * bufSize];
            for (int ir = 0; ir < cell.getNumRectangles(); ir += sz) {
                sz = Math.min(bufSize, cell.getNumRectangles() - ir);
                cell.readRectangleCoords(coords, ir, sz);
                orient.transformRects(coords, 0, sz);
                for (int j = 0; j < sz; ++j) {
                    int lx = coords[j * 4 + 0] + x;
                    int ly = coords[j * 4 + 1] + y;
                    int hx = coords[j * 4 + 2] + x;
                    int hy = coords[j * 4 + 3] + y;
                    ps.put(lx, ly, hx, hy);
                }
            }
            if (cell.getNumSubcells() > 0) {
                cell.traverseSubcellInstances(new LayoutCell.SubcellHandler(){

                    @Override
                    public void apply(LayoutCell subCell, int anchorX, int anchorY, ManhattanOrientation subOrient) {
                        Point p = new Point(anchorX, anchorY).transform(orient);
                        Task.this.collect(ps, subCell, p.getX() + x, p.getY() + y, orient.concatenate(subOrient));
                    }
                });
            }
        }

        private void traversePolyTree(PolyBase.PolyBaseTree obj, int level, long minArea, ErrorLogger errorLogger) {
            if (level % 2 == 0) {
                PolyBase poly = obj.getPoly();
                double area = poly.getArea();
                for (PolyBase.PolyBaseTree son : obj.getSons()) {
                    PolyBase hole = son.getPoly();
                    area -= hole.getArea();
                }
                long larea = DBMath.lambdaToGrid(area * 400.0);
                this.totalArea += larea;
                if (larea < minArea) {
                    PolyBase.Point p = poly.getPoints()[1];
                    Area shape = null;
                    if (this.reportTiles) {
                        shape = new Area(Task.scale(poly));
                        for (PolyBase.PolyBaseTree son : obj.getSons()) {
                            PolyBase hole = son.getPoly();
                            shape.subtract(new Area(Task.scale(hole)));
                        }
                    }
                    errorLogger.reportMinAreaViolation(larea, (int)DBMath.lambdaToGrid(((Point2D)p).getX()), (int)DBMath.lambdaToGrid(((Point2D)p).getY()), shape);
                }
            }
            for (PolyBase.PolyBaseTree son : obj.getSons()) {
                this.traversePolyTree(son, level + 1, minArea, errorLogger);
            }
        }

        private static PolyBase scale(PolyBase poly) {
            PolyBase.Point[] origPoints = poly.getPoints();
            PolyBase.Point[] newPoints = new PolyBase.Point[origPoints.length];
            for (int i = 0; i < origPoints.length; ++i) {
                PolyBase.Point p = origPoints[i];
                newPoints[i] = PolyBase.fromLambda(DBMath.lambdaToGrid(((Point2D)p).getX()), DBMath.lambdaToGrid(((Point2D)p).getY()));
            }
            return new PolyBase(newPoints);
        }
    }
}

