/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.gui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.gcalc.plugin.properties.GraphProperties;

public class GraphDimensionPanel
extends JPanel
implements ActionListener {
    private GraphProperties properties;
    private JTextField width;
    private JTextField height;
    private JButton apply;
    private JButton reset;

    public GraphDimensionPanel(GraphProperties gp) {
        this.properties = gp;
        Dimension dimension = (Dimension)this.properties.get(GraphProperties.SCREEN_DIMENSION);
        this.width = new JTextField("" + dimension.width);
        this.height = new JTextField("" + dimension.height);
        JPanel dimBox = new JPanel(new GridLayout(2, 2));
        dimBox.add(new JLabel("Width"));
        dimBox.add(new JLabel("Height"));
        dimBox.add(this.width);
        dimBox.add(this.height);
        Box buttonBox = Box.createHorizontalBox();
        this.apply = new JButton("Apply");
        buttonBox.add(this.apply);
        this.reset = new JButton("Restore");
        buttonBox.add(this.reset);
        this.apply.addActionListener(this);
        this.reset.addActionListener(this);
        this.width.addActionListener(this);
        this.height.addActionListener(this);
        Box mainBox = Box.createVerticalBox();
        mainBox.add(dimBox);
        mainBox.add(Box.createVerticalStrut(10));
        mainBox.add(buttonBox);
        this.add(mainBox);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.width) {
            this.height.requestFocus();
            return;
        }
        if (src == this.reset) {
            this.reset();
        }
        if (src == this.apply) {
            this.apply();
        }
    }

    private void reset() {
        Dimension dimension = (Dimension)this.properties.get(GraphProperties.SCREEN_DIMENSION);
        this.width.setText("" + dimension.width);
        this.height.setText("" + dimension.height);
    }

    private void apply() {
        int h;
        int w;
        String wstr = this.width.getText();
        String hstr = this.height.getText();
        try {
            w = Integer.parseInt(wstr);
        }
        catch (NumberFormatException e) {
            this.width.setSelectionStart(0);
            this.width.setSelectionEnd(wstr.length());
            this.width.requestFocus();
            return;
        }
        try {
            h = Integer.parseInt(hstr);
        }
        catch (NumberFormatException e) {
            this.height.setSelectionStart(0);
            this.height.setSelectionEnd(hstr.length());
            this.height.requestFocus();
            return;
        }
        if (w >= 150 && h >= 150 && (double)(w * h) < 1000000.0) {
            this.properties.put(GraphProperties.SCREEN_DIMENSION, new Dimension(w, h));
        }
    }
}

