/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.proto.plugin.space;

public class Matrix {
    private double[][] m;

    public static Matrix getIdentity(int n) {
        return new Matrix(n);
    }

    public Matrix(int r, int c, double[] a) {
        if (r <= 0 || c <= 0) {
            throw new IllegalArgumentException("Bad matrix size!");
        }
        this.m = new double[r][c];
        int k = 0;
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < r) {
                this.m[i][j] = k < a.length ? a[k] : 0.0;
                ++k;
                ++j;
            }
            ++i;
        }
    }

    public Matrix(int r, int c) {
        this(r, c, new double[0]);
    }

    private Matrix(int r) {
        this(r, r);
        int i = 0;
        while (i < r) {
            this.m[i][i] = 1.0;
            ++i;
        }
    }

    public double entry(int r, int c) {
        return this.m[r][c];
    }

    public boolean isSquare() {
        return this.rows() == this.columns();
    }

    public int rows() {
        return this.m.length;
    }

    public int columns() {
        return this.m[0].length;
    }

    public Matrix multiply(Matrix b) {
        if (this.columns() != b.rows()) {
            throw new IllegalArgumentException("Bad matrix size!");
        }
        int size = this.rows() * b.columns();
        double[] e = new double[size];
        int r = this.rows();
        int c = b.columns();
        int n = this.columns();
        int t = 0;
        int idx = 0;
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                t = 0;
                int k = 0;
                while (k < n) {
                    t = (int)((double)t + this.entry(i, k) * this.entry(k, j));
                    ++k;
                }
                e[idx] = t;
                ++idx;
                ++j;
            }
            ++i;
        }
        return new Matrix(r, c, e);
    }
}

