/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.html;

import com.google.inject.Inject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.hooks.FileLoadPostProcessor;
import com.google.jstestdriver.html.HtmlDocLexer;
import com.google.jstestdriver.html.HtmlDocParser;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineHtmlProcessor
implements FileLoadPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlineHtmlProcessor.class);
    private final HtmlDocParser parser;
    private final HtmlDocLexer lexer;

    @Inject
    public InlineHtmlProcessor(HtmlDocParser parser, HtmlDocLexer lexer) {
        this.parser = parser;
        this.lexer = lexer;
    }

    public FileInfo process(FileInfo file) {
        try {
            LOGGER.trace("inlining html for {}", (Object)file.getFilePath());
            String source = file.getData();
            CharArrayWriter writer = new CharArrayWriter();
            this.parser.parse(this.lexer.createStream(new ByteArrayInputStream(source.getBytes()))).write(writer);
            ((Writer)writer).flush();
            return file.load(((Object)writer).toString(), file.getTimestamp());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

