/* flyBase2004Xref.c was originally generated by the autoSql program, which also 
 * generated flyBase2004Xref.h and flyBase2004Xref.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "flyBase2004Xref.h"


void flyBase2004XrefStaticLoad(char **row, struct flyBase2004Xref *ret)
/* Load a row from flyBase2004Xref table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->symbol = row[1];
ret->synonyms = row[2];
ret->fbtr = row[3];
ret->fbgn = row[4];
ret->fbpp = row[5];
ret->fban = row[6];
ret->type = row[7];
}

struct flyBase2004Xref *flyBase2004XrefLoad(char **row)
/* Load a flyBase2004Xref from row fetched with select * from flyBase2004Xref
 * from database.  Dispose of this with flyBase2004XrefFree(). */
{
struct flyBase2004Xref *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->symbol = cloneString(row[1]);
ret->synonyms = cloneString(row[2]);
ret->fbtr = cloneString(row[3]);
ret->fbgn = cloneString(row[4]);
ret->fbpp = cloneString(row[5]);
ret->fban = cloneString(row[6]);
ret->type = cloneString(row[7]);
return ret;
}

struct flyBase2004Xref *flyBase2004XrefLoadAll(char *fileName) 
/* Load all flyBase2004Xref from a whitespace-separated file.
 * Dispose of this with flyBase2004XrefFreeList(). */
{
struct flyBase2004Xref *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = flyBase2004XrefLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct flyBase2004Xref *flyBase2004XrefLoadAllByChar(char *fileName, char chopper) 
/* Load all flyBase2004Xref from a chopper separated file.
 * Dispose of this with flyBase2004XrefFreeList(). */
{
struct flyBase2004Xref *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = flyBase2004XrefLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct flyBase2004Xref *flyBase2004XrefCommaIn(char **pS, struct flyBase2004Xref *ret)
/* Create a flyBase2004Xref out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new flyBase2004Xref */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->symbol = sqlStringComma(&s);
ret->synonyms = sqlStringComma(&s);
ret->fbtr = sqlStringComma(&s);
ret->fbgn = sqlStringComma(&s);
ret->fbpp = sqlStringComma(&s);
ret->fban = sqlStringComma(&s);
ret->type = sqlStringComma(&s);
*pS = s;
return ret;
}

void flyBase2004XrefFree(struct flyBase2004Xref **pEl)
/* Free a single dynamically allocated flyBase2004Xref such as created
 * with flyBase2004XrefLoad(). */
{
struct flyBase2004Xref *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->symbol);
freeMem(el->synonyms);
freeMem(el->fbtr);
freeMem(el->fbgn);
freeMem(el->fbpp);
freeMem(el->fban);
freeMem(el->type);
freez(pEl);
}

void flyBase2004XrefFreeList(struct flyBase2004Xref **pList)
/* Free a list of dynamically allocated flyBase2004Xref's */
{
struct flyBase2004Xref *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    flyBase2004XrefFree(&el);
    }
*pList = NULL;
}

void flyBase2004XrefOutput(struct flyBase2004Xref *el, FILE *f, char sep, char lastSep) 
/* Print out flyBase2004Xref.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->symbol);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->synonyms);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fbtr);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fbgn);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fbpp);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fban);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

