(import "elixir")


(defpattern derive
    (((/ 1 _x) _x) `(/ -1 (^ ,_x 2)))
    (((sqrt _x) _x) `(/ 1 (* 2 sqrt (,_x))))
    (((sin _x) _x) `(cos ,_x))
    (((cos _x) _x) `(- (sin ,_x)))
    (((tan _x) _x) `(/ 1 (^ (cos ,_x) 2)))
    (((exp _x) _x) `(exp ,_x))
    (((^ _a _x) _x) `(* (^ ,_a ,_x) (log ,_a)))
    (((log _x) _x) `(/ 1 ,_x))
    (((log _a _x) _x) `(/ 1 (* ,_x (log ,_a))))
    (((* _k (_f _x)) _x) (when (numberp _k)) (let ((d (derive `(,_f ,_x) `,_x)))
                                                `(* ,_k ,d) ))
    (((+ (_f _x) (_g _x)) _x)
     (let ((d1 (derive `(,_f ,_x) `,_x))
           (d2 (derive `(,_g ,_x) `,_x)) )
        `(+ ,d1 ,d2)))
    (((* (_f _x) (_g _x)) _x)
     (let ((d1 (derive `(,_f ,_x) `,_x))
           (d2 (derive `(,_g ,_x) `,_x)) )
        `(+ (* ,d1 (,_g ,_x)) (* (,_f ,_x) ,d2))))
    (((/ (_f _x) (_g _x)) _x)
     (let ((d1 (derive `(,_f ,_x) `,_x))
           (d2 (derive `(,_g ,_x) `,_x)) )
        `(/ (+ (* ,d1 (,_g ,_x))
               (* (,_f ,_x) ,d2 (^ (,_g ,_x) 2)))))))
