/*
 * render.h: Header file for rotoscope's rendering-related functionality.
 *
 * 
 * Copyright 2006, James Foster
 *
 * This file is part of rotoscope.
 *
 * Rotoscope is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rotoscope is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with rotoscope; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef _RENDER_H_
#define _RENDER_H_

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib.h>

#include "graph.h"

typedef struct
{
	guchar r;
	guchar g;
	guchar b;
} Color;

typedef enum { UNUSED, EDGE, REGION } RotoPixel;

RotoPixel** create_rotomap( unsigned int width, unsigned int height );
void free_rotomap( RotoPixel** rotomap, unsigned int width );

GList* get_region_pixels( RotoPixel** rotomap, unsigned int width, unsigned int height, unsigned int x, unsigned int y );
void free_regions( GList* regions );

void plot_edge( RotoPixel** rotomap, Edge* e );
void plot_edges( RotoPixel** rotomap, GList* edges );

void put_pixel( GdkPixbuf* dest, unsigned int x, unsigned int y, Color color );
Color get_pixel( GdkPixbuf* src, unsigned int x, unsigned int y );

Color calc_average_color( GList* pixels, GdkPixbuf* src );
void color_pixels( GList* pixels, GdkPixbuf* dest, Color color );

void render_region( RotoPixel** rotomap, unsigned int width, unsigned int height,
		unsigned int x, unsigned int y,
		GdkPixbuf* src, GdkPixbuf* dest );
void render( GdkPixbuf* src, GList* edges, GdkPixbuf* dest );

#endif

