/*
 * <one line to give the program's name and a brief idea of what it does.>
 * Copyright 2018  <copyright holder> <email>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License or (at your option) version 3 or any later version
 * accepted by the membership of KDE e.V. (or its successor approved
 * by the membership of KDE e.V.), which shall act as a proxy
 * defined in Section 14 of version 3 of the license.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "progressjob.h"

namespace ThreadWeaver {
class Thread;
}  // namespace ThreadWeaver

ProgressJob::ProgressJob() = default;

auto ProgressJob::progress() const -> int
{
    return m_progress;
}

void ProgressJob::setProgress ( int progress )
{
    if ( m_progress == progress ) {
        return;
    }

    m_progress = progress;
    Q_EMIT progressChanged ( m_progress );
}

auto ProgressJob::totalSteps() const -> int
{
    return m_totalSteps;
}

void ProgressJob::setTotalSteps ( int totalSteps )
{
    if ( m_totalSteps == totalSteps ) {
        return;
    }

    m_totalSteps = totalSteps;
    Q_EMIT progressChanged ( m_totalSteps );
}

auto ProgressJob::isAborted() const -> bool
{
	return m_isAborted;
}
void ProgressJob::setIsAborted( bool isAborted )
{
	m_isAborted = isAborted;
}

// void ProgressJob::defaultBegin(const ThreadWeaver::JobPointer& self, ThreadWeaver::Thread *thread)
// {
//     Q_EMIT started(self);
//     ThreadWeaver::Job::defaultBegin(self, thread);
// }
// 
// void ProgressJob::defaultEnd(const ThreadWeaver::JobPointer& self, ThreadWeaver::Thread *thread)
// {
//     ThreadWeaver::Job::defaultEnd(self, thread);
//     if (!self->success()) {
//         Q_EMIT failed(self);
//     }
//     Q_EMIT done(self);
// }

