/***************************************************************************
 *	Copyright (C) 2005 by karye												*
 *	karye@users.sourceforge.net												*
 *																			*
 *	This program is free software; you can redistribute it and/or modify	*
 *	it under the terms of the GNU General Public License as published by	*
 *	the Free Software Foundation; either version 2 of the License, or		*
 *	(at your option) any later version.										*
 *																			*
 *	This program is distributed in the hope that it will be useful,			*
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of			*
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *	GNU General Public License for more details.							*
 *																			*
 *	You should have received a copy of the GNU General Public License		*
 *	along with this program; if not, write to the							*
 *	Free Software Foundation, Inc.,											*
 *	59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.				*
 ***************************************************************************/

#ifndef SCANPORTAGEJOB_H
#define SCANPORTAGEJOB_H

#include <QObject>
#include <ThreadWeaver/Job>
#include <ThreadWeaver/JobPointer>
#include <ThreadWeaver/QObjectDecorator>
#include <ThreadWeaver/Thread>
#include <qglobal.h>                        // for qSwap
#include <qmap.h>                           // for QMap<>::key_iterator, QMap
#include <qstring.h>                        // for QString, operator<
#include <threadweaver/job.h>               // for Job
#include <threadweaver/jobinterface.h>      // for JobPointer
#include <threadweaver/qobjectdecorator.h>  // for QObjectDecorator

#include "common.h"                         // for Info
#include "progressjob.h"

class DbConnection;

namespace ThreadWeaver {
class Thread;
}  // namespace ThreadWeaver

typedef QMap<QString, QString> InstalledMap;

/**
 * @class ScanPortageJob
 * @short Thread for scanning local portage tree.
 */
class ScanPortageJob : public ProgressJob
{
	Q_OBJECT
public:
	ScanPortageJob();
	~ScanPortageJob();

protected:
	void 						run( ThreadWeaver::JobPointer, ThreadWeaver::Thread* ) override;

private:
	void						scanInstalledPackages();
	//void 						completeJob();
	static Info					scanInfo( const QString& path, const QString& category, const QString& name, const QString& version, const QString& revision );
	static QString				formatSize( const QString& size );

	void						loadCache();
	//QString						cacheFind( const QString& package );

private:
	DbConnection* const 		m_db;

	QMap<QString, QString> 		m_mapCache;

	struct Data {
		QString					description;
		QString					homepage;
		QString					status;
		QString					licenses;
		QString					useFlags;
		QString					slot;
		QString					size;
		QString					keywords;
	};
	typedef QMap<QString, Data>	PortageVersions;
	struct Versions {
		QString					status;
		QString					description;
		QString					path;
		PortageVersions			versions;
	};
	typedef QMap<QString, Versions>	PortagePackages;
	struct Categories {
		QString					idCategory;
		QString					idSubCategory;
		PortagePackages			packages;
	};
	typedef QMap<QString, Categories>	PortageCategories;
	PortageCategories				m_categories;
	Q_DISABLE_COPY(ScanPortageJob)
};

#endif
