;;; devanagari.el --- support for Devanagari -*- coding: iso-2022-7bit; -*-

;; Copyright (C) 1996 Free Software Foundation, Inc.
;; Copyright (C) 2005, 2010 Ben Wing.

;; Author: KAWABATA, Taichi <kawabata@is.s.u-tokyo.ac.jp>

;; Keywords: multilingual, Indian, Devanagari

;; This file is part of XEmacs.

;; XEmacs is free software: you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by the
;; Free Software Foundation, either version 3 of the License, or (at your
;; option) any later version.

;; XEmacs is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs.  If not, see <http://www.gnu.org/licenses/>.

;;; Synched up with: Emacs 21.1 (language/devanagari.el).

;;; Commentary:

;; History:
;; 1996.10.18 written by KAWABATA, Taichi <kawabata@is.s.u-tokyo.ac.jp>
;; 1997.1.20 fixed some bugs.

;;; Code:

; (make-coding-system
;  'in-is13194-devanagari 2 ?D
;  "8-bit encoding for ASCII (MSB=0) and IS13194-Devanagari (MSB=1)"
;  '(ascii indian-is13194 nil nil
;    nil ascii-eol)
;  '((safe-charsets ascii indian-is13194)
;    (post-read-conversion . in-is13194-devanagari-post-read-conversion)
;    (pre-write-conversion . in-is13194-devanagari-pre-write-conversion)))

(make-coding-system
 'in-is13194-devanagari 'iso2022
 "Indian IS13194-Devanagari"
 '(charset-g0 ascii
   charset-g1 indian-is13194
   charset-g2 t
   charset-g3 t
   mnemonic "In-13194"
   documentation
   "8-bit encoding for ASCII (MSB=0) and IS13194-Devanagari (MSB=1)"
   post-read-conversion in-is13194-devanagari-post-read-conversion
   pre-write-conversion in-is13194-devanagari-pre-write-conversion))

(define-coding-system-alias 'devanagari 'in-is13194-devanagari)

(set-language-info-alist
 "Devanagari" '((charset indian-is13194 indian-2-column indian-1-column
			 devanagari)
		(coding-system in-is13194-devanagari)
		(coding-priority in-is13194-devanagari)
                ;; Not available in packages. 
		; (input-method . "devanagari-itrans")
		(features devan-util)
		(documentation . "\
Such languages using Devanagari script as Hindi and Marathi
are supported in this language environment."))
 '("Indian"))

;;
;; Devanagari Glyph List
;;
;;      0 1 2 3 4 5 6 7 8 9 a b c d e f
;;2120   $(5!!!"!#!$!%!&!'!(!)!*!+!,!-!.!/(B
;;2130 $(5!0!1!2!3!4!5!6!7!8!9!:!;!<!=!>!?(B
;;2140 $(5!@!A!B!C!D!E!F!G!H!I!J!K!L!M!N!O(B
;;2150 $(5!P!Q!R!S!T!U!V!W!X!Y!Z![!\!]!^!_(B
;;2160 $(5!`!a!b!c!d!e!f!g!h!i!j!k!l!m!n!o(B
;;2170 $(5!p!q!r!s!t!u!v!w!x!y!z!{!|!}!~(B
;;
;;      0 1 2 3 4 5 6 7 8 9 a b c d e f
;;2220   $(5"!"""#"$"%"&"'"(")"*"+","-"."/(B
;;2230 $(5"0"1"2"3"4"5"6"7"8"9":";"<"=">"?(B
;;2240 $(5"@"A"B"C"D"E"F"G"H"I"J"K"L"M"N"O(B
;;2250 $(5"P"Q"R"S"T"U"V"W"X"Y"Z"["\"]"^"_(B
;;2260 $(5"`"a"b"c"d"e"f"g"h"i"j"k"l"m"n"o(B
;;2270 $(5"p"q"r"s"t"u"v"w"x"y"z"{"|"}"~(B
;;
;;      0 1 2 3 4 5 6 7 8 9 a b c d e f
;;2320   $(5#!#"###$#%#&#'#(#)#*#+#,#-#.#/(B
;;2330 $(5#0#1#2#3#4#5#6#7#8#9#:#;#<#=#>#?(B
;;2340 $(5#@#A#B#C#D#E#F#G#H#I#J#K#L#M#N#O(B
;;2350 $(5#P#Q#R#S#T#U#V#W#X#Y#Z#[#\#]#^#_(B
;;2360 $(5#`#a#b#c#d#e#f#g#h#i#j#k#l#m#n#o(B
;;2370 $(5#p#q#r#s#t#u#v#w#x#y#z#{#|#}#~(B
;;
;;      0 1 2 3 4 5 6 7 8 9 a b c d e f
;;2420   $(5$!$"$#$$$%$&$'$($)$*$+$,$-$.$/(B
;;2430 $(5$0$1$2$3$4$5$6$7$8$9$:$;$<$=$>$?(B
;;2440 $(5$@$A$B$C$D$E$F$G$H$I$J$K$L$M$N$O(B
;;2450 $(5$P$Q$R$S$T$U$V$W$X$Y$Z$[$\$]$^$_(B
;;2460 $(5$`$a$b$c$d$e$f$g$h$i$j$k$l$m$n$o(B
;;2470 $(5$p$q$r$s$t$u$v$w$x$y$z${$|$}$~(B
;;
;;     0123456789abcdef
;;2120  $(6!!!"!#!$!%!&!'!(!)!*!+!,!-!.!/(B
;;2130 $(6!0!1!2!3!4!5!6!7!8!9!:!;!<!=!>!?(B
;;2140 $(6!@!A!B!C!D!E!F!G!H!I!J!K!L!M!N!O(B
;;2150 $(6!P!Q!R!S!T!U!V!W!X!Y!Z![!\!]!^!_(B
;;2160 $(6!`!a!b!c!d!e!f!g!h!i!j!k!l!m!n!o(B
;;2170 $(6!p!q!r!s!t!u!v!w!x!y!z!{!|!}!~(B
;;
;;     0123456789abcdef
;;2220  $(6"!"""#"$"%"&"'"(")"*"+","-"."/(B
;;2230 $(6"0"1"2"3"4"5"6"7"8"9":";"<"=">"?(B
;;2240 $(6"@"A"B"C"D"E"F"G"H"I"J"K"L"M"N"O(B
;;2250 $(6"P"Q"R"S"T"U"V"W"X"Y"Z"["\"]"^"_(B
;;2260 $(6"`"a"b"c"d"e"f"g"h"i"j"k"l"m"n"o(B
;;2270 $(6"p"q"r"s"t"u"v"w"x"y"z"{"|"}"~(B
;;2320  $(6#!#"###$#%#&#'#(#)#*#+#,#-#.#/(B
;;2330 $(6#0#1#2#3#4#5#6#7#8#9#:#;#<#=#>#?(B
;;2340 $(6#@#A#B#C#D#E#F#G#H#I#J#K#L#M#N#O(B
;;2350 $(6#P#Q#R#S#T#U#V#W#X#Y#Z#[#\#]#^#_(B
;;2360 $(6#`#a#b#c#d#e#f#g#h#i#j#k#l#m#n#o(B
;;2370 $(6#p#q#r#s#t#u#v#w#x#y#z#{#|#}#~(B
;;
;;     0123456789abcdef
;;2320  $(6$!$"$#$$$%$&$'$($)$*$+$,$-$.$/(B
;;2430 $(6$0$1$2$3$4$5$6$7$8$9$:$;$<$=$>$?(B
;;2440 $(6$@$A$B$C$D$E$F$G$H$I$J$K$L$M$N$O(B
;;2450 $(6$P$Q$R$S$T$U$V$W$X$Y$Z$[$\$]$^$_(B
;;2460 $(6$`$a$b$c$d$e$f$g$h$i$j$k$l$m$n$o(B
;;2470 $(6$p$q$r$s$t$u$v$w$x$y$z${$|$}$~(B
;;
;;
;; Modify the following table if you change the set of 1-column font.
;;
(defconst devanagari-1-column-char 
  (loop for (a . b) in
    '(((#x21 #x21) . (#x21 #x21))	;?$(5!!(B ;?$(6!!(B
      ((#x21 #x22) . (#x21 #x22))	;?$(5!"(B ;?$(6!"(B
      ((#x21 #x23) . (#x21 #x23))	;?$(5!#(B ;?$(6!#(B
      ((#x21 #x24) . nil)		;?$(5!$(B
      ((#x21 #x25) . nil)		;?$(5!%(B
      ((#x21 #x26) . (#x21 #x26))	;?$(5!&(B ;?$(6!&(B
      ((#x21 #x27) . (#x21 #x27))	;?$(5!'(B ;?$(6!'(B
      ((#x21 #x28) . (#x21 #x28))	;?$(5!((B ;?$(6!((B
      ((#x21 #x29) . nil)		;?$(5!)(B
      ((#x21 #x2a) . nil)		;?$(5!*(B
      ((#x21 #x2b) . nil)		;?$(5!+(B
      ((#x21 #x2c) . nil)		;?$(5!,(B
      ((#x21 #x2d) . nil)		;?$(5!-(B
      ((#x21 #x2e) . nil)		;?$(5!.(B
      ((#x21 #x2f) . nil)		;?$(5!/(B
      ((#x21 #x30) . nil)		;?$(5!0(B
      ((#x21 #x31) . nil)		;?$(5!1(B
      ((#x21 #x32) . nil)		;?$(5!2(B
      ((#x21 #x33) . nil)		;?$(5!3(B
      ((#x21 #x34) . nil)		;?$(5!4(B
      ((#x21 #x35) . (#x21 #x35))	;?$(5!5(B ;?$(6!5(B
      ((#x21 #x36) . nil)		;?$(5!6(B
      ((#x21 #x37) . nil)		;?$(5!7(B
      ((#x21 #x38) . nil)		;?$(5!8(B
      ((#x21 #x39) . nil)		;?$(5!9(B
      ((#x21 #x3a) . nil)		;?$(5!:(B
      ((#x21 #x3b) . nil)		;?$(5!;(B
      ((#x21 #x3c) . nil)		;?$(5!<(B
      ((#x21 #x3d) . (#x21 #x3d))	;?$(5!=(B ;?$(6!=(B
      ((#x21 #x3e) . (#x21 #x3e))	;?$(5!>(B ;?$(6!>(B
      ((#x21 #x3f) . (#x21 #x3f))	;?$(5!?(B ;?$(6!?(B
      ((#x21 #x40) . (#x21 #x40))	;?$(5!@(B ;?$(6!@(B
      ((#x21 #x41) . nil)		;?$(5!A(B
      ((#x21 #x42) . (#x21 #x42))	;?$(5!B(B ;?$(6!B(B
      ((#x21 #x43) . (#x21 #x43))	;?$(5!C(B ;?$(6!C(B
      ((#x21 #x44) . (#x21 #x44))	;?$(5!D(B ;?$(6!D(B
      ((#x21 #x45) . (#x21 #x45))	;?$(5!E(B ;?$(6!E(B
      ((#x21 #x46) . (#x21 #x46))	;?$(5!F(B ;?$(6!F(B
      ((#x21 #x47) . (#x21 #x47))	;?$(5!G(B ;?$(6!G(B
      ((#x21 #x48) . (#x21 #x48))	;?$(5!H(B ;?$(6!H(B
      ((#x21 #x49) . nil)		;?$(5!I(B
      ((#x21 #x4a) . (#x21 #x4a))	;?$(5!J(B ;?$(6!J(B
      ((#x21 #x4b) . (#x21 #x4b))	;?$(5!K(B ;?$(6!K(B
      ((#x21 #x4c) . (#x21 #x4c))	;?$(5!L(B ;?$(6!L(B
      ((#x21 #x4d) . (#x21 #x4d))	;?$(5!M(B ;?$(6!M(B
      ((#x21 #x4e) . (#x21 #x4e))	;?$(5!N(B ;?$(6!N(B
      ((#x21 #x4f) . (#x21 #x4f))	;?$(5!O(B ;?$(6!O(B
      ((#x21 #x50) . (#x21 #x50))	;?$(5!P(B ;?$(6!P(B
      ((#x21 #x51) . nil)		;?$(5!Q(B
      ((#x21 #x52) . nil)		;?$(5!R(B
      ((#x21 #x53) . nil)		;?$(5!S(B
      ((#x21 #x54) . (#x21 #x54))	;?$(5!T(B ;?$(6!T(B
      ((#x21 #x55) . nil)		;?$(5!U(B
      ((#x21 #x56) . (#x21 #x56))	;?$(5!V(B ;?$(6!V(B
      ((#x21 #x57) . (#x21 #x57))	;?$(5!W(B ;?$(6!W(B
      ((#x21 #x58) . (#x21 #x58))	;?$(5!X(B ;?$(6!X(B
      ((#x21 #x59) . nil)		;?$(5!Y(B
      ((#x21 #x5a) . (#x21 #x5a))	;?$(5!Z(B ;?$(6!Z(B
      ((#x21 #x5b) . (#x21 #x5b))	;?$(5![(B ;?$(6![(B
      ((#x21 #x5c) . (#x21 #x5c))	;?$(5!\(B ;?$(6!\(B
      ((#x21 #x5d) . (#x21 #x5d))	;?$(5!](B ;?$(6!](B
      ((#x21 #x5e) . (#x21 #x5e))	;?$(5!^(B ;?$(6!^(B
      ((#x21 #x5f) . (#x21 #x5f))	;?$(5!_(B ;?$(6!_(B
      ((#x21 #x60) . (#x21 #x60))	;?$(5!`(B ;?$(6!`(B
      ((#x21 #x61) . (#x21 #x61))	;?$(5!a(B ;?$(6!a(B
      ((#x21 #x62) . (#x21 #x62))	;?$(5!b(B ;?$(6!b(B
      ((#x21 #x63) . (#x21 #x63))	;?$(5!c(B ;?$(6!c(B
      ((#x21 #x64) . (#x21 #x64))	;?$(5!d(B ;?$(6!d(B
      ((#x21 #x65) . (#x21 #x65))	;?$(5!e(B ;?$(6!e(B
      ((#x21 #x66) . (#x21 #x66))	;?$(5!f(B ;?$(6!f(B
      ((#x21 #x67) . (#x21 #x67))	;?$(5!g(B ;?$(6!g(B
      ((#x21 #x68) . (#x21 #x68))	;?$(5!h(B ;?$(6!h(B
      ((#x21 #x69) . (#x21 #x69))	;?$(5!i(B ;?$(6!i(B
      ((#x21 #x6a) . (#x21 #x6a))	;?$(5!j(B ;?$(6!j(B
      (nil . nil)
      (nil . nil)
      (nil . nil)
      (nil . nil)
      (nil . nil)
      (nil . nil)
      ((#x21 #x71) . (#x21 #x71))	;?$(5!q(B ;?$(6!q(B
      ((#x21 #x72) . (#x21 #x72))	;?$(5!r(B ;?$(6!r(B
      ((#x21 #x73) . (#x21 #x73))	;?$(5!s(B ;?$(6!s(B
      ((#x21 #x74) . (#x21 #x74))	;?$(5!t(B ;?$(6!t(B
      ((#x21 #x75) . (#x21 #x75))	;?$(5!u(B ;?$(6!u(B
      ((#x21 #x76) . (#x21 #x76))	;?$(5!v(B ;?$(6!v(B
      ((#x21 #x77) . (#x21 #x77))	;?$(5!w(B ;?$(6!w(B
      ((#x21 #x78) . (#x21 #x78))	;?$(5!x(B ;?$(6!x(B
      ((#x21 #x79) . (#x21 #x79))	;?$(5!y(B ;?$(6!y(B
      ((#x21 #x7a) . (#x21 #x7a))	;?$(5!z(B ;?$(6!z(B
      (nil . nil)
      (nil . nil)
      (nil . nil)
      (nil . nil)
      ((#x22 #x21) . nil)		;?$(5"!(B
      ((#x22 #x22) . nil)		;?$(5""(B
      ((#x22 #x23) . nil)		;?$(5"#(B
      ((#x22 #x24) . (#x22 #x24))	;?$(5"$(B ;?$(6"$(B
      ((#x22 #x25) . (#x22 #x25))	;?$(5"%(B ;?$(6"%(B
      ((#x22 #x26) . (#x22 #x26))	;?$(5"&(B ;?$(6"&(B
      ((#x22 #x27) . nil)		;?$(5"'(B
      ((#x22 #x28) . nil)		;?$(5"((B
      ((#x22 #x29) . nil)		;?$(5")(B
      ((#x22 #x2a) . nil)		;?$(5"*(B
      ((#x22 #x2b) . nil)		;?$(5"+(B
      ((#x22 #x2c) . (#x22 #x2c))	;?$(5",(B ;?$(6",(B
      ((#x22 #x2d) . nil)		;?$(5"-(B
      ((#x22 #x2e) . (#x22 #x2e))	;?$(5".(B ;?$(6".(B
      ((#x22 #x2f) . nil)		;?$(5"/(B
      ((#x22 #x30) . nil)		;?$(5"0(B
      ((#x22 #x31) . nil)		;?$(5"1(B
      ((#x22 #x32) . nil)		;?$(5"2(B
      ((#x22 #x33) . (#x22 #x33))	;?$(5"3(B ;?$(6"3(B
      ((#x22 #x34) . (#x22 #x34))	;?$(5"4(B ;?$(6"4(B
      ((#x22 #x35) . (#x22 #x35))	;?$(5"5(B ;?$(6"5(B
      ((#x22 #x36) . (#x22 #x36))	;?$(5"6(B ;?$(6"6(B
      ((#x22 #x37) . nil)		;?$(5"7(B
      ((#x22 #x38) . (#x22 #x38))	;?$(5"8(B ;?$(6"8(B
      ((#x22 #x39) . nil)		;?$(5"9(B
      ((#x22 #x3a) . (#x22 #x3a))	;?$(5":(B ;?$(6":(B
      ((#x22 #x3b) . (#x22 #x3b))	;?$(5";(B ;?$(6";(B
      ((#x22 #x3c) . (#x22 #x3c))	;?$(5"<(B ;?$(6"<(B
      ((#x22 #x3d) . nil)		;?$(5"=(B
      ((#x22 #x3e) . nil)		;?$(5">(B
      ((#x22 #x3f) . nil)		;?$(5"?(B
      ((#x22 #x40) . nil)		;?$(5"@(B
      ((#x22 #x41) . (#x22 #x41))	;?$(5"A(B ;?$(6"A(B
      ((#x22 #x42) . (#x22 #x42))	;?$(5"B(B ;?$(6"B(B
      ((#x22 #x43) . (#x22 #x43))	;?$(5"C(B ;?$(6"C(B
      ((#x22 #x44) . nil)		;?$(5"D(B
      ((#x22 #x45) . (#x22 #x45))	;?$(5"E(B ;?$(6"E(B
      ((#x22 #x46) . (#x22 #x46))	;?$(5"F(B ;?$(6"F(B
      ((#x22 #x47) . (#x22 #x47))	;?$(5"G(B ;?$(6"G(B
      ((#x22 #x48) . (#x22 #x48))	;?$(5"H(B ;?$(6"H(B
      ((#x22 #x49) . (#x22 #x49))	;?$(5"I(B ;?$(6"I(B
      ((#x22 #x4a) . (#x22 #x4a))	;?$(5"J(B ;?$(6"J(B
      ((#x22 #x4b) . (#x22 #x4b))	;?$(5"K(B ;?$(6"K(B
      ((#x22 #x4c) . (#x22 #x4c))	;?$(5"L(B ;?$(6"L(B
      ((#x22 #x4d) . (#x22 #x4d))	;?$(5"M(B ;?$(6"M(B
      ((#x22 #x4e) . (#x22 #x4e))	;?$(5"N(B ;?$(6"N(B
      ((#x22 #x4f) . nil)		;?$(5"O(B
      ((#x22 #x50) . nil)		;?$(5"P(B
      ((#x22 #x51) . (#x22 #x51))	;?$(5"Q(B ;?$(6"Q(B
      ((#x22 #x52) . nil)		;?$(5"R(B
      ((#x22 #x53) . nil)		;?$(5"S(B
      ((#x22 #x54) . (#x22 #x54))	;?$(5"T(B ;?$(6"T(B
      ((#x22 #x55) . (#x22 #x55))	;?$(5"U(B ;?$(6"U(B
      ((#x22 #x56) . (#x22 #x56))	;?$(5"V(B ;?$(6"V(B
      ((#x22 #x57) . (#x22 #x57))	;?$(5"W(B ;?$(6"W(B
      ((#x22 #x58) . nil)		;?$(5"X(B
      ((#x22 #x59) . nil)		;?$(5"Y(B
      ((#x22 #x5a) . nil)		;?$(5"Z(B
      ((#x22 #x5b) . nil)		;?$(5"[(B
      ((#x22 #x5c) . nil)		;?$(5"\(B
      ((#x22 #x5d) . (#x22 #x5d))	;?$(5"](B ;?$(6"](B
      ((#x22 #x5e) . nil)		;?$(5"^(B
      ((#x22 #x5f) . nil)		;?$(5"_(B
      ((#x22 #x60) . (#x22 #x60))	;?$(5"`(B ;?$(6"`(B
      ((#x22 #x61) . (#x22 #x61))	;?$(5"a(B ;?$(6"a(B
      ((#x22 #x62) . (#x22 #x62))	;?$(5"b(B ;?$(6"b(B
      ((#x22 #x63) . (#x22 #x63))	;?$(5"c(B ;?$(6"c(B
      ((#x22 #x64) . (#x22 #x64))	;?$(5"d(B ;?$(6"d(B
      ((#x22 #x65) . (#x22 #x65))	;?$(5"e(B ;?$(6"e(B
      ((#x22 #x66) . (#x22 #x66))	;?$(5"f(B ;?$(6"f(B
      ((#x22 #x67) . (#x22 #x67))	;?$(5"g(B ;?$(6"g(B
      ((#x22 #x68) . (#x22 #x68))	;?$(5"h(B ;?$(6"h(B
      ((#x22 #x69) . (#x22 #x69))	;?$(5"i(B ;?$(6"i(B
      ((#x22 #x6a) . (#x22 #x6a))	;?$(5"j(B ;?$(6"j(B
      ((#x22 #x6b) . (#x22 #x6b))	;?$(5"k(B ;?$(6"k(B
      ((#x22 #x6c) . (#x22 #x6c))	;?$(5"l(B ;?$(6"l(B
      ((#x22 #x6d) . (#x22 #x6d))	;?$(5"m(B ;?$(6"m(B
      ((#x22 #x6e) . nil)		;?$(5"n(B
      ((#x22 #x6f) . nil)		;?$(5"o(B
      ((#x22 #x70) . (#x22 #x70))	;?$(5"p(B ;?$(6"p(B
      ((#x22 #x71) . (#x22 #x71))	;?$(5"q(B ;?$(6"q(B
      ((#x22 #x72) . (#x22 #x72))	;?$(5"r(B ;?$(6"r(B
      ((#x22 #x73) . (#x22 #x73))	;?$(5"s(B ;?$(6"s(B
      ((#x22 #x74) . (#x22 #x74))	;?$(5"t(B ;?$(6"t(B
      ((#x22 #x75) . (#x22 #x75))	;?$(5"u(B ;?$(6"u(B
      ((#x22 #x76) . nil)		;?$(5"v(B
      ((#x22 #x77) . nil)		;?$(5"w(B
      ((#x22 #x78) . nil)		;?$(5"x(B
      ((#x22 #x79) . (#x22 #x79))	;?$(5"y(B ;?$(6"y(B
      ((#x22 #x7a) . (#x22 #x7a))	;?$(5"z(B ;?$(6"z(B
      ((#x22 #x7b) . nil)		;?$(5"{(B
      ((#x22 #x7c) . nil)		;?$(5"|(B
      ((#x22 #x7d) . nil)		;?$(5"}(B
      ((#x22 #x7e) . nil)		;?$(5"~(B
      ((#x23 #x21) . nil)		;?$(5#!(B
      ((#x23 #x22) . nil)		;?$(5#"(B
      ((#x23 #x23) . nil)		;?$(5##(B
      ((#x23 #x24) . nil)		;?$(5#$(B
      ((#x23 #x25) . nil)		;?$(5#%(B
      ((#x23 #x26) . nil)		;?$(5#&(B
      ((#x23 #x27) . nil)		;?$(5#'(B
      ((#x23 #x28) . nil)		;?$(5#((B
      ((#x23 #x29) . nil)		;?$(5#)(B
      ((#x23 #x2a) . nil)		;?$(5#*(B
      ((#x23 #x2b) . nil)		;?$(5#+(B
      ((#x23 #x2c) . nil)		;?$(5#,(B
      ((#x23 #x2d) . nil)		;?$(5#-(B
      ((#x23 #x2e) . nil)		;?$(5#.(B
      ((#x23 #x2f) . nil)		;?$(5#/(B
      ((#x23 #x30) . nil)		;?$(5#0(B
      ((#x23 #x31) . nil)		;?$(5#1(B
      ((#x23 #x32) . nil)		;?$(5#2(B
      ((#x23 #x33) . nil)		;?$(5#3(B
      ((#x23 #x34) . nil)		;?$(5#4(B
      ((#x23 #x35) . (#x23 #x35))	;?$(5#5(B ;?$(6#5(B
      ((#x23 #x36) . nil)		;?$(5#6(B
      ((#x23 #x37) . nil)		;?$(5#7(B
      ((#x23 #x38) . nil)		;?$(5#8(B
      ((#x23 #x39) . nil)		;?$(5#9(B
      ((#x23 #x3a) . nil)		;?$(5#:(B
      ((#x23 #x3b) . nil)		;?$(5#;(B
      ((#x23 #x3c) . nil)		;?$(5#<(B
      ((#x23 #x3d) . nil)		;?$(5#=(B
      ((#x23 #x3e) . nil)		;?$(5#>(B
      ((#x23 #x3f) . (#x23 #x3f))	;?$(5#?(B ;?$(6#?(B
      ((#x23 #x40) . (#x23 #x40))	;?$(5#@(B ;?$(6#@(B
      ((#x23 #x41) . nil)		;?$(5#A(B
      ((#x23 #x42) . nil)		;?$(5#B(B
      ((#x23 #x43) . nil)		;?$(5#C(B
      ((#x23 #x44) . nil)		;?$(5#D(B
      ((#x23 #x45) . nil)		;?$(5#E(B
      ((#x23 #x46) . nil)		;?$(5#F(B
      ((#x23 #x47) . nil)		;?$(5#G(B
      ((#x23 #x48) . nil)		;?$(5#H(B
      ((#x23 #x49) . nil)		;?$(5#I(B
      ((#x23 #x4a) . (#x23 #x4a))	;?$(5#J(B ;?$(6#J(B
      ((#x23 #x4b) . (#x23 #x4b))	;?$(5#K(B ;?$(6#K(B
      ((#x23 #x4c) . (#x23 #x4c))	;?$(5#L(B ;?$(6#L(B
      ((#x23 #x4d) . (#x23 #x4d))	;?$(5#M(B ;?$(6#M(B
      ((#x23 #x4e) . nil)		;?$(5#N(B
      ((#x23 #x4f) . nil)		;?$(5#O(B
      ((#x23 #x50) . nil)		;?$(5#P(B
      ((#x23 #x51) . nil)		;?$(5#Q(B
      ((#x23 #x52) . (#x23 #x52))	;?$(5#R(B ;?$(6#R(B
      ((#x23 #x53) . nil)		;?$(5#S(B
      ((#x23 #x54) . nil)		;?$(5#T(B
      ((#x23 #x55) . nil)		;?$(5#U(B
      ((#x23 #x56) . nil)		;?$(5#V(B
      ((#x23 #x57) . nil)		;?$(5#W(B
      ((#x23 #x58) . nil)		;?$(5#X(B
      ((#x23 #x59) . nil)		;?$(5#Y(B
      ((#x23 #x5a) . nil)		;?$(5#Z(B
      ((#x23 #x5b) . nil)		;?$(5#[(B
      ((#x23 #x5c) . nil)		;?$(5#\(B
      ((#x23 #x5d) . nil)		;?$(5#](B
      ((#x23 #x5e) . nil)		;?$(5#^(B
      ((#x23 #x5f) . nil)		;?$(5#_(B
      ((#x23 #x60) . nil)		;?$(5#`(B
      ((#x23 #x61) . (#x23 #x61))	;?$(5#a(B ;?$(6#a(B
      ((#x23 #x62) . (#x23 #x62))	;?$(5#b(B ;?$(6#b(B
      ((#x23 #x63) . nil)		;?$(5#c(B
      ((#x23 #x64) . nil)		;?$(5#d(B
      ((#x23 #x65) . nil)		;?$(5#e(B
      ((#x23 #x66) . nil)		;?$(5#f(B
      ((#x23 #x67) . nil)		;?$(5#g(B
      ((#x23 #x68) . nil)		;?$(5#h(B
      ((#x23 #x69) . nil)		;?$(5#i(B
      ((#x23 #x6a) . (#x23 #x6a))	;?$(5#j(B ;?$(6#j(B
      ((#x23 #x6b) . (#x23 #x6b))	;?$(5#k(B ;?$(6#k(B
      ((#x23 #x6c) . (#x23 #x6c))	;?$(5#l(B ;?$(6#l(B
      ((#x23 #x6d) . nil)		;?$(5#m(B
      ((#x23 #x6e) . nil)		;?$(5#n(B
      ((#x23 #x6f) . nil)		;?$(5#o(B
      ((#x23 #x70) . nil)		;?$(5#p(B
      ((#x23 #x71) . nil)		;?$(5#q(B
      ((#x23 #x72) . nil)		;?$(5#r(B
      ((#x23 #x73) . nil)		;?$(5#s(B
      ((#x23 #x74) . nil)		;?$(5#t(B
      ((#x23 #x75) . nil)		;?$(5#u(B
      ((#x23 #x76) . nil)		;?$(5#v(B
      ((#x23 #x77) . nil)		;?$(5#w(B
      ((#x23 #x78) . nil)		;?$(5#x(B
      ((#x23 #x79) . nil)		;?$(5#y(B
      ((#x23 #x7a) . nil)		;?$(5#z(B
      ((#x23 #x7b) . nil)		;?$(5#{(B
      ((#x23 #x7c) . nil)		;?$(5#|(B
      ((#x23 #x7d) . nil)		;?$(5#}(B
      ((#x23 #x7e) . nil)		;?$(5#~(B
      ((#x24 #x21) . nil)		;?$(5$!(B
      ((#x24 #x22) . nil)		;?$(5$"(B
      ((#x24 #x23) . nil)		;?$(5$#(B
      ((#x24 #x24) . nil)		;?$(5$$(B
      ((#x24 #x25) . nil)		;?$(5$%(B
      ((#x24 #x26) . nil)		;?$(5$&(B
      ((#x24 #x27) . nil)		;?$(5$'(B
      ((#x24 #x28) . nil)		;?$(5$((B
      ((#x24 #x29) . nil)		;?$(5$)(B
      ((#x24 #x2a) . nil)		;?$(5$*(B
      ((#x24 #x2b) . nil)		;?$(5$+(B
      ((#x24 #x2c) . nil)		;?$(5$,(B
      ((#x24 #x2d) . nil)		;?$(5$-(B
      ((#x24 #x2e) . nil)		;?$(5$.(B
      ((#x24 #x2f) . nil)		;?$(5$/(B
      ((#x24 #x30) . nil)		;?$(5$0(B
      ((#x24 #x31) . nil)		;?$(5$1(B
      ((#x24 #x32) . nil)		;?$(5$2(B
      ((#x24 #x33) . nil)		;?$(5$3(B
      ((#x24 #x34) . nil)		;?$(5$4(B
      ((#x24 #x35) . nil)		;?$(5$5(B
      ((#x24 #x36) . nil)		;?$(5$6(B
      ((#x24 #x37) . nil)		;?$(5$7(B
      ((#x24 #x38) . nil)		;?$(5$8(B
      ((#x24 #x39) . nil)		;?$(5$9(B
      ((#x24 #x3a) . nil)		;?$(5$:(B
      ((#x24 #x3b) . nil)		;?$(5$;(B
      ((#x24 #x3c) . nil)		;?$(5$<(B
      ((#x24 #x3d) . nil)		;?$(5$=(B
      ((#x24 #x3e) . nil)		;?$(5$>(B
      ((#x24 #x3f) . nil)		;?$(5$?(B
      ((#x24 #x40) . nil)		;?$(5$@(B
      ((#x24 #x41) . (#x24 #x41))	;?$(5$A(B ;?$(6$A(B
      ((#x24 #x42) . nil)		;?$(5$B(B
      ((#x24 #x43) . nil)		;?$(5$C(B
      ((#x24 #x44) . nil)		;?$(5$D(B
      ((#x24 #x45) . (#x24 #x45))	;?$(5$E(B ;?$(6$E(B
      ((#x24 #x46) . nil)		;?$(5$F(B
      ((#x24 #x47) . nil)		;?$(5$G(B
      ((#x24 #x48) . (#x24 #x48))	;?$(5$H(B ;?$(6$H(B
      ((#x24 #x49) . (#x24 #x49))	;?$(5$I(B ;?$(6$I(B
      ((#x24 #x4a) . (#x24 #x4a))	;?$(5$J(B ;?$(6$J(B
      ((#x24 #x4b) . nil)		;?$(5$K(B
      ((#x24 #x4c) . nil)		;?$(5$L(B
      ((#x24 #x4d) . nil)		;?$(5$M(B
      ((#x24 #x4e) . (#x24 #x4e))	;?$(5$N(B ;?$(6$N(B
      ((#x24 #x4f) . nil)		;?$(5$O(B
      ((#x24 #x50) . (#x24 #x50))	;?$(5$P(B ;?$(6$P(B
      ((#x24 #x51) . (#x24 #x51))	;?$(5$Q(B ;?$(6$Q(B
      ((#x24 #x52) . (#x24 #x52))	;?$(5$R(B ;?$(6$R(B
      ((#x24 #x53) . nil)		;?$(5$S(B
      ((#x24 #x54) . nil)		;?$(5$T(B
      ((#x24 #x55) . nil)		;?$(5$U(B
      ((#x24 #x56) . nil)		;?$(5$V(B
      ((#x24 #x57) . nil)		;?$(5$W(B
      ((#x24 #x58) . nil)		;?$(5$X(B
      ((#x24 #x59) . nil)		;?$(5$Y(B
      ((#x24 #x5a) . nil)		;?$(5$Z(B
      ((#x24 #x5b) . nil)		;?$(5$[(B
      ((#x24 #x5c) . nil)		;?$(5$\(B
      ((#x24 #x5d) . nil)		;?$(5$](B
      ((#x24 #x5e) . nil)		;?$(5$^(B
      ((#x24 #x5f) . nil)		;?$(5$_(B
      ((#x24 #x60) . nil)		;?$(5$`(B
      ((#x24 #x61) . nil)		;?$(5$a(B
      ((#x24 #x62) . nil)		;?$(5$b(B
      ((#x24 #x63) . nil)		;?$(5$c(B
      ((#x24 #x64) . nil)		;?$(5$d(B
      ((#x24 #x65) . nil)		;?$(5$e(B
      ((#x24 #x66) . nil)		;?$(5$f(B
      ((#x24 #x67) . nil)		;?$(5$g(B
      ((#x24 #x68) . (#x24 #x68))	;?$(5$h(B ;?$(6$h(B
      ((#x24 #x69) . (#x24 #x69))	;?$(5$i(B ;?$(6$i(B
      ((#x24 #x6a) . (#x24 #x6a))	;?$(5$j(B ;?$(6$j(B
      ((#x24 #x6b) . nil)		;?$(5$k(B
      ((#x24 #x6c) . (#x24 #x6c))	;?$(5$l(B ;?$(6$l(B
      ((#x24 #x6d) . (#x24 #x6d))	;?$(5$m(B ;?$(6$m(B
      ((#x24 #x6e) . (#x24 #x6e))	;?$(5$n(B ;?$(6$n(B
      ((#x24 #x6f) . nil)		;?$(5$o(B
      ((#x24 #x70) . (#x24 #x70))	;?$(5$p(B ;?$(6$p(B
      ((#x24 #x71) . (#x24 #x71))	;?$(5$q(B ;?$(6$q(B
      ((#x24 #x72) . (#x24 #x72))	;?$(5$r(B ;?$(6$r(B
      ((#x24 #x73) . nil)		;?$(5$s(B
      ((#x24 #x74) . nil)		;?$(5$t(B
      ((#x24 #x75) . (#x24 #x75))	;?$(5$u(B ;?$(6$u(B
      ((#x24 #x76) . (#x24 #x76))	;?$(5$v(B ;?$(6$v(B
      ((#x24 #x77) . nil)		;?$(5$w(B
      ((#x24 #x78) . (#x24 #x78))	;?$(5$x(B ;?$(6$x(B
      ((#x24 #x79) . (#x24 #x79))	;?$(5$y(B ;?$(6$y(B
      ((#x24 #x7a) . nil)		;?$(5$z(B
      ((#x24 #x7b) . nil)		;?$(5${(B
      ((#x24 #x7c) . nil)		;?$(5$|(B
      ((#x24 #x7d) . nil)		;?$(5$}(B
      ((#x24 #x7e) . nil)		;?$(5$~(B
      )
    collect (cons (and a (apply #'make-char 'indian-2-column a))
		  (and b (apply #'make-char 'indian-1-column b)))
    ))

(provide 'devanagari)

;;; devanagari.el ends here
