/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.mortbay.util.Frame;
import org.mortbay.util.LogSink;
import org.mortbay.util.StringMap;

public class LoggerLogSink
implements LogSink {
    private static StringMap __tagMap = new StringMap();
    private String _name = "org.mortbay";
    private Logger _logger;
    private boolean _ownLogger;
    private boolean _started;

    public LoggerLogSink() {
    }

    public LoggerLogSink(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void setLogger(Logger logger) {
        this._ownLogger = false;
        this._logger = logger;
    }

    public void start() throws Exception {
        if (this._logger == null) {
            this._logger = Logger.getLogger(this._name);
            this._ownLogger = true;
        }
        this._started = true;
    }

    public void stop() throws InterruptedException {
        this._started = false;
        if (this._ownLogger) {
            this._logger = null;
            this._ownLogger = false;
        }
    }

    public boolean isStarted() {
        return this._started;
    }

    public void setOptions(String options) {
    }

    public String getOptions() {
        return null;
    }

    public void log(String tag, Object msg, Frame frame, long time) {
        Level level = (Level)__tagMap.get(tag);
        LogRecord lr = new LogRecord(level, msg.toString());
        lr.setMillis(time);
        if (frame != null) {
            StackTraceElement ste = frame.getStackTraceElement();
            lr.setSourceMethodName(ste.getMethodName());
            lr.setSourceClassName(ste.getClassName());
        }
        this._logger.log(lr);
    }

    public void log(String formattedLog) {
        this._logger.log(Level.INFO, formattedLog);
    }

    static {
        __tagMap.put("DEBUG  ", (Object)Level.FINE);
        __tagMap.put("EVENT  ", (Object)Level.INFO);
        __tagMap.put("WARN!! ", (Object)Level.WARNING);
        __tagMap.put("ASSERT ", (Object)Level.WARNING);
        __tagMap.put("FAIL!! ", (Object)Level.SEVERE);
    }
}

