// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

package environments

// PublishedApis is a map containing Application IDs for well known APIs published by Microsoft.
// They can be used to acquire access tokens, but are primarily described here for easy inclusion in
// application manifests and service principal assignments.
var PublishedApis = map[string]string{
	"ApiManagement":                     apiManagementAppId,
	"ApplicationInsights":               applicationInsightsAppId,
	"AttestationService":                attestationServiceAppId,
	"AzureAdIdentityGovernanceInsights": azureAdIdentityGovernanceInsightsAppId,
	"AzureAdIntegratedApp":              azureAdIntegratedAppAppId,
	"AzureAdNotification":               azureAdNotificationAppId,
	"AzureAnalysisServices":             analysisServicesAppId,
	"AzureAppConfiguration":             appConfigurationAppId,
	"AzureAppService":                   appServiceAppId,
	"AzureBatch":                        batchAppId,
	"AzureContainerRegistry":            containerRegistryAppId,
	"AzureCosmosDb":                     cosmosDBAppId,
	"AzureDataBricks":                   dataBricksAppId,
	"AzureDataCatalog":                  dataCatalogAppId,
	"AzureDataLake":                     dataLakeAppId,
	"AzureDevOps":                       azureDevOpsAppId,
	"AzureDigitalTwins":                 digitalTwinsAppId,
	"AzureEventHubs":                    eventHubsAppId,
	"AzureHdInsightCluster":             hdinsightClusterAppId,
	"AzureHealthcare":                   healthCareAppId,
	"AzureIamSupportability":            iamSupportabilityAppId,
	"AzureImportExport":                 importExportAppId,
	"AzureIotCentral":                   iotCentralAppId,
	"AzureIotHubDeviceProvisioning":     iotHubDeviceProvisioningAppId,
	"AzureKeyVault":                     keyVaultAppId,
	"AzureKubernetesServiceAadServer":   kubernetesServiceAadServerAppId,
	"AzureLinuxVirtualMachineSignIn":    azureLinuxVmSignInAppId,
	"AzureMaps":                         mapsAppId,
	"AzureMediaServices":                mediaServicesAppId,
	"AzurePortal":                       portalAppId,
	"AzureResourceManager":              azureServiceManagementAppId,
	"AzureSecurityInsights":             securityInsightsAppId,
	"AzureServiceBus":                   serviceBusAppId,
	"AzureServiceDeploy":                serviceDeployAppId,
	"AzureSqlDatabase":                  sqlDatabaseAppId,
	"AzureStackHciService":              stackHciServiceAppId,
	"AzureStorage":                      storageAppId,
	"AzureStreamAnalytics":              streamAnalyticsAppId,
	"AzureSynapseGateway":               synapseGatewayAppId,
	"AzureSynapseStudio":                synapseStudioAppId,
	"AzureTimeSeriesInsights":           timeSeriesInsightsAppId,
	"AzureVPN":                          azureVPNAppId,
	"AzureWindowsVirtualMachineSignIn":  azureWindowsVmSignInAppId,
	"Bing":                              bingAppId,
	"BotFrameworkDevPortal":             botFrameworkDevPortalAppId,
	"BranchConnectWebService":           branchConnectWebServiceAppId,
	"CognitiveServices":                 cognitiveServicesAppId,
	"ComputeRecommendationService":      computeRecommendationServiceAppId,
	"ConnectionsService":                connectionsServiceAppId,
	"CortanaAtWorkBingServices":         cortanaAtWorkBingServicesAppId,
	"CortanaAtWorkService":              cortanaAtWorkServiceAppId,
	"CortanaRuntimeService":             cortanaRuntimeServiceAppId,
	"CustomerInsights":                  customerInsightsAppId,
	"DataMigrationService":              dataMigrationsServiceAppId,
	"DomainControllerServices":          domainControllerServiceAppId,
	"Dynamic365BusinessCentral":         dynamic365BusinessCentralAppId,
	"Dynamics365DataExportService":      dynamics365DataExportServiceAppId,
	"DynamicsCrm":                       dynamicsCRMAppId,
	"DynamicsErp":                       dynamicsERPAppId,
	"FlowService":                       flowServiceAppId,
	"GraphConnectorService":             graphConnectorServiceAppId,
	"InformationProtectionSyncService":  informationProtectionSyncServiceAppId,
	"InTune":                            inTuneAppId,
	"KustoService":                      kustoServiceAppId,
	"KustoServiceMFA":                   kustoServiceMFAAppId,
	"LogAnalytics":                      logAnalyticsAppId,
	"ManagedHSM":                        managedHSMAppId,
	"MileIqAdminCenter":                 mileIqAdminCenterAppId,
	"MileIqDashboard":                   mileIqDashboardAppId,
	"MileIqRestService":                 mileIqRestServiceAppId,
	"MixedReality":                      mixedRealityAppId,
	"Microsoft365DataAtRestEncryption":  microsoft365DataAtRestEncryptionAppId,
	"MicrosoftAppAccessPanel":           microsoftAppAccessPanelAppId,
	"MicrosoftAzureCli":                 microsoftAzureCliAppId,
	"MicrosoftGraph":                    microsoftGraphAppId,
	"MicrosoftIntune":                   microsoftIntuneAppId,
	"MicrosoftIntuneEnrollment":         microsoftIntuneEnrollmentAppId,
	"MicrosoftInvoicing":                microsoftInvoicingAppId,
	"MicrosoftOffice":                   microsoftOfficeAppId,
	"MicrosoftStorageSync":              microsoftStorageSyncAppId,
	"MicrosoftTeams":                    microsoftTeamsAppId,
	"MicrosoftTeamsWebClient":           microsoftTeamsWebClientAppId,
	"Office365Connectors":               office365ConnectorsAppId,
	"Office365Demeter":                  office365DemeterAppId,
	"Office365DwEngineV2":               office365DwEngineV2AppId,
	"Office365ExchangeOnline":           office365ExchangeOnlineAppId,
	"Office365ExchangeOnlineProtection": office365ExchangeOnlineProtectionAppId,
	"Office365InformationProtection":    office365InformationProtectionAppId,
	"Office365Management":               office365ManagementAppId,
	"Office365Portal":                   office365PortalAppId,
	"Office365SharePointOnline":         office365SharePointOnlineAppId,
	"Office365SuiteUx":                  office365SuiteUxAppId,
	"Office365Zoom":                     office365ZoomAppId,
	"OfficeHome":                        officeHomeAppId,
	"OfficeUwpPwa":                      officeUwpPwaAppId,
	"OneNote":                           oneNoteAppId,
	"OneProfileService":                 oneProfileServiceAppId,
	"OssRdbms":                          ossRDBMSAppId,
	"OssRdbmsPostgreSqlFlexibleServerAadAuthentication": ossRdbmsPostgreSqlFlexibleServerAadAuthenticationAppId,
	"PeopleCardsService":          peopleCardsServiceAppId,
	"PolicyAdministrationService": policyAdministrationServiceAppId,
	"PowerAppsRuntimeService":     powerAppsRuntimeServiceAppId,
	"PowerBiService":              powerBiServiceAppId,
	"Purview":                     purviewAppId,
	"RightsManagementServices":    rightsManagementServiceAppId,
	"ServiceTrust":                serviceTrustAppId,
	"Signup":                      signupAppId,
	"SkypeForBusinessOnline":      skypeForBusinessOnlineAppId,
	"SpeechRecognition":           speechRecognitionAppId,
	"Synapse":                     synapseAppId,
	"TargetedMessagingService":    targetedMessagingServiceAppId,
	"TeamsServices":               teamsServiceAppId,
	"ThreatProtection":            threatProtectionAppId,
	"TrafficManager":              trafficManagerAppId,
	"UniversalPrint":              universalPrintAppId,
	"WindowsDefenderAtp":          windowsDefenderAtpAppId,
	"WindowsVirtualDesktop":       windowsVirtualDesktopAppId,
	"Yammer":                      yammerAppId,

	// Deprecated, remove these when APIs reach final EOL
	"AzureActiveDirectoryGraph": "00000002-0000-0000-c000-000000000000",
	"AzureServiceManagement":    "797f4846-ba00-4fd7-ba43-dac1f8f63013",
}
