# frozen_string_literal: true

require 'open3'
require 'json'
require 'yaml'
require 'hocon'
require 'hocon/config_value_factory'
require 'singleton'
require 'logger'

require_relative '../../framework/core/options/config_file_options'
require_relative '../../framework/core/options/option_store'
require_relative '../../framework/core/options/options_validator'

require_relative '../../../facter/framework/core/options'
require_relative '../../../facter/framework/logging/logger_helper'
require_relative '../../../facter/framework/logging/logger'

require_relative '../../../facter/util/file_helper'

require_relative '../../../facter/resolvers/base_resolver'
require_relative '../../../facter/framework/detector/os_hierarchy'
require_relative '../../../facter/framework/detector/os_detector'

require_relative '../../../facter/framework/config/config_reader'
require_relative '../../../facter/framework/config/fact_groups'

require_relative '../../util/api_debugger'
require_relative '../../util/file_helper'
require_relative '../../util/utils'

require_relative '../../util/resolvers/aws_token'
require_relative '../../util/resolvers/filesystem_helper'
require_relative '../../util/resolvers/fingerprint'
require_relative '../../util/resolvers/http'
require_relative '../../util/resolvers/ssh'
require_relative '../../util/resolvers/ssh_helper'
require_relative '../../util/resolvers/uptime_helper'

require_relative '../../util/facts/facts_utils'
require_relative '../../util/facts/unit_converter'
require_relative '../../util/facts/uptime_parser'
require_relative '../../util/facts/windows_release_finder'

require_relative '../../util/facts/posix/virtual_detector'

require_relative '../../util/resolvers/networking/dhcp'
require_relative '../../util/resolvers/networking/networking'
require_relative '../../util/resolvers/networking/primary_interface'

require_relative '../../resolvers/aio_agent_version'
require_relative '../../resolvers/augeas'
require_relative '../../resolvers/az'
require_relative '../../resolvers/base_resolver'
require_relative '../../resolvers/containers'
require_relative '../../resolvers/debian_version'
require_relative '../../resolvers/disks'
require_relative '../../resolvers/dmi'
require_relative '../../resolvers/dmi_decode'
require_relative '../../resolvers/ec2'
require_relative '../../resolvers/eos_release'
require_relative '../../resolvers/facterversion'
require_relative '../../resolvers/filesystems'
require_relative '../../resolvers/fips_enabled'
require_relative '../../resolvers/gce'
require_relative '../../resolvers/hostname'
require_relative '../../resolvers/identity'
require_relative '../../resolvers/load_averages'
require_relative '../../resolvers/lpar'
require_relative '../../resolvers/lsb_release'
require_relative '../../resolvers/lspci'
require_relative '../../resolvers/memory'
require_relative '../../resolvers/mountpoints'
require_relative '../../resolvers/networking'
require_relative '../../resolvers/open_vz'
require_relative '../../resolvers/os_release'
require_relative '../../resolvers/partitions'
require_relative '../../resolvers/path'
require_relative '../../resolvers/processors'
require_relative '../../resolvers/processors_lscpu'
require_relative '../../resolvers/redhat_release'
require_relative '../../resolvers/release_from_first_line'
require_relative '../../resolvers/ruby'
require_relative '../../resolvers/selinux'
require_relative '../../resolvers/specific_release_file'
require_relative '../../resolvers/ssh'
require_relative '../../resolvers/suse_release'
require_relative '../../resolvers/sw_vers'
require_relative '../../resolvers/timezone'
require_relative '../../resolvers/uname'
require_relative '../../resolvers/uptime'
require_relative '../../resolvers/virt_what'
require_relative '../../resolvers/vmware'
require_relative '../../resolvers/wpar'
require_relative '../../resolvers/xen'
require_relative '../../resolvers/zfs'
require_relative '../../resolvers/zpool'

require_relative '../../framework/core/cache_manager'
require_relative '../../framework/core/fact_filter'
require_relative '../../framework/core/fact_manager'
require_relative '../../framework/core/options'
require_relative '../../framework/core/session_cache'

require_relative '../../models/fact_collection'
require_relative '../../models/loaded_fact'
require_relative '../../models/resolved_fact'
require_relative '../../models/searched_fact'

require_relative '../../framework/benchmarking/timer'

require_relative '../../framework/core/fact_loaders/class_discoverer'
require_relative '../../framework/core/fact_loaders/external_fact_loader'
require_relative '../../framework/core/fact_loaders/fact_loader'
require_relative '../../framework/core/fact_loaders/internal_fact_loader'

require_relative '../../framework/core/fact/internal/core_fact'
require_relative '../../framework/core/fact/internal/internal_fact_manager'

require_relative '../../framework/core/fact/external/external_fact_manager'

require_relative '../../framework/formatters/formatter_factory'
require_relative '../../framework/formatters/formatter_helper'
require_relative '../../framework/formatters/hocon_fact_formatter'
require_relative '../../framework/formatters/json_fact_formatter'
require_relative '../../framework/formatters/legacy_fact_formatter'
require_relative '../../framework/formatters/yaml_fact_formatter'

os_hierarchy = OsDetector.instance.hierarchy
os_hierarchy.each do |os|
  case os.downcase
  when 'aix'
    require_relative '../../util/aix/info_extractor.rb'
    require_relative '../../util/aix/odm_query.rb'

    require_relative '../../facts/aix/aio_agent_version.rb'
    require_relative '../../facts/aix/augeas/version.rb'
    require_relative '../../facts/aix/disks.rb'
    require_relative '../../facts/aix/facterversion.rb'
    require_relative '../../facts/aix/filesystems.rb'
    require_relative '../../facts/aix/hypervisors/lpar.rb'
    require_relative '../../facts/aix/hypervisors/wpar.rb'
    require_relative '../../facts/aix/identity/gid.rb'
    require_relative '../../facts/aix/identity/group.rb'
    require_relative '../../facts/aix/identity/privileged.rb'
    require_relative '../../facts/aix/identity/uid.rb'
    require_relative '../../facts/aix/identity/user.rb'
    require_relative '../../facts/aix/interfaces.rb'
    require_relative '../../facts/aix/ipaddress6_interfaces.rb'
    require_relative '../../facts/aix/ipaddress_interfaces.rb'
    require_relative '../../facts/aix/kernel.rb'
    require_relative '../../facts/aix/kernelmajversion.rb'
    require_relative '../../facts/aix/kernelrelease.rb'
    require_relative '../../facts/aix/kernelversion.rb'
    require_relative '../../facts/aix/load_averages.rb'
    require_relative '../../facts/aix/macaddress_interfaces.rb'
    require_relative '../../facts/aix/memory/swap/available.rb'
    require_relative '../../facts/aix/memory/swap/available_bytes.rb'
    require_relative '../../facts/aix/memory/swap/capacity.rb'
    require_relative '../../facts/aix/memory/swap/total.rb'
    require_relative '../../facts/aix/memory/swap/total_bytes.rb'
    require_relative '../../facts/aix/memory/swap/used.rb'
    require_relative '../../facts/aix/memory/swap/used_bytes.rb'
    require_relative '../../facts/aix/memory/system/available.rb'
    require_relative '../../facts/aix/memory/system/available_bytes.rb'
    require_relative '../../facts/aix/memory/system/capacity.rb'
    require_relative '../../facts/aix/memory/system/total.rb'
    require_relative '../../facts/aix/memory/system/total_bytes.rb'
    require_relative '../../facts/aix/memory/system/used.rb'
    require_relative '../../facts/aix/memory/system/used_bytes.rb'
    require_relative '../../facts/aix/mountpoints.rb'
    require_relative '../../facts/aix/mtu_interfaces.rb'
    require_relative '../../facts/aix/netmask6_interfaces.rb'
    require_relative '../../facts/aix/netmask_interfaces.rb'
    require_relative '../../facts/aix/network6_interfaces.rb'
    require_relative '../../facts/aix/network_interfaces.rb'
    require_relative '../../facts/aix/networking/domain.rb'
    require_relative '../../facts/aix/networking/fqdn.rb'
    require_relative '../../facts/aix/networking/hostname.rb'
    require_relative '../../facts/aix/networking/interfaces.rb'
    require_relative '../../facts/aix/networking/ip.rb'
    require_relative '../../facts/aix/networking/ip6.rb'
    require_relative '../../facts/aix/networking/mac.rb'
    require_relative '../../facts/aix/networking/mtu.rb'
    require_relative '../../facts/aix/networking/netmask.rb'
    require_relative '../../facts/aix/networking/netmask6.rb'
    require_relative '../../facts/aix/networking/network.rb'
    require_relative '../../facts/aix/networking/network6.rb'
    require_relative '../../facts/aix/networking/primary.rb'
    require_relative '../../facts/aix/networking/scope6.rb'
    require_relative '../../facts/aix/nim_type.rb'
    require_relative '../../facts/aix/os/architecture.rb'
    require_relative '../../facts/aix/os/family.rb'
    require_relative '../../facts/aix/os/hardware.rb'
    require_relative '../../facts/aix/os/name.rb'
    require_relative '../../facts/aix/os/release.rb'
    require_relative '../../facts/aix/partitions.rb'
    require_relative '../../facts/aix/path.rb'
    require_relative '../../facts/aix/processor.rb'
    require_relative '../../facts/aix/processors/cores.rb'
    require_relative '../../facts/aix/processors/count.rb'
    require_relative '../../facts/aix/processors/isa.rb'
    require_relative '../../facts/aix/processors/models.rb'
    require_relative '../../facts/aix/processors/speed.rb'
    require_relative '../../facts/aix/processors/threads.rb'
    require_relative '../../facts/aix/ruby/platform.rb'
    require_relative '../../facts/aix/ruby/sitedir.rb'
    require_relative '../../facts/aix/ruby/version.rb'
    require_relative '../../facts/aix/scope6_interfaces.rb'
    require_relative '../../facts/aix/serialnumber.rb'
    require_relative '../../facts/aix/ssh.rb'
    require_relative '../../facts/aix/sshalgorithmkey.rb'
    require_relative '../../facts/aix/sshfp_algorithm.rb'
    require_relative '../../facts/aix/system_uptime/days.rb'
    require_relative '../../facts/aix/system_uptime/hours.rb'
    require_relative '../../facts/aix/system_uptime/seconds.rb'
    require_relative '../../facts/aix/system_uptime/uptime.rb'
    require_relative '../../facts/aix/timezone.rb'

    require_relative '../../resolvers/aix/architecture.rb'
    require_relative '../../resolvers/aix/disks.rb'
    require_relative '../../resolvers/aix/filesystem.rb'
    require_relative '../../resolvers/aix/hardware.rb'
    require_relative '../../resolvers/aix/load_averages.rb'
    require_relative '../../resolvers/aix/memory.rb'
    require_relative '../../resolvers/aix/mountpoints.rb'
    require_relative '../../resolvers/aix/networking.rb'
    require_relative '../../resolvers/aix/nim.rb'
    require_relative '../../resolvers/aix/os_level.rb'
    require_relative '../../resolvers/aix/partitions.rb'
    require_relative '../../resolvers/aix/processors.rb'
    require_relative '../../resolvers/aix/serialnumber.rb'

  when 'alpine'
    require_relative '../../facts/alpine/os/release.rb'

  when 'amzn'
    require_relative '../../facts/amzn/lsbdistcodename.rb'
    require_relative '../../facts/amzn/lsbdistdescription.rb'
    require_relative '../../facts/amzn/lsbdistid.rb'
    require_relative '../../facts/amzn/os/distro/codename.rb'
    require_relative '../../facts/amzn/os/distro/description.rb'
    require_relative '../../facts/amzn/os/distro/id.rb'
    require_relative '../../facts/amzn/os/distro/release.rb'
    require_relative '../../facts/amzn/os/release.rb'

    require_relative '../../resolvers/amzn/os_release_rpm'

  when 'bsd'
    require_relative '../../facts/bsd/kernelmajversion.rb'
    require_relative '../../facts/bsd/kernelversion.rb'
    require_relative '../../facts/bsd/load_averages.rb'
    require_relative '../../facts/bsd/os/family.rb'
    require_relative '../../facts/bsd/processors/count.rb'
    require_relative '../../facts/bsd/processors/models.rb'
    require_relative '../../facts/bsd/processors/speed.rb'

    require_relative '../../resolvers/bsd/processors.rb'

  when 'debian'
    require_relative '../../facts/debian/architecture.rb'
    require_relative '../../facts/debian/lsbdistcodename.rb'
    require_relative '../../facts/debian/lsbdistdescription.rb'
    require_relative '../../facts/debian/lsbdistid.rb'
    require_relative '../../facts/debian/os/distro/codename.rb'
    require_relative '../../facts/debian/os/distro/description.rb'
    require_relative '../../facts/debian/os/distro/id.rb'
    require_relative '../../facts/debian/os/distro/release.rb'
    require_relative '../../facts/debian/os/release.rb'

  when 'devuan'
    require_relative '../../facts/devuan/os/distro/release.rb'
    require_relative '../../facts/devuan/os/release.rb'

  when 'freebsd'
    require_relative '../../facts/freebsd/augeas/version.rb'
    require_relative '../../facts/freebsd/disks.rb'
    require_relative '../../facts/freebsd/dmi/bios/release_date.rb'
    require_relative '../../facts/freebsd/dmi/bios/vendor.rb'
    require_relative '../../facts/freebsd/dmi/bios/version.rb'
    require_relative '../../facts/freebsd/dmi/manufacturer.rb'
    require_relative '../../facts/freebsd/dmi/product/name.rb'
    require_relative '../../facts/freebsd/dmi/product/serial_number.rb'
    require_relative '../../facts/freebsd/dmi/product/uuid.rb'
    require_relative '../../facts/freebsd/ec2_metadata.rb'
    require_relative '../../facts/freebsd/ec2_userdata.rb'
    require_relative '../../facts/freebsd/facterversion.rb'
    require_relative '../../facts/freebsd/identity/gid.rb'
    require_relative '../../facts/freebsd/identity/group.rb'
    require_relative '../../facts/freebsd/identity/privileged.rb'
    require_relative '../../facts/freebsd/identity/uid.rb'
    require_relative '../../facts/freebsd/identity/user.rb'
    require_relative '../../facts/freebsd/ipaddress6_interfaces.rb'
    require_relative '../../facts/freebsd/ipaddress_interfaces.rb'
    require_relative '../../facts/freebsd/is_virtual.rb'
    require_relative '../../facts/freebsd/kernel.rb'
    require_relative '../../facts/freebsd/kernelrelease.rb'
    require_relative '../../facts/freebsd/memory/swap/available.rb'
    require_relative '../../facts/freebsd/memory/swap/available_bytes.rb'
    require_relative '../../facts/freebsd/memory/swap/capacity.rb'
    require_relative '../../facts/freebsd/memory/swap/encrypted.rb'
    require_relative '../../facts/freebsd/memory/swap/total.rb'
    require_relative '../../facts/freebsd/memory/swap/total_bytes.rb'
    require_relative '../../facts/freebsd/memory/swap/used.rb'
    require_relative '../../facts/freebsd/memory/swap/used_bytes.rb'
    require_relative '../../facts/freebsd/memory/system/available.rb'
    require_relative '../../facts/freebsd/memory/system/available_bytes.rb'
    require_relative '../../facts/freebsd/memory/system/capacity.rb'
    require_relative '../../facts/freebsd/memory/system/total.rb'
    require_relative '../../facts/freebsd/memory/system/total_bytes.rb'
    require_relative '../../facts/freebsd/memory/system/used.rb'
    require_relative '../../facts/freebsd/memory/system/used_bytes.rb'
    require_relative '../../facts/freebsd/mountpoints.rb'
    require_relative '../../facts/freebsd/netmask6_interfaces.rb'
    require_relative '../../facts/freebsd/netmask_interfaces.rb'
    require_relative '../../facts/freebsd/network6_interfaces.rb'
    require_relative '../../facts/freebsd/network_interfaces.rb'
    require_relative '../../facts/freebsd/networking/dhcp.rb'
    require_relative '../../facts/freebsd/networking/domain.rb'
    require_relative '../../facts/freebsd/networking/fqdn.rb'
    require_relative '../../facts/freebsd/networking/hostname.rb'
    require_relative '../../facts/freebsd/networking/interfaces.rb'
    require_relative '../../facts/freebsd/networking/ip.rb'
    require_relative '../../facts/freebsd/networking/ip6.rb'
    require_relative '../../facts/freebsd/networking/mac.rb'
    require_relative '../../facts/freebsd/networking/mtu.rb'
    require_relative '../../facts/freebsd/networking/netmask.rb'
    require_relative '../../facts/freebsd/networking/netmask6.rb'
    require_relative '../../facts/freebsd/networking/network.rb'
    require_relative '../../facts/freebsd/networking/network6.rb'
    require_relative '../../facts/freebsd/networking/primary.rb'
    require_relative '../../facts/freebsd/networking/scope6.rb'
    require_relative '../../facts/freebsd/os/architecture.rb'
    require_relative '../../facts/freebsd/os/hardware.rb'
    require_relative '../../facts/freebsd/os/name.rb'
    require_relative '../../facts/freebsd/os/release.rb'
    require_relative '../../facts/freebsd/partitions.rb'
    require_relative '../../facts/freebsd/path.rb'
    require_relative '../../facts/freebsd/processors/count.rb'
    require_relative '../../facts/freebsd/processors/isa.rb'
    require_relative '../../facts/freebsd/processors/models.rb'
    require_relative '../../facts/freebsd/processors/speed.rb'
    require_relative '../../facts/freebsd/ruby/platform.rb'
    require_relative '../../facts/freebsd/ruby/sitedir.rb'
    require_relative '../../facts/freebsd/ruby/version.rb'
    require_relative '../../facts/freebsd/ssh.rb'
    require_relative '../../facts/freebsd/sshalgorithmkey.rb'
    require_relative '../../facts/freebsd/sshfp_algorithm.rb'
    require_relative '../../facts/freebsd/system_uptime/days.rb'
    require_relative '../../facts/freebsd/system_uptime/hours.rb'
    require_relative '../../facts/freebsd/system_uptime/seconds.rb'
    require_relative '../../facts/freebsd/system_uptime/uptime.rb'
    require_relative '../../facts/freebsd/timezone.rb'
    require_relative '../../facts/freebsd/virtual.rb'
    require_relative '../../facts/freebsd/zfs_featurenumbers.rb'
    require_relative '../../facts/freebsd/zfs_version.rb'
    require_relative '../../facts/freebsd/zpool_featureflags.rb'
    require_relative '../../facts/freebsd/zpool_featurenumbers.rb'
    require_relative '../../facts/freebsd/zpool_version.rb'

    require_relative '../../resolvers/freebsd/dmi.rb'
    require_relative '../../resolvers/freebsd/freebsd_version.rb'
    require_relative '../../resolvers/freebsd/geom.rb'
    require_relative '../../resolvers/freebsd/processors.rb'
    require_relative '../../resolvers/freebsd/swap_memory.rb'
    require_relative '../../resolvers/freebsd/system_memory.rb'
    require_relative '../../resolvers/freebsd/virtual.rb'

  when 'gentoo'
    require_relative '../../facts/gentoo/os/release.rb'

  when 'linux'
    require_relative '../../util/linux/dhcp.rb'
    require_relative '../../util/linux/if_inet6.rb'
    require_relative '../../util/linux/routing_table.rb'
    require_relative '../../util/linux/socket_parser.rb'

    require_relative '../../facts/linux/aio_agent_version.rb'
    require_relative '../../facts/linux/augeas/version.rb'
    require_relative '../../facts/linux/az_metadata.rb'
    require_relative '../../facts/linux/cloud/provider.rb'
    require_relative '../../facts/linux/dhcp_servers.rb'
    require_relative '../../facts/linux/disks.rb'
    require_relative '../../facts/linux/dmi/bios/release_date.rb'
    require_relative '../../facts/linux/dmi/bios/vendor.rb'
    require_relative '../../facts/linux/dmi/bios/version.rb'
    require_relative '../../facts/linux/dmi/board/asset_tag.rb'
    require_relative '../../facts/linux/dmi/board/manufacturer.rb'
    require_relative '../../facts/linux/dmi/board/product.rb'
    require_relative '../../facts/linux/dmi/board/serial_number.rb'
    require_relative '../../facts/linux/dmi/chassis/asset_tag.rb'
    require_relative '../../facts/linux/dmi/chassis/type.rb'
    require_relative '../../facts/linux/dmi/manufacturer.rb'
    require_relative '../../facts/linux/dmi/product/name.rb'
    require_relative '../../facts/linux/dmi/product/serial_number.rb'
    require_relative '../../facts/linux/dmi/product/uuid.rb'
    require_relative '../../facts/linux/ec2_metadata.rb'
    require_relative '../../facts/linux/ec2_userdata.rb'
    require_relative '../../facts/linux/facterversion.rb'
    require_relative '../../facts/linux/filesystems.rb'
    require_relative '../../facts/linux/fips_enabled.rb'
    require_relative '../../facts/linux/gce.rb'
    require_relative '../../facts/linux/hypervisors/docker.rb'
    require_relative '../../facts/linux/hypervisors/hyper_v.rb'
    require_relative '../../facts/linux/hypervisors/kvm.rb'
    require_relative '../../facts/linux/hypervisors/lxc.rb'
    require_relative '../../facts/linux/hypervisors/openvz.rb'
    require_relative '../../facts/linux/hypervisors/systemd_nspawn.rb'
    require_relative '../../facts/linux/hypervisors/virtualbox.rb'
    require_relative '../../facts/linux/hypervisors/vmware.rb'
    require_relative '../../facts/linux/hypervisors/xen.rb'
    require_relative '../../facts/linux/identity/gid.rb'
    require_relative '../../facts/linux/identity/group.rb'
    require_relative '../../facts/linux/identity/privileged.rb'
    require_relative '../../facts/linux/identity/uid.rb'
    require_relative '../../facts/linux/identity/user.rb'
    require_relative '../../facts/linux/interfaces.rb'
    require_relative '../../facts/linux/ipaddress6_interfaces.rb'
    require_relative '../../facts/linux/ipaddress_interfaces.rb'
    require_relative '../../facts/linux/is_virtual.rb'
    require_relative '../../facts/linux/kernel.rb'
    require_relative '../../facts/linux/kernelmajversion.rb'
    require_relative '../../facts/linux/kernelrelease.rb'
    require_relative '../../facts/linux/kernelversion.rb'
    require_relative '../../facts/linux/load_averages.rb'
    require_relative '../../facts/linux/lsbdistrelease.rb'
    require_relative '../../facts/linux/macaddress_interfaces.rb'
    require_relative '../../facts/linux/memory/swap/available.rb'
    require_relative '../../facts/linux/memory/swap/available_bytes.rb'
    require_relative '../../facts/linux/memory/swap/capacity.rb'
    require_relative '../../facts/linux/memory/swap/total.rb'
    require_relative '../../facts/linux/memory/swap/total_bytes.rb'
    require_relative '../../facts/linux/memory/swap/used.rb'
    require_relative '../../facts/linux/memory/swap/used_bytes.rb'
    require_relative '../../facts/linux/memory/system/available.rb'
    require_relative '../../facts/linux/memory/system/available_bytes.rb'
    require_relative '../../facts/linux/memory/system/capacity.rb'
    require_relative '../../facts/linux/memory/system/total.rb'
    require_relative '../../facts/linux/memory/system/total_bytes.rb'
    require_relative '../../facts/linux/memory/system/used.rb'
    require_relative '../../facts/linux/memory/system/used_bytes.rb'
    require_relative '../../facts/linux/mountpoints.rb'
    require_relative '../../facts/linux/mtu_interfaces.rb'
    require_relative '../../facts/linux/netmask6_interfaces.rb'
    require_relative '../../facts/linux/netmask_interfaces.rb'
    require_relative '../../facts/linux/network6_interfaces.rb'
    require_relative '../../facts/linux/network_interfaces.rb'
    require_relative '../../facts/linux/networking/dhcp.rb'
    require_relative '../../facts/linux/networking/domain.rb'
    require_relative '../../facts/linux/networking/fqdn.rb'
    require_relative '../../facts/linux/networking/hostname.rb'
    require_relative '../../facts/linux/networking/interfaces.rb'
    require_relative '../../facts/linux/networking/ip.rb'
    require_relative '../../facts/linux/networking/ip6.rb'
    require_relative '../../facts/linux/networking/mac.rb'
    require_relative '../../facts/linux/networking/mtu.rb'
    require_relative '../../facts/linux/networking/netmask.rb'
    require_relative '../../facts/linux/networking/netmask6.rb'
    require_relative '../../facts/linux/networking/network.rb'
    require_relative '../../facts/linux/networking/network6.rb'
    require_relative '../../facts/linux/networking/primary.rb'
    require_relative '../../facts/linux/networking/scope6.rb'
    require_relative '../../facts/linux/os/architecture.rb'
    require_relative '../../facts/linux/os/distro/codename.rb'
    require_relative '../../facts/linux/os/distro/description.rb'
    require_relative '../../facts/linux/os/distro/id.rb'
    require_relative '../../facts/linux/os/distro/release.rb'
    require_relative '../../facts/linux/os/distro/specification.rb'
    require_relative '../../facts/linux/os/family.rb'
    require_relative '../../facts/linux/os/hardware.rb'
    require_relative '../../facts/linux/os/name.rb'
    require_relative '../../facts/linux/os/release.rb'
    require_relative '../../facts/linux/os/selinux/config_mode.rb'
    require_relative '../../facts/linux/os/selinux/config_policy.rb'
    require_relative '../../facts/linux/os/selinux/current_mode.rb'
    require_relative '../../facts/linux/os/selinux/enabled.rb'
    require_relative '../../facts/linux/os/selinux/enforced.rb'
    require_relative '../../facts/linux/os/selinux/policy_version.rb'
    require_relative '../../facts/linux/partitions.rb'
    require_relative '../../facts/linux/path.rb'
    require_relative '../../facts/linux/processor.rb'
    require_relative '../../facts/linux/processors/cores.rb'
    require_relative '../../facts/linux/processors/count.rb'
    require_relative '../../facts/linux/processors/isa.rb'
    require_relative '../../facts/linux/processors/models.rb'
    require_relative '../../facts/linux/processors/physicalcount.rb'
    require_relative '../../facts/linux/processors/speed.rb'
    require_relative '../../facts/linux/processors/threads.rb'
    require_relative '../../facts/linux/ruby/platform.rb'
    require_relative '../../facts/linux/ruby/sitedir.rb'
    require_relative '../../facts/linux/ruby/version.rb'
    require_relative '../../facts/linux/scope6_interfaces.rb'
    require_relative '../../facts/linux/ssh.rb'
    require_relative '../../facts/linux/sshalgorithmkey.rb'
    require_relative '../../facts/linux/sshfp_algorithm.rb'
    require_relative '../../facts/linux/system_uptime/days.rb'
    require_relative '../../facts/linux/system_uptime/hours.rb'
    require_relative '../../facts/linux/system_uptime/seconds.rb'
    require_relative '../../facts/linux/system_uptime/uptime.rb'
    require_relative '../../facts/linux/timezone.rb'
    require_relative '../../facts/linux/virtual.rb'
    require_relative '../../facts/linux/xen.rb'

    require_relative '../../resolvers/linux/docker_uptime.rb'
    require_relative '../../resolvers/linux/hostname.rb'
    require_relative '../../resolvers/linux/load_averages.rb'
    require_relative '../../resolvers/linux/networking.rb'

  when 'linuxmint'
    require_relative '../../facts/linuxmint/os/name.rb'
    require_relative '../../facts/linuxmint/os/release.rb'

  when 'macosx'
    require_relative '../../util/macosx/system_profile_executor.rb'

    require_relative '../../facts/macosx/aio_agent_version.rb'
    require_relative '../../facts/macosx/augeas/version.rb'
    require_relative '../../facts/macosx/dhcp_servers.rb'
    require_relative '../../facts/macosx/dmi/product/name.rb'
    require_relative '../../facts/macosx/facterversion.rb'
    require_relative '../../facts/macosx/filesystems.rb'
    require_relative '../../facts/macosx/identity/gid.rb'
    require_relative '../../facts/macosx/identity/group.rb'
    require_relative '../../facts/macosx/identity/privileged.rb'
    require_relative '../../facts/macosx/identity/uid.rb'
    require_relative '../../facts/macosx/identity/user.rb'
    require_relative '../../facts/macosx/interfaces.rb'
    require_relative '../../facts/macosx/ipaddress6_interfaces.rb'
    require_relative '../../facts/macosx/ipaddress_interfaces.rb'
    require_relative '../../facts/macosx/is_virtual.rb'
    require_relative '../../facts/macosx/kernel.rb'
    require_relative '../../facts/macosx/kernelmajversion.rb'
    require_relative '../../facts/macosx/kernelrelease.rb'
    require_relative '../../facts/macosx/kernelversion.rb'
    require_relative '../../facts/macosx/load_averages.rb'
    require_relative '../../facts/macosx/macaddress_interfaces.rb'
    require_relative '../../facts/macosx/memory/swap/available.rb'
    require_relative '../../facts/macosx/memory/swap/available_bytes.rb'
    require_relative '../../facts/macosx/memory/swap/capacity.rb'
    require_relative '../../facts/macosx/memory/swap/encrypted.rb'
    require_relative '../../facts/macosx/memory/swap/total.rb'
    require_relative '../../facts/macosx/memory/swap/total_bytes.rb'
    require_relative '../../facts/macosx/memory/swap/used.rb'
    require_relative '../../facts/macosx/memory/swap/used_bytes.rb'
    require_relative '../../facts/macosx/memory/system/available.rb'
    require_relative '../../facts/macosx/memory/system/available_bytes.rb'
    require_relative '../../facts/macosx/memory/system/capacity.rb'
    require_relative '../../facts/macosx/memory/system/total.rb'
    require_relative '../../facts/macosx/memory/system/total_bytes.rb'
    require_relative '../../facts/macosx/memory/system/used.rb'
    require_relative '../../facts/macosx/memory/system/used_bytes.rb'
    require_relative '../../facts/macosx/mountpoints.rb'
    require_relative '../../facts/macosx/mtu_interfaces.rb'
    require_relative '../../facts/macosx/netmask6_interfaces.rb'
    require_relative '../../facts/macosx/netmask_interfaces.rb'
    require_relative '../../facts/macosx/network6_interfaces.rb'
    require_relative '../../facts/macosx/network_interfaces.rb'
    require_relative '../../facts/macosx/networking/dhcp.rb'
    require_relative '../../facts/macosx/networking/domain.rb'
    require_relative '../../facts/macosx/networking/fqdn.rb'
    require_relative '../../facts/macosx/networking/hostname.rb'
    require_relative '../../facts/macosx/networking/interfaces.rb'
    require_relative '../../facts/macosx/networking/ip.rb'
    require_relative '../../facts/macosx/networking/ip6.rb'
    require_relative '../../facts/macosx/networking/mac.rb'
    require_relative '../../facts/macosx/networking/mtu.rb'
    require_relative '../../facts/macosx/networking/netmask.rb'
    require_relative '../../facts/macosx/networking/netmask6.rb'
    require_relative '../../facts/macosx/networking/network.rb'
    require_relative '../../facts/macosx/networking/network6.rb'
    require_relative '../../facts/macosx/networking/primary.rb'
    require_relative '../../facts/macosx/networking/scope6.rb'
    require_relative '../../facts/macosx/os/architecture.rb'
    require_relative '../../facts/macosx/os/family.rb'
    require_relative '../../facts/macosx/os/hardware.rb'
    require_relative '../../facts/macosx/os/macosx/build.rb'
    require_relative '../../facts/macosx/os/macosx/product.rb'
    require_relative '../../facts/macosx/os/macosx/version.rb'
    require_relative '../../facts/macosx/os/name.rb'
    require_relative '../../facts/macosx/os/release.rb'
    require_relative '../../facts/macosx/path.rb'
    require_relative '../../facts/macosx/processors/cores.rb'
    require_relative '../../facts/macosx/processors/count.rb'
    require_relative '../../facts/macosx/processors/isa.rb'
    require_relative '../../facts/macosx/processors/models.rb'
    require_relative '../../facts/macosx/processors/physicalcount.rb'
    require_relative '../../facts/macosx/processors/speed.rb'
    require_relative '../../facts/macosx/processors/threads.rb'
    require_relative '../../facts/macosx/ruby/platform.rb'
    require_relative '../../facts/macosx/ruby/sitedir.rb'
    require_relative '../../facts/macosx/ruby/version.rb'
    require_relative '../../facts/macosx/scope6_interfaces.rb'
    require_relative '../../facts/macosx/ssh.rb'
    require_relative '../../facts/macosx/sshalgorithmkey.rb'
    require_relative '../../facts/macosx/sshfp_algorithm.rb'
    require_relative '../../facts/macosx/system_profiler/boot_mode.rb'
    require_relative '../../facts/macosx/system_profiler/boot_rom_version.rb'
    require_relative '../../facts/macosx/system_profiler/boot_volume.rb'
    require_relative '../../facts/macosx/system_profiler/computer_name.rb'
    require_relative '../../facts/macosx/system_profiler/cores.rb'
    require_relative '../../facts/macosx/system_profiler/hardware_uuid.rb'
    require_relative '../../facts/macosx/system_profiler/kernel_version.rb'
    require_relative '../../facts/macosx/system_profiler/l2_cache_per_core.rb'
    require_relative '../../facts/macosx/system_profiler/l3_cache.rb'
    require_relative '../../facts/macosx/system_profiler/memory.rb'
    require_relative '../../facts/macosx/system_profiler/model_identifier.rb'
    require_relative '../../facts/macosx/system_profiler/model_name.rb'
    require_relative '../../facts/macosx/system_profiler/processor_name.rb'
    require_relative '../../facts/macosx/system_profiler/processor_speed.rb'
    require_relative '../../facts/macosx/system_profiler/processors.rb'
    require_relative '../../facts/macosx/system_profiler/secure_virtual_memory.rb'
    require_relative '../../facts/macosx/system_profiler/serial_number.rb'
    require_relative '../../facts/macosx/system_profiler/smc_version.rb'
    require_relative '../../facts/macosx/system_profiler/system_version.rb'
    require_relative '../../facts/macosx/system_profiler/uptime.rb'
    require_relative '../../facts/macosx/system_profiler/username.rb'
    require_relative '../../facts/macosx/system_uptime/days.rb'
    require_relative '../../facts/macosx/system_uptime/hours.rb'
    require_relative '../../facts/macosx/system_uptime/seconds.rb'
    require_relative '../../facts/macosx/system_uptime/uptime.rb'
    require_relative '../../facts/macosx/timezone.rb'
    require_relative '../../facts/macosx/virtual.rb'

    require_relative '../../resolvers/macosx/dmi.rb'
    require_relative '../../resolvers/macosx/filesystems.rb'
    require_relative '../../resolvers/macosx/load_averages.rb'
    require_relative '../../resolvers/macosx/mountpoints.rb'
    require_relative '../../resolvers/macosx/processors.rb'
    require_relative '../../resolvers/macosx/swap_memory.rb'
    require_relative '../../resolvers/macosx/system_memory.rb'
    require_relative '../../resolvers/macosx/system_profiler.rb'

  when 'mageia'
    require_relative '../../facts/mageia/os/release.rb'

  when 'mariner'
    require_relative '../../facts/mariner/os/release.rb'

  when 'meego'
    require_relative '../../facts/meego/os/release.rb'

  when 'oel'
    require_relative '../../facts/oel/os/release.rb'

  when 'ol'
    require_relative '../../facts/ol/os/release.rb'
    require_relative '../../facts/ol/lsbdistdescription.rb'
    require_relative '../../facts/ol/lsbdistid.rb'
    require_relative '../../facts/ol/os/distro/description.rb'
    require_relative '../../facts/ol/os/distro/id.rb'

  when 'openwrt'
    require_relative '../../facts/openwrt/os/release.rb'

  when 'ovs'
    require_relative '../../facts/ovs/os/release.rb'

  when 'photon'
    require_relative '../../facts/photon/os/release.rb'

  when 'rhel'
    require_relative '../../facts/rhel/lsbdistcodename.rb'
    require_relative '../../facts/rhel/lsbdistdescription.rb'
    require_relative '../../facts/rhel/lsbdistid.rb'
    require_relative '../../facts/rhel/os/distro/codename.rb'
    require_relative '../../facts/rhel/os/distro/description.rb'
    require_relative '../../facts/rhel/os/distro/id.rb'
    require_relative '../../facts/rhel/os/distro/release.rb'
    require_relative '../../facts/rhel/os/family.rb'
    require_relative '../../facts/rhel/os/name.rb'
    require_relative '../../facts/rhel/os/release.rb'

  when 'slackware'
    require_relative '../../facts/slackware/os/release.rb'

  when 'sles'
    require_relative '../../facts/sles/lsbdistcodename.rb'
    require_relative '../../facts/sles/lsbdistdescription.rb'
    require_relative '../../facts/sles/lsbdistid.rb'
    require_relative '../../facts/sles/os/distro/codename.rb'
    require_relative '../../facts/sles/os/distro/description.rb'
    require_relative '../../facts/sles/os/distro/id.rb'
    require_relative '../../facts/sles/os/distro/release.rb'
    require_relative '../../facts/sles/os/family.rb'
    require_relative '../../facts/sles/os/release.rb'

  when 'solaris'
    require_relative '../../facts/solaris/aio_agent_version.rb'
    require_relative '../../facts/solaris/augeas/version.rb'
    require_relative '../../facts/solaris/current_zone.rb'
    require_relative '../../facts/solaris/dhcp_servers.rb'
    require_relative '../../facts/solaris/disks.rb'
    require_relative '../../facts/solaris/dmi/bios/release_date.rb'
    require_relative '../../facts/solaris/dmi/bios/vendor.rb'
    require_relative '../../facts/solaris/dmi/bios/version.rb'
    require_relative '../../facts/solaris/dmi/chassis/asset_tag.rb'
    require_relative '../../facts/solaris/dmi/chassis/type.rb'
    require_relative '../../facts/solaris/dmi/manufacturer.rb'
    require_relative '../../facts/solaris/dmi/product/name.rb'
    require_relative '../../facts/solaris/dmi/product/serial_number.rb'
    require_relative '../../facts/solaris/dmi/product/uuid.rb'
    require_relative '../../facts/solaris/facterversion.rb'
    require_relative '../../facts/solaris/filesystems.rb'
    require_relative '../../facts/solaris/hypervisors/ldom.rb'
    require_relative '../../facts/solaris/hypervisors/zone.rb'
    require_relative '../../facts/solaris/identity/gid.rb'
    require_relative '../../facts/solaris/identity/group.rb'
    require_relative '../../facts/solaris/identity/privileged.rb'
    require_relative '../../facts/solaris/identity/uid.rb'
    require_relative '../../facts/solaris/identity/user.rb'
    require_relative '../../facts/solaris/interfaces.rb'
    require_relative '../../facts/solaris/ipaddress6_interfaces.rb'
    require_relative '../../facts/solaris/ipaddress_interfaces.rb'
    require_relative '../../facts/solaris/is_virtual.rb'
    require_relative '../../facts/solaris/kernel.rb'
    require_relative '../../facts/solaris/kernelmajversion.rb'
    require_relative '../../facts/solaris/kernelrelease.rb'
    require_relative '../../facts/solaris/kernelversion.rb'
    require_relative '../../facts/solaris/ldom.rb'
    require_relative '../../facts/solaris/load_averages.rb'
    require_relative '../../facts/solaris/macaddress_interfaces.rb'
    require_relative '../../facts/solaris/memory/swap/available.rb'
    require_relative '../../facts/solaris/memory/swap/available_bytes.rb'
    require_relative '../../facts/solaris/memory/swap/capacity.rb'
    require_relative '../../facts/solaris/memory/swap/total.rb'
    require_relative '../../facts/solaris/memory/swap/total_bytes.rb'
    require_relative '../../facts/solaris/memory/swap/used.rb'
    require_relative '../../facts/solaris/memory/swap/used_bytes.rb'
    require_relative '../../facts/solaris/memory/system/available.rb'
    require_relative '../../facts/solaris/memory/system/available_bytes.rb'
    require_relative '../../facts/solaris/memory/system/capacity.rb'
    require_relative '../../facts/solaris/memory/system/total.rb'
    require_relative '../../facts/solaris/memory/system/total_bytes.rb'
    require_relative '../../facts/solaris/memory/system/used.rb'
    require_relative '../../facts/solaris/memory/system/used_bytes.rb'
    require_relative '../../facts/solaris/mountpoints.rb'
    require_relative '../../facts/solaris/mtu_interfaces.rb'
    require_relative '../../facts/solaris/netmask6_interfaces.rb'
    require_relative '../../facts/solaris/netmask_interfaces.rb'
    require_relative '../../facts/solaris/network6_interfaces.rb'
    require_relative '../../facts/solaris/network_interfaces.rb'
    require_relative '../../facts/solaris/networking/dhcp.rb'
    require_relative '../../facts/solaris/networking/domain.rb'
    require_relative '../../facts/solaris/networking/fqdn.rb'
    require_relative '../../facts/solaris/networking/hostname.rb'
    require_relative '../../facts/solaris/networking/interfaces.rb'
    require_relative '../../facts/solaris/networking/ip.rb'
    require_relative '../../facts/solaris/networking/ip6.rb'
    require_relative '../../facts/solaris/networking/mac.rb'
    require_relative '../../facts/solaris/networking/mtu.rb'
    require_relative '../../facts/solaris/networking/netmask.rb'
    require_relative '../../facts/solaris/networking/netmask6.rb'
    require_relative '../../facts/solaris/networking/network.rb'
    require_relative '../../facts/solaris/networking/network6.rb'
    require_relative '../../facts/solaris/networking/primary.rb'
    require_relative '../../facts/solaris/os/architecture.rb'
    require_relative '../../facts/solaris/os/family.rb'
    require_relative '../../facts/solaris/os/hardware.rb'
    require_relative '../../facts/solaris/os/name.rb'
    require_relative '../../facts/solaris/os/release.rb'
    require_relative '../../facts/solaris/path.rb'
    require_relative '../../facts/solaris/processors/cores.rb'
    require_relative '../../facts/solaris/processors/count.rb'
    require_relative '../../facts/solaris/processors/isa.rb'
    require_relative '../../facts/solaris/processors/models.rb'
    require_relative '../../facts/solaris/processors/physicalcount.rb'
    require_relative '../../facts/solaris/processors/speed.rb'
    require_relative '../../facts/solaris/processors/threads.rb'
    require_relative '../../facts/solaris/ruby/platform.rb'
    require_relative '../../facts/solaris/ruby/sitedir.rb'
    require_relative '../../facts/solaris/ruby/version.rb'
    require_relative '../../facts/solaris/ssh.rb'
    require_relative '../../facts/solaris/sshalgorithmkey.rb'
    require_relative '../../facts/solaris/sshfp_algorithm.rb'
    require_relative '../../facts/solaris/system_uptime/days.rb'
    require_relative '../../facts/solaris/system_uptime/hours.rb'
    require_relative '../../facts/solaris/system_uptime/seconds.rb'
    require_relative '../../facts/solaris/system_uptime/uptime.rb'
    require_relative '../../facts/solaris/timezone.rb'
    require_relative '../../facts/solaris/virtual.rb'
    require_relative '../../facts/solaris/zfs_featurenumbers.rb'
    require_relative '../../facts/solaris/zfs_version.rb'
    require_relative '../../facts/solaris/zones.rb'
    require_relative '../../facts/solaris/zpool_featureflags.rb'
    require_relative '../../facts/solaris/zpool_featurenumbers.rb'
    require_relative '../../facts/solaris/zpool_version.rb'

    require_relative '../../resolvers/solaris/disks.rb'
    require_relative '../../resolvers/solaris/dmi.rb'
    require_relative '../../resolvers/solaris/dmi_sparc.rb'
    require_relative '../../resolvers/solaris/filesystems.rb'
    require_relative '../../resolvers/solaris/ipaddress.rb'
    require_relative '../../resolvers/solaris/ldom.rb'
    require_relative '../../resolvers/solaris/memory.rb'
    require_relative '../../resolvers/solaris/mountpoints.rb'
    require_relative '../../resolvers/solaris/networking.rb'
    require_relative '../../resolvers/solaris/os_release.rb'
    require_relative '../../resolvers/solaris/processors.rb'
    require_relative '../../resolvers/solaris/zone.rb'
    require_relative '../../resolvers/solaris/zone_name.rb'

  when 'ubuntu'
    require_relative '../../facts/ubuntu/lsbdistrelease.rb'
    require_relative '../../facts/ubuntu/os/distro/release.rb'
    require_relative '../../facts/ubuntu/os/release.rb'

  when 'windows'
    require_relative '../../util/windows/win32ole.rb'

    require_relative '../../facts/windows/aio_agent_version.rb'
    require_relative '../../facts/windows/az_metadata.rb'
    require_relative '../../facts/windows/cloud/provider.rb'
    require_relative '../../facts/windows/dhcp_servers.rb'
    require_relative '../../facts/windows/dmi/manufacturer.rb'
    require_relative '../../facts/windows/dmi/product/name.rb'
    require_relative '../../facts/windows/dmi/product/serial_number.rb'
    require_relative '../../facts/windows/dmi/product/uuid.rb'
    require_relative '../../facts/windows/ec2_metadata.rb'
    require_relative '../../facts/windows/ec2_userdata.rb'
    require_relative '../../facts/windows/facterversion.rb'
    require_relative '../../facts/windows/fips_enabled.rb'
    require_relative '../../facts/windows/gce.rb'
    require_relative '../../facts/windows/hypervisors/hyperv.rb'
    require_relative '../../facts/windows/hypervisors/kvm.rb'
    require_relative '../../facts/windows/hypervisors/virtualbox.rb'
    require_relative '../../facts/windows/hypervisors/vmware.rb'
    require_relative '../../facts/windows/hypervisors/xen.rb'
    require_relative '../../facts/windows/identity/privileged.rb'
    require_relative '../../facts/windows/identity/user.rb'
    require_relative '../../facts/windows/interfaces.rb'
    require_relative '../../facts/windows/ipaddress6_interfaces.rb'
    require_relative '../../facts/windows/ipaddress_interfaces.rb'
    require_relative '../../facts/windows/is_virtual.rb'
    require_relative '../../facts/windows/kernel.rb'
    require_relative '../../facts/windows/kernelmajversion.rb'
    require_relative '../../facts/windows/kernelrelease.rb'
    require_relative '../../facts/windows/kernelversion.rb'
    require_relative '../../facts/windows/macaddress_interfaces.rb'
    require_relative '../../facts/windows/memory/system/available.rb'
    require_relative '../../facts/windows/memory/system/available_bytes.rb'
    require_relative '../../facts/windows/memory/system/capacity.rb'
    require_relative '../../facts/windows/memory/system/total.rb'
    require_relative '../../facts/windows/memory/system/total_bytes.rb'
    require_relative '../../facts/windows/memory/system/used.rb'
    require_relative '../../facts/windows/memory/system/used_bytes.rb'
    require_relative '../../facts/windows/mtu_interfaces.rb'
    require_relative '../../facts/windows/netmask6_interfaces.rb'
    require_relative '../../facts/windows/netmask_interfaces.rb'
    require_relative '../../facts/windows/network6_interfaces.rb'
    require_relative '../../facts/windows/network_interfaces.rb'
    require_relative '../../facts/windows/networking/dhcp.rb'
    require_relative '../../facts/windows/networking/domain.rb'
    require_relative '../../facts/windows/networking/fqdn.rb'
    require_relative '../../facts/windows/networking/hostname.rb'
    require_relative '../../facts/windows/networking/interfaces.rb'
    require_relative '../../facts/windows/networking/ip.rb'
    require_relative '../../facts/windows/networking/ip6.rb'
    require_relative '../../facts/windows/networking/mac.rb'
    require_relative '../../facts/windows/networking/mtu.rb'
    require_relative '../../facts/windows/networking/netmask.rb'
    require_relative '../../facts/windows/networking/netmask6.rb'
    require_relative '../../facts/windows/networking/network.rb'
    require_relative '../../facts/windows/networking/network6.rb'
    require_relative '../../facts/windows/networking/primary.rb'
    require_relative '../../facts/windows/networking/scope6.rb'
    require_relative '../../facts/windows/os/architecture.rb'
    require_relative '../../facts/windows/os/family.rb'
    require_relative '../../facts/windows/os/hardware.rb'
    require_relative '../../facts/windows/os/name.rb'
    require_relative '../../facts/windows/os/release.rb'
    require_relative '../../facts/windows/os/windows/display_version.rb'
    require_relative '../../facts/windows/os/windows/edition_id.rb'
    require_relative '../../facts/windows/os/windows/installation_type.rb'
    require_relative '../../facts/windows/os/windows/product_name.rb'
    require_relative '../../facts/windows/os/windows/release_id.rb'
    require_relative '../../facts/windows/os/windows/system32.rb'
    require_relative '../../facts/windows/path.rb'
    require_relative '../../facts/windows/processor.rb'
    require_relative '../../facts/windows/processors/cores.rb'
    require_relative '../../facts/windows/processors/count.rb'
    require_relative '../../facts/windows/processors/isa.rb'
    require_relative '../../facts/windows/processors/models.rb'
    require_relative '../../facts/windows/processors/physicalcount.rb'
    require_relative '../../facts/windows/processors/threads.rb'
    require_relative '../../facts/windows/ruby/platform.rb'
    require_relative '../../facts/windows/ruby/sitedir.rb'
    require_relative '../../facts/windows/ruby/version.rb'
    require_relative '../../facts/windows/scope6_interfaces.rb'
    require_relative '../../facts/windows/ssh.rb'
    require_relative '../../facts/windows/sshalgorithmkey.rb'
    require_relative '../../facts/windows/sshfp_algorithm.rb'
    require_relative '../../facts/windows/system_uptime/days.rb'
    require_relative '../../facts/windows/system_uptime/hours.rb'
    require_relative '../../facts/windows/system_uptime/seconds.rb'
    require_relative '../../facts/windows/system_uptime/uptime.rb'
    require_relative '../../facts/windows/timezone.rb'
    require_relative '../../facts/windows/virtual.rb'

    require_relative '../../resolvers/windows/aio_agent_version.rb'
    require_relative '../../resolvers/windows/dmi_bios.rb'
    require_relative '../../resolvers/windows/dmi_computersystem.rb'
    require_relative '../../resolvers/windows/fips.rb'
    require_relative '../../resolvers/windows/hardware_architecture.rb'
    require_relative '../../resolvers/windows/identity.rb'
    require_relative '../../resolvers/windows/kernel.rb'
    require_relative '../../resolvers/windows/memory.rb'
    require_relative '../../resolvers/windows/netkvm.rb'
    require_relative '../../resolvers/windows/networking.rb'
    require_relative '../../resolvers/windows/processors.rb'
    require_relative '../../resolvers/windows/product_release.rb'
    require_relative '../../resolvers/windows/ssh.rb'
    require_relative '../../resolvers/windows/system32.rb'
    require_relative '../../resolvers/windows/timezone.rb'
    require_relative '../../resolvers/windows/uptime.rb'
    require_relative '../../resolvers/windows/virtualization.rb'
    require_relative '../../resolvers/windows/win_os_description.rb'
  end
end

require_relative '../../../facter/custom_facts/core/legacy_facter'

require_relative '../../../facter/framework/parsers/query_parser'
