/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  zip.h

  Zip file management functions
*/

#ifndef MAMORY_ZIP_H
#define MAMORY_ZIP_H

#include <stdio.h>

/* Struct */

typedef struct {
  unsigned int Sig __attribute__ ((packed));
  unsigned short VerExt __attribute__ ((packed)) ;
  unsigned short GenFlag __attribute__ ((packed)) ;
  unsigned short CompMethod __attribute__ ((packed)) ;
  unsigned short LastModFileTime __attribute__ ((packed));
  unsigned short LastModFileDate __attribute__ ((packed));
  unsigned int CRC __attribute__ ((packed));
  unsigned int CompSize __attribute__ ((packed));
  unsigned int UncompSize __attribute__ ((packed));
  unsigned short FileNameLen __attribute__ ((packed));
  unsigned short ExtraFieldLen __attribute__ ((packed));
} s_ZipLocalFileHeader;

#define FIX_ZLFH_ENDIANNESS(zlfh) (zlfh).Sig=LE2ME_32((zlfh).Sig); \
                                  (zlfh).VerExt=LE2ME_16((zlfh).VerExt); \
                                  (zlfh).GenFlag=LE2ME_16((zlfh).GenFlag); \
                                  (zlfh).CompMethod=LE2ME_16((zlfh).CompMethod); \
                                  (zlfh).LastModFileTime=LE2ME_16((zlfh).LastModFileTime); \
                                  (zlfh).LastModFileDate=LE2ME_16((zlfh).LastModFileDate); \
                                  (zlfh).CRC=LE2ME_32((zlfh).CRC); \
                                  (zlfh).CompSize=LE2ME_32((zlfh).CompSize); \
                                  (zlfh).UncompSize=LE2ME_32((zlfh).UncompSize); \
                                  (zlfh).FileNameLen=LE2ME_16((zlfh).FileNameLen); \
                                  (zlfh).ExtraFieldLen=LE2ME_16((zlfh).ExtraFieldLen)

typedef struct {
  unsigned int Sig __attribute__ ((packed));
  unsigned int CRC __attribute__ ((packed));
  unsigned int CompSize __attribute__ ((packed));
  unsigned int UncompSize __attribute__ ((packed));
} s_ZipLocalFileDataDesc;

#define FIX_ZLFDD_ENDIANNESS(zlfdd) (zlfdd).Sig=LE2ME_32((zlfdd).Sig); \
                                    (zlfdd).CRC=LE2ME_32((zlfdd).CRC); \
                                    (zlfdd).CompSize=LE2ME_32((zlfdd).CompSize); \
                                    (zlfdd).UncompSize=LE2ME_32((zlfdd).UncompSize)

typedef struct {
  s_ZipLocalFileHeader *LocalFileHeader;
  unsigned char *FileName;
  unsigned char *ExtraField;
  s_ZipLocalFileDataDesc *DataDesc;
  void *Data;
} s_ZipLocalFileEntry;


typedef struct {
  unsigned int Sig __attribute__ ((packed));
  unsigned short VerMade __attribute__ ((packed));
  unsigned short VerExt __attribute__ ((packed));
  unsigned short GenFlag __attribute__ ((packed));
  unsigned short CompMethod __attribute__ ((packed));
  unsigned short LastModFileTime __attribute__ ((packed));
  unsigned short LastModFileDate __attribute__ ((packed));
  unsigned int CRC __attribute__ ((packed));
  unsigned int CompSize __attribute__ ((packed));
  unsigned int UncompSize __attribute__ ((packed));
  unsigned short FileNameLen __attribute__ ((packed));
  unsigned short ExtraFieldLen __attribute__ ((packed));
  unsigned short CommentLen __attribute__ ((packed));
  unsigned short StartDiskNb __attribute__ ((packed));
  unsigned short IntFileAttr __attribute__ ((packed));
  unsigned int ExtFileAttr __attribute__ ((packed));
  unsigned int LocalHeaderOffset __attribute__ ((packed));
} s_ZipCentralDirEntryConst;

#define FIX_ZCDENTRY_ENDIANNESS(zcdec) (zcdec).Sig=LE2ME_32((zcdec).Sig); \
                                    (zcdec).VerMade=LE2ME_16((zcdec).VerMade); \
                                    (zcdec).VerExt=LE2ME_16((zcdec).VerExt); \
                                    (zcdec).GenFlag=LE2ME_16((zcdec).GenFlag); \
                                    (zcdec).CompMethod=LE2ME_16((zcdec).CompMethod); \
                                    (zcdec).LastModFileTime=LE2ME_16((zcdec).LastModFileTime); \
                                    (zcdec).LastModFileDate=LE2ME_16((zcdec).LastModFileDate); \
                                    (zcdec).CRC=LE2ME_32((zcdec).CRC); \
                                    (zcdec).CompSize=LE2ME_32((zcdec).CompSize); \
                                    (zcdec).UncompSize=LE2ME_32((zcdec).UncompSize); \
                                    (zcdec).FileNameLen=LE2ME_16((zcdec).FileNameLen); \
                                    (zcdec).ExtraFieldLen=LE2ME_16((zcdec).ExtraFieldLen); \
                                    (zcdec).CommentLen=LE2ME_16((zcdec).CommentLen); \
                                    (zcdec).StartDiskNb=LE2ME_16((zcdec).StartDiskNb); \
                                    (zcdec).IntFileAttr=LE2ME_16((zcdec).IntFileAttr); \
                                    (zcdec).ExtFileAttr=LE2ME_32((zcdec).ExtFileAttr); \
                                    (zcdec).LocalHeaderOffset=LE2ME_32((zcdec).LocalHeaderOffset)

typedef struct {
  s_ZipCentralDirEntryConst *Const;
  unsigned char *FileName;
  unsigned char *ExtraField;
  unsigned char *Comment;
} s_ZipCentralDirEntry;


typedef struct {
  unsigned int Sig __attribute__ ((packed));
  unsigned short DiskNb __attribute__ ((packed));
  unsigned short CentralDirStartDisk __attribute__ ((packed));
  unsigned short DiskEntriesNb __attribute__ ((packed));
  unsigned short EntriesNb __attribute__ ((packed));
  unsigned int CentralDirSize __attribute__ ((packed));
  unsigned int CentralDirStartOffset __attribute__ ((packed));
  unsigned short CommentLen __attribute__ ((packed));
} s_ZipCentralDirEndConst;

#define FIX_ZCDEND_ENDIANNESS(zcde) (zcde).Sig=LE2ME_32((zcde).Sig); \
                                    (zcde).DiskNb=LE2ME_16((zcde).DiskNb); \
                                    (zcde).CentralDirStartDisk=LE2ME_16((zcde).CentralDirStartDisk); \
                                    (zcde).DiskEntriesNb=LE2ME_16((zcde).DiskEntriesNb); \
                                    (zcde).EntriesNb=LE2ME_16((zcde).EntriesNb); \
                                    (zcde).CentralDirSize=LE2ME_32((zcde).CentralDirSize); \
                                    (zcde).CentralDirStartOffset=LE2ME_32((zcde).CentralDirStartOffset); \
                                    (zcde).CommentLen=LE2ME_16((zcde).CommentLen)

typedef struct {
  s_ZipCentralDirEndConst *Const;
  unsigned char *Comment;
} s_ZipCentralDirEnd;

typedef struct {
  FILE *fp;
  unsigned int Size; 
  unsigned int NbFileEntries;
  s_ZipLocalFileEntry **FileEntries;
  unsigned int NbCentralDirEntries;
  s_ZipCentralDirEntry **CentralDirEntries;
  s_ZipCentralDirEnd *CentralDirEnd;
} s_Zip;


s_Zip *Zipfopen(const char *path,const char *mode);
int Zipfclose(s_Zip *Zip);
s_ZipLocalFileEntry *GetZipLocalFileEntry(s_Zip *Zip,unsigned char *file);
int CopyZipLocalFile(s_Zip *DestZip,s_Zip *SourceZip, 
		     unsigned char *file, unsigned char *newname);
int WriteZipCentralDir(s_Zip *Zip,unsigned char *Comment);
int isFileNameinZip(s_Zip *Zip,unsigned char *file);
unsigned char* isFileCRCinZip(s_Zip *Zip,unsigned int CRC32, unsigned int size);
int FreeZip(s_Zip *Zip);
s_Zip *InitVirtualZip();
void AddToVirtualZip(s_Zip *Zip,
		     unsigned char *File,
		     unsigned int CompSize);
unsigned int GetVirtualZipSize(s_Zip *Zip);
#endif
