/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  conffile.c

  Configuration files functions
*/

#include "common.h"
#include <stdio.h>
#include <scapi/scapi.h>

FILE *fp_scapi;
unsigned char FileLine[BUFSIZ]={0};
unsigned int LinePtr=0;

int SCAPI_ReadConfNextLine(void)
{
  memset(FileLine,0,BUFSIZ);
  if (!fgets(FileLine,BUFSIZ,fp_scapi))
    return(0);
  
  FileLine[strlen(FileLine)-1]=0;
  LinePtr=0;

  return 1;
};

unsigned char *SCAPI_ReadConfNextToken(void)
{
  unsigned char *Token;
  unsigned int TokenMemSize=0;
  unsigned int TokenStart;

  if (LinePtr>=strlen(FileLine))
    if(!SCAPI_ReadConfNextLine())
      return 0;
      
  while(FileLine[LinePtr]==' ' || 
	FileLine[LinePtr]=='\t' ||
	FileLine[LinePtr]=='\0')
    {
     if (LinePtr>=strlen(FileLine) ||
	 FileLine[LinePtr]=='\0')
       {
	 if(!SCAPI_ReadConfNextLine())
	   return 0;
       }
     else
       LinePtr++;
    };


  if (FileLine[LinePtr]=='=')
    {
      TokenStart=LinePtr;
      LinePtr++;
      TokenMemSize++; 
    }
  else
    {
      if (FileLine[LinePtr]!='"')
	{
	  TokenStart=LinePtr;
	  while(FileLine[LinePtr]!=' ' &&
		FileLine[LinePtr]!='\t' &&
		FileLine[LinePtr]!='=' &&
		LinePtr<strlen(FileLine))
	    {    
	      LinePtr++;
	      TokenMemSize++;
	    };
	}
      else
	{
	  LinePtr++;
	  TokenStart=LinePtr;
	  while(FileLine[LinePtr]!='"' &&
		LinePtr<strlen(FileLine))
	    {
	      if(FileLine[LinePtr]=='\\')
		{
		  LinePtr++;
		  TokenMemSize++;
		};
	      LinePtr++;
	      TokenMemSize++;
	    };
	  LinePtr++;
	};
    };

  Token=XCALLOC(unsigned char,TokenMemSize+1);

  strncpy(Token,&FileLine[TokenStart],TokenMemSize);
  
  if(Token[strlen(Token)-1]=='\r')
    Token[strlen(Token)-1]=0;

  return Token;
};

s_Context *SetOptionConfFileName(s_Options *Options,
				 s_Context *Context,
				 unsigned char *Option,
				 unsigned char *token,
				 void (*Function)(s_Option *,s_Context *))
{
  unsigned int i,j;

  for(i=0;i<Options->NbrContexts;i++)
    for(j=0;j<Options->Contexts[i]->NbrOptions;j++)
      if(strcmp(Options->Contexts[i]->Options[j]->ConfFileName,token)==0)
	{
	  LPRINTF(ERROR,"This ConfFileName has already been defined by context '%s'",
		  Options->Contexts[i]->Title);
	  return Context;
	};

  for(i=0;i<Context->NbrOptions;i++)
    if(strcmp(Context->Options[i]->Name,Option)==0 ||
       (Context->Options[i]->ShortName!=NULL &&
	strcmp(Context->Options[i]->ShortName,Option)==0 )
       )
       break;

  if(i==Context->NbrOptions)
    {
      LPRINTF(ERROR,"This option has not been defined");
      return Context;
    }

  Context->Options[i]->ConfFileName=XSTRDUP(token);
  Context->Options[i]->ConfFileFunc=Function;

  return Context;
};

s_Options *ParseConfFile(s_Options *Options,
			 s_Context *Context,
			 unsigned char *File)
{
  unsigned int i,j,k;
  unsigned char *Token=NULL;
  unsigned char *string=NULL;
  unsigned char *string2=NULL;
  unsigned char *value=NULL;

  if(!File)
    return Options;

  fp_scapi=fopen(File,"r");
  
  if(!fp_scapi)
    {
      LPRINTF(ERROR,"'%s' can't be opened for parsing",File);
      return Options;
    };

  XFREE(Token);
  Token=SCAPI_ReadConfNextToken();
  while (!feof(fp_scapi))
    {
      for(i=0;i<Options->NbrContexts;i++)
	{
	  for(j=0;j<Options->Contexts[i]->NbrOptions;j++)
	    if(Options->Contexts[i]->Options[j]->ConfFileName!=NULL &&
	       strcmp(Options->Contexts[i]->Options[j]->ConfFileName,Token)==0)
	      break;
	  if(j!=Options->Contexts[i]->NbrOptions)
	    break;
	};
      
      if(i==Options->NbrContexts && j==Options->Contexts[i]->NbrOptions)
	{
	  LPRINTF(WARNING,"'%s' has not been defined",Token);
	  XFREE(Token);
	  continue;
	}
      
      if(!Options->Contexts[i]->Options[j]->ConfFileFunc)
	{
	  XFREE(Token);
	  Token=SCAPI_ReadConfNextToken();
	  if(strcmp(Token,"=")==0)
	    {
	      XFREE(Token);
	      Token=SCAPI_ReadConfNextToken();
	    };
	  switch(Options->Contexts[i]->Options[j]->Type)
	    {
	    case SET_ARG:
	      for(k=0;k<Options->Contexts[i]->Options[j]->NbrSetArgs;k++)
		if(strcmp(Options->Contexts[i]->Options[j]->SetArgs[k],Token)==0)
		  break;
	      if(k==Options->Contexts[i]->Options[j]->NbrSetArgs)
		break;
	    case FREE_ARG:
	      Options->Contexts[i]->Options[j]->Flags|=SCAPI_OPTION_USED;
	      if((Options->Contexts[i]->Options[j]->Flags & SCAPI_MULTIPLE_ARGS)==0)
		{
		  for(k=0;k<Options->Contexts[i]->Options[j]->NbrArgs;k++)
		    XFREE(Options->Contexts[i]->Options[j]->Args[k]);
		  XFREE(Options->Contexts[i]->Options[j]->Args);
		  Options->Contexts[i]->Options[j]->NbrArgs=0;
		};

	      if(Options->Contexts[i]->Options[j]->Separator!=NULL)
		{
		  string=XSTRDUP(Token);
		  string2=Token;
		  value=strtok(string,Options->Contexts[i]->Options[j]->Separator);
		  while(value!=NULL)
		    {
		      Options->Contexts[i]->Options[j]->Args=
			XREALLOC(Options->Contexts[i]->Options[j]->Args,
				 unsigned char*,
				 Options->Contexts[i]->Options[j]->NbrArgs+1);
		      Options->Contexts[i]->Options[j]->Args[Options->Contexts[i]->Options[j]->NbrArgs]=XSTRDUP(value);
		      Options->Contexts[i]->Options[j]->NbrArgs++;
		      value=strtok(NULL,Options->Contexts[i]->Options[j]->Separator);
		    }
		  string=NULL;
		  XFREE(string2);
		}
	      else
		{
		  Options->Contexts[i]->Options[j]->Args=
		    XREALLOC(Options->Contexts[i]->Options[j]->Args,
			     unsigned char*,
			     Options->Contexts[i]->Options[j]->NbrArgs+1);
		  Options->Contexts[i]->Options[j]->Args[Options->Contexts[i]->Options[j]->NbrArgs]=XSTRDUP(Token);
		  Options->Contexts[i]->Options[j]->NbrArgs++;
		}
	      break;
	    case NO_ARG:
	      if(strcasecmp(Token,"yes")==0 ||
		 strcasecmp(Token,"true")==0 ||
		 strcasecmp(Token,"1")==0)
		{
		  Options->Contexts[i]->Options[j]->Flags|=SCAPI_OPTION_USED;
		  break;
		};
	      if(strcasecmp(Token,"no")==0 ||
		 strcasecmp(Token,"false")==0 ||
		 strcasecmp(Token,"0")==0)
		{
		  Options->Contexts[i]->Options[j]->Flags^=SCAPI_OPTION_USED;
		  break;
		};
	      LPRINTF(WARNING,"Parameter '%s' should in 'yes', 'true', '1' or 'no', 'false', '0'",Options->Contexts[i]->Options[j]->ConfFileName);
	      break;
	    };
	}
      else
	Options->Contexts[i]->Options[j]->ConfFileFunc(Options,Context);

      XFREE(Token);
      Token=SCAPI_ReadConfNextToken();
    };

  fclose(fp_scapi);

  return Options;
}
