/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.HttpClientBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CompositeClientConfigurator
implements ClientConfigurator {
    private final List<ClientConfigurator> configurators;

    public CompositeClientConfigurator(List<ClientConfigurator> configurators) {
        this.configurators = new ArrayList<ClientConfigurator>(configurators);
    }

    public static CompositeClientConfigurator of(ClientConfigurator ... configurators) {
        return new CompositeClientConfigurator(Arrays.asList(configurators));
    }

    @Override
    public void customizeClient(HttpClientBuilder builder) {
        for (ClientConfigurator configurator : this.configurators) {
            configurator.customizeClient(builder);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeClientConfigurator that = (CompositeClientConfigurator)o;
        return this.configurators != null ? this.configurators.equals(that.configurators) : that.configurators == null;
    }

    public int hashCode() {
        return this.configurators != null ? this.configurators.hashCode() : 0;
    }

    public List<ClientConfigurator> getConfigurators() {
        return this.configurators;
    }
}

