"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStable = useStable;
var _react = require("react");
/**
 * Allows access to a changing value in a stable way.
 */
function useStable(value) {
  var ref = (0, _react.useRef)(value);
  (0, _react.useEffect)(function () {
    ref.current = value;
  }, [value]);
  var getValue = (0, _react.useCallback)(function () {
    return ref.current;
  }, []);
  return getValue;
}