function(debug_strip TARGET)
	if(DISTBUILD AND NOT APPLE)
		if(CMAKE_BUILD_TYPE STREQUAL "RelWithDebInfo")
			add_custom_command(TARGET ${TARGET} POST_BUILD COMMAND "${OBJCOPY}" --only-keep-debug "$<TARGET_FILE:${TARGET}>" "$<TARGET_FILE:${TARGET}>.debug")
			add_custom_command(TARGET ${TARGET} POST_BUILD COMMAND "${STRIP}" "$<TARGET_FILE:${TARGET}>")
			add_custom_command(TARGET ${TARGET} POST_BUILD COMMAND "${OBJCOPY}" --add-gnu-debuglink "$<TARGET_FILE:${TARGET}>.debug" "$<TARGET_FILE:${TARGET}>")
			install(FILES "$<TARGET_FILE:${TARGET}>.debug" DESTINATION ${CMAKE_INSTALL_BINDIR} COMPONENT ${TARGET}-dbg)
		elseif(BUILD_STATIC AND (CMAKE_BUILD_TYPE STREQUAL "Release" OR CMAKE_BUILD_TYPE STREQUAL "MinSizeRel"))
			add_custom_command(TARGET ${TARGET} POST_BUILD COMMAND "${STRIP}" "$<TARGET_FILE:${TARGET}>")
		endif()
	endif()
endfunction()
