/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/*
 * units.h
 */

#ifndef __CONVERT_H
#define __CONVERT_H

#include <math.h>

#ifndef M_PI
#define M_PI           3.14159265358979323846  /* pi */
#endif

#ifndef M_E
#define M_E            2.7182818284590452354   /* e */
#endif

static gfloat conv_length[7][7] = {
  { 1.0,       2.54e-3,   2.54e-2,   2.54e-5,   25.4,     1.e-3,   1./12000},
  {1./2.54e-3,    1.0,     10.0,      1.e-2,    1.e4,   1./2.54,   1./30.48},
  {1./2.54e-2,  1./10.,     1.0,       1.e-3,   1.e3,   1./25.4,   1./304.8},
  {1./2.54e-5,    1.e2,    1.e3,         1.0,   1.e6,  1./2.54e-2, 1./0.3048},
  {1./25.4,      1.e-4,   1.e-3,       1.e-6,    1.0,  1./2.54e4,  1./3.048e5},
  {1.e3,          2.54,    25.4,     2.54e-2, 2.54e4,        1.0,    1./12.},
  {1.2e4,        30.48,   304.8,      0.3048, 3.048e5,      12.0,       1.0}
};

static gfloat conv_freq[4][4] = {
  { 1.0,     1.e9,     1.e6,      1.e3},
  { 1.e-9,   1.0,      1.e-3,     1.e-6},
  { 1.e-6,   1.e3,     1.0,       1.e-3},
  { 1.e-3,   1.e6,     1.e3,      1.0}
};

static gfloat conv_res[2][2] = {
  {1.0,    1.e-3},
  {1.e3,   1.0}
};

static gfloat conv_ang[2][2] = {
  {1.0,         M_PI/180.0},
  {180.0/M_PI,         1.0}
};


#endif
