// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/secretmanager/v1/resources.proto

package secretmanager

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The state of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion], indicating if it can be accessed.
type SecretVersion_State int32

const (
	// Not specified. This value is unused and invalid.
	SecretVersion_STATE_UNSPECIFIED SecretVersion_State = 0
	// The [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] may be accessed.
	SecretVersion_ENABLED SecretVersion_State = 1
	// The [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] may not be accessed, but the secret data
	// is still available and can be placed back into the [ENABLED][google.cloud.secretmanager.v1.SecretVersion.State.ENABLED]
	// state.
	SecretVersion_DISABLED SecretVersion_State = 2
	// The [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] is destroyed and the secret data is no longer
	// stored. A version may not leave this state once entered.
	SecretVersion_DESTROYED SecretVersion_State = 3
)

// Enum value maps for SecretVersion_State.
var (
	SecretVersion_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
		3: "DESTROYED",
	}
	SecretVersion_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ENABLED":           1,
		"DISABLED":          2,
		"DESTROYED":         3,
	}
)

func (x SecretVersion_State) Enum() *SecretVersion_State {
	p := new(SecretVersion_State)
	*p = x
	return p
}

func (x SecretVersion_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecretVersion_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_secretmanager_v1_resources_proto_enumTypes[0].Descriptor()
}

func (SecretVersion_State) Type() protoreflect.EnumType {
	return &file_google_cloud_secretmanager_v1_resources_proto_enumTypes[0]
}

func (x SecretVersion_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecretVersion_State.Descriptor instead.
func (SecretVersion_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{1, 0}
}

// A [Secret][google.cloud.secretmanager.v1.Secret] is a logical secret whose value and versions can
// be accessed.
//
// A [Secret][google.cloud.secretmanager.v1.Secret] is made up of zero or more [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] that
// represent the secret data.
type Secret struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the [Secret][google.cloud.secretmanager.v1.Secret] in the format `projects/*/secrets/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The replication policy of the secret data attached to the [Secret][google.cloud.secretmanager.v1.Secret].
	//
	// The replication policy cannot be changed after the Secret has been created.
	Replication *Replication `protobuf:"bytes,2,opt,name=replication,proto3" json:"replication,omitempty"`
	// Output only. The time at which the [Secret][google.cloud.secretmanager.v1.Secret] was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The labels assigned to this Secret.
	//
	// Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
	// of maximum 128 bytes, and must conform to the following PCRE regular
	// expression: `[\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}`
	//
	// Label values must be between 0 and 63 characters long, have a UTF-8
	// encoding of maximum 128 bytes, and must conform to the following PCRE
	// regular expression: `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`
	//
	// No more than 64 labels can be assigned to a given resource.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. A list of up to 10 Pub/Sub topics to which messages are published when
	// control plane operations are called on the secret or its versions.
	Topics []*Topic `protobuf:"bytes,5,rep,name=topics,proto3" json:"topics,omitempty"`
	// Expiration policy attached to the [Secret][google.cloud.secretmanager.v1.Secret]. If specified the [Secret][google.cloud.secretmanager.v1.Secret]
	// and all [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] will be automatically deleted at
	// expiration. Expired secrets are irreversibly deleted.
	//
	// Expiration is *not* the recommended way to set time-based permissions. [IAM
	// Conditions](https://cloud.google.com/secret-manager/docs/access-control#conditions)
	// is recommended for granting time-based permissions because the operation
	// can be reversed.
	//
	// Types that are assignable to Expiration:
	//	*Secret_ExpireTime
	//	*Secret_Ttl
	Expiration isSecret_Expiration `protobuf_oneof:"expiration"`
	// Optional. Etag of the currently stored [Secret][google.cloud.secretmanager.v1.Secret].
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Rotation policy attached to the [Secret][google.cloud.secretmanager.v1.Secret]. May be excluded if there is no
	// rotation policy.
	Rotation *Rotation `protobuf:"bytes,9,opt,name=rotation,proto3" json:"rotation,omitempty"`
	// Optional. Mapping from version alias to version name.
	//
	// A version alias is a string with a maximum length of 63 characters and can
	// contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
	// and underscore ('_') characters. An alias string must start with a
	// letter and cannot be the string 'latest' or 'NEW'.
	// No more than 50 aliases can be assigned to a given secret.
	//
	// Version-Alias pairs will be viewable via GetSecret and modifiable via
	// UpdateSecret. At launch access by alias will only be supported on
	// GetSecretVersion and AccessSecretVersion.
	VersionAliases map[string]int64 `protobuf:"bytes,11,rep,name=version_aliases,json=versionAliases,proto3" json:"version_aliases,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (x *Secret) Reset() {
	*x = Secret{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Secret) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Secret) ProtoMessage() {}

func (x *Secret) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Secret.ProtoReflect.Descriptor instead.
func (*Secret) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Secret) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Secret) GetReplication() *Replication {
	if x != nil {
		return x.Replication
	}
	return nil
}

func (x *Secret) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Secret) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Secret) GetTopics() []*Topic {
	if x != nil {
		return x.Topics
	}
	return nil
}

func (m *Secret) GetExpiration() isSecret_Expiration {
	if m != nil {
		return m.Expiration
	}
	return nil
}

func (x *Secret) GetExpireTime() *timestamppb.Timestamp {
	if x, ok := x.GetExpiration().(*Secret_ExpireTime); ok {
		return x.ExpireTime
	}
	return nil
}

func (x *Secret) GetTtl() *durationpb.Duration {
	if x, ok := x.GetExpiration().(*Secret_Ttl); ok {
		return x.Ttl
	}
	return nil
}

func (x *Secret) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Secret) GetRotation() *Rotation {
	if x != nil {
		return x.Rotation
	}
	return nil
}

func (x *Secret) GetVersionAliases() map[string]int64 {
	if x != nil {
		return x.VersionAliases
	}
	return nil
}

type isSecret_Expiration interface {
	isSecret_Expiration()
}

type Secret_ExpireTime struct {
	// Optional. Timestamp in UTC when the [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire. This is
	// always provided on output, regardless of what was sent on input.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=expire_time,json=expireTime,proto3,oneof"`
}

type Secret_Ttl struct {
	// Input only. The TTL for the [Secret][google.cloud.secretmanager.v1.Secret].
	Ttl *durationpb.Duration `protobuf:"bytes,7,opt,name=ttl,proto3,oneof"`
}

func (*Secret_ExpireTime) isSecret_Expiration() {}

func (*Secret_Ttl) isSecret_Expiration() {}

// A secret version resource in the Secret Manager API.
type SecretVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] in the
	// format `projects/*/secrets/*/versions/*`.
	//
	// [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] IDs in a [Secret][google.cloud.secretmanager.v1.Secret] start at 1 and
	// are incremented for each subsequent version of the secret.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
	// Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
	// [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
	DestroyTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=destroy_time,json=destroyTime,proto3" json:"destroy_time,omitempty"`
	// Output only. The current state of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	State SecretVersion_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.secretmanager.v1.SecretVersion_State" json:"state,omitempty"`
	// The replication status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	ReplicationStatus *ReplicationStatus `protobuf:"bytes,5,opt,name=replication_status,json=replicationStatus,proto3" json:"replication_status,omitempty"`
	// Output only. Etag of the currently stored [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	Etag string `protobuf:"bytes,6,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. True if payload checksum specified in [SecretPayload][google.cloud.secretmanager.v1.SecretPayload] object has been
	// received by [SecretManagerService][google.cloud.secretmanager.v1.SecretManagerService] on
	// [SecretManagerService.AddSecretVersion][google.cloud.secretmanager.v1.SecretManagerService.AddSecretVersion].
	ClientSpecifiedPayloadChecksum bool `protobuf:"varint,7,opt,name=client_specified_payload_checksum,json=clientSpecifiedPayloadChecksum,proto3" json:"client_specified_payload_checksum,omitempty"`
}

func (x *SecretVersion) Reset() {
	*x = SecretVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretVersion) ProtoMessage() {}

func (x *SecretVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretVersion.ProtoReflect.Descriptor instead.
func (*SecretVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *SecretVersion) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SecretVersion) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *SecretVersion) GetDestroyTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DestroyTime
	}
	return nil
}

func (x *SecretVersion) GetState() SecretVersion_State {
	if x != nil {
		return x.State
	}
	return SecretVersion_STATE_UNSPECIFIED
}

func (x *SecretVersion) GetReplicationStatus() *ReplicationStatus {
	if x != nil {
		return x.ReplicationStatus
	}
	return nil
}

func (x *SecretVersion) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *SecretVersion) GetClientSpecifiedPayloadChecksum() bool {
	if x != nil {
		return x.ClientSpecifiedPayloadChecksum
	}
	return false
}

// A policy that defines the replication and encryption configuration of data.
type Replication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The replication policy for this secret.
	//
	// Types that are assignable to Replication:
	//	*Replication_Automatic_
	//	*Replication_UserManaged_
	Replication isReplication_Replication `protobuf_oneof:"replication"`
}

func (x *Replication) Reset() {
	*x = Replication{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Replication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Replication) ProtoMessage() {}

func (x *Replication) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Replication.ProtoReflect.Descriptor instead.
func (*Replication) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (m *Replication) GetReplication() isReplication_Replication {
	if m != nil {
		return m.Replication
	}
	return nil
}

func (x *Replication) GetAutomatic() *Replication_Automatic {
	if x, ok := x.GetReplication().(*Replication_Automatic_); ok {
		return x.Automatic
	}
	return nil
}

func (x *Replication) GetUserManaged() *Replication_UserManaged {
	if x, ok := x.GetReplication().(*Replication_UserManaged_); ok {
		return x.UserManaged
	}
	return nil
}

type isReplication_Replication interface {
	isReplication_Replication()
}

type Replication_Automatic_ struct {
	// The [Secret][google.cloud.secretmanager.v1.Secret] will automatically be replicated without any restrictions.
	Automatic *Replication_Automatic `protobuf:"bytes,1,opt,name=automatic,proto3,oneof"`
}

type Replication_UserManaged_ struct {
	// The [Secret][google.cloud.secretmanager.v1.Secret] will only be replicated into the locations specified.
	UserManaged *Replication_UserManaged `protobuf:"bytes,2,opt,name=user_managed,json=userManaged,proto3,oneof"`
}

func (*Replication_Automatic_) isReplication_Replication() {}

func (*Replication_UserManaged_) isReplication_Replication() {}

// Configuration for encrypting secret payloads using customer-managed
// encryption keys (CMEK).
type CustomerManagedEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Cloud KMS CryptoKey used to encrypt secret
	// payloads.
	//
	// For secrets using the [UserManaged][google.cloud.secretmanager.v1.Replication.UserManaged] replication
	// policy type, Cloud KMS CryptoKeys must reside in the same location as the
	// [replica location][Secret.UserManaged.Replica.location].
	//
	// For secrets using the [Automatic][google.cloud.secretmanager.v1.Replication.Automatic] replication policy
	// type, Cloud KMS CryptoKeys must reside in `global`.
	//
	// The expected format is `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
	KmsKeyName string `protobuf:"bytes,1,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
}

func (x *CustomerManagedEncryption) Reset() {
	*x = CustomerManagedEncryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomerManagedEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomerManagedEncryption) ProtoMessage() {}

func (x *CustomerManagedEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomerManagedEncryption.ProtoReflect.Descriptor instead.
func (*CustomerManagedEncryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *CustomerManagedEncryption) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

// The replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
type ReplicationStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The replication status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	//
	// Types that are assignable to ReplicationStatus:
	//	*ReplicationStatus_Automatic
	//	*ReplicationStatus_UserManaged
	ReplicationStatus isReplicationStatus_ReplicationStatus `protobuf_oneof:"replication_status"`
}

func (x *ReplicationStatus) Reset() {
	*x = ReplicationStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationStatus) ProtoMessage() {}

func (x *ReplicationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationStatus.ProtoReflect.Descriptor instead.
func (*ReplicationStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (m *ReplicationStatus) GetReplicationStatus() isReplicationStatus_ReplicationStatus {
	if m != nil {
		return m.ReplicationStatus
	}
	return nil
}

func (x *ReplicationStatus) GetAutomatic() *ReplicationStatus_AutomaticStatus {
	if x, ok := x.GetReplicationStatus().(*ReplicationStatus_Automatic); ok {
		return x.Automatic
	}
	return nil
}

func (x *ReplicationStatus) GetUserManaged() *ReplicationStatus_UserManagedStatus {
	if x, ok := x.GetReplicationStatus().(*ReplicationStatus_UserManaged); ok {
		return x.UserManaged
	}
	return nil
}

type isReplicationStatus_ReplicationStatus interface {
	isReplicationStatus_ReplicationStatus()
}

type ReplicationStatus_Automatic struct {
	// Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
	// automatic replication.
	//
	// Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
	// policy.
	Automatic *ReplicationStatus_AutomaticStatus `protobuf:"bytes,1,opt,name=automatic,proto3,oneof"`
}

type ReplicationStatus_UserManaged struct {
	// Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
	// user-managed replication.
	//
	// Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
	// policy.
	UserManaged *ReplicationStatus_UserManagedStatus `protobuf:"bytes,2,opt,name=user_managed,json=userManaged,proto3,oneof"`
}

func (*ReplicationStatus_Automatic) isReplicationStatus_ReplicationStatus() {}

func (*ReplicationStatus_UserManaged) isReplicationStatus_ReplicationStatus() {}

// Describes the status of customer-managed encryption.
type CustomerManagedEncryptionStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Cloud KMS CryptoKeyVersion used to encrypt the
	// secret payload, in the following format:
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*/versions/*`.
	KmsKeyVersionName string `protobuf:"bytes,1,opt,name=kms_key_version_name,json=kmsKeyVersionName,proto3" json:"kms_key_version_name,omitempty"`
}

func (x *CustomerManagedEncryptionStatus) Reset() {
	*x = CustomerManagedEncryptionStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomerManagedEncryptionStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomerManagedEncryptionStatus) ProtoMessage() {}

func (x *CustomerManagedEncryptionStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomerManagedEncryptionStatus.ProtoReflect.Descriptor instead.
func (*CustomerManagedEncryptionStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *CustomerManagedEncryptionStatus) GetKmsKeyVersionName() string {
	if x != nil {
		return x.KmsKeyVersionName
	}
	return ""
}

// A Pub/Sub topic which Secret Manager will publish to when control plane
// events occur on this secret.
type Topic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Pub/Sub topic that will be published to, in the
	// following format: `projects/*/topics/*`. For publication to succeed, the
	// Secret Manager P4SA must have `pubsub.publisher` permissions on the topic.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Topic) Reset() {
	*x = Topic{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Topic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Topic) ProtoMessage() {}

func (x *Topic) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Topic.ProtoReflect.Descriptor instead.
func (*Topic) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *Topic) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The rotation time and period for a [Secret][google.cloud.secretmanager.v1.Secret]. At next_rotation_time, Secret
// Manager will send a Pub/Sub notification to the topics configured on the
// Secret. [Secret.topics][google.cloud.secretmanager.v1.Secret.topics] must be set to configure rotation.
type Rotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Timestamp in UTC at which the [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to rotate. Cannot be
	// set to less than 300s (5 min) in the future and at most 3153600000s (100
	// years).
	//
	// [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time] MUST  be set if [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period] is set.
	NextRotationTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=next_rotation_time,json=nextRotationTime,proto3" json:"next_rotation_time,omitempty"`
	// Input only. The Duration between rotation notifications. Must be in seconds
	// and at least 3600s (1h) and at most 3153600000s (100 years).
	//
	// If [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period] is set, [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time] must be set.
	// [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time] will be advanced by this period when the service
	// automatically sends rotation notifications.
	RotationPeriod *durationpb.Duration `protobuf:"bytes,2,opt,name=rotation_period,json=rotationPeriod,proto3" json:"rotation_period,omitempty"`
}

func (x *Rotation) Reset() {
	*x = Rotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rotation) ProtoMessage() {}

func (x *Rotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rotation.ProtoReflect.Descriptor instead.
func (*Rotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *Rotation) GetNextRotationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextRotationTime
	}
	return nil
}

func (x *Rotation) GetRotationPeriod() *durationpb.Duration {
	if x != nil {
		return x.RotationPeriod
	}
	return nil
}

// A secret payload resource in the Secret Manager API. This contains the
// sensitive secret payload that is associated with a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
type SecretPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The secret data. Must be no larger than 64KiB.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// Optional. If specified, [SecretManagerService][google.cloud.secretmanager.v1.SecretManagerService] will verify the integrity of the
	// received [data][google.cloud.secretmanager.v1.SecretPayload.data] on [SecretManagerService.AddSecretVersion][google.cloud.secretmanager.v1.SecretManagerService.AddSecretVersion] calls using
	// the crc32c checksum and store it to include in future
	// [SecretManagerService.AccessSecretVersion][google.cloud.secretmanager.v1.SecretManagerService.AccessSecretVersion] responses. If a checksum is
	// not provided in the [SecretManagerService.AddSecretVersion][google.cloud.secretmanager.v1.SecretManagerService.AddSecretVersion] request, the
	// [SecretManagerService][google.cloud.secretmanager.v1.SecretManagerService] will generate and store one for you.
	//
	// The CRC32C value is encoded as a Int64 for compatibility, and can be
	// safely downconverted to uint32 in languages that support this type.
	// https://cloud.google.com/apis/design/design_patterns#integer_types
	DataCrc32C *int64 `protobuf:"varint,2,opt,name=data_crc32c,json=dataCrc32c,proto3,oneof" json:"data_crc32c,omitempty"`
}

func (x *SecretPayload) Reset() {
	*x = SecretPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretPayload) ProtoMessage() {}

func (x *SecretPayload) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretPayload.ProtoReflect.Descriptor instead.
func (*SecretPayload) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *SecretPayload) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *SecretPayload) GetDataCrc32C() int64 {
	if x != nil && x.DataCrc32C != nil {
		return *x.DataCrc32C
	}
	return 0
}

// A replication policy that replicates the [Secret][google.cloud.secretmanager.v1.Secret] payload without any
// restrictions.
type Replication_Automatic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The customer-managed encryption configuration of the [Secret][google.cloud.secretmanager.v1.Secret]. If no
	// configuration is provided, Google-managed default encryption is used.
	//
	// Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption configuration only apply to
	// [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added afterwards. They do not apply
	// retroactively to existing [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
	CustomerManagedEncryption *CustomerManagedEncryption `protobuf:"bytes,1,opt,name=customer_managed_encryption,json=customerManagedEncryption,proto3" json:"customer_managed_encryption,omitempty"`
}

func (x *Replication_Automatic) Reset() {
	*x = Replication_Automatic{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Replication_Automatic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Replication_Automatic) ProtoMessage() {}

func (x *Replication_Automatic) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Replication_Automatic.ProtoReflect.Descriptor instead.
func (*Replication_Automatic) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{2, 0}
}

func (x *Replication_Automatic) GetCustomerManagedEncryption() *CustomerManagedEncryption {
	if x != nil {
		return x.CustomerManagedEncryption
	}
	return nil
}

// A replication policy that replicates the [Secret][google.cloud.secretmanager.v1.Secret] payload into the
// locations specified in [Secret.replication.user_managed.replicas][]
type Replication_UserManaged struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of Replicas for this [Secret][google.cloud.secretmanager.v1.Secret].
	//
	// Cannot be empty.
	Replicas []*Replication_UserManaged_Replica `protobuf:"bytes,1,rep,name=replicas,proto3" json:"replicas,omitempty"`
}

func (x *Replication_UserManaged) Reset() {
	*x = Replication_UserManaged{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Replication_UserManaged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Replication_UserManaged) ProtoMessage() {}

func (x *Replication_UserManaged) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Replication_UserManaged.ProtoReflect.Descriptor instead.
func (*Replication_UserManaged) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{2, 1}
}

func (x *Replication_UserManaged) GetReplicas() []*Replication_UserManaged_Replica {
	if x != nil {
		return x.Replicas
	}
	return nil
}

// Represents a Replica for this [Secret][google.cloud.secretmanager.v1.Secret].
type Replication_UserManaged_Replica struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The canonical IDs of the location to replicate data.
	// For example: `"us-east1"`.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Optional. The customer-managed encryption configuration of the [User-Managed
	// Replica][Replication.UserManaged.Replica]. If no configuration is
	// provided, Google-managed default encryption is used.
	//
	// Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption configuration only apply to
	// [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added afterwards. They do not apply
	// retroactively to existing [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
	CustomerManagedEncryption *CustomerManagedEncryption `protobuf:"bytes,2,opt,name=customer_managed_encryption,json=customerManagedEncryption,proto3" json:"customer_managed_encryption,omitempty"`
}

func (x *Replication_UserManaged_Replica) Reset() {
	*x = Replication_UserManaged_Replica{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Replication_UserManaged_Replica) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Replication_UserManaged_Replica) ProtoMessage() {}

func (x *Replication_UserManaged_Replica) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Replication_UserManaged_Replica.ProtoReflect.Descriptor instead.
func (*Replication_UserManaged_Replica) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{2, 1, 0}
}

func (x *Replication_UserManaged_Replica) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Replication_UserManaged_Replica) GetCustomerManagedEncryption() *CustomerManagedEncryption {
	if x != nil {
		return x.CustomerManagedEncryption
	}
	return nil
}

// The replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] using automatic replication.
//
// Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
// policy.
type ReplicationStatus_AutomaticStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
	// populated if customer-managed encryption is used.
	CustomerManagedEncryption *CustomerManagedEncryptionStatus `protobuf:"bytes,1,opt,name=customer_managed_encryption,json=customerManagedEncryption,proto3" json:"customer_managed_encryption,omitempty"`
}

func (x *ReplicationStatus_AutomaticStatus) Reset() {
	*x = ReplicationStatus_AutomaticStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicationStatus_AutomaticStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationStatus_AutomaticStatus) ProtoMessage() {}

func (x *ReplicationStatus_AutomaticStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationStatus_AutomaticStatus.ProtoReflect.Descriptor instead.
func (*ReplicationStatus_AutomaticStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{4, 0}
}

func (x *ReplicationStatus_AutomaticStatus) GetCustomerManagedEncryption() *CustomerManagedEncryptionStatus {
	if x != nil {
		return x.CustomerManagedEncryption
	}
	return nil
}

// The replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] using user-managed
// replication.
//
// Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
// policy.
type ReplicationStatus_UserManagedStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	Replicas []*ReplicationStatus_UserManagedStatus_ReplicaStatus `protobuf:"bytes,1,rep,name=replicas,proto3" json:"replicas,omitempty"`
}

func (x *ReplicationStatus_UserManagedStatus) Reset() {
	*x = ReplicationStatus_UserManagedStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicationStatus_UserManagedStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationStatus_UserManagedStatus) ProtoMessage() {}

func (x *ReplicationStatus_UserManagedStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationStatus_UserManagedStatus.ProtoReflect.Descriptor instead.
func (*ReplicationStatus_UserManagedStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{4, 1}
}

func (x *ReplicationStatus_UserManagedStatus) GetReplicas() []*ReplicationStatus_UserManagedStatus_ReplicaStatus {
	if x != nil {
		return x.Replicas
	}
	return nil
}

// Describes the status of a user-managed replica for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
type ReplicationStatus_UserManagedStatus_ReplicaStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The canonical ID of the replica location.
	// For example: `"us-east1"`.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
	// populated if customer-managed encryption is used.
	CustomerManagedEncryption *CustomerManagedEncryptionStatus `protobuf:"bytes,2,opt,name=customer_managed_encryption,json=customerManagedEncryption,proto3" json:"customer_managed_encryption,omitempty"`
}

func (x *ReplicationStatus_UserManagedStatus_ReplicaStatus) Reset() {
	*x = ReplicationStatus_UserManagedStatus_ReplicaStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicationStatus_UserManagedStatus_ReplicaStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationStatus_UserManagedStatus_ReplicaStatus) ProtoMessage() {}

func (x *ReplicationStatus_UserManagedStatus_ReplicaStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_secretmanager_v1_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationStatus_UserManagedStatus_ReplicaStatus.ProtoReflect.Descriptor instead.
func (*ReplicationStatus_UserManagedStatus_ReplicaStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP(), []int{4, 1, 0}
}

func (x *ReplicationStatus_UserManagedStatus_ReplicaStatus) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *ReplicationStatus_UserManagedStatus_ReplicaStatus) GetCustomerManagedEncryption() *CustomerManagedEncryptionStatus {
	if x != nil {
		return x.CustomerManagedEncryption
	}
	return nil
}

var File_google_cloud_secretmanager_v1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_secretmanager_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe6, 0x06, 0x0a, 0x06, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a,
	0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x06,
	0xe0, 0x41, 0x05, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x41, 0x0a, 0x06, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x73, 0x12, 0x42, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x04, 0x48, 0x00, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x12, 0x48, 0x0a, 0x08, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67,
	0x0a, 0x0f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65,
	0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x2e, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x41, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x41, 0x0a, 0x13, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x69,
	0x61, 0x73, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x4d, 0xea, 0x41, 0x4a, 0x0a, 0x23, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12,
	0x23, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x7d, 0x42, 0x0c, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x81, 0x05, 0x0a, 0x0d, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x42, 0x0a, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x5f, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x11, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x4e, 0x0a, 0x21,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64,
	0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75,
	0x6d, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1e, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x22, 0x48, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x45, 0x53, 0x54, 0x52,
	0x4f, 0x59, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x6e, 0xea, 0x41, 0x6b, 0x0a, 0x2a, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x7d, 0x2f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xf4, 0x04, 0x0a, 0x0b, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x09, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x48,
	0x00, 0x52, 0x09, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x12, 0x5b, 0x0a, 0x0c,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55,
	0x73, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x73,
	0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x1a, 0x8a, 0x01, 0x0a, 0x09, 0x41, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x12, 0x7d, 0x0a, 0x1b, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x95, 0x02, 0x0a, 0x0b, 0x55, 0x73, 0x65, 0x72, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x12, 0x5f, 0x0a, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x1a, 0xa4, 0x01, 0x0a, 0x07, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x7d, 0x0a, 0x1b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x19, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0d,
	0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x42, 0x0a,
	0x19, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0c, 0x6b, 0x6d,
	0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x22, 0xd0, 0x05, 0x0a, 0x11, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x60, 0x0a, 0x09, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x41, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x09,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x12, 0x67, 0x0a, 0x0c, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x1a, 0x97, 0x01, 0x0a, 0x0f, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x1b, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x19, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xbf, 0x02, 0x0a,
	0x11, 0x55, 0x73, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x71, 0x0a, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x73, 0x1a, 0xb6, 0x01, 0x0a, 0x0d, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x83, 0x01, 0x0a, 0x1b, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x19, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x14,
	0x0a, 0x12, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x22, 0x57, 0x0a, 0x1f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x34, 0x0a, 0x14, 0x6b, 0x6d, 0x73, 0x5f, 0x6b,
	0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x6b, 0x6d, 0x73, 0x4b,
	0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x65, 0x0a,
	0x05, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x3a,
	0x43, 0xea, 0x41, 0x40, 0x0a, 0x1b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69,
	0x63, 0x12, 0x21, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x2f, 0x7b, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x7d, 0x22, 0xa2, 0x01, 0x0a, 0x08, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x4d, 0x0a, 0x12, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x6e, 0x65, 0x78, 0x74, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x47, 0x0a, 0x0f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0e, 0x72, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x22, 0x5e, 0x0a, 0x0d, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x29,
	0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61,
	0x43, 0x72, 0x63, 0x33, 0x32, 0x63, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x42, 0xed, 0x01, 0x0a, 0x21, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42,
	0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x3b,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0xf8, 0x01, 0x01,
	0xa2, 0x02, 0x03, 0x47, 0x53, 0x4d, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_secretmanager_v1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_secretmanager_v1_resources_proto_rawDescData = file_google_cloud_secretmanager_v1_resources_proto_rawDesc
)

func file_google_cloud_secretmanager_v1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_secretmanager_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_secretmanager_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_secretmanager_v1_resources_proto_rawDescData)
	})
	return file_google_cloud_secretmanager_v1_resources_proto_rawDescData
}

var file_google_cloud_secretmanager_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_secretmanager_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_secretmanager_v1_resources_proto_goTypes = []interface{}{
	(SecretVersion_State)(0),                    // 0: google.cloud.secretmanager.v1.SecretVersion.State
	(*Secret)(nil),                              // 1: google.cloud.secretmanager.v1.Secret
	(*SecretVersion)(nil),                       // 2: google.cloud.secretmanager.v1.SecretVersion
	(*Replication)(nil),                         // 3: google.cloud.secretmanager.v1.Replication
	(*CustomerManagedEncryption)(nil),           // 4: google.cloud.secretmanager.v1.CustomerManagedEncryption
	(*ReplicationStatus)(nil),                   // 5: google.cloud.secretmanager.v1.ReplicationStatus
	(*CustomerManagedEncryptionStatus)(nil),     // 6: google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
	(*Topic)(nil),                               // 7: google.cloud.secretmanager.v1.Topic
	(*Rotation)(nil),                            // 8: google.cloud.secretmanager.v1.Rotation
	(*SecretPayload)(nil),                       // 9: google.cloud.secretmanager.v1.SecretPayload
	nil,                                         // 10: google.cloud.secretmanager.v1.Secret.LabelsEntry
	nil,                                         // 11: google.cloud.secretmanager.v1.Secret.VersionAliasesEntry
	(*Replication_Automatic)(nil),               // 12: google.cloud.secretmanager.v1.Replication.Automatic
	(*Replication_UserManaged)(nil),             // 13: google.cloud.secretmanager.v1.Replication.UserManaged
	(*Replication_UserManaged_Replica)(nil),     // 14: google.cloud.secretmanager.v1.Replication.UserManaged.Replica
	(*ReplicationStatus_AutomaticStatus)(nil),   // 15: google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
	(*ReplicationStatus_UserManagedStatus)(nil), // 16: google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
	(*ReplicationStatus_UserManagedStatus_ReplicaStatus)(nil), // 17: google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
	(*timestamppb.Timestamp)(nil),                             // 18: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                               // 19: google.protobuf.Duration
}
var file_google_cloud_secretmanager_v1_resources_proto_depIdxs = []int32{
	3,  // 0: google.cloud.secretmanager.v1.Secret.replication:type_name -> google.cloud.secretmanager.v1.Replication
	18, // 1: google.cloud.secretmanager.v1.Secret.create_time:type_name -> google.protobuf.Timestamp
	10, // 2: google.cloud.secretmanager.v1.Secret.labels:type_name -> google.cloud.secretmanager.v1.Secret.LabelsEntry
	7,  // 3: google.cloud.secretmanager.v1.Secret.topics:type_name -> google.cloud.secretmanager.v1.Topic
	18, // 4: google.cloud.secretmanager.v1.Secret.expire_time:type_name -> google.protobuf.Timestamp
	19, // 5: google.cloud.secretmanager.v1.Secret.ttl:type_name -> google.protobuf.Duration
	8,  // 6: google.cloud.secretmanager.v1.Secret.rotation:type_name -> google.cloud.secretmanager.v1.Rotation
	11, // 7: google.cloud.secretmanager.v1.Secret.version_aliases:type_name -> google.cloud.secretmanager.v1.Secret.VersionAliasesEntry
	18, // 8: google.cloud.secretmanager.v1.SecretVersion.create_time:type_name -> google.protobuf.Timestamp
	18, // 9: google.cloud.secretmanager.v1.SecretVersion.destroy_time:type_name -> google.protobuf.Timestamp
	0,  // 10: google.cloud.secretmanager.v1.SecretVersion.state:type_name -> google.cloud.secretmanager.v1.SecretVersion.State
	5,  // 11: google.cloud.secretmanager.v1.SecretVersion.replication_status:type_name -> google.cloud.secretmanager.v1.ReplicationStatus
	12, // 12: google.cloud.secretmanager.v1.Replication.automatic:type_name -> google.cloud.secretmanager.v1.Replication.Automatic
	13, // 13: google.cloud.secretmanager.v1.Replication.user_managed:type_name -> google.cloud.secretmanager.v1.Replication.UserManaged
	15, // 14: google.cloud.secretmanager.v1.ReplicationStatus.automatic:type_name -> google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
	16, // 15: google.cloud.secretmanager.v1.ReplicationStatus.user_managed:type_name -> google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
	18, // 16: google.cloud.secretmanager.v1.Rotation.next_rotation_time:type_name -> google.protobuf.Timestamp
	19, // 17: google.cloud.secretmanager.v1.Rotation.rotation_period:type_name -> google.protobuf.Duration
	4,  // 18: google.cloud.secretmanager.v1.Replication.Automatic.customer_managed_encryption:type_name -> google.cloud.secretmanager.v1.CustomerManagedEncryption
	14, // 19: google.cloud.secretmanager.v1.Replication.UserManaged.replicas:type_name -> google.cloud.secretmanager.v1.Replication.UserManaged.Replica
	4,  // 20: google.cloud.secretmanager.v1.Replication.UserManaged.Replica.customer_managed_encryption:type_name -> google.cloud.secretmanager.v1.CustomerManagedEncryption
	6,  // 21: google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.customer_managed_encryption:type_name -> google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
	17, // 22: google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.replicas:type_name -> google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
	6,  // 23: google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus.customer_managed_encryption:type_name -> google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_google_cloud_secretmanager_v1_resources_proto_init() }
func file_google_cloud_secretmanager_v1_resources_proto_init() {
	if File_google_cloud_secretmanager_v1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Secret); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Replication); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomerManagedEncryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicationStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomerManagedEncryptionStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Topic); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Replication_Automatic); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Replication_UserManaged); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Replication_UserManaged_Replica); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicationStatus_AutomaticStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicationStatus_UserManagedStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_secretmanager_v1_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicationStatus_UserManagedStatus_ReplicaStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_secretmanager_v1_resources_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Secret_ExpireTime)(nil),
		(*Secret_Ttl)(nil),
	}
	file_google_cloud_secretmanager_v1_resources_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Replication_Automatic_)(nil),
		(*Replication_UserManaged_)(nil),
	}
	file_google_cloud_secretmanager_v1_resources_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*ReplicationStatus_Automatic)(nil),
		(*ReplicationStatus_UserManaged)(nil),
	}
	file_google_cloud_secretmanager_v1_resources_proto_msgTypes[8].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_secretmanager_v1_resources_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_secretmanager_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_secretmanager_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_secretmanager_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_secretmanager_v1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_secretmanager_v1_resources_proto = out.File
	file_google_cloud_secretmanager_v1_resources_proto_rawDesc = nil
	file_google_cloud_secretmanager_v1_resources_proto_goTypes = nil
	file_google_cloud_secretmanager_v1_resources_proto_depIdxs = nil
}
