/*
    ChibiOS/RT - Copyright (C) 2006-2013 Giovanni Di Sirio

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

#include "ch.h"
#include "hal.h"
#include "adc_cfg.h"

/*
 * ADC conversion group.
 * Mode:        Linear buffer, 8 samples of 5 channels, SW triggered.
 * Channels:    ADC_CHN_VRL, ADC_CHN_VREF25, ADC_CHN_VREF50,
 *              ADC_CHN_VREF75, ADC_CHN_VRH.
 *
 * NOTE: The configuration of a sequence is very complex in this ADC
 * implementation. Configurations are meant to be generated by the
 * SPC5 Studio visual configuration tool and not be written manually.
 * Writing complex sequences manually requires ad deep knowledge of both
 * the EQADC peripheral and the driver implementation.
 */
static const adccommand_t adcgrpcfg1_commands[ADC_GRP1_NUM_CHANNELS *
                                              ADC_GRP1_BUF_DEPTH] = {
  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(0) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH)
};

const ADCConversionGroup adcgrpcfg1 = {
  FALSE,
  ADC_GRP1_NUM_CHANNELS,
  NULL,
  adcerrorcallback,
  EQADC_CFCR_MODE_SWCS,
  0, 0,                     /* ISEL, EISEL.*/
  ADC_GRP1_BUF_DEPTH,
  adcgrpcfg1_commands
};

/*
 * ADC conversion group.
 * Mode:        Circular buffer, 16 samples of 5 channels, SW triggered.
 * Channels:    ADC_CHN_VRL, ADC_CHN_VRL, ADC_CHN_VREF25, ADC_CHN_VREF50,
 *              ADC_CHN_VREF50, ADC_CHN_VREF75, ADC_CHN_VRH, ADC_CHN_VRH.
 *
 * NOTE: The configuration of a sequence is very complex in this ADC
 * implementation. Configurations are meant to be generated by the
 * SPC5 Studio visual configuration tool and not be written manually.
 * Writing complex sequences manually requires ad deep knowledge of both
 * the EQADC peripheral and the driver implementation.
 */
static const adccommand_t adcgrpcfg2_commands[ADC_GRP2_NUM_CHANNELS *
                                              ADC_GRP2_BUF_DEPTH] = {
  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRL),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF25),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF50),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VREF75),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),

  EQADC_CONV_BN_ADC0 | EQADC_CONV_LST_64 | EQADC_CONV_CAL |
  EQADC_CONV_FMT_RJU | EQADC_CONV_CONFIG_STD | EQADC_CONV_MSG_RFIFO(2) |
  EQADC_CONV_CHANNEL(ADC_CHN_VRH),
};

const ADCConversionGroup adcgrpcfg2 = {
  TRUE,
  ADC_GRP2_NUM_CHANNELS,
  adccallback,
  adcerrorcallback,
  EQADC_CFCR_MODE_SWCS,
  0, 0,                     /* ISEL, EISEL.*/
  ADC_GRP2_BUF_DEPTH,
  adcgrpcfg2_commands
};
