/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.tigris.swidgets.DecoratedIcon;
import org.tigris.swidgets.DropDownIcon;
import org.tigris.swidgets.PopupToolBox;

public class PopupToolBoxButton
extends JButton {
    private JButton button;
    private PopupToolBox popupToolBox;
    private DecoratedIcon standardIcon;
    private String tooltip;
    private boolean showSplitter;

    public PopupToolBoxButton(Action action, int n, int n2) {
        super(action);
        this.setAction(action);
        this.popupToolBox = new PopupToolBox(n, n2);
        MyMouseListener myMouseListener = new MyMouseListener();
        this.addMouseMotionListener(myMouseListener);
        this.addMouseListener(myMouseListener);
    }

    public void setAction(Action action) {
        this.button = new JButton(action);
        this.tooltip = this.button.getToolTipText();
        if (this.tooltip == null || this.tooltip.trim().length() == 0) {
            this.tooltip = this.button.getText();
        }
        this.button.setText(null);
        this.standardIcon = new DropDownIcon((ImageIcon)this.button.getIcon());
        super.setAction(null);
        this.setIcon(this.standardIcon);
        this.setToolTipText(this.tooltip);
    }

    private void popup() {
        final JPopupMenu jPopupMenu = new JPopupMenu();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                jPopupMenu.setVisible(false);
                Component component = mouseEvent.getComponent();
                if (component instanceof JButton) {
                    Action action = ((JButton)component).getAction();
                    PopupToolBoxButton.this.setAction(action);
                }
            }
        };
        this.popupToolBox.setButtonMouseListener(mouseAdapter);
        this.popupToolBox.rebuild();
        jPopupMenu.add(this.popupToolBox);
        jPopupMenu.show(this, 0, this.getHeight());
    }

    public JButton add(Action action) {
        return this.popupToolBox.add(action);
    }

    private int getSplitterPosn() {
        return this.getIconPosn() + this.button.getIcon().getIconWidth() + 3;
    }

    private int getIconPosn() {
        int n = (this.getWidth() - this.standardIcon.getIconWidth()) / 2;
        return n;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Color[] colorArray = new Color[]{this.getBackground(), UIManager.getColor("controlDkShadow"), UIManager.getColor("infoText"), UIManager.getColor("controlHighlight")};
        if (this.showSplitter) {
            this.showSplitter(colorArray[1], graphics, this.getSplitterPosn(), 1, this.getHeight() - 4);
            this.showSplitter(colorArray[3], graphics, this.getSplitterPosn() + 1, 1, this.getHeight() - 4);
        }
    }

    public void showSplitter(Color color, Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(color);
        graphics.drawLine(n, n2 + 0, n, n2 + n3);
    }

    public void showSplitter(boolean bl) {
        if (bl && !this.showSplitter) {
            this.showSplitter = true;
            this.repaint();
            this.setToolTipText("Select Tool");
        } else if (!bl && this.showSplitter) {
            this.showSplitter = false;
            this.repaint();
            this.setToolTipText(this.tooltip);
        }
    }

    private class MyMouseListener
    implements MouseMotionListener,
    MouseListener {
        private MyMouseListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            PopupToolBoxButton.this.showSplitter(mouseEvent.getX() >= PopupToolBoxButton.this.getSplitterPosn());
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PopupToolBoxButton.this.showSplitter(false);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getX() >= PopupToolBoxButton.this.getSplitterPosn()) {
                PopupToolBoxButton.this.popup();
            } else {
                PopupToolBoxButton.this.button.doClick();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

