/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.activity2.diagram;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.argouml.activity2.diagram.FigComposite;
import org.argouml.activity2.diagram.FigNotation;
import org.argouml.model.AddAssociationEvent;
import org.argouml.model.AssociationChangeListener;
import org.argouml.model.InvalidElementException;
import org.argouml.model.Model;
import org.argouml.model.RemoveAssociationEvent;
import org.argouml.model.UmlChangeListener;
import org.argouml.notation2.NotationType;
import org.argouml.uml.diagram.DiagramSettings;
import org.tigris.gef.presentation.Fig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FigCompartment
extends FigComposite
implements AssociationChangeListener {
    public FigCompartment(Object owner, Rectangle bounds, DiagramSettings settings, Object metaType, String propertyName) {
        this(owner, bounds, settings, Arrays.asList(metaType), propertyName);
    }

    public FigCompartment(Object owner, Rectangle bounds, DiagramSettings settings, List<Object> metaTypes, String propertyName) {
        super(owner, settings);
        Model.getFacade().getModelElementContents(owner);
        for (Object element : Model.getFacade().getModelElementContents(owner)) {
            if (!metaTypes.contains(element.getClass())) continue;
            try {
                int y = bounds.y + this.getTopMargin();
                int x = bounds.x + this.getLeftMargin();
                Rectangle childBounds = new Rectangle(x, y, 0, 0);
                FigNotation fn = new FigNotation(element, childBounds, settings, NotationType.NAME);
                this.addFig((Fig)fn);
                y += fn.getHeight();
            }
            catch (InvalidElementException e) {}
        }
        Model.getPump().addModelEventListener((UmlChangeListener)this, owner, propertyName);
    }

    public FigCompartment(Object owner, DiagramSettings settings) {
        super(owner, settings);
    }

    @Override
    public Dimension getMinimumSize() {
        int minWidth = 0;
        int minHeight = 0;
        Iterator i$ = this.getFigs().iterator();
        while (i$.hasNext()) {
            Fig f;
            Fig fig = f = (Fig)i$.next();
            minWidth = Math.max(fig.getMinimumSize().width, minWidth);
            minHeight += fig.getMinimumSize().height;
        }
        return new Dimension(minWidth += this.getLeftMargin() + this.getRightMargin(), minHeight += this.getTopMargin() + this.getBottomMargin());
    }

    @Override
    protected void positionChildren() {
        int w = this._w - (this.getLeftMargin() + this.getRightMargin());
        int x = this._x + this.getLeftMargin();
        int y = this._y + this.getTopMargin();
        Iterator i$ = this.getFigs().iterator();
        while (i$.hasNext()) {
            Fig f;
            Fig fig = f = (Fig)i$.next();
            fig.setBounds(x, y, w, fig.getMinimumSize().height);
            y += fig.getHeight();
        }
    }

    public void elementAdded(AddAssociationEvent evt) {
        Object element = evt.getNewValue();
        Rectangle childBounds = new Rectangle(this.getX() + this.getHeight(), this.getY(), 0, 0);
        FigNotation fn = new FigNotation(element, childBounds, this.getDiagramSettings(), NotationType.NAME);
        this.addFig((Fig)fn);
        this.calcBounds();
    }

    public void elementRemoved(RemoveAssociationEvent evt) {
        Object element = evt.getOldValue();
        for (Fig f : this.getFigs()) {
            Fig fig = f;
            if (fig.getOwner() != element) continue;
            this.removeFig(fig);
            this.calcBounds();
            return;
        }
    }
}

